/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.adfmf.amx.dt.editor.AMXMetadataResolver;
import oracle.adfmf.amx.dt.inspector.FacetNameAttributeValueProvider;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.selection.XmlSelectionElement;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.event.XmlContextLifecycleListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.webapp.common.action.EditorKeys;
import oracle.jdevimpl.webapp.common.html.HtmlUtils;
import oracle.jdevimpl.webapp.jsp.taglibraries.jsf.JsfArb;
import oracle.jdevimpl.webapp.model.content.dom.util.XmlDomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class AMXFacetIdeController
implements Controller,
ContextMenuListener,
MenuListener {
    private JMenu _facetSubMenu;
    private WeakReference<FacetActions> _lastFacetActions;
    private final Logger _logger = Logger.getLogger(AMXFacetIdeController.class.getName());
    private static final String _FACET_ACTIONS = "amx.facet.actions";
    private static final int _FACET_CMD_ID = Ide.findOrCreateCmdID((String)"amx.facet");
    private static final IdeAction _FACET_ACTION = AMXFacetIdeController._getAction(_FACET_CMD_ID, JsfArb.getString((int)41), Integer.valueOf(JsfArb.getMnemonic((int)42)));

    public AMXFacetIdeController() {
        _FACET_ACTION.addController((Controller)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        oracle.ide.model.Element element = context.getElement();
        if (element == null || element.getData() == null) {
            return;
        }
        JDevXmlContext xmlContext = null;
        if (element.getData() instanceof XmlSelectionElement) {
            xmlContext = JDevXmlContext.getXmlContext((Context)context);
        }
        if (xmlContext == null || xmlContext.getActiveView() == null || !this._isValidResolver(xmlContext)) {
            return;
        }
        XmlView xmlView = xmlContext.getActiveView();
        xmlView.acquireReadLock();
        try {
            Node[] selectedNodes = xmlView.getSelection().getSelectedNodesArray();
            if (!xmlView.isReadOnly() && selectedNodes.length == 1) {
                this._buildContextMenu((MenuManager)popup);
                if (this._updateMenu(xmlContext, selectedNodes[0])) {
                    FacetActions actions = (FacetActions)_FACET_ACTION.getValue(_FACET_ACTIONS);
                    StringBuffer subMenuText = new StringBuffer(JsfArb.getString((int)41));
                    subMenuText.append(" - ");
                    subMenuText.append(HtmlUtils.makeItReadable((String)actions.getNode().getLocalName()));
                    this._facetSubMenu.setText(subMenuText.toString());
                    popup.add((Component)this._facetSubMenu, JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
                }
            }
        }
        finally {
            xmlView.releaseReadLock();
        }
    }

    public void menuWillHide(ContextMenu popup) {
        if (this._facetSubMenu != null) {
            this._facetSubMenu.removeAll();
        }
        popup.remove((Component)this._facetSubMenu);
    }

    public boolean handleDefaultAction(Context ctx) {
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        return false;
    }

    @Override
    public void menuSelected(MenuEvent e) {
        FacetActions actions = (FacetActions)_FACET_ACTION.getValue(_FACET_ACTIONS);
        if (actions != null) {
            actions._populate();
        }
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    private void _buildContextMenu(MenuManager menuManager) {
        if (this._facetSubMenu == null) {
            this._facetSubMenu = menuManager.createSubMenu(JsfArb.getString((int)41), Integer.valueOf(JsfArb.getMnemonic((int)42)), JDeveloperMenuConstants.WEIGHT_DESIGN_FACETS);
            this._facetSubMenu.setAction((Action)_FACET_ACTION);
            this._facetSubMenu.addMenuListener(this);
        }
    }

    private boolean _updateMenu(JDevXmlContext xmlContext, Node node) {
        XmlMetadataResolver metadataResolver;
        if (this._lastFacetActions != null) {
            FacetActions facetActions = (FacetActions)this._lastFacetActions.get();
            if (facetActions != null) {
                facetActions._destroy();
            }
            this._lastFacetActions = null;
        }
        if ((metadataResolver = xmlContext.getModel().getXmlMetadataResolver()).isImmutable(node)) {
            return false;
        }
        if (this._isValidResolver(xmlContext)) {
            while (node != null) {
                List<String> facetNames = FacetNameAttributeValueProvider.collectNameValues(node);
                if (!facetNames.isEmpty()) {
                    FacetActions actions = new FacetActions(xmlContext, node, facetNames);
                    this._lastFacetActions = new WeakReference<FacetActions>(actions);
                    _FACET_ACTION.putValue(_FACET_ACTIONS, (Object)actions);
                    return true;
                }
                node = node.getParentNode();
            }
        }
        return false;
    }

    private String _getNamespace() {
        return "http://xmlns.oracle.com/adf/mf/amx";
    }

    private Node _findFacet(JDevXmlContext xmlContext, Node node, String facetName) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            XmlKey nodeKey = xmlContext.getModel().getNodeXmlKey(child);
            String ns = nodeKey.getNamespace();
            String localName = nodeKey.getLocalName();
            if (ns == null || !ns.equals(this._getNamespace()) || localName == null || !localName.equals("facet") || !((Element)child).getAttributeNS(null, "name").equals(facetName)) continue;
            return child;
        }
        return null;
    }

    private boolean _isValidResolver(JDevXmlContext xmlContext) {
        return xmlContext.getModel().getXmlMetadataResolver() instanceof AMXMetadataResolver;
    }

    private static IdeAction _getAction(int cmdId, String label, Integer mnemonic) {
        return EditorKeys.getAction((int)cmdId, (String)label, (Integer)mnemonic, null, (int)-1, null, (boolean)true, null, null);
    }

    private final class FacetAction
    extends AbstractAction {
        private FacetActions _actions;
        private String _facetName;
        private boolean _ignoreAction;

        public FacetAction(FacetActions actions, String readableName, String facetName) {
            super(readableName);
            this._actions = actions;
            this._facetName = facetName;
            this.putValue("MnemonicKey", readableName.charAt(0));
        }

        public void ignoreAction(boolean ignore) {
            this._ignoreAction = ignore;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this._ignoreAction) {
                return;
            }
            JDevXmlContext xmlContext = this._actions.getXmlContext();
            XmlView xmlView = xmlContext.getActiveView();
            if (xmlView == null) {
                return;
            }
            XmlModel model = xmlView.getBaseModel();
            try {
                boolean resetSelection = true;
                JCheckBoxMenuItem checkBox = (JCheckBoxMenuItem)ae.getSource();
                Node selectedNode = null;
                Node parentNode = this._actions.getNode();
                if (checkBox.isSelected()) {
                    String s = JsfArb.getString((int)43);
                    model.startTransaction(s + " " + this._facetName);
                    Element facetElement = parentNode.getOwnerDocument().createElementNS(AMXFacetIdeController.this._getNamespace(), "facet");
                    facetElement.setAttributeNS(null, "name", this._facetName);
                    selectedNode = facetElement;
                    DomPosition position = DomPositionFactory.createInsideOrAfterPosition((Node)parentNode);
                    model.insertNode((Node)facetElement, position);
                } else {
                    String s = JsfArb.getString((int)44);
                    model.startTransaction(s + " " + this._facetName);
                    Node facetNode = AMXFacetIdeController.this._findFacet(xmlContext, parentNode, this._facetName);
                    if (facetNode != null) {
                        boolean deleteFacet = true;
                        if (facetNode.getFirstChild() != null) {
                            StringBuffer confirmationMessage = new StringBuffer();
                            confirmationMessage.append(this._facetName);
                            confirmationMessage.append(" - ");
                            confirmationMessage.append(JsfArb.getString((int)45));
                            StringBuffer dialogTitle = new StringBuffer();
                            dialogTitle.append(this._facetName);
                            dialogTitle.append(" - ");
                            dialogTitle.append(JsfArb.getString((int)46));
                            deleteFacet = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)confirmationMessage.toString(), (String)dialogTitle.toString(), null, (boolean)true);
                        }
                        if (deleteFacet) {
                            selectedNode = facetNode.getParentNode();
                            selectedNode.removeChild(facetNode);
                        } else {
                            resetSelection = false;
                        }
                    }
                }
                if (resetSelection && selectedNode != null) {
                    XmlDomUtils.setSelection((AbstractModel)model, (Node)selectedNode);
                }
                model.commitTransaction();
            }
            catch (XmlCommitException commitExc) {
                model.rollbackTransaction();
                commitExc.printStackTrace();
            }
            catch (Exception commitExc) {
                model.rollbackTransaction();
                commitExc.printStackTrace();
                AMXFacetIdeController.this._logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00070", commitExc));
            }
        }
    }

    private final class FacetActions {
        private WeakReference<Node> _node;
        private final List<String> _facetNames;
        private JDevXmlContext _xmlContext;
        private boolean _populated;
        private XmlContextLifecycleListener _xmlContextLifecycleListener;

        public FacetActions(JDevXmlContext xmlContext, Node node, List<String> facetNames) {
            this._node = new WeakReference<Node>(node);
            this._facetNames = facetNames;
            this._xmlContext = xmlContext;
            this._xmlContextLifecycleListener = new XmlContextLifecycleListener(){

                public void preContextDisposal(XmlContext context) {
                    FacetActions.this._destroy();
                }
            };
            xmlContext.addLifecycleListener(this._xmlContextLifecycleListener);
        }

        public Node getNode() {
            return (Node)this._node.get();
        }

        public JDevXmlContext getXmlContext() {
            return this._xmlContext;
        }

        private void _destroy() {
            if (this._xmlContext != null) {
                if (this._xmlContextLifecycleListener != null) {
                    this._xmlContext.removeLifecycleListener(this._xmlContextLifecycleListener);
                }
                this._xmlContext = null;
                this._xmlContextLifecycleListener = null;
            }
            this._node = null;
        }

        private void _populate() {
            if (this._populated) {
                return;
            }
            ArrayList<String> modList = new ArrayList<String>(this._facetNames);
            Collections.sort(modList, String.CASE_INSENSITIVE_ORDER);
            for (String facetname : modList) {
                FacetAction action = new FacetAction(this, HtmlUtils.makeItReadable((String)facetname), facetname);
                JCheckBoxMenuItem checkBox = new JCheckBoxMenuItem(action);
                if (AMXFacetIdeController.this._findFacet(this._xmlContext, (Node)this._node.get(), facetname) != null) {
                    action.ignoreAction(true);
                    checkBox.setSelected(true);
                    action.ignoreAction(false);
                }
                AMXFacetIdeController.this._facetSubMenu.add(checkBox);
            }
            this._populated = true;
        }
    }
}

