/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.audit;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oracle.adfdt.common.util.StringUtils;
import oracle.adfmf.amx.dt.editor.AMXMetadataResolver;
import oracle.adfmf.amx.dt.inspector.FacetNameAttributeValueProvider;
import oracle.adfmf.amx.util.AMXUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.XmlUtils;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.ide.Context;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.ViolationReport;
import oracle.jdeveloper.audit.extension.ExtensionResource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AmxAnalyzer
extends Analyzer {
    private AMXMetadataResolver _amxResolver = null;
    private boolean _isAmxDocument = false;
    private final Stack<Element> _encounteredValidationGroupTagStack = new Stack();
    private final Stack<Set<String>> _usedFacetNamesSet = new Stack();
    private final Stack<Element> _uiComponents = new Stack();
    private static final List<String> _TABLE_LAYOUT_COMPONENTS = Arrays.asList("tableLayout", "rowLayout");
    private static final Map<String, List<String>> _ALLOWABLE_ITERATOR_CHILDREN;
    private static final List<String> _PROHIBITED_MARKER_ATTRIBUTES;
    private static final List<String> _PROHIBITED_GAUGE_TICK_LABEL_ATTRIBUTES;
    private static final Map<String, String> _ALLOWABLE_PARENTS;
    @ExtensionResource(value="oracle.adfmf.nested-validationGroup-tags")
    private Rule _nestValidationGroupTagsRule;
    @ExtensionResource(value="oracle.adfmf.duplicate-child")
    private Rule _duplicateChildRule;
    @ExtensionResource(value="oracle.adfmf.invalid-child")
    private Rule _invalidChildRule;
    @ExtensionResource(value="oracle.adfmf.undefined-facet")
    private Rule _undefinedFacetRule;
    @ExtensionResource(value="oracle.adfmf.duplicate-facet")
    private Rule _duplicateFacetRule;
    @ExtensionResource(value="oracle.adfmf.invalid-facet-child")
    private Rule _invalidFacetChildRule;
    @ExtensionResource(value="oracle.adfmf.invalid-iterator-child")
    private Rule _invalidIteratorChildRule;
    @ExtensionResource(value="oracle.adfmf.unexpected-rowLayout-cellFormat-element")
    private Rule _rowLayoutCellFormatElementRule;
    @ExtensionResource(value="oracle.adfmf.inputText-secret-true")
    private Rule _inputTextSecretTrueRule;
    @ExtensionResource(value="oracle.adfmf.inputText-inputType-value")
    private Rule _inputTextInputTypeValueRule;
    @ExtensionResource(value="oracle.adfmf.inputText-convertNumber-child")
    private Rule _inputTextConvertNumberRule;
    @ExtensionResource(value="oracle.adfmf.warning-missing-shortDesc")
    private Rule _missingShortDescRule;
    @ExtensionResource(value="oracle.adfmf.warning-missing-hintText")
    private Rule _missingHintTextRule;
    @ExtensionResource(value="oracle.adfmf.warning-missing-label")
    private Rule _missingLabelRule;
    @ExtensionResource(value="oracle.adfmf.pointLocation-type-value")
    private Rule _pointLocationTypeValueRule;
    @ExtensionResource(value="oracle.adfmf.prohibited-marker-attributes")
    private Rule _markerAttributesRule;
    @ExtensionResource(value="oracle.adfmf.error-empty-tableLayout-width")
    private Rule _cellFormatWidthRule;
    @ExtensionResource(value="oracle.adfmf.prohibited-axis-ticklabel-rotation")
    private Rule _axisTicklabelRotationRule;
    @ExtensionResource(value="oracle.adfmf.prohibited-gauge-ticklabel-attributes")
    private Rule _gaugeTickLabelAttributesRule;

    public void enter(AuditContext context, Document document) {
        this._isAmxDocument = AMXUtils.isSupportedNode(context.getModel().getNode());
        if (!this._isAmxDocument) {
            this.setEnabled(false);
            return;
        }
        Context ideContext = context.getIdeContext();
        JDevXmlContext xmlContext = XMLSourceNode.getXmlContext((Context)ideContext);
        XmlMetadataResolver xmlResolver = xmlContext.getModel().getXmlMetadataResolver();
        if (xmlResolver != null && xmlResolver instanceof AMXMetadataResolver) {
            this._amxResolver = (AMXMetadataResolver)xmlResolver;
        }
    }

    public void enter(AuditContext context, Element element) {
        assert (this._isAmxDocument && this._amxResolver != null);
        this._validateInvalidChildren(context, element);
        this._validateDuplicateChildren(context, element);
        this._validateFacets(context, element);
        this._validateShortDesc(context, element);
        if ("http://xmlns.oracle.com/adf/mf/amx".equals(element.getNamespaceURI())) {
            this._validateNestedValidationGroup(context, element);
            this._validateInputText(context, element);
            this._validateConvertNumber(context, element);
            this._validateRowLayoutAndCellFormat(context, element);
            this._validateCellFormatWidth(context, element);
            this._validateHintText(context, element);
            this._validateLabel(context, element);
        }
        if ("http://xmlns.oracle.com/adf/mf/amx/dvt".equals(element.getNamespaceURI())) {
            this._validatePointDataLayerType(context, element);
            this._validateMarkerAttributes(context, element);
            this._validateGaugeTickLabelAttributes(context, element);
            this._validateAxis(context, element);
        }
    }

    public void exit(AuditContext context, Element element) {
        if (!this._encounteredValidationGroupTagStack.isEmpty() && this._encounteredValidationGroupTagStack.peek() == element) {
            this._encounteredValidationGroupTagStack.pop();
        }
        if (!this._uiComponents.isEmpty() && this._uiComponents.peek() == element) {
            this._usedFacetNamesSet.pop();
            this._uiComponents.pop();
        }
    }

    public void exit(AuditContext context, Document document) {
        this._isAmxDocument = false;
        this._amxResolver = null;
        this._encounteredValidationGroupTagStack.clear();
        this._usedFacetNamesSet.clear();
        this._uiComponents.clear();
    }

    private void _validateNestedValidationGroup(AuditContext context, Element element) {
        if (this._nestValidationGroupTagsRule.isEnabled() && "validationGroup".equals(element.getLocalName())) {
            if (!this._encounteredValidationGroupTagStack.isEmpty()) {
                Element lastValidationGroupTag = this._encounteredValidationGroupTagStack.peek();
                ViolationReport violationReport = context.report(this._nestValidationGroupTagsRule, (Object)element);
                violationReport.addParameter(null, (Object)element.getAttributeNS(null, "id"));
                violationReport.addParameter(null, (Object)lastValidationGroupTag.getAttributeNS(null, "id"));
            }
            this._encounteredValidationGroupTagStack.push(element);
        }
    }

    private void _validateDuplicateChildren(AuditContext context, Element element) {
        Element parent;
        List<Node> children;
        Node parentNode;
        if (this._duplicateChildRule.isEnabled() && this._amxResolver.getComponentsToAppearOnce().contains(element.getLocalName()) && DomUtils.isElement((Node)(parentNode = element.getParentNode())) && (children = XmlUtils.getNamedChildElements(parent = (Element)parentNode, element.getLocalName())).size() > 1) {
            Iterator<Node> iterator = children.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                Node child = iterator.next();
                if (!child.isSameNode(element)) continue;
                ViolationReport violationReport = context.report(this._duplicateChildRule, (Object)element);
                violationReport.addParameter(null, (Object)element.getLocalName());
                violationReport.addParameter(null, (Object)parent.getLocalName());
                break;
            }
        }
    }

    private void _validateInvalidChildren(AuditContext context, Element element) {
        this._validateFacetChildren(context, element);
        this._validateIteratorChildren(context, element);
    }

    private void _validateFacetChildren(AuditContext context, Element element) {
        Map<String, List<String>> validFacetParents;
        if (this._invalidChildRule.isEnabled() && FacetNameAttributeValueProvider.isFacetChildRestrictedByAncestors(element.getLocalName()) && (validFacetParents = FacetNameAttributeValueProvider.getFacetChildAncestors(element.getLocalName())) != null && !validFacetParents.isEmpty()) {
            boolean isInvalidChildRuleViolated = true;
            String validFacetName = validFacetParents.keySet().iterator().next();
            List<String> validGrandparents = validFacetParents.get(validFacetName);
            Element parent = (Element)element.getParentNode();
            Element grandparent = null;
            if (parent != null && "facet".equals(parent.getLocalName()) && validFacetName.equals(parent.getAttributeNS(null, "name")) && (grandparent = (Element)parent.getParentNode()) != null && validGrandparents.contains(grandparent.getLocalName())) {
                isInvalidChildRuleViolated = false;
            }
            if (isInvalidChildRuleViolated) {
                ViolationReport violationReport = context.report(this._invalidChildRule, (Object)element);
                violationReport.addParameter(null, (Object)element.getLocalName());
                violationReport.addParameter(null, (Object)validFacetName);
                violationReport.addParameter(null, (Object)StringUtils.join((String[])validGrandparents.toArray(new String[0]), (String)","));
            }
        }
    }

    private void _validateIteratorChildren(AuditContext context, Element element) {
        if (this._invalidIteratorChildRule.isEnabled() && "iterator".equals(element.getLocalName())) {
            for (Element iteratorAncestor = (Element)element.getParentNode(); iteratorAncestor != null && !"cellFormat".equals(iteratorAncestor.getLocalName()); iteratorAncestor = (Element)iteratorAncestor.getParentNode()) {
                String iteratorAncestorName = iteratorAncestor.getLocalName();
                if (!_TABLE_LAYOUT_COMPONENTS.contains(iteratorAncestorName)) continue;
                List<String> allowableChildren = _ALLOWABLE_ITERATOR_CHILDREN.get(iteratorAncestorName);
                NodeList iteratorChildren = element.getChildNodes();
                for (int index = 0; index < iteratorChildren.getLength(); ++index) {
                    Node iteratorChild = iteratorChildren.item(index);
                    String iteratorChildName = iteratorChild.getLocalName();
                    if (!DomUtils.isElement((Node)iteratorChild) || allowableChildren.contains(iteratorChildName)) continue;
                    ViolationReport violationReport = context.report(this._invalidIteratorChildRule, (Object)iteratorChild);
                    violationReport.addParameter(null, (Object)iteratorChildName);
                    violationReport.addParameter(null, (Object)iteratorAncestorName);
                }
                break;
            }
        }
    }

    private void _validateFacets(AuditContext context, Element element) {
        if (this._undefinedFacetRule.isEnabled() || this._duplicateFacetRule.isEnabled() || this._invalidFacetChildRule.isEnabled()) {
            if (this._amxResolver.isUIComponent(element)) {
                this._usedFacetNamesSet.push(new HashSet());
                this._uiComponents.push(element);
            } else if ("facet".equals(element.getLocalName())) {
                String facetName;
                Attr facetNameAttr = element.getAttributeNodeNS(null, "name");
                String string = facetName = facetNameAttr != null ? facetNameAttr.getNodeValue() : null;
                if (!this._usedFacetNamesSet.isEmpty()) {
                    Element uiComponent = this._uiComponents.peek();
                    if (facetName != null) {
                        List<String> validChildren;
                        List<String> allowedFacetNames;
                        ViolationReport violationReport;
                        boolean newFacet;
                        if (this._duplicateFacetRule.isEnabled() && !(newFacet = this._usedFacetNamesSet.peek().add(facetName))) {
                            violationReport = context.report(this._duplicateFacetRule, (Object)element);
                            violationReport.addParameter(null, (Object)facetName);
                            violationReport.addParameter(null, (Object)uiComponent.getLocalName());
                        }
                        if (this._undefinedFacetRule.isEnabled() && !(allowedFacetNames = FacetNameAttributeValueProvider.collectNameValues(uiComponent)).isEmpty() && !allowedFacetNames.contains(facetName)) {
                            violationReport = context.report(this._undefinedFacetRule, (Object)element);
                            violationReport.addParameter(null, (Object)facetName);
                            violationReport.addParameter(null, (Object)uiComponent.getLocalName());
                        }
                        if (this._invalidFacetChildRule.isEnabled() && FacetNameAttributeValueProvider.isFacetRestrictingChildren(facetName) && (validChildren = FacetNameAttributeValueProvider.getValidFacetChildren(facetName)) != null && !validChildren.isEmpty()) {
                            NodeList facetChildren = element.getChildNodes();
                            for (int index = 0; index < facetChildren.getLength(); ++index) {
                                Node facetChild = facetChildren.item(index);
                                if (!DomUtils.isElement((Node)facetChild) || validChildren.contains(facetChild.getLocalName())) continue;
                                ViolationReport violationReport2 = context.report(this._invalidFacetChildRule, (Object)facetChild);
                                violationReport2.addParameter(null, (Object)facetChild.getLocalName());
                                violationReport2.addParameter(null, (Object)facetName);
                            }
                        }
                    }
                }
            }
        }
    }

    private void _validateRowLayoutAndCellFormat(AuditContext context, Element element) {
        String elementName;
        if (this._rowLayoutCellFormatElementRule.isEnabled() && ("rowLayout".equals(elementName = element.getLocalName()) || "cellFormat".equals(elementName))) {
            String validParentName = _ALLOWABLE_PARENTS.get(elementName);
            boolean reportViolation = false;
            if (validParentName != null) {
                for (Element ancestor = (Element)element.getParentNode(); ancestor != null && !validParentName.equals(ancestor.getLocalName()); ancestor = (Element)ancestor.getParentNode()) {
                    if ("iterator".equals(ancestor.getLocalName())) {
                        continue;
                    }
                    reportViolation = true;
                    break;
                }
            }
            if (reportViolation) {
                ViolationReport violationReport = context.report(this._rowLayoutCellFormatElementRule, (Object)element);
                violationReport.addParameter(null, (Object)elementName);
                violationReport.addParameter(null, (Object)validParentName);
            }
        }
    }

    private void _validateInputText(AuditContext context, Element element) {
        if ("inputText".equals(element.getLocalName())) {
            Attr inputTypeAttr;
            String rowsValue = element.getAttributeNS(null, "rows");
            int numberOfRows = 0;
            if (!rowsValue.isEmpty()) {
                try {
                    numberOfRows = Integer.parseInt(rowsValue);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            String secretValue = element.getAttributeNS(null, "secret");
            if (this._inputTextInputTypeValueRule.isEnabled() && (numberOfRows > 1 || "true".equals(secretValue)) && (inputTypeAttr = element.getAttributeNodeNS(null, "inputType")) != null && !"text".equals(inputTypeAttr.getNodeValue())) {
                context.report(this._inputTextInputTypeValueRule, (Object)inputTypeAttr);
            }
            if (this._inputTextSecretTrueRule.isEnabled() && numberOfRows > 1 && "true".equals(secretValue)) {
                Attr inputRowsAttr = element.getAttributeNodeNS(null, "rows");
                context.report(this._inputTextSecretTrueRule, (Object)inputRowsAttr);
            }
        }
    }

    private void _validateConvertNumber(AuditContext context, Element element) {
        String inputTypeValue;
        Node parentNode;
        if (this._inputTextConvertNumberRule.isEnabled() && "convertNumber".equals(element.getLocalName()) && (parentNode = element.getParentNode()) != null && "inputText".equals(parentNode.getLocalName()) && (inputTypeValue = ((Element)parentNode).getAttributeNS(null, "inputType")) != null && !"".equals(inputTypeValue) && !"text".equals(inputTypeValue)) {
            ViolationReport violationReport = context.report(this._inputTextConvertNumberRule, (Object)element);
            violationReport.addParameter(null, (Object)element.getLocalName());
            violationReport.addParameter(null, (Object)parentNode.getLocalName());
            violationReport.addParameter(null, (Object)inputTypeValue);
        }
    }

    private void _validatePointDataLayerType(AuditContext context, Element element) {
        if (this._pointLocationTypeValueRule.isEnabled() && "pointLocation".equals(element.getLocalName())) {
            String typeValue = element.getAttributeNS(null, "type");
            Element topParent = AmxAnalyzer._findValidPointLocationAncestor(element);
            if (topParent != null) {
                Attr typeAttr = element.getAttributeNodeNS(null, "type");
                ViolationReport violationReport = null;
                String supportedValues = null;
                if ("geographicMap".equals(topParent.getLocalName())) {
                    if ("pointName".equals(typeValue)) {
                        violationReport = context.report(this._pointLocationTypeValueRule, (Object)typeAttr);
                        supportedValues = "address;pointXY";
                    }
                } else if ("thematicMap".equals(topParent.getLocalName()) && "address".equals(typeValue) && typeValue != null && typeValue.length() > 0) {
                    violationReport = context.report(this._pointLocationTypeValueRule, (Object)typeAttr);
                    supportedValues = "pointName;pointXY";
                }
                if (violationReport != null) {
                    violationReport.addParameter(null, (Object)typeValue);
                    violationReport.addParameter(null, (Object)topParent.getLocalName());
                    violationReport.addParameter(null, (Object)supportedValues);
                }
            }
        }
    }

    private void _validateMarkerAttributes(AuditContext context, Element element) {
        Element topParent;
        if (this._markerAttributesRule.isEnabled() && "marker".equals(element.getLocalName()) && (topParent = AmxAnalyzer._findValidPointLocationAncestor(element)) != null && "geographicMap".equals(topParent.getLocalName())) {
            NamedNodeMap attrs = element.getAttributes();
            Node node = null;
            Attr attributeNode = null;
            String attributeName = null;
            if (attrs != null && attrs.getLength() > 0) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    node = attrs.item(i);
                    if (node == null || node.getNodeType() != 2 || !_PROHIBITED_MARKER_ATTRIBUTES.contains(attributeName = (attributeNode = (Attr)node).getLocalName())) continue;
                    context.report(this._markerAttributesRule, (Object)node).addParameter(null, (Object)attributeName);
                }
            }
        }
    }

    private void _validateGaugeTickLabelAttributes(AuditContext context, Element element) {
        if (this._gaugeTickLabelAttributesRule.isEnabled() && "tickLabel".equals(element.getLocalName())) {
            ArrayList<String> validParent = new ArrayList<String>();
            validParent.add("dialGauge");
            Element topParent = AmxAnalyzer._findAncestor(element, validParent);
            if (topParent != null) {
                NamedNodeMap attrs = element.getAttributes();
                Node node = null;
                Attr attributeNode = null;
                String attributeName = null;
                if (attrs != null && attrs.getLength() > 0) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        node = attrs.item(i);
                        if (node == null || node.getNodeType() != 2 || !_PROHIBITED_GAUGE_TICK_LABEL_ATTRIBUTES.contains(attributeName = (attributeNode = (Attr)node).getLocalName())) continue;
                        context.report(this._gaugeTickLabelAttributesRule, (Object)node).addParameter(null, (Object)attributeName);
                    }
                }
            }
        }
    }

    private void _validateAxis(AuditContext context, Element element) {
        Attr nodeAttr;
        List<String> lstStrPointLocationNames;
        Element elementFound;
        String strAttrRotation;
        if (context != null && element != null && this._axisTicklabelRotationRule.isEnabled() && "tickLabel".equals(element.getLocalName()) && (strAttrRotation = element.getAttributeNS(null, "rotation")) != null && strAttrRotation != "" && (elementFound = AmxAnalyzer._findAncestor(element, lstStrPointLocationNames = Arrays.asList("yAxis", "y2Axis"))) != null && (nodeAttr = element.getAttributeNodeNS(null, "rotation")) != null) {
            context.report(this._axisTicklabelRotationRule, (Object)nodeAttr).addParameter(null, (Object)"rotation");
        }
    }

    private static Element _findValidPointLocationAncestor(Node target) {
        List<String> lstStrPointLocationNames = Arrays.asList("geographicMap", "thematicMap");
        return AmxAnalyzer._findAncestor(target, lstStrPointLocationNames);
    }

    private static Element _findAncestor(Node nodeTarget, List<String> lstStrElementNames) {
        Iterator<String> iteratorStrElementNames;
        if (nodeTarget == null || lstStrElementNames == null) {
            return null;
        }
        Node nodeParent = nodeTarget.getParentNode();
        if (nodeParent == null) {
            return null;
        }
        if (nodeParent.getNodeType() == 1 && (iteratorStrElementNames = lstStrElementNames.iterator()) != null) {
            String strElementName = null;
            while (iteratorStrElementNames.hasNext()) {
                strElementName = iteratorStrElementNames.next();
                if (strElementName == null || !strElementName.equals(nodeParent.getLocalName())) continue;
                return (Element)nodeParent;
            }
        }
        return AmxAnalyzer._findAncestor(nodeParent, lstStrElementNames);
    }

    private void _validateShortDesc(AuditContext context, Element element) {
        String shortDesc;
        if (this._missingShortDescRule.isEnabled() && XmlUtils.isAttributeSupported(this._amxResolver, element, "shortDesc") && ((shortDesc = element.getAttributeNS(null, "shortDesc")) == null || "".equals(shortDesc.trim()))) {
            ViolationReport violationReport = context.report(this._missingShortDescRule, (Object)element);
            String message = "image".equals(element.getLocalName()) ? MobileResourceUtils.getText("NO_IMAGE_SHORT_DESC_FOUND") : MobileResourceUtils.getText("NO_SHORT_DESC_FOUND");
            violationReport.addParameter("message", (Object)message);
        }
    }

    private void _validateHintText(AuditContext context, Element element) {
        String hintText;
        if (this._missingHintTextRule.isEnabled() && XmlUtils.isAttributeSupported(this._amxResolver, element, "hintText") && ((hintText = element.getAttributeNS(null, "hintText")) == null || "".equals(hintText.trim()))) {
            context.report(this._missingHintTextRule, (Object)element);
        }
    }

    private void _validateLabel(AuditContext context, Element element) {
        if (this._missingLabelRule.isEnabled() && XmlUtils.isAttributeSupported(this._amxResolver, element, "label")) {
            String elementName = element.getLocalName();
            if ("inputText".equals(elementName) || "selectOneButton".equals(elementName)) {
                return;
            }
            String label = element.getAttributeNS(null, "label");
            if (label == null || "".equals(label.trim())) {
                ViolationReport violationReport = context.report(this._missingLabelRule, (Object)element);
                violationReport.addParameter(null, (Object)elementName);
            }
        }
    }

    private void _validateCellFormatWidth(AuditContext context, Element element) {
        String cellWidth;
        String elementName;
        if (this._cellFormatWidthRule.isEnabled() && "cellFormat".equals(elementName = element.getLocalName()) && (cellWidth = element.getAttribute("width")) != null && cellWidth.trim().length() > 0) {
            NumberFormat nf = NumberFormat.getPercentInstance();
            try {
                nf.parse(cellWidth);
            }
            catch (ParseException e) {
                return;
            }
            for (Node ancestor = element.getParentNode(); ancestor != null; ancestor = ancestor.getParentNode()) {
                String ancestorName = ancestor.getLocalName();
                if (!"tableLayout".equals(ancestorName)) continue;
                String tableWidth = ((Element)ancestor).getAttribute("width");
                if (tableWidth == null || tableWidth.isEmpty()) {
                    context.report(this._cellFormatWidthRule, (Object)ancestor);
                }
                return;
            }
        }
    }

    static {
        HashMap<String, List<String>> allowableIteratorChildren = new HashMap<String, List<String>>();
        allowableIteratorChildren.put("tableLayout", Arrays.asList("rowLayout", "iterator"));
        allowableIteratorChildren.put("rowLayout", Arrays.asList("cellFormat", "iterator"));
        _ALLOWABLE_ITERATOR_CHILDREN = Collections.unmodifiableMap(allowableIteratorChildren);
        ArrayList<String> prohibitedMarkerAttributes = new ArrayList<String>();
        prohibitedMarkerAttributes.add("gradientEffect");
        prohibitedMarkerAttributes.add("labelPosition");
        prohibitedMarkerAttributes.add("scaleX");
        prohibitedMarkerAttributes.add("scaleY");
        prohibitedMarkerAttributes.add("shape");
        prohibitedMarkerAttributes.add("fillColor");
        prohibitedMarkerAttributes.add("fillPattern");
        prohibitedMarkerAttributes.add("opacity");
        prohibitedMarkerAttributes.add("labelDisplay");
        prohibitedMarkerAttributes.add("labelStyle");
        prohibitedMarkerAttributes.add("value");
        prohibitedMarkerAttributes.add("width");
        prohibitedMarkerAttributes.add("height");
        _PROHIBITED_MARKER_ATTRIBUTES = Collections.unmodifiableList(prohibitedMarkerAttributes);
        ArrayList<String> prohibitedGaugeTickLabelAttributes = new ArrayList<String>();
        prohibitedGaugeTickLabelAttributes.add("rotation");
        _PROHIBITED_GAUGE_TICK_LABEL_ATTRIBUTES = Collections.unmodifiableList(prohibitedGaugeTickLabelAttributes);
        HashMap<String, String> allowableParents = new HashMap<String, String>();
        allowableParents.put("rowLayout", "tableLayout");
        allowableParents.put("cellFormat", "rowLayout");
        _ALLOWABLE_PARENTS = Collections.unmodifiableMap(allowableParents);
    }
}

