/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.amx.dt.audit;

import java.util.Collection;
import java.util.Map;
import oracle.adfdt.view.unified.id.ScopedId;
import oracle.adfdt.view.unified.id.ScopedIdContext;
import oracle.adfdt.view.unified.id.ScopedIdUtils;
import oracle.adfmf.amx.dt.editor.AMXMetadataResolver;
import oracle.adfmf.amx.dt.inspector.scopedid.AMXScopedIdContext;
import oracle.adfmf.amx.dt.inspector.scopedid.AMXScopedIdTraversalHandler;
import oracle.adfmf.amx.util.AMXUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.ViolationReport;
import oracle.jdeveloper.audit.extension.ExtensionResource;
import oracle.jdevimpl.audit.xml.XmlModelAdapter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AMXScopedIdAnalyzer
extends Analyzer {
    private AMXMetadataResolver _amxResolver = null;
    private static final String _AFFECTED_BIT = "___affected_bit";
    @ExtensionResource(value="oracle.adfmf.error-invalid-scoped-id")
    private Rule _invalidScopedId;
    @ExtensionResource(value="oracle.adfmf.error-target-not-popup")
    private Rule _targetNotPopup;
    @ExtensionResource(value="oracle.adfmf.error-target-not-ui-component")
    private Rule _targetNotUIComponent;
    @ExtensionResource(value="oracle.adfmf.error-missing-popup-id")
    private Rule _noPopupId;
    @ExtensionResource(value="oracle.adfmf.error-missing-align-id")
    private Rule _noAlignId;

    public void enter(AuditContext context, Document document) {
        if (!this._targetNotPopup.isEnabled() && !this._invalidScopedId.isEnabled()) {
            this.setEnabled(false);
        }
        Context ideContext = context.getIdeContext();
        Node node = context.getModel().getNode();
        if (AMXUtils.isSupportedNode(node)) {
            JDevXmlContext xmlContext = XMLSourceNode.getXmlContext((Context)ideContext);
            XmlMetadataResolver xmlResolver = xmlContext.getModel().getXmlMetadataResolver();
            if (xmlResolver != null && xmlResolver instanceof AMXMetadataResolver) {
                this._amxResolver = (AMXMetadataResolver)xmlResolver;
            }
        } else {
            this.setEnabled(false);
        }
    }

    public void enter(AuditContext context, Element element) {
        if ("http://xmlns.oracle.com/adf/mf/amx".equals(element.getNamespaceURI()) && "showPopupBehavior".equals(element.getLocalName())) {
            this._validatePopupId(context, element);
            this._validateAlignId(context, element);
        }
    }

    public void enter(AuditContext context, Attr attr) {
        if (this._amxResolver == null) {
            return;
        }
        if (!this._amxResolver.isScopedIdHolder(attr)) {
            return;
        }
        XmlModel model = ((XmlModelAdapter)context.getModel()).getXmlModel();
        Map<Attr, Collection<AMXScopedIdTraversalHandler.AMXScopedIdTraversalReference>> refs = AMXScopedIdTraversalHandler.getScopedIdReferencesMap(model);
        if (refs == null || refs.isEmpty()) {
            return;
        }
        Collection<AMXScopedIdTraversalHandler.AMXScopedIdTraversalReference> attrReferences = refs.get(attr);
        if (attrReferences == null || attrReferences.isEmpty()) {
            return;
        }
        Context ideContext = context.getIdeContext();
        JDevXmlContext xmlContext = XMLSourceNode.getXmlContext((Context)ideContext);
        AMXScopedIdContext idContext = new AMXScopedIdContext((XmlContext)xmlContext);
        for (AMXScopedIdTraversalHandler.AMXScopedIdTraversalReference attrRef : attrReferences) {
            this._checkReferences(context, idContext, attr, attrRef);
        }
    }

    public void exit(AuditContext context, Document document) {
        this._amxResolver = null;
    }

    private void _checkReferences(AuditContext context, ScopedIdContext idContext, Attr attr, AMXScopedIdTraversalHandler.AMXScopedIdTraversalReference ref) {
        String bit = ref.getRef();
        ScopedId targetId = ScopedIdUtils.resolveScopedId((ScopedIdContext)idContext, (ScopedId)ref.getScopedId(), (String)bit);
        if (targetId == null) {
            if (this._invalidScopedId.isEnabled()) {
                ViolationReport report = context.report(this._invalidScopedId, (Object)attr);
                report.addParameter(_AFFECTED_BIT, (Object)bit);
            }
        } else {
            ViolationReport report;
            Element targetElement = targetId.getOwnerElement();
            if ("popupId".equals(attr.getLocalName()) && this._targetNotPopup.isEnabled() && (!"http://xmlns.oracle.com/adf/mf/amx".equals(targetElement.getNamespaceURI()) || !"popup".equals(targetElement.getLocalName()))) {
                report = context.report(this._targetNotPopup, (Object)attr);
                report.addParameter(_AFFECTED_BIT, (Object)bit);
            }
            if ("alignId".equals(attr.getLocalName()) && this._targetNotUIComponent.isEnabled() && !this._amxResolver.isUIComponent(targetElement)) {
                report = context.report(this._targetNotUIComponent, (Object)attr);
                report.addParameter(_AFFECTED_BIT, (Object)bit);
            }
        }
    }

    private void _validatePopupId(AuditContext context, Element element) {
        if (this._noPopupId.isEnabled()) {
            String popupId = element.getAttributeNS(null, "popupId");
            if (popupId != null) {
                popupId = popupId.trim();
            }
            if (popupId == null || popupId.isEmpty()) {
                ViolationReport report = context.report(this._noPopupId, (Object)element);
                report.addParameter("message", (Object)MobileResourceUtils.getText("NO_POPUP_ID_FOUND", element.getLocalName()));
            }
        }
    }

    private void _validateAlignId(AuditContext context, Element element) {
        if (this._noAlignId.isEnabled()) {
            String alignId = element.getAttributeNS(null, "alignId");
            if (alignId != null) {
                alignId = alignId.trim();
            }
            if (alignId == null || alignId.isEmpty()) {
                ViolationReport report = context.report(this._noAlignId, (Object)element);
                report.addParameter("message", (Object)MobileResourceUtils.getText("NO_ALIGN_ID_FOUND", element.getLocalName()));
            }
        }
    }
}

