/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.util.regex;

import oracle.adfmf.util.regex.Pattern;

public final class Matcher {
    Pattern parentPattern;
    int[] groups;
    int from;
    int to;
    CharSequence text;
    static final int ENDANCHOR = 1;
    static final int NOANCHOR = 0;
    int acceptMode = 0;
    int first = -1;
    int last = -1;
    int oldLast = -1;
    int lastAppendPosition = 0;
    int[] locals;

    Matcher() {
    }

    Matcher(Pattern pattern, CharSequence charSequence) {
        this.parentPattern = pattern;
        this.text = charSequence;
        int n = Math.max(pattern.groupCount, 10);
        this.groups = new int[n * 2];
        this.locals = new int[pattern.localCount];
        this.reset();
    }

    public Pattern pattern() {
        return this.parentPattern;
    }

    public Matcher reset() {
        int n;
        this.first = -1;
        this.last = -1;
        this.oldLast = -1;
        for (n = 0; n < this.groups.length; ++n) {
            this.groups[n] = -1;
        }
        for (n = 0; n < this.locals.length; ++n) {
            this.locals[n] = -1;
        }
        this.lastAppendPosition = 0;
        return this;
    }

    public Matcher reset(CharSequence charSequence) {
        this.text = charSequence;
        return this.reset();
    }

    public int start() {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        return this.first;
    }

    public int start(int n) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (n > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + n);
        }
        return this.groups[n * 2];
    }

    public int end() {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        return this.last;
    }

    public int end(int n) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (n > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + n);
        }
        return this.groups[n * 2 + 1];
    }

    public String group() {
        return this.group(0);
    }

    public String group(int n) {
        if (this.first < 0) {
            throw new IllegalStateException("No match found");
        }
        if (n < 0 || n > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + n);
        }
        if (this.groups[n * 2] == -1 || this.groups[n * 2 + 1] == -1) {
            return null;
        }
        return ((Object)this.getSubSequence(this.groups[n * 2], this.groups[n * 2 + 1])).toString();
    }

    public int groupCount() {
        return this.parentPattern.groupCount - 1;
    }

    public boolean matches() {
        this.reset();
        return this.match(0, this.getTextLength(), 1);
    }

    public boolean find() {
        if (this.last == this.first) {
            ++this.last;
        }
        if (this.last > this.to) {
            for (int i = 0; i < this.groups.length; ++i) {
                this.groups[i] = -1;
            }
            return false;
        }
        return this.find(this.last, this.getTextLength());
    }

    public boolean find(int n) {
        int n2 = this.getTextLength();
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("Illegal start index");
        }
        this.reset();
        return this.find(n, n2);
    }

    public boolean lookingAt() {
        this.reset();
        return this.match(0, this.getTextLength(), 0);
    }

    public Matcher appendReplacement(StringBuffer stringBuffer, String string) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        int n = 0;
        String string2 = string;
        StringBuffer stringBuffer2 = new StringBuffer();
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\') {
                c = string.charAt(++n);
                stringBuffer2.append(c);
                ++n;
                continue;
            }
            if (c == '$') {
                int n2;
                int n3;
                if ((n3 = string.charAt(++n) - 48) < 0 || n3 > 9) {
                    throw new IllegalArgumentException("Illegal group reference");
                }
                ++n;
                boolean bl = false;
                while (!bl && n < string.length() && (n2 = string.charAt(n) - 48) >= 0 && n2 <= 9) {
                    int n4 = n3 * 10 + n2;
                    if (this.groupCount() < n4) {
                        bl = true;
                        continue;
                    }
                    n3 = n4;
                    ++n;
                }
                if (this.group(n3) == null) continue;
                stringBuffer2.append(this.group(n3));
                continue;
            }
            stringBuffer2.append(c);
            ++n;
        }
        stringBuffer.append((Object)this.getSubSequence(this.lastAppendPosition, this.first));
        stringBuffer.append(stringBuffer2.toString());
        this.lastAppendPosition = this.last;
        return this;
    }

    public StringBuffer appendTail(StringBuffer stringBuffer) {
        stringBuffer.append(((Object)this.getSubSequence(this.lastAppendPosition, this.getTextLength())).toString());
        return stringBuffer;
    }

    public String replaceAll(String string) {
        this.reset();
        boolean bl = this.find();
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            do {
                this.appendReplacement(stringBuffer, string);
            } while (bl = this.find());
            this.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return ((Object)this.text).toString();
    }

    public String replaceFirst(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.reset();
        if (this.find()) {
            this.appendReplacement(stringBuffer, string);
        }
        this.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private boolean find(int n, int n2) {
        boolean bl;
        n = n < 0 ? 0 : n;
        this.to = n2;
        this.first = n;
        this.last = -1;
        this.oldLast = this.oldLast < 0 ? n : this.oldLast;
        for (bl = false; bl < this.groups.length; bl += 1) {
            this.groups[bl] = -1;
        }
        this.acceptMode = 0;
        bl = this.parentPattern.root.match(this, n, this.text);
        if (!bl) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return bl;
    }

    private boolean match(int n, int n2, int n3) {
        boolean bl;
        n = n < 0 ? 0 : n;
        this.to = n2;
        this.first = n;
        this.last = -1;
        this.oldLast = this.oldLast < 0 ? n : this.oldLast;
        for (bl = false; bl < this.groups.length; bl += 1) {
            this.groups[bl] = -1;
        }
        this.acceptMode = n3;
        bl = this.parentPattern.matchRoot.match(this, n, this.text);
        if (!bl) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return bl;
    }

    int getTextLength() {
        return this.text.length();
    }

    CharSequence getSubSequence(int n, int n2) {
        return this.text.subSequence(n, n2);
    }

    char charAt(int n) {
        return this.text.charAt(n);
    }
}

