/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.Node;
import de.odysseus.el.tree.impl.ast.AstNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueReference;

public abstract class AstProperty
extends AstNode {
    protected final AstNode prefix;
    protected final boolean lvalue;
    protected final boolean strict;

    public AstProperty(AstNode astNode, boolean bl, boolean bl2) {
        this.prefix = astNode;
        this.lvalue = bl;
        this.strict = bl2;
    }

    protected abstract Object getProperty(Bindings var1, ELContext var2) throws ELException;

    protected AstNode getPrefix() {
        return this.prefix;
    }

    public ValueReference getValueReference(Bindings bindings, ELContext eLContext) {
        Object object = this.prefix.eval(bindings, eLContext);
        if (object == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", new Object[]{this.prefix}));
        }
        Object object2 = this.getProperty(bindings, eLContext);
        if (object2 == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", new Object[]{"null", object}));
        }
        return new ValueReference(object, object2);
    }

    public Object eval(Bindings bindings, ELContext eLContext) {
        Object object = this.prefix.eval(bindings, eLContext);
        if (object == null) {
            return null;
        }
        Object object2 = this.getProperty(bindings, eLContext);
        if (object2 == null && this.strict) {
            return null;
        }
        eLContext.setPropertyResolved(false);
        Object object3 = eLContext.getELResolver().getValue(eLContext, object, object2);
        if (!eLContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", new Object[]{object2, object}));
        }
        return object3;
    }

    public final boolean isLiteralText() {
        return false;
    }

    public final boolean isLeftValue() {
        return this.lvalue;
    }

    public boolean isMethodInvocation() {
        return false;
    }

    public Class getType(Bindings bindings, ELContext eLContext) {
        if (!this.lvalue) {
            return null;
        }
        Object object = this.prefix.eval(bindings, eLContext);
        if (object == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", new Object[]{this.prefix}));
        }
        Object object2 = this.getProperty(bindings, eLContext);
        if (object2 == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", new Object[]{"null", object}));
        }
        eLContext.setPropertyResolved(false);
        Class clazz = eLContext.getELResolver().getType(eLContext, object, object2);
        if (!eLContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", new Object[]{object2, object}));
        }
        return clazz;
    }

    public boolean isReadOnly(Bindings bindings, ELContext eLContext) throws ELException {
        if (!this.lvalue) {
            return true;
        }
        Object object = this.prefix.eval(bindings, eLContext);
        if (object == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", new Object[]{this.prefix}));
        }
        Object object2 = this.getProperty(bindings, eLContext);
        if (object2 == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", new Object[]{"null", object}));
        }
        eLContext.setPropertyResolved(false);
        boolean bl = eLContext.getELResolver().isReadOnly(eLContext, object, object2);
        if (!eLContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", new Object[]{object2, object}));
        }
        return bl;
    }

    public void setValue(Bindings bindings, ELContext eLContext, Object object) throws ELException {
        if (!this.lvalue) {
            throw new ELException(LocalMessages.get("error.value.set.rvalue", new Object[]{this.getStructuralId(bindings)}));
        }
        Object object2 = this.prefix.eval(bindings, eLContext);
        if (object2 == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", new Object[]{this.prefix}));
        }
        Object object3 = this.getProperty(bindings, eLContext);
        if (object3 == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", new Object[]{"null", object2}));
        }
        eLContext.setPropertyResolved(false);
        eLContext.getELResolver().setValue(eLContext, object2, object3, object);
        if (!eLContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", new Object[]{object3, object2}));
        }
    }

    protected Method findMethod(String string, Class clazz, Class clazz2, Class[] classArray) {
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", new Object[]{string, clazz}));
        }
        method = this.findAccessibleMethod(method);
        if (method == null) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", new Object[]{string, clazz}));
        }
        if (clazz2 != null && !clazz2.isAssignableFrom(method.getReturnType())) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", new Object[]{string, clazz}));
        }
        return method;
    }

    public MethodInfo getMethodInfo(Bindings bindings, ELContext eLContext, Class clazz, Class[] classArray) {
        Object object = this.prefix.eval(bindings, eLContext);
        if (object == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", new Object[]{this.prefix}));
        }
        Object object2 = this.getProperty(bindings, eLContext);
        if (object2 == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.method.notfound", new Object[]{"null", object}));
        }
        String string = (String)bindings.convert(object2, String.class);
        Method method = this.findMethod(string, object.getClass(), clazz, classArray);
        return new MethodInfo(method.getName(), method.getReturnType(), classArray);
    }

    public Object invoke(Bindings bindings, ELContext eLContext, Class clazz, Class[] classArray, Object[] objectArray) {
        Object object = this.prefix.eval(bindings, eLContext);
        if (object == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", new Object[]{this.prefix}));
        }
        Object object2 = this.getProperty(bindings, eLContext);
        if (object2 == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.method.notfound", new Object[]{"null", object}));
        }
        String string = (String)bindings.convert(object2, String.class);
        Method method = this.findMethod(string, object.getClass(), clazz, classArray);
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ELException(LocalMessages.get("error.property.method.access", new Object[]{string, object.getClass()}));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ELException(LocalMessages.get("error.property.method.invocation", new Object[]{string, object.getClass()}), (Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ELException(LocalMessages.get("error.property.method.invocation", new Object[]{string, object.getClass()}), invocationTargetException.getCause());
        }
    }

    public Node getChild(int n) {
        return n == 0 ? this.prefix : null;
    }
}

