/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.ExpressionNode;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import javax.el.ELContext;

public abstract class AstNode
implements ExpressionNode {
    public final Object getValue(Bindings bindings, ELContext eLContext, Class clazz) {
        Object object = this.eval(bindings, eLContext);
        if (clazz != null) {
            object = bindings.convert(object, clazz);
        }
        return object;
    }

    public abstract void appendStructure(StringBuffer var1, Bindings var2);

    public abstract Object eval(Bindings var1, ELContext var2);

    public final String getStructuralId(Bindings bindings) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendStructure(stringBuffer, bindings);
        return stringBuffer.toString();
    }

    protected Method findAccessibleMethod(Method method) {
        if (method == null || method.isAccessible()) {
            return method;
        }
        try {
            method.setAccessible(true);
        }
        catch (SecurityException securityException) {
            GenericDeclaration genericDeclaration;
            Class<?>[] classArray = method.getDeclaringClass().getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                genericDeclaration = classArray[i];
                Method method2 = null;
                try {
                    method2 = genericDeclaration.getMethod(method.getName(), method.getParameterTypes());
                    method2 = this.findAccessibleMethod(method2);
                    if (method2 == null) continue;
                    return method2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            Class<?> clazz = method.getDeclaringClass().getSuperclass();
            if (clazz != null) {
                genericDeclaration = null;
                try {
                    genericDeclaration = clazz.getMethod(method.getName(), method.getParameterTypes());
                    genericDeclaration = this.findAccessibleMethod((Method)genericDeclaration);
                    if (genericDeclaration != null) {
                        return genericDeclaration;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return null;
        }
        return method;
    }
}

