/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.BooleanOperations;
import de.odysseus.el.misc.NumberOperations;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.Node;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstRightValue;
import javax.el.ELContext;

public class AstBinary
extends AstRightValue {
    public static final Operator ADD = new SimpleOperator(){

        public Object apply(TypeConverter typeConverter, Object object, Object object2) {
            if (object instanceof String && object2 instanceof String) {
                return (String)object + (String)object2;
            }
            return NumberOperations.add(typeConverter, object, object2);
        }

        public String toString() {
            return "+";
        }
    };
    public static final Operator AND = new Operator(){

        public Object eval(Bindings bindings, ELContext eLContext, AstNode astNode, AstNode astNode2) {
            Boolean bl = (Boolean)bindings.convert(astNode.eval(bindings, eLContext), class$java$lang$Boolean == null ? (class$java$lang$Boolean = AstBinary.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            return Boolean.TRUE.equals(bl) ? bindings.convert(astNode2.eval(bindings, eLContext), class$java$lang$Boolean == null ? (class$java$lang$Boolean = AstBinary.class$("java.lang.Boolean")) : class$java$lang$Boolean) : Boolean.FALSE;
        }

        public String toString() {
            return "&&";
        }
    };
    public static final Operator DIV = new SimpleOperator(){

        public Object apply(TypeConverter typeConverter, Object object, Object object2) {
            return NumberOperations.div(typeConverter, object, object2);
        }

        public String toString() {
            return "/";
        }
    };
    public static final Operator EQ = new SimpleOperator(){

        public Object apply(TypeConverter typeConverter, Object object, Object object2) {
            return new Boolean(BooleanOperations.eq(typeConverter, object, object2));
        }

        public String toString() {
            return "==";
        }
    };
    public static final Operator GE = new SimpleOperator(){

        public Object apply(TypeConverter typeConverter, Object object, Object object2) {
            return new Boolean(BooleanOperations.ge(typeConverter, object, object2));
        }

        public String toString() {
            return ">=";
        }
    };
    public static final Operator GT = new SimpleOperator(){

        public Object apply(TypeConverter typeConverter, Object object, Object object2) {
            return new Boolean(BooleanOperations.gt(typeConverter, object, object2));
        }

        public String toString() {
            return ">";
        }
    };
    public static final Operator LE = new SimpleOperator(){

        public Object apply(TypeConverter typeConverter, Object object, Object object2) {
            return new Boolean(BooleanOperations.le(typeConverter, object, object2));
        }

        public String toString() {
            return "<=";
        }
    };
    public static final Operator LT = new SimpleOperator(){

        public Object apply(TypeConverter typeConverter, Object object, Object object2) {
            return new Boolean(BooleanOperations.lt(typeConverter, object, object2));
        }

        public String toString() {
            return "<";
        }
    };
    public static final Operator MOD = new SimpleOperator(){

        public Object apply(TypeConverter typeConverter, Object object, Object object2) {
            return NumberOperations.mod(typeConverter, object, object2);
        }

        public String toString() {
            return "%";
        }
    };
    public static final Operator MUL = new SimpleOperator(){

        public Object apply(TypeConverter typeConverter, Object object, Object object2) {
            return NumberOperations.mul(typeConverter, object, object2);
        }

        public String toString() {
            return "*";
        }
    };
    public static final Operator NE = new SimpleOperator(){

        public Object apply(TypeConverter typeConverter, Object object, Object object2) {
            return new Boolean(BooleanOperations.ne(typeConverter, object, object2));
        }

        public String toString() {
            return "!=";
        }
    };
    public static final Operator OR = new Operator(){

        public Object eval(Bindings bindings, ELContext eLContext, AstNode astNode, AstNode astNode2) {
            Boolean bl = (Boolean)bindings.convert(astNode.eval(bindings, eLContext), class$java$lang$Boolean == null ? (class$java$lang$Boolean = AstBinary.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            return Boolean.TRUE.equals(bl) ? Boolean.TRUE : bindings.convert(astNode2.eval(bindings, eLContext), class$java$lang$Boolean == null ? (class$java$lang$Boolean = AstBinary.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        }

        public String toString() {
            return "||";
        }
    };
    public static final Operator SUB = new SimpleOperator(){

        public Object apply(TypeConverter typeConverter, Object object, Object object2) {
            return NumberOperations.sub(typeConverter, object, object2);
        }

        public String toString() {
            return "-";
        }
    };
    private final Operator operator;
    private final AstNode left;
    private final AstNode right;
    static /* synthetic */ Class class$java$lang$Boolean;

    public AstBinary(AstNode astNode, AstNode astNode2, Operator operator) {
        this.left = astNode;
        this.right = astNode2;
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Object eval(Bindings bindings, ELContext eLContext) {
        return this.operator.eval(bindings, eLContext, this.left, this.right);
    }

    public String toString() {
        return "'" + this.operator.toString() + "'";
    }

    public void appendStructure(StringBuffer stringBuffer, Bindings bindings) {
        this.left.appendStructure(stringBuffer, bindings);
        stringBuffer.append(' ');
        stringBuffer.append(this.operator);
        stringBuffer.append(' ');
        this.right.appendStructure(stringBuffer, bindings);
    }

    public int getCardinality() {
        return 2;
    }

    public Node getChild(int n) {
        return n == 0 ? this.left : (n == 1 ? this.right : null);
    }

    public static abstract class SimpleOperator
    implements Operator {
        public Object eval(Bindings bindings, ELContext eLContext, AstNode astNode, AstNode astNode2) {
            return this.apply(bindings, astNode.eval(bindings, eLContext), astNode2.eval(bindings, eLContext));
        }

        protected abstract Object apply(TypeConverter var1, Object var2, Object var3);
    }

    public static interface Operator {
        public Object eval(Bindings var1, ELContext var2, AstNode var3, AstNode var4);
    }
}

