/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl;

import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.TreeCache;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class Cache
implements TreeCache {
    private final Map primary;
    private final Map secondary;

    public Cache(int n) {
        this(n, new WeakHashMap());
    }

    public Cache(final int n, Map map) {
        this.primary = Collections.synchronizedMap(new LinkedHashMap(16, 0.75f, true){

            protected boolean removeEldestEntry(Map.Entry entry) {
                if (this.size() > n) {
                    if (Cache.this.secondary != null) {
                        Cache.this.secondary.put(entry.getKey(), entry.getValue());
                    }
                    return true;
                }
                return false;
            }
        });
        this.secondary = map == null ? null : Collections.synchronizedMap(map);
    }

    public Tree get(String string) {
        if (this.secondary == null) {
            return (Tree)this.primary.get(string);
        }
        Tree tree = (Tree)this.primary.get(string);
        if (tree == null) {
            tree = (Tree)this.secondary.get(string);
        }
        return tree;
    }

    public void put(String string, Tree tree) {
        this.primary.put(string, tree);
    }
}

