/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl;

import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.TreeBuilder;
import de.odysseus.el.tree.TreeBuilderException;
import de.odysseus.el.tree.impl.Parser;
import de.odysseus.el.tree.impl.Scanner;

public class Builder
implements TreeBuilder {
    private static final long serialVersionUID = 1L;

    public Builder() {
    }

    public Builder(Feature[] featureArray) {
    }

    public boolean isEnabled(Feature feature) {
        return true;
    }

    public Tree build(String string) throws TreeBuilderException {
        try {
            return this.createParser(string).tree();
        }
        catch (Scanner.ScanException scanException) {
            throw new TreeBuilderException(string, scanException.position, scanException.encountered, scanException.expected, scanException.getMessage());
        }
        catch (Parser.ParseException parseException) {
            throw new TreeBuilderException(string, parseException.position, parseException.encountered, parseException.expected, parseException.getMessage());
        }
    }

    protected Parser createParser(String string) {
        return new Parser(this, string);
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class Feature {
        public static int METHOD_INVOCATIONS = 0;
        public static int NULL_PROPERTIES = 1;
        public static int VARARGS = 2;
        private int _code;

        public Feature(int n) {
            this._code = n;
        }

        public int getCode() {
            return this._code;
        }
    }
}

