/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree;

import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.misc.TypeConverterImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.el.ValueExpression;

public class Bindings
implements TypeConverter {
    private static final long serialVersionUID = 1L;
    private static final Method[] NO_FUNCTIONS = new Method[0];
    private static final ValueExpression[] NO_VARIABLES = new ValueExpression[0];
    private TypeConverterImpl myConv = new TypeConverterImpl();
    private transient Method[] functions;
    private final ValueExpression[] variables;
    private final TypeConverter converter;

    public Bindings(Method[] methodArray, ValueExpression[] valueExpressionArray) {
        this(methodArray, valueExpressionArray, TypeConverter.DEFAULT);
    }

    public Bindings(Method[] methodArray, ValueExpression[] valueExpressionArray, TypeConverter typeConverter) {
        this.functions = methodArray == null || methodArray.length == 0 ? NO_FUNCTIONS : methodArray;
        this.variables = valueExpressionArray == null || valueExpressionArray.length == 0 ? NO_VARIABLES : valueExpressionArray;
        this.converter = typeConverter == null ? TypeConverter.DEFAULT : typeConverter;
    }

    public Method getFunction(int n) {
        return this.functions[n];
    }

    public boolean isFunctionBound(int n) {
        return n >= 0 && n < this.functions.length;
    }

    public ValueExpression getVariable(int n) {
        return this.variables[n];
    }

    public boolean isVariableBound(int n) {
        return n >= 0 && n < this.variables.length && this.variables[n] != null;
    }

    public Object convert(Object object, Class clazz) {
        return this.myConv.coerceToType(object, clazz);
    }

    public boolean equals(Object object) {
        if (object instanceof Bindings) {
            Bindings bindings = (Bindings)object;
            return Arrays.equals(this.functions, bindings.functions) && Arrays.equals(this.variables, bindings.variables) && this.converter.equals(bindings.converter);
        }
        return false;
    }

    public int hashCode() {
        int n;
        int n2 = 0;
        if (this.functions != null) {
            for (n = 0; n < this.functions.length; ++n) {
                n2 ^= this.functions[n].hashCode();
            }
        }
        if (this.variables != null) {
            for (n = 0; n < this.variables.length; ++n) {
                n2 ^= this.variables[n].hashCode();
            }
        }
        return n2 ^ this.converter.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        objectOutputStream.defaultWriteObject();
        MethodWrapper[] methodWrapperArray = new MethodWrapper[this.functions.length];
        for (int i = 0; i < methodWrapperArray.length; ++i) {
            methodWrapperArray[i] = new MethodWrapper(this.functions[i]);
        }
        objectOutputStream.writeObject(methodWrapperArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        MethodWrapper[] methodWrapperArray = (MethodWrapper[])objectInputStream.readObject();
        if (methodWrapperArray.length == 0) {
            this.functions = NO_FUNCTIONS;
        } else {
            this.functions = new Method[methodWrapperArray.length];
            for (int i = 0; i < this.functions.length; ++i) {
                this.functions[i] = methodWrapperArray[i].method;
            }
        }
    }

    private static class MethodWrapper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient Method method;

        private MethodWrapper(Method method) {
            this.method = method;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(this.method.getDeclaringClass());
            objectOutputStream.writeObject(this.method.getName());
            objectOutputStream.writeObject(this.method.getParameterTypes());
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            Class clazz = (Class)objectInputStream.readObject();
            String string = (String)objectInputStream.readObject();
            Class[] classArray = (Class[])objectInputStream.readObject();
            try {
                this.method = clazz.getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IOException(noSuchMethodException.getMessage());
            }
        }
    }
}

