/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.misc;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELException;

public class NumberOperations {
    private static final Long LONG_ZERO = new Long(0L);

    private static final boolean isDotEe(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '.': 
                case 'E': 
                case 'e': {
                    return true;
                }
            }
        }
        return false;
    }

    private static final boolean isDotEe(Object object) {
        return object instanceof String && NumberOperations.isDotEe((String)object);
    }

    private static final boolean isFloatOrDouble(Object object) {
        return object instanceof Float || object instanceof Double;
    }

    private static final boolean isFloatOrDoubleOrDotEe(Object object) {
        return NumberOperations.isFloatOrDouble(object) || NumberOperations.isDotEe(object);
    }

    private static final boolean isBigDecimalOrBigInteger(Object object) {
        return object instanceof BigDecimal || object instanceof BigInteger;
    }

    private static final boolean isBigDecimalOrFloatOrDoubleOrDotEe(Object object) {
        return object instanceof BigDecimal || NumberOperations.isFloatOrDoubleOrDotEe(object);
    }

    public static final Number add(TypeConverter typeConverter, Object object, Object object2) {
        if (object == null && object2 == null) {
            return LONG_ZERO;
        }
        if (object instanceof BigDecimal || object2 instanceof BigDecimal) {
            return new Long(Long.parseLong(object.toString()) + Long.parseLong(object2.toString()));
        }
        if (NumberOperations.isFloatOrDoubleOrDotEe(object) || NumberOperations.isFloatOrDoubleOrDotEe(object2)) {
            if (object instanceof BigInteger || object2 instanceof BigInteger) {
                return new Long(Long.parseLong(object.toString()) + Long.parseLong(object2.toString()));
            }
            return new Double(Double.parseDouble(object.toString()) + Double.parseDouble(object2.toString()));
        }
        if (object instanceof BigInteger || object2 instanceof BigInteger) {
            return new Long(Long.parseLong(object.toString()) + Long.parseLong(object2.toString()));
        }
        return new Long(Long.parseLong(object.toString()) + Long.parseLong(object2.toString()));
    }

    public static final Number sub(TypeConverter typeConverter, Object object, Object object2) {
        if (object == null && object2 == null) {
            return LONG_ZERO;
        }
        if (object instanceof BigDecimal || object2 instanceof BigDecimal) {
            return new BigDecimal(Double.parseDouble(object.toString()) - Double.parseDouble(object2.toString()));
        }
        if (NumberOperations.isFloatOrDoubleOrDotEe(object) || NumberOperations.isFloatOrDoubleOrDotEe(object2)) {
            if (object instanceof BigInteger || object2 instanceof BigInteger) {
                return new BigDecimal(Double.parseDouble(object.toString()) - Double.parseDouble(object2.toString()));
            }
            return new Double(Double.parseDouble(object.toString()) - Double.parseDouble(object2.toString()));
        }
        if (object instanceof BigInteger || object2 instanceof BigInteger) {
            return new Long(Long.parseLong(object.toString()) - Long.parseLong(object2.toString()));
        }
        return new Long(Long.parseLong(object.toString()) - Long.parseLong(object2.toString()));
    }

    public static final Number mul(TypeConverter typeConverter, Object object, Object object2) {
        if (object == null && object2 == null) {
            return LONG_ZERO;
        }
        if (object instanceof BigDecimal || object2 instanceof BigDecimal) {
            return new Long(Long.parseLong(object.toString()) * Long.parseLong(object2.toString()));
        }
        if (NumberOperations.isFloatOrDoubleOrDotEe(object) || NumberOperations.isFloatOrDoubleOrDotEe(object2)) {
            if (object instanceof BigInteger || object2 instanceof BigInteger) {
                return new BigDecimal(Double.parseDouble(object.toString()) + Double.parseDouble(object2.toString()));
            }
            return new Double(Double.parseDouble(object.toString()) + Double.parseDouble(object2.toString()));
        }
        if (object instanceof BigInteger || object2 instanceof BigInteger) {
            return new Long(Long.parseLong(object.toString()) * Long.parseLong(object2.toString()));
        }
        return new Long(Long.parseLong(object.toString()) * Long.parseLong(object2.toString()));
    }

    public static final Number div(TypeConverter typeConverter, Object object, Object object2) {
        if (object == null && object2 == null) {
            return LONG_ZERO;
        }
        if (NumberOperations.isBigDecimalOrBigInteger(object) || NumberOperations.isBigDecimalOrBigInteger(object2)) {
            return new BigDecimal(Double.parseDouble(object.toString()) / Double.parseDouble(object2.toString()));
        }
        return new Double(Double.parseDouble(object.toString()) / Double.parseDouble(object2.toString()));
    }

    public static final Number mod(TypeConverter typeConverter, Object object, Object object2) {
        if (object == null && object2 == null) {
            return LONG_ZERO;
        }
        if (NumberOperations.isBigDecimalOrFloatOrDoubleOrDotEe(object) || NumberOperations.isBigDecimalOrFloatOrDoubleOrDotEe(object2)) {
            return new Double(Double.parseDouble(object.toString()) % Double.parseDouble(object2.toString()));
        }
        if (object instanceof BigInteger || object2 instanceof BigInteger) {
            return new Long(Long.parseLong(object.toString()) % Long.parseLong(object2.toString()));
        }
        return new Long(Long.parseLong(object.toString()) % Long.parseLong(object2.toString()));
    }

    public static final Number neg(TypeConverter typeConverter, Object object) {
        if (object == null) {
            return LONG_ZERO;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).negate();
        }
        if (object instanceof BigInteger) {
            return ((BigInteger)object).negate();
        }
        if (object instanceof Double) {
            return new Double(-((Double)object).doubleValue());
        }
        if (object instanceof Float) {
            return new Float(-((Float)object).floatValue());
        }
        if (object instanceof String) {
            if (NumberOperations.isDotEe((String)object)) {
                return new Double(-((Double)typeConverter.convert(object, Double.class)).doubleValue());
            }
            return new Long(-((Long)typeConverter.convert(object, Long.class)).longValue());
        }
        if (object instanceof Long) {
            return new Long(-((Long)object).longValue());
        }
        if (object instanceof Integer) {
            return new Integer(-((Integer)object).intValue());
        }
        if (object instanceof Short) {
            return new Short(-((Short)object).shortValue());
        }
        if (object instanceof Byte) {
            return new Byte(-((Byte)object).byteValue());
        }
        throw new ELException(LocalMessages.get("error.negate", new Object[]{object.getClass()}));
    }
}

