/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.Node;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstParameters;
import de.odysseus.el.tree.impl.ast.AstProperty;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueReference;

public class AstMethod
extends AstNode {
    private final AstProperty property;
    private final AstParameters params;

    public AstMethod(AstProperty astProperty, AstParameters astParameters) {
        this.property = astProperty;
        this.params = astParameters;
    }

    public boolean isLiteralText() {
        return false;
    }

    public Class getType(Bindings bindings, ELContext eLContext) {
        return null;
    }

    public boolean isReadOnly(Bindings bindings, ELContext eLContext) {
        return true;
    }

    public void setValue(Bindings bindings, ELContext eLContext, Object object) {
        throw new ELException(LocalMessages.get("error.value.set.rvalue", new Object[]{this.getStructuralId(bindings)}));
    }

    public MethodInfo getMethodInfo(Bindings bindings, ELContext eLContext, Class clazz, Class[] classArray) {
        return null;
    }

    public boolean isLeftValue() {
        return false;
    }

    public boolean isMethodInvocation() {
        return true;
    }

    public final ValueReference getValueReference(Bindings bindings, ELContext eLContext) {
        return null;
    }

    public void appendStructure(StringBuffer stringBuffer, Bindings bindings) {
        this.property.appendStructure(stringBuffer, bindings);
        this.params.appendStructure(stringBuffer, bindings);
    }

    protected Object eval(Bindings bindings, ELContext eLContext, boolean bl) {
        Object object = this.property.getPrefix().eval(bindings, eLContext);
        if (object == null) {
            if (bl) {
                return null;
            }
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", new Object[]{this.property.getPrefix()}));
        }
        Object object2 = this.property.getProperty(bindings, eLContext);
        if (object2 == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.method.notfound", new Object[]{"null", object}));
        }
        String string = (String)bindings.convert(object2, String.class);
        eLContext.setPropertyResolved(false);
        Object object3 = eLContext.getELResolver().invoke(eLContext, object, (Object)string, null, (Object[])this.params.eval(bindings, eLContext));
        if (!eLContext.isPropertyResolved()) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", new Object[]{string, object.getClass()}));
        }
        return object3;
    }

    public Object eval(Bindings bindings, ELContext eLContext) {
        return this.eval(bindings, eLContext, true);
    }

    public Object invoke(Bindings bindings, ELContext eLContext, Class clazz, Class[] classArray, Object[] objectArray) {
        return this.eval(bindings, eLContext, false);
    }

    public int getCardinality() {
        return 2;
    }

    public Node getChild(int n) {
        if (n == 0) {
            return this.property;
        }
        if (n == 1) {
            return this.params;
        }
        return null;
    }

    public String toString() {
        return "<method>";
    }
}

