/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.IdentifierNode;
import de.odysseus.el.tree.Node;
import de.odysseus.el.tree.impl.ast.AstNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import javax.el.ValueReference;

public class AstIdentifier
extends AstNode
implements IdentifierNode {
    private final String name;
    private final int index;

    public AstIdentifier(String string, int n) {
        this.name = string;
        this.index = n;
    }

    public Class getType(Bindings bindings, ELContext eLContext) {
        ValueExpression valueExpression = bindings.getVariable(this.index);
        if (valueExpression != null) {
            return valueExpression.getType(eLContext);
        }
        eLContext.setPropertyResolved(false);
        Class clazz = eLContext.getELResolver().getType(eLContext, null, (Object)this.name);
        if (!eLContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.identifier.property.notfound", new Object[]{this.name}));
        }
        return clazz;
    }

    public boolean isLeftValue() {
        return true;
    }

    public boolean isMethodInvocation() {
        return false;
    }

    public boolean isLiteralText() {
        return false;
    }

    public ValueReference getValueReference(Bindings bindings, ELContext eLContext) {
        ValueExpression valueExpression = bindings.getVariable(this.index);
        if (valueExpression != null) {
            return valueExpression.getValueReference(eLContext);
        }
        return new ValueReference(null, (Object)this.name);
    }

    public Object eval(Bindings bindings, ELContext eLContext) {
        ValueExpression valueExpression = bindings.getVariable(this.index);
        if (valueExpression != null) {
            return valueExpression.getValue(eLContext);
        }
        eLContext.setPropertyResolved(false);
        Object object = eLContext.getELResolver().getValue(eLContext, null, (Object)this.name);
        if (!eLContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.identifier.property.notfound", new Object[]{this.name}));
        }
        return object;
    }

    public void setValue(Bindings bindings, ELContext eLContext, Object object) {
        ValueExpression valueExpression = bindings.getVariable(this.index);
        if (valueExpression != null) {
            valueExpression.setValue(eLContext, object);
            return;
        }
        eLContext.setPropertyResolved(false);
        eLContext.getELResolver().setValue(eLContext, null, (Object)this.name, object);
        if (!eLContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.identifier.property.notfound", new Object[]{this.name}));
        }
    }

    public boolean isReadOnly(Bindings bindings, ELContext eLContext) {
        ValueExpression valueExpression = bindings.getVariable(this.index);
        if (valueExpression != null) {
            return valueExpression.isReadOnly(eLContext);
        }
        eLContext.setPropertyResolved(false);
        boolean bl = eLContext.getELResolver().isReadOnly(eLContext, null, (Object)this.name);
        if (!eLContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.identifier.property.notfound", new Object[]{this.name}));
        }
        return bl;
    }

    protected Method getMethod(Bindings bindings, ELContext eLContext, Class clazz, Class[] classArray) {
        Object object = this.eval(bindings, eLContext);
        if (object == null) {
            throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.notfound", new Object[]{this.name}));
        }
        if (object instanceof Method) {
            Method method = this.findAccessibleMethod((Method)object);
            if (method == null) {
                throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.notfound", new Object[]{this.name}));
            }
            if (clazz != null && !clazz.isAssignableFrom(method.getReturnType())) {
                throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.notfound", new Object[]{this.name}));
            }
            if (!Arrays.equals(method.getParameterTypes(), classArray)) {
                throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.notfound", new Object[]{this.name}));
            }
            return method;
        }
        throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.notamethod", new Object[]{this.name, object.getClass()}));
    }

    public MethodInfo getMethodInfo(Bindings bindings, ELContext eLContext, Class clazz, Class[] classArray) {
        Method method = this.getMethod(bindings, eLContext, clazz, classArray);
        return new MethodInfo(method.getName(), method.getReturnType(), classArray);
    }

    public Object invoke(Bindings bindings, ELContext eLContext, Class clazz, Class[] classArray, Object[] objectArray) {
        Method method = this.getMethod(bindings, eLContext, clazz, classArray);
        try {
            return method.invoke(null, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ELException(LocalMessages.get("error.identifier.method.access", new Object[]{this.name}));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ELException(LocalMessages.get("error.identifier.method.invocation", new Object[]{this.name, illegalArgumentException}));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ELException(LocalMessages.get("error.identifier.method.invocation", new Object[]{this.name, invocationTargetException.getCause()}));
        }
    }

    public String toString() {
        return this.name;
    }

    public void appendStructure(StringBuffer stringBuffer, Bindings bindings) {
        stringBuffer.append(bindings != null && bindings.isVariableBound(this.index) ? "<var>" : this.name);
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public int getCardinality() {
        return 0;
    }

    public Node getChild(int n) {
        return null;
    }
}

