/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl;

import de.odysseus.el.misc.LocalMessages;
import java.util.HashMap;

public class Scanner {
    private static final HashMap KEYMAP = new HashMap();
    private static final HashMap FIXMAP = new HashMap();
    private Token token;
    private int position;
    private final String input;
    protected final StringBuffer builder = new StringBuffer();

    private static void addFixToken(Token token) {
        FIXMAP.put(token.getSymbol(), token);
    }

    private static void addKeyToken(Token token) {
        KEYMAP.put(token.getImage(), token);
    }

    protected Scanner(String string) {
        this.input = string;
    }

    public String getInput() {
        return this.input;
    }

    public Token getToken() {
        return this.token;
    }

    public int getPosition() {
        return this.position;
    }

    protected boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    protected Token keyword(String string) {
        return (Token)KEYMAP.get(string);
    }

    protected Token fixed(Symbol symbol) {
        return (Token)FIXMAP.get(symbol);
    }

    protected Token fixed(int n) {
        return (Token)FIXMAP.get(new Symbol(n));
    }

    protected Token token(Symbol symbol, String string, int n) {
        return new Token(symbol, string, n);
    }

    protected Token token(int n, String string, int n2) {
        return this.token(new Symbol(n), string, n2);
    }

    protected boolean isEval() {
        return this.token != null && this.token.getSymbol().getCode() != 28 && this.token.getSymbol().getCode() != 35;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Token nextText() throws ScanException {
        int n;
        this.builder.setLength(0);
        int n2 = this.input.length();
        boolean bl = false;
        block4: for (n = this.position; n < n2; ++n) {
            char c = this.input.charAt(n);
            switch (c) {
                case '\\': {
                    if (bl) {
                        this.builder.append('\\');
                        continue block4;
                    }
                    bl = true;
                    continue block4;
                }
                case '#': 
                case '$': {
                    if (n + 1 < n2 && this.input.charAt(n + 1) == '{') {
                        if (!bl) return this.token(new Symbol(28), this.builder.toString(), n - this.position);
                        this.builder.append(c);
                    } else {
                        if (bl) {
                            this.builder.append('\\');
                        }
                        this.builder.append(c);
                    }
                    bl = false;
                    continue block4;
                }
                default: {
                    if (bl) {
                        this.builder.append('\\');
                    }
                    this.builder.append(c);
                    bl = false;
                }
            }
        }
        if (!bl) return this.token(new Symbol(28), this.builder.toString(), n - this.position);
        this.builder.append('\\');
        return this.token(new Symbol(28), this.builder.toString(), n - this.position);
    }

    protected Token nextString() throws ScanException {
        this.builder.setLength(0);
        char c = this.input.charAt(this.position);
        int n = this.position + 1;
        int n2 = this.input.length();
        while (n < n2) {
            char c2;
            if ((c2 = this.input.charAt(n++)) == '\\') {
                if (n == n2) {
                    throw new ScanException(this.position, "unterminated string", c + " or \\");
                }
                if ((c2 = this.input.charAt(n++)) == '\\' || c2 == c) {
                    this.builder.append(c2);
                    continue;
                }
                throw new ScanException(this.position, "invalid escape sequence \\" + c2, "\\" + c + " or \\\\");
            }
            if (c2 == c) {
                return this.token(new Symbol(18), this.builder.toString(), n - this.position);
            }
            this.builder.append(c2);
        }
        throw new ScanException(this.position, "unterminated string", String.valueOf(c));
    }

    protected Token nextNumber() throws ScanException {
        int n;
        int n2 = this.input.length();
        for (n = this.position; n < n2 && this.isDigit(this.input.charAt(n)); ++n) {
        }
        Symbol symbol = new Symbol(14);
        if (n < n2 && this.input.charAt(n) == '.') {
            ++n;
            while (n < n2 && this.isDigit(this.input.charAt(n))) {
                ++n;
            }
            symbol = new Symbol(15);
        }
        if (n < n2 && (this.input.charAt(n) == 'e' || this.input.charAt(n) == 'E')) {
            int n3 = n++;
            if (n < n2 && (this.input.charAt(n) == '+' || this.input.charAt(n) == '-')) {
                ++n;
            }
            if (n < n2 && this.isDigit(this.input.charAt(n))) {
                ++n;
                while (n < n2 && this.isDigit(this.input.charAt(n))) {
                    ++n;
                }
                symbol = new Symbol(15);
            } else {
                n = n3;
            }
        }
        return this.token(symbol, this.input.substring(this.position, n), n - this.position);
    }

    protected Token nextEval() throws ScanException {
        char c = this.input.charAt(this.position);
        char c2 = this.position < this.input.length() - 1 ? this.input.charAt(this.position + 1) : (char)'\u0000';
        switch (c) {
            case '*': {
                return this.fixed(3);
            }
            case '/': {
                return this.fixed(4);
            }
            case '%': {
                return this.fixed(5);
            }
            case '+': {
                return this.fixed(1);
            }
            case '-': {
                return this.fixed(2);
            }
            case '?': {
                return this.fixed(26);
            }
            case ':': {
                return this.fixed(27);
            }
            case '[': {
                return this.fixed(30);
            }
            case ']': {
                return this.fixed(31);
            }
            case '(': {
                return this.fixed(6);
            }
            case ')': {
                return this.fixed(7);
            }
            case ',': {
                return this.fixed(32);
            }
            case '.': {
                if (this.isDigit(c2)) break;
                return this.fixed(29);
            }
            case '=': {
                if (c2 != '=') break;
                return this.fixed(24);
            }
            case '&': {
                if (c2 != '&') break;
                return this.fixed(10);
            }
            case '|': {
                if (c2 != '|') break;
                return this.fixed(11);
            }
            case '!': {
                if (c2 == '=') {
                    return this.fixed(25);
                }
                return this.fixed(9);
            }
            case '<': {
                if (c2 == '=') {
                    return this.fixed(20);
                }
                return this.fixed(21);
            }
            case '>': {
                if (c2 == '=') {
                    return this.fixed(22);
                }
                return this.fixed(23);
            }
            case '\"': 
            case '\'': {
                return this.nextString();
            }
        }
        if (this.isDigit(c) || c == '.') {
            return this.nextNumber();
        }
        if (Character.isJavaIdentifierStart(c)) {
            int n;
            int n2 = this.input.length();
            for (n = this.position + 1; n < n2 && Character.isJavaIdentifierPart(this.input.charAt(n)); ++n) {
            }
            String string = this.input.substring(this.position, n);
            Token token = this.keyword(string);
            return token == null ? this.token(8, string, n - this.position) : token;
        }
        throw new ScanException(this.position, "invalid character '" + c + "'", "expression token");
    }

    protected Token nextToken() throws ScanException {
        if (this.isEval()) {
            if (this.input.charAt(this.position) == '}') {
                return this.fixed(35);
            }
            return this.nextEval();
        }
        if (this.position + 1 < this.input.length() && this.input.charAt(this.position + 1) == '{') {
            switch (this.input.charAt(this.position)) {
                case '#': {
                    return this.fixed(33);
                }
                case '$': {
                    return this.fixed(34);
                }
            }
        }
        return this.nextText();
    }

    public Token next() throws ScanException {
        if (this.token != null) {
            this.position += this.token.getSize();
        }
        int n = this.input.length();
        if (this.isEval()) {
            while (this.position < n && Character.isWhitespace(this.input.charAt(this.position))) {
                ++this.position;
            }
        }
        if (this.position == n) {
            this.token = this.fixed(0);
            return this.token;
        }
        this.token = this.nextToken();
        return this.token;
    }

    static {
        Scanner.addFixToken(new Token(new Symbol(1), "+"));
        Scanner.addFixToken(new Token(new Symbol(2), "-"));
        Scanner.addFixToken(new Token(new Symbol(3), "*"));
        Scanner.addFixToken(new Token(new Symbol(4), "/"));
        Scanner.addFixToken(new Token(new Symbol(5), "%"));
        Scanner.addFixToken(new Token(new Symbol(6), "("));
        Scanner.addFixToken(new Token(new Symbol(7), ")"));
        Scanner.addFixToken(new Token(new Symbol(9), "!"));
        Scanner.addFixToken(new Token(new Symbol(10), "&&"));
        Scanner.addFixToken(new Token(new Symbol(11), "||"));
        Scanner.addFixToken(new Token(new Symbol(24), "=="));
        Scanner.addFixToken(new Token(new Symbol(25), "!="));
        Scanner.addFixToken(new Token(new Symbol(21), "<"));
        Scanner.addFixToken(new Token(new Symbol(20), "<="));
        Scanner.addFixToken(new Token(new Symbol(23), ">"));
        Scanner.addFixToken(new Token(new Symbol(22), ">="));
        Scanner.addFixToken(new Token(new Symbol(26), "?"));
        Scanner.addFixToken(new Token(new Symbol(27), ":"));
        Scanner.addFixToken(new Token(new Symbol(32), ","));
        Scanner.addFixToken(new Token(new Symbol(29), "."));
        Scanner.addFixToken(new Token(new Symbol(30), "["));
        Scanner.addFixToken(new Token(new Symbol(31), "]"));
        Scanner.addFixToken(new Token(new Symbol(33), "#{"));
        Scanner.addFixToken(new Token(new Symbol(34), "${"));
        Scanner.addFixToken(new Token(new Symbol(35), "}"));
        Scanner.addFixToken(new Token(new Symbol(0), null, 0));
        Scanner.addKeyToken(new Token(new Symbol(19), "null"));
        Scanner.addKeyToken(new Token(new Symbol(16), "true"));
        Scanner.addKeyToken(new Token(new Symbol(17), "false"));
        Scanner.addKeyToken(new Token(new Symbol(12), "empty"));
        Scanner.addKeyToken(new Token(new Symbol(4), "div"));
        Scanner.addKeyToken(new Token(new Symbol(5), "mod"));
        Scanner.addKeyToken(new Token(new Symbol(9), "not"));
        Scanner.addKeyToken(new Token(new Symbol(10), "and"));
        Scanner.addKeyToken(new Token(new Symbol(11), "or"));
        Scanner.addKeyToken(new Token(new Symbol(20), "le"));
        Scanner.addKeyToken(new Token(new Symbol(21), "lt"));
        Scanner.addKeyToken(new Token(new Symbol(24), "eq"));
        Scanner.addKeyToken(new Token(new Symbol(25), "ne"));
        Scanner.addKeyToken(new Token(new Symbol(22), "ge"));
        Scanner.addKeyToken(new Token(new Symbol(23), "gt"));
        Scanner.addKeyToken(new Token(new Symbol(13), "instanceof"));
    }

    static class Symbol {
        static final int EOF = 0;
        static final int PLUS = 1;
        static final int MINUS = 2;
        static final int MUL = 3;
        static final int DIV = 4;
        static final int MOD = 5;
        static final int LPAREN = 6;
        static final int RPAREN = 7;
        static final int IDENTIFIER = 8;
        static final int NOT = 9;
        static final int AND = 10;
        static final int OR = 11;
        static final int EMPTY = 12;
        static final int INSTANCEOF = 13;
        static final int INTEGER = 14;
        static final int FLOAT = 15;
        static final int TRUE = 16;
        static final int FALSE = 17;
        static final int STRING = 18;
        static final int NULL = 19;
        static final int LE = 20;
        static final int LT = 21;
        static final int GE = 22;
        static final int GT = 23;
        static final int EQ = 24;
        static final int NE = 25;
        static final int QUESTION = 26;
        static final int COLON = 27;
        static final int TEXT = 28;
        static final int DOT = 29;
        static final int LBRACK = 30;
        static final int RBRACK = 31;
        static final int COMMA = 32;
        static final int START_EVAL_DEFERRED = 33;
        static final int START_EVAL_DYNAMIC = 34;
        static final int END_EVAL = 35;
        static final int EXTENSION = 36;
        private int _code;

        public Symbol(int n) {
            this._code = n;
        }

        public int getCode() {
            return this._code;
        }

        public String toString() {
            return Symbol.codeToString(this._code);
        }

        public static String codeToString(int n) {
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    return "+";
                }
                case 35: {
                    return "}";
                }
                case 8: {
                    return "<IDENTIFIER>";
                }
                case 18: {
                    return "<STRING>";
                }
                case 15: {
                    return "<FLOAT>";
                }
                case 14: {
                    return "<INTEGER>";
                }
                case 16: {
                    return "'true'";
                }
                case 17: {
                    return "'false'";
                }
                case 19: {
                    return "'null'";
                }
                case 2: {
                    return "'-'";
                }
                case 9: {
                    return "'!'|'not'";
                }
                case 12: {
                    return "'empty'";
                }
                case 6: {
                    return "'('";
                }
                case 33: {
                    return "'#{'";
                }
                case 34: {
                    return "'${'";
                }
            }
            return "";
        }

        public boolean equals(Symbol symbol) {
            return symbol.getCode() == this._code;
        }

        public boolean equals(Object object) {
            if (object instanceof Symbol) {
                return ((Symbol)object).getCode() == this._code;
            }
            return false;
        }

        public int hashCode() {
            return this._code;
        }
    }

    public static class ExtensionToken
    extends Token {
        public ExtensionToken(String string) {
            super(new Symbol(36), string);
        }
    }

    public static class Token {
        private final Symbol symbol;
        private final String image;
        private final int length;

        public Token(Symbol symbol, String string) {
            this(symbol, string, string.length());
        }

        public Token(Symbol symbol, String string, int n) {
            this.symbol = symbol;
            this.image = string;
            this.length = n;
        }

        public Symbol getSymbol() {
            return this.symbol;
        }

        public String getImage() {
            return this.image;
        }

        public int getSize() {
            return this.length;
        }

        public String toString() {
            return this.symbol.toString();
        }
    }

    public static class ScanException
    extends Exception {
        final int position;
        final String encountered;
        final String expected;

        public ScanException(int n, String string, String string2) {
            super(LocalMessages.get("error.scan", new Object[]{new Integer(n), string, string2}));
            this.position = n;
            this.encountered = string;
            this.expected = string2;
        }
    }
}

