/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.ExpressionNode;
import de.odysseus.el.tree.FunctionNode;
import de.odysseus.el.tree.IdentifierNode;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import javax.el.ELException;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;

public class Tree {
    private final ExpressionNode root;
    private final Collection functions;
    private final Collection identifiers;
    private final boolean deferred;

    public Tree(ExpressionNode expressionNode, Collection collection, Collection collection2, boolean bl) {
        this.root = expressionNode;
        this.functions = collection;
        this.identifiers = collection2;
        this.deferred = bl;
    }

    public Iterator getFunctionNodes() {
        return this.functions.iterator();
    }

    public Iterator getIdentifierNodes() {
        return this.identifiers.iterator();
    }

    public ExpressionNode getRoot() {
        return this.root;
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public String toString() {
        return this.getRoot().getStructuralId(null);
    }

    public Bindings bind(FunctionMapper functionMapper, VariableMapper variableMapper) {
        return this.bind(functionMapper, variableMapper, null);
    }

    public Bindings bind(FunctionMapper functionMapper, VariableMapper variableMapper, TypeConverter typeConverter) {
        Object object;
        Object object2;
        Object object3;
        ValueExpression[] valueExpressionArray;
        Method[] methodArray = null;
        if (!this.functions.isEmpty()) {
            if (functionMapper == null) {
                throw new ELException(LocalMessages.get("error.function.nomapper", new Object[0]));
            }
            methodArray = new Method[this.functions.size()];
            valueExpressionArray = this.functions.iterator();
            while (valueExpressionArray.hasNext()) {
                object3 = (FunctionNode)valueExpressionArray.next();
                object2 = object3.getName();
                object = null;
                int n = ((String)object2).indexOf(58);
                object = n < 0 ? functionMapper.resolveFunction("", (String)object2) : functionMapper.resolveFunction(((String)object2).substring(0, n), ((String)object2).substring(n + 1));
                if (object == null) {
                    throw new ELException(LocalMessages.get("error.function.notfound", new Object[]{object2}));
                }
                if (((Method)object).getParameterTypes().length != object3.getParamCount()) {
                    throw new ELException(LocalMessages.get("error.function.params", new Object[]{object2}));
                }
                methodArray[object3.getIndex()] = object;
            }
        }
        valueExpressionArray = null;
        if (this.identifiers.size() > 0) {
            valueExpressionArray = new ValueExpression[this.identifiers.size()];
            object3 = this.identifiers.iterator();
            while (object3.hasNext()) {
                object2 = (IdentifierNode)object3.next();
                object = null;
                if (variableMapper != null) {
                    object = variableMapper.resolveVariable(object2.getName());
                }
                valueExpressionArray[object2.getIndex()] = object;
            }
        }
        return new Bindings(methodArray, valueExpressionArray, typeConverter);
    }
}

