/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el;

import de.odysseus.el.ObjectValueExpression;
import de.odysseus.el.TreeMethodExpression;
import de.odysseus.el.TreeValueExpression;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.tree.TreeBuilder;
import de.odysseus.el.tree.TreeStore;
import de.odysseus.el.tree.impl.Builder;
import de.odysseus.el.tree.impl.Cache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;

public class ExpressionFactoryImpl
extends ExpressionFactory {
    public static final String PROP_METHOD_INVOCATIONS = "javax.el.methodInvocations";
    public static final String PROP_VAR_ARGS = "javax.el.varArgs";
    public static final String PROP_NULL_PROPERTIES = "javax.el.nullProperties";
    public static final String PROP_CACHE_SIZE = "javax.el.cacheSize";
    private final TreeStore store;
    private final TypeConverter converter;

    public ExpressionFactoryImpl() {
        Properties properties = this.loadProperties("el.properties");
        this.store = this.createTreeStore(1000);
        this.converter = this.createTypeConverter(properties);
    }

    public ExpressionFactoryImpl(TreeStore treeStore) {
        this(treeStore, TypeConverter.DEFAULT);
    }

    public ExpressionFactoryImpl(TreeStore treeStore, TypeConverter typeConverter) {
        this.store = treeStore;
        this.converter = typeConverter;
    }

    private Properties loadDefaultProperties() {
        String string = System.getProperty("java.home");
        String string2 = string + File.separator + "lib" + File.separator + "el.properties";
        File file = new File(string2);
        if (file.exists()) {
            Properties properties = new Properties();
            InputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                throw new ELException("Cannot read default EL properties", (Throwable)iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (((Object)((Object)this)).getClass().getName().equals(properties.getProperty("javax.el.ExpressionFactory"))) {
                return properties;
            }
        }
        if (((Object)((Object)this)).getClass().getName().equals(System.getProperty("javax.el.ExpressionFactory"))) {
            return System.getProperties();
        }
        return null;
    }

    private Properties loadProperties(String string) {
        Properties properties = new Properties(this.loadDefaultProperties());
        InputStream inputStream = null;
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        }
        catch (SecurityException securityException) {
            inputStream = ClassLoader.getSystemResourceAsStream(string);
        }
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                throw new ELException("Cannot read EL properties", (Throwable)iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    protected TreeStore createTreeStore(int n) {
        Builder builder = new Builder(null);
        int n2 = n;
        Cache cache = n2 > 0 ? new Cache(n2) : null;
        return new TreeStore(builder, cache);
    }

    protected TypeConverter createTypeConverter(Properties properties) {
        return TypeConverter.DEFAULT;
    }

    protected TreeBuilder createTreeBuilder(Properties properties, Builder.Feature[] featureArray) {
        return new Builder(featureArray);
    }

    private Class load(Class clazz, Properties properties) {
        String string;
        if (properties != null && (string = properties.getProperty(clazz.getName())) != null) {
            ClassLoader classLoader;
            try {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception exception) {
                throw new ELException("Could not get context class loader", (Throwable)exception);
            }
            try {
                return classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ELException("Class " + string + " not found", (Throwable)classNotFoundException);
            }
            catch (Exception exception) {
                throw new ELException("Class " + string + " could not be instantiated", (Throwable)exception);
            }
        }
        return null;
    }

    public final Object coerceToType(Object object, Class clazz) {
        return this.converter.convert(object, clazz);
    }

    public final ValueExpression createValueExpression(Object object, Class clazz) {
        return new ObjectValueExpression(this.converter, object, clazz);
    }

    public final ValueExpression createValueExpression(ELContext eLContext, String string, Class clazz) {
        return new TreeValueExpression(this.store, eLContext.getFunctionMapper(), eLContext.getVariableMapper(), this.converter, string, clazz);
    }

    public final MethodExpression createMethodExpression(ELContext eLContext, String string, Class clazz, Class[] classArray) {
        return new TreeMethodExpression(this.store, eLContext.getFunctionMapper(), eLContext.getVariableMapper(), this.converter, string, clazz, classArray);
    }
}

