/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.global.ProfilingPointServerHandler;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.global.TransactionalSupport;
import org.netbeans.lib.profiler.server.ClassBytesLoader;
import org.netbeans.lib.profiler.server.ClassLoaderManager;
import org.netbeans.lib.profiler.server.EventBufferManager;
import org.netbeans.lib.profiler.server.Monitors;
import org.netbeans.lib.profiler.server.ProfilerCalibrator;
import org.netbeans.lib.profiler.server.ProfilerRuntime;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPU;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUCodeRegion;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUFullInstr;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUSampledInstr;
import org.netbeans.lib.profiler.server.ProfilerRuntimeMemory;
import org.netbeans.lib.profiler.server.ProfilerRuntimeObjAlloc;
import org.netbeans.lib.profiler.server.ProfilerRuntimeObjLiveness;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Classes;
import org.netbeans.lib.profiler.server.system.GC;
import org.netbeans.lib.profiler.server.system.HeapDump;
import org.netbeans.lib.profiler.server.system.Stacks;
import org.netbeans.lib.profiler.server.system.Threads;
import org.netbeans.lib.profiler.server.system.Timers;
import org.netbeans.lib.profiler.wireprotocol.AsyncMessageCommand;
import org.netbeans.lib.profiler.wireprotocol.ClassLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.CodeRegionCPUResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.GetClassIdCommand;
import org.netbeans.lib.profiler.wireprotocol.GetClassIdResponse;
import org.netbeans.lib.profiler.wireprotocol.InitiateInstrumentationCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupData;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupResponse;
import org.netbeans.lib.profiler.wireprotocol.MethodInvokedFirstTimeCommand;
import org.netbeans.lib.profiler.wireprotocol.MethodLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.MethodNamesResponse;
import org.netbeans.lib.profiler.wireprotocol.ObjectAllocationResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.Response;
import org.netbeans.lib.profiler.wireprotocol.RootClassLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.ThreadLivenessStatusResponse;

public class ProfilerInterface
implements CommonConstants {
    private static String INTERNAL_ERROR_MSG = "Internal error:\nExpected InstrumentMethodGroupResponse, got response of class {0},\nvalue = {1}\nAll instrumentation will be removed";
    private static String UNEXPECTED_EXCEPTION_MSG = "Unexpected exception caught when trying to instrument classes.\nOriginal exception:\n{0}\nStack trace:\n\n{1}";
    private static String INSTRUMENTATION_SUCCESSFUL_MSG = "Deferred instrumentation performed successfully";
    private static final boolean DEBUG;
    private static final boolean INSTRUMENT_JFLUID_CLASSES;
    public static TransactionalSupport serialClientOperationsLock;
    private static ProfilerServer profilerServer;
    private static ProfilingSessionStatus status;
    private static EventBufferManager evBufManager;
    private static Class[] loadedClassesArray;
    private static int[] loadedClassesLoaders;
    private static WeakHashMap reflectMethods;
    private static boolean targetAppSuspended;
    private static boolean instrumentReflection;
    private static int[] packedArrayOffsets;
    private static int nSystemThreads;
    private static Thread initInstrumentationThread;
    private static String[] rootClassNames;
    private static boolean[] rootClassNameWildcard;
    private static boolean[] rootClassNamePackageWildcard;
    static int nClassLoads;
    static int nFirstMethodInvocations;
    static int nEmptyInstrMethodGroupResponses;
    static int nNonEmptyInstrMethodGroupResponses;
    static int nSingleMethodInstrMethodGroupResponses;
    static int nTotalInstrMethods;
    static long totalHotswappingTime;
    static long minHotswappingTime;
    static long maxHotswappingTime;
    static long clientInstrStartTime;
    static long clientInstrTime;
    static long clientDataProcStartTime;
    static long clientDataProcTime;
    private static boolean rootClassLoaded;
    private static volatile Thread instrumentMethodGroupCallThread;

    public static CodeRegionCPUResultsResponse getCodeRegionCPUResults() {
        CodeRegionCPUResultsResponse resp = new CodeRegionCPUResultsResponse(ProfilerRuntimeCPUCodeRegion.getProfilingResults());
        return resp;
    }

    public static void setCurrentInstrType(int type) {
        boolean isMemoryProfiling = type == 4 || type == 5;
        ProfilerInterface.status.currentInstrType = type;
        Classes.setVMObjectAllocEnabled((boolean)isMemoryProfiling);
    }

    public static int getCurrentInstrType() {
        return ProfilerInterface.status.currentInstrType;
    }

    public static ThreadLivenessStatusResponse getCurrentThreadLivenessStatus() {
        ThreadLivenessStatusResponse resp = new ThreadLivenessStatusResponse(ThreadInfo.getCurrentLivenessStatus());
        return resp;
    }

    public static void setInstrumentReflection(boolean v) {
        if (ProfilerInterface.status.targetAppRunning) {
            ProfilerRuntimeCPU.setJavaLangReflectMethodInvokeInterceptEnabled(v);
        } else {
            instrumentReflection = v;
        }
    }

    public static MethodNamesResponse getMethodNamesForJMethodIds(int[] methodIds) {
        int nMethods = methodIds.length;
        int len = nMethods * 3;
        packedArrayOffsets = new int[len];
        byte[] packedData = Stacks.getMethodNamesForJMethodIds(nMethods, methodIds, packedArrayOffsets);
        MethodNamesResponse resp = new MethodNamesResponse(packedData, packedArrayOffsets);
        return resp;
    }

    public static int getNPrerecordedSystemThreads() {
        return nSystemThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectAllocationResultsResponse getObjectAllocationResults() {
        status.beginTrans(false);
        try {
            ObjectAllocationResultsResponse resp;
            ObjectAllocationResultsResponse objectAllocationResultsResponse = resp = new ObjectAllocationResultsResponse(status.getAllocatedInstancesCount(), status.getNInstrClasses());
            return objectAllocationResultsResponse;
        }
        finally {
            status.endTrans();
        }
    }

    public static void setProfilerServer(ProfilerServer server) {
        profilerServer = server;
    }

    public static void clearProfilerDataStructures() {
        reflectMethods = null;
    }

    public static boolean cpuResultsExist() {
        return ProfilerRuntime.profiledTargetAppThreadsExist();
    }

    public static void deactivateInjectedCode() {
        int instrType = ProfilerInterface.getCurrentInstrType();
        if (instrType == 0) {
            return;
        }
        ProfilerInterface.disableProfilerHooks();
        switch (instrType) {
            case 1: {
                ProfilerRuntimeCPUCodeRegion.enableProfiling(false);
                if (rootClassNames == null) break;
                rootClassNames = null;
                break;
            }
            case 2: {
                ProfilerRuntimeCPUFullInstr.enableProfiling(false);
                ProfilerRuntimeCPU.setTimerTypes(false, false);
                break;
            }
            case 3: {
                ProfilerRuntimeCPUSampledInstr.enableProfiling(false);
                ProfilerRuntimeCPU.setTimerTypes(false, false);
                break;
            }
            case 4: {
                ProfilerRuntimeObjAlloc.enableProfiling(false);
                break;
            }
            case 5: {
                ProfilerRuntimeObjLiveness.enableProfiling(false);
            }
        }
        status.resetInstrClassAndMethodInfo();
        ProfilerInterface.setCurrentInstrType(0);
    }

    public static void disableProfilerHooks() {
        Classes.setWaitTrackingEnabled((boolean)false);
        Classes.setSleepTrackingEnabled((boolean)false);
        Classes.disableClassLoadHook();
        ProfilerRuntimeCPU.setJavaLangReflectMethodInvokeInterceptEnabled(false);
        ClassLoaderManager.setNotifyToolAboutUnloadedClasses(false);
    }

    public static void dumpExistingResults(boolean live) {
        if (!live && ProfilerInterface.getCurrentInstrType() == 5 && ProfilerRuntimeObjLiveness.getRunGCOnGetResults()) {
            GC.runGC();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ProfilerRuntime.dumpEventBuffer();
    }

    public static void initProfilerInterface(ProfilingSessionStatus status, Thread specialThread) {
        Timers.initialize();
        Classes.initialize();
        GC.initialize();
        Stacks.initialize();
        Threads.initialize();
        HeapDump.initialize((Platform.getJDKVersionNumber() == 2 ? 1 : 0) != 0);
        ClassLoaderManager.initialize(profilerServer);
        ClassLoaderManager.addLoader(ClassLoader.getSystemClassLoader());
        reflectMethods = new WeakHashMap();
        evBufManager = new EventBufferManager(profilerServer);
        ProfilerInterface.status = status;
        while (!Monitors.monitorThreadsStarted()) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        if (status.runningInAttachedMode) {
            Threads.recordProfilerOwnThreads(false, specialThread);
            nSystemThreads = -1;
        } else {
            nSystemThreads = Threads.recordProfilerOwnThreads(true, specialThread);
        }
        ProfilerRuntime.init(new ProfilerRuntime.ExternalActionsHandler(){

            public void handleFirstTimeMethodInvoke(char methodId) {
                ProfilerInterface.firstTimeMethodInvokeHook(methodId);
            }

            public void handleReflectiveInvoke(Method method) {
                ProfilerInterface.reflectiveMethodInvokeHook(method);
            }

            public int handleFirstTimeVMObjectAlloc(String className, int classLoaderId) {
                return ProfilerInterface.firstTimeVMObjectAlloc(className, classLoaderId);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEventBufferDump(byte[] eventBuffer, int startPos, int curPtrPos) {
                serialClientOperationsLock.beginTrans(true);
                try {
                    clientDataProcStartTime = Timers.getCurrentTimeInCounts();
                    evBufManager.eventBufferDumpHook(eventBuffer, startPos, curPtrPos);
                    clientDataProcTime += Timers.getCurrentTimeInCounts() - clientDataProcStartTime;
                }
                finally {
                    serialClientOperationsLock.endTrans();
                }
            }
        });
    }

    public static void initiateInstrumentation(InitiateInstrumentationCommand cmd, boolean targetAppRunning) throws Exception {
        int instrType = cmd.getInstrType();
        String instrClassName = cmd.getRootClassName();
        if (instrClassName.equals("*FAKE_CLASS_FOR_INTERNAL_TEST*")) {
            ProfilerInterface.handleFakeInitRecursiveInstrumentationCommand();
            return;
        }
        switch (instrType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                evBufManager.openBufferFile(1200000);
                ProfilerRuntime.createEventBuffer(1200000);
                status.resetInstrClassAndMethodInfo();
                if (instrType == 4 || instrType == 5) {
                    ClassLoaderManager.setNotifyToolAboutUnloadedClasses(true);
                    break;
                }
                ClassLoaderManager.setNotifyToolAboutUnloadedClasses(false);
                break;
            }
            case 1: {
                ProfilerRuntimeCPUCodeRegion.resetProfilerCollectors();
            }
        }
        new InitiateInstThread(cmd, targetAppRunning).start();
    }

    public static void instrumentMethods(InstrumentMethodGroupCommand cmd) throws Exception {
        if (!cmd.isEmpty()) {
            try {
                ProfilerInterface.instrumentMethodGroupNow(cmd.getBase());
            }
            catch (Exception ex) {
                ProfilerInterface.deactivateInjectedCode();
                ProfilerInterface.setCurrentInstrType(0);
                throw ex;
            }
        }
        ProfilerInterface.setCurrentInstrType(cmd.getInstrType());
    }

    public static void resetProfilerCollectors() {
        ProfilerRuntime.resetProfilerCollectors(ProfilerInterface.getCurrentInstrType());
        reflectMethods = new WeakHashMap();
    }

    public static void resumeTargetApp() {
        if (ProfilerInterface.getCurrentInstrType() == 2) {
            ProfilerRuntimeCPUFullInstr.resumeActiveTimers();
        }
        Threads.resumeTargetAppThreads(null);
        targetAppSuspended = false;
    }

    public static void suspendTargetApp() {
        Threads.suspendTargetAppThreads(null);
        if (ProfilerInterface.getCurrentInstrType() == 2) {
            ProfilerRuntimeCPUFullInstr.suspendActiveTimers();
        }
        targetAppSuspended = true;
    }

    private static boolean getAndInstrumentClasses(boolean rootClassInstrumentation) {
        Response r = profilerServer.getLastResponse();
        if (!(r instanceof InstrumentMethodGroupResponse)) {
            String msg = MessageFormat.format(INTERNAL_ERROR_MSG, r.getClass(), r);
            ProfilerInterface.deactivateInjectedCode();
            profilerServer.sendComplexCmdToClient(new AsyncMessageCommand(false, msg));
            return false;
        }
        InstrumentMethodGroupResponse imgr = (InstrumentMethodGroupResponse)r;
        clientInstrTime += Timers.getCurrentTimeInCounts() - clientInstrStartTime;
        if (!imgr.isOK()) {
            return false;
        }
        if (imgr.isEmpty()) {
            ++nEmptyInstrMethodGroupResponses;
        } else {
            ProfilerInterface.updateInstrClassAndMethodNames(imgr.getBase(), true);
            if (rootClassInstrumentation && ProfilerInterface.getCurrentInstrType() == 5) {
                ThreadInfo.getThreadInfo();
            }
            try {
                ProfilerInterface.instrumentMethodGroupNow(imgr.getBase());
            }
            catch (Exception ex) {
                profilerServer.sendComplexCmdToClient(new AsyncMessageCommand(false, ex.getMessage()));
                return true;
            }
        }
        if (rootClassInstrumentation) {
            switch (ProfilerInterface.getCurrentInstrType()) {
                case 2: {
                    if (instrumentReflection) {
                        ProfilerRuntimeCPU.setJavaLangReflectMethodInvokeInterceptEnabled(true);
                    }
                    ProfilerRuntimeCPUFullInstr.enableProfiling(true);
                    break;
                }
                case 3: {
                    if (instrumentReflection) {
                        ProfilerRuntimeCPU.setJavaLangReflectMethodInvokeInterceptEnabled(true);
                    }
                    ProfilerRuntimeCPUSampledInstr.enableProfiling(true);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.enableProfiling(true);
                    break;
                }
                case 4: {
                    ProfilerRuntimeObjAlloc.enableProfiling(true);
                    break;
                }
                case 5: {
                    ProfilerRuntimeObjLiveness.enableProfiling(true);
                }
            }
        }
        return true;
    }

    private static boolean isCoreClassName(String name) {
        return (name = name.replace('.', '/')).startsWith("java/") || name.startsWith("sun/") || name.startsWith("javax/");
    }

    private static void getLoadedClasses() {
        if (loadedClassesArray == null) {
            int nonSystemIndex = 0;
            int MAX_CLASSES = 1000;
            Class[] nonSystemClasses = new Class[MAX_CLASSES + 1];
            loadedClassesArray = Classes.getAllLoadedClasses();
            loadedClassesLoaders = new int[loadedClassesArray.length];
            for (int i = 0; i < loadedClassesArray.length; ++i) {
                Class clazz = loadedClassesArray[i];
                ProfilerInterface.loadedClassesLoaders[i] = ClassLoaderManager.registerLoader(clazz);
                if (loadedClassesLoaders[i] > 0) {
                    nonSystemClasses[nonSystemIndex++] = clazz;
                }
                if (nonSystemIndex != MAX_CLASSES) continue;
                ProfilerInterface.cacheLoadedClasses(nonSystemClasses, nonSystemIndex);
                nonSystemIndex = 0;
            }
            if (nonSystemIndex > 0) {
                ProfilerInterface.cacheLoadedClasses(nonSystemClasses, nonSystemIndex);
            }
        }
    }

    private static boolean isRootClass(String className) {
        for (int i = 0; i < rootClassNames.length; ++i) {
            String rootName = rootClassNames[i];
            if (rootClassNameWildcard[i]) {
                if (!className.startsWith(rootName)) continue;
                if (rootClassNamePackageWildcard[i]) {
                    return true;
                }
                if (className.indexOf(46, rootName.length()) != -1) continue;
                return true;
            }
            if (!rootName.equals(className)) continue;
            return true;
        }
        return false;
    }

    private static void appendTypeName(StringBuffer sb, Class type) {
        if (type.isArray()) {
            do {
                sb.append('[');
            } while ((type = type.getComponentType()).isArray());
        }
        if (type == Integer.TYPE) {
            sb.append('I');
        } else if (type == Boolean.TYPE) {
            sb.append('Z');
        } else if (type == Byte.TYPE) {
            sb.append('B');
        } else if (type == Character.TYPE) {
            sb.append('C');
        } else if (type == Long.TYPE) {
            sb.append('J');
        } else if (type == Float.TYPE) {
            sb.append('F');
        } else if (type == Double.TYPE) {
            sb.append('D');
        } else if (type == Void.TYPE) {
            sb.append('V');
        } else {
            sb.append('L');
            sb.append(type.getName().replace('.', '/'));
            sb.append(';');
        }
    }

    private static boolean checkForLoadedRootClasses() {
        for (int i = 0; i < loadedClassesArray.length; ++i) {
            if (!ProfilerInterface.isRootClass(loadedClassesArray[i].getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void classLoadHook(Class clazz) {
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        ++threadInfo.inProfilingRuntimeMethod;
        try {
            String className = clazz.getName();
            if (instrumentMethodGroupCallThread == Thread.currentThread() || ProfilerInterface.internalClassName(className)) {
                ClassLoaderManager.registerLoader(clazz);
                return;
            }
            Thread currentThread = Thread.currentThread();
            if ("*** Profiler Agent Communication Thread".equals(currentThread.getName())) {
                System.err.println("*** Profiler engine warning: class " + className + " loaded by " + "*** Profiler Agent Communication Thread");
                return;
            }
            if (initInstrumentationThread != null && currentThread == initInstrumentationThread) {
                System.err.println("*** Profiler engine warning: class load hook invoked at inappropriate time for " + className + ", loader = " + clazz.getClassLoader());
                System.err.println("*** This class will not be instrumented unless you re-run the instrumentation command");
                System.err.println("*** Please report this problem to feedback@profiler.netbeans.org");
                System.err.println("=============================== Stack trace =====================");
                Thread.dumpStack();
                System.err.println("=============================== End stack trace =================");
                return;
            }
            int classLoaderId = ClassLoaderManager.registerLoader(clazz);
            boolean resumeTimer = false;
            if (DEBUG) {
                System.err.println("ProfilerInterface.classLoadHook.DEBUG: " + className + ", classLoaderId: " + classLoaderId);
            }
            serialClientOperationsLock.beginTrans(true);
            try {
                boolean rootInstrumented = false;
                String excMessage = null;
                int instrType = ProfilerInterface.getCurrentInstrType();
                if (instrType == 0) {
                    return;
                }
                boolean resumeProfiling = false;
                if (ThreadInfo.profilingSuspended()) {
                    ThreadInfo.suspendProfiling();
                    resumeProfiling = true;
                }
                try {
                    if (rootClassLoaded) {
                        if (instrType != 2 && instrType != 3 && instrType != 4 && instrType != 5) {
                            if (instrType != 1) return;
                            if (!className.equals(rootClassNames[0])) {
                                return;
                            }
                        }
                        ThreadInfo ti = null;
                        if (instrType == 2 || instrType == 3) {
                            ++nClassLoads;
                            ti = ProfilerRuntimeCPU.suspendCurrentThreadTimer();
                            clientInstrStartTime = Timers.getCurrentTimeInCounts();
                            resumeTimer = true;
                        }
                        byte[] classFileBytes = null;
                        if (classLoaderId > 0) {
                            classFileBytes = Classes.getCachedClassFileBytes((Class)clazz);
                            if (classFileBytes == null) {
                                if (DEBUG) {
                                    System.err.println("Cannot get classbytes for " + clazz.getName() + " loader " + classLoaderId);
                                }
                                ProfilerInterface.cacheLoadedClass(clazz);
                                classFileBytes = ProfilerInterface.getCachedClassFileBytes(clazz);
                            }
                        } else if (ProfilerInterface.status.remoteProfiling) {
                            classFileBytes = ClassBytesLoader.getClassFileBytes(className);
                        }
                        ClassLoadedCommand cmd = new ClassLoadedCommand(className, ClassLoaderManager.getThisAndParentLoaderData(classLoaderId), classFileBytes, ti != null ? ti.isInCallGraph() : false);
                        profilerServer.sendComplexCmdToClient(cmd);
                        if (!ProfilerInterface.getAndInstrumentClasses(false)) {
                            ProfilerInterface.disableProfilerHooks();
                            return;
                        }
                    } else {
                        boolean rootWasLoaded;
                        boolean bl = rootWasLoaded = (instrType == 2 || instrType == 3) && ProfilerInterface.status.instrScheme == 3;
                        if (!rootWasLoaded && !ProfilerInterface.isRootClass(className)) {
                            return;
                        }
                        ++nClassLoads;
                        clientInstrStartTime = Timers.getCurrentTimeInCounts();
                        ProfilerInterface.sendRootClassLoadedCommand(true);
                        if (!ProfilerInterface.getAndInstrumentClasses(true)) {
                            ProfilerInterface.disableProfilerHooks();
                            return;
                        }
                        rootInstrumented = true;
                        rootClassLoaded = true;
                        ProfilerCalibrator.resetInternalStatsCollectors();
                    }
                    if (rootInstrumented || excMessage != null) {
                        AsyncMessageCommand cmd = null;
                        cmd = excMessage == null ? new AsyncMessageCommand(true, INSTRUMENTATION_SUCCESSFUL_MSG) : new AsyncMessageCommand(false, excMessage);
                        profilerServer.sendComplexCmdToClient(cmd);
                    }
                }
                finally {
                    if (resumeProfiling) {
                        ThreadInfo.resumeProfiling();
                    }
                }
            }
            finally {
                serialClientOperationsLock.endTrans();
            }
            if (!resumeTimer) return;
            int instrType = ProfilerInterface.getCurrentInstrType();
            if (instrType != 2) {
                if (instrType != 3) return;
            }
            ProfilerRuntimeCPU.resumeCurrentThreadTimer();
            return;
        }
        finally {
            --threadInfo.inProfilingRuntimeMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void firstTimeMethodInvokeHook(char methodId) {
        serialClientOperationsLock.beginTrans(true);
        try {
            int instrType = ProfilerInterface.getCurrentInstrType();
            if (instrType != 2 && instrType != 3) {
                return;
            }
            clientInstrStartTime = Timers.getCurrentTimeInCounts();
            MethodInvokedFirstTimeCommand cmd = new MethodInvokedFirstTimeCommand(methodId);
            profilerServer.sendComplexCmdToClient(cmd);
            if (!ProfilerInterface.getAndInstrumentClasses(false)) {
                ProfilerInterface.disableProfilerHooks();
                return;
            }
            if (nFirstMethodInvocations == 0) {
                ProfilerCalibrator.resetInternalStatsCollectors();
            }
            ++nFirstMethodInvocations;
        }
        finally {
            serialClientOperationsLock.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int firstTimeVMObjectAlloc(String className, int classLoaderId) {
        if (ProfilerInterface.internalClassName(className)) {
            return -1;
        }
        serialClientOperationsLock.beginTrans(true);
        try {
            if (classLoaderId > 0) {
                classLoaderId = ClassLoaderManager.getDefiningLoaderForClass(className, classLoaderId);
            }
            GetClassIdCommand cmd = new GetClassIdCommand(className, classLoaderId);
            profilerServer.sendComplexCmdToClient(cmd);
            GetClassIdResponse resp = (GetClassIdResponse)profilerServer.getLastResponse();
            if (resp.isOK()) {
                int n = resp.getClassId();
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            serialClientOperationsLock.endTrans();
        }
    }

    private static void handleFakeInitRecursiveInstrumentationCommand() {
        new HFIRIThread().start();
    }

    private static boolean hasAnyCoreClassNames(String[] classes) {
        if (classes.length <= 0) {
            return false;
        }
        for (int i = 0; i < classes.length; ++i) {
            if (!ProfilerInterface.isCoreClassName(classes[i])) continue;
            return true;
        }
        return false;
    }

    private static void instrumentMethodGroupNow(InstrumentMethodGroupData imgb) throws Exception {
        try {
            instrumentMethodGroupCallThread = Thread.currentThread();
            boolean res = false;
            long time = Timers.getCurrentTimeInCounts();
            ++nNonEmptyInstrMethodGroupResponses;
            int nClasses = imgb.getNClasses();
            String[] instrClassNames = imgb.getMethodClasses();
            int[] instrClassLoaders = imgb.getClassLoaderIds();
            int nMethods = imgb.getNMethods();
            Class[] clazzes = new Class[nClasses];
            byte[][] b = imgb.getReplacementClassFileBytes();
            int k = 0;
            for (int i = 0; i < nClasses; ++i) {
                clazzes[k] = ClassLoaderManager.getLoadedClass(instrClassNames[i], instrClassLoaders[i]);
                if (clazzes[k] != null) {
                    if (b[k] == null) {
                        b[k] = instrClassLoaders[i] == 0 ? ClassBytesLoader.getClassFileBytes(instrClassNames[i]) : ProfilerInterface.getCachedClassFileBytes(clazzes[k]);
                    }
                    ++k;
                    continue;
                }
                ProfilerInterface.reportUnloadedClass(instrClassNames[i]);
                int classesToMove = nClasses - k - 1;
                System.arraycopy(clazzes, k + 1, clazzes, k, classesToMove);
                System.arraycopy(b, k + 1, b, k, classesToMove);
            }
            if (k < nClasses) {
                Class[] oldClazzes = clazzes;
                clazzes = new Class[k];
                System.arraycopy(oldClazzes, 0, clazzes, 0, k);
            }
            Classes.redefineClasses((Class[])clazzes, (byte[][])imgb.getReplacementClassFileBytes());
            time = Timers.getCurrentTimeInCounts() - time;
            totalHotswappingTime += time;
            if (time < minHotswappingTime) {
                minHotswappingTime = time;
            } else if (time > maxHotswappingTime) {
                maxHotswappingTime = time;
            }
            instrumentMethodGroupCallThread = null;
        }
        catch (Throwable t) {
            if (t instanceof Classes.RedefineException) {
                int nClasses = imgb.getNClasses();
                String[] instrClassNames = imgb.getMethodClasses();
                System.err.println("Profiler Agent Error: Redefinition failed for classes:");
                for (int i = 0; i < nClasses; ++i) {
                    System.err.println(instrClassNames[i]);
                }
                System.err.println("Profiler Agent Error: with message: " + ((Classes.RedefineException)t).getMessage());
                byte[][] newBytes = imgb.getReplacementClassFileBytes();
                for (int i = 0; i < nClasses; ++i) {
                    String name = instrClassNames[i];
                    File outFile = new File(name + ".class");
                    System.err.println("Debug: writing class file: " + name + ", into file: " + outFile.getPath());
                    try {
                        FileOutputStream fos = new FileOutputStream(outFile);
                        fos.write(newBytes[i]);
                        fos.close();
                        continue;
                    }
                    catch (IOException exc) {
                        System.err.println("error: " + exc + " writing class file: " + outFile.getPath());
                    }
                }
                throw (Classes.RedefineException)t;
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            throw new Exception(MessageFormat.format(UNEXPECTED_EXCEPTION_MSG, t, sw.toString()));
        }
        finally {
            instrumentMethodGroupCallThread = null;
        }
    }

    private static boolean internalClassName(String name) {
        return ProfilerInterface.serverInternalClassName(name) || name.startsWith("sun.reflect.") && !name.startsWith("sun.reflect.GeneratedSerializationConstructorAccessor") && !name.startsWith("sun.reflect.GeneratedConstructorAccessor") || name.startsWith("sun.instrument.") || name.equals("com.sun.enterprise.J2EESecurityManager");
    }

    private static boolean serverInternalClassName(String name) {
        if (INSTRUMENT_JFLUID_CLASSES) {
            return name.startsWith("org.netbeans.lib.profiler.server") || name.startsWith("org.netbeans.lib.profiler.global") || name.startsWith("org.netbeans.lib.profiler.wireprotocol");
        }
        return name.startsWith("org.netbeans.lib.profiler.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reflectiveMethodInvokeHook(Method method) {
        serialClientOperationsLock.beginTrans(true);
        try {
            if (reflectMethods.containsKey(method)) {
                return;
            }
            ProfilerRuntimeCPU.suspendCurrentThreadTimer();
            reflectMethods.put(method, null);
            Class<?> clazz = method.getDeclaringClass();
            String className = clazz.getName();
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            StringBuffer sb = new StringBuffer();
            sb.append('(');
            for (int i = 0; i < paramTypes.length; ++i) {
                ProfilerInterface.appendTypeName(sb, paramTypes[i]);
            }
            sb.append(')');
            ProfilerInterface.appendTypeName(sb, method.getReturnType());
            String methodSignature = sb.toString();
            clientInstrStartTime = Timers.getCurrentTimeInCounts();
            MethodLoadedCommand cmd = new MethodLoadedCommand(className, ClassLoaderManager.registerLoader(clazz), methodName, methodSignature);
            profilerServer.sendComplexCmdToClient(cmd);
            if (!ProfilerInterface.getAndInstrumentClasses(false)) {
                ProfilerInterface.disableProfilerHooks();
                return;
            }
            ProfilerRuntimeCPU.resumeCurrentThreadTimer();
        }
        finally {
            serialClientOperationsLock.endTrans();
        }
    }

    private static void reportUnloadedClass(String className) {
        System.err.println("*** Profiler engine warning: target VM cannot load class to instrument " + className);
        System.err.println("*** probably it has been unloaded recently");
    }

    private static void reportCacheMiss(byte[] bytes, Class clazz) {
        if (bytes == null) {
            System.err.println("*** Profiler engine warning: Failed to lookup cached class " + clazz.getName());
        }
    }

    private static byte[] getCachedClassFileBytes(Class clazz) {
        byte[] bytes = Classes.getCachedClassFileBytes((Class)clazz);
        ProfilerInterface.reportCacheMiss(bytes, clazz);
        return bytes;
    }

    private static void cacheLoadedClass(Class clazz) {
        Class[] classes = new Class[2];
        classes[0] = clazz;
        ProfilerInterface.cacheLoadedClasses(classes, 1);
    }

    private static void cacheLoadedClasses(Class[] nonSystemClasses, int nonSystemIndex) {
        if (DEBUG) {
            System.out.println("Caching " + nonSystemIndex + " classes");
        }
        nonSystemClasses[nonSystemIndex++] = InitiateInstThread.class;
        Classes.cacheLoadedClasses((Class[])nonSystemClasses, (int)nonSystemIndex);
    }

    private static void sendRootClassLoadedCommand(boolean doGetLoadedClasses) {
        if (doGetLoadedClasses) {
            ProfilerInterface.getLoadedClasses();
        }
        int len = loadedClassesArray.length;
        String[] loadedClassNames = new String[len];
        int[] loaders = new int[len];
        byte[][] cachedClassFileBytes = new byte[len][];
        int idx = 0;
        for (int i = 0; i < loadedClassesArray.length; ++i) {
            String name = loadedClassesArray[i].getName();
            if (name.startsWith("[") || ProfilerInterface.internalClassName(name)) continue;
            loadedClassNames[idx] = name;
            loaders[idx] = loadedClassesLoaders[i];
            if (loaders[idx] > 0) {
                cachedClassFileBytes[idx] = ProfilerInterface.getCachedClassFileBytes(loadedClassesArray[i]);
            } else if (ProfilerInterface.status.remoteProfiling) {
                cachedClassFileBytes[idx] = ClassBytesLoader.getClassFileBytes(loadedClassesArray[i].getName());
            }
            ++idx;
        }
        String bufferFileName = ProfilerInterface.getCurrentInstrType() == 2 || ProfilerInterface.getCurrentInstrType() == 3 || ProfilerInterface.getCurrentInstrType() == 4 || ProfilerInterface.getCurrentInstrType() == 5 ? evBufManager.getBufferFileName() : " ";
        RootClassLoadedCommand cmd = new RootClassLoadedCommand(loadedClassNames, loaders, cachedClassFileBytes, idx, ClassLoaderManager.getParentLoaderIdTable(), bufferFileName);
        profilerServer.sendComplexCmdToClient(cmd);
        loadedClassesArray = null;
        loadedClassesLoaders = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateInstrClassAndMethodNames(InstrumentMethodGroupData imgb, boolean firstTime) {
        status.beginTrans(false);
        try {
            switch (ProfilerInterface.getCurrentInstrType()) {
                case 2: 
                case 3: {
                    status.updateInstrMethodsInfo(imgb.getNClasses(), imgb.getNMethods(), null, null, null, null, null, imgb.getInstrMethodLeaf());
                    ProfilerRuntimeCPU.setInstrMethodsInvoked(status.getInstrMethodInvoked());
                    return;
                }
                case 4: 
                case 5: {
                    status.updateAllocatedInstancesCountInfoInServer(imgb.getAddInfo());
                    ProfilerRuntimeMemory.setAllocatedInstancesCountArray(status.getAllocatedInstancesCount());
                    return;
                }
            }
            return;
        }
        finally {
            status.endTrans();
        }
    }

    static /* synthetic */ String[] access$202(String[] x0) {
        rootClassNames = x0;
        return x0;
    }

    static /* synthetic */ boolean[] access$1002(boolean[] x0) {
        rootClassNameWildcard = x0;
        return x0;
    }

    static /* synthetic */ boolean[] access$1102(boolean[] x0) {
        rootClassNamePackageWildcard = x0;
        return x0;
    }

    static {
        ResourceBundle messages = ProfilerServer.getProfilerServerResourceBundle();
        if (messages != null) {
            INTERNAL_ERROR_MSG = messages.getString("ProfilerInterface_InternalErrorMsg");
            UNEXPECTED_EXCEPTION_MSG = messages.getString("ProfilerInterface_UnexpectedExceptionMsg");
            INSTRUMENTATION_SUCCESSFUL_MSG = messages.getString("ProfilerInterface_InstrumentationSuccessfulMsg");
        }
        DEBUG = System.getProperty("org.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook") != null;
        INSTRUMENT_JFLUID_CLASSES = Boolean.getBoolean("org.netbeans.lib.profiler.server.instrumentJFluidClasses");
        serialClientOperationsLock = new TransactionalSupport();
        targetAppSuspended = false;
        instrumentReflection = false;
        minHotswappingTime = 10000000000L;
    }

    private static class InitiateInstThread
    extends Thread {
        private InitiateInstrumentationCommand cmd;
        private boolean targetAppRunning;

        InitiateInstThread(InitiateInstrumentationCommand cmd, boolean targetAppRunning) {
            ThreadInfo.addProfilerServerThread(this);
            this.setName("*** Profiler Agent Special Execution Thread 2");
            this.cmd = cmd;
            this.targetAppRunning = targetAppRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            serialClientOperationsLock.beginTrans(true);
            try {
                initInstrumentationThread = Thread.currentThread();
                int instrType = this.cmd.getInstrType();
                ProfilerInterface.setCurrentInstrType(instrType);
                if (instrType != 0) {
                    ProfilerInterface.access$202(this.cmd.getRootClassNames());
                    status.startProfilingPointsActive = this.cmd.isStartProfilingPointsActive();
                    status.profilingPointIDs = this.cmd.getProfilingPointIDs();
                    String[] handlers = this.cmd.getProfilingPointHandlers();
                    String[] infos = this.cmd.getProfilingPointInfos();
                    status.profilingPointHandlers = ProfilingPointServerHandler.getInstances(handlers, infos);
                    InitiateInstThread.computeRootWildcard();
                    rootClassLoaded = false;
                    try {
                        Class.forName("java.util.LinkedHashMap");
                        Class.forName("java.util.LinkedHashMap$LinkedHashIterator");
                        Class.forName("java.util.LinkedHashMap$KeyIterator");
                        Class.forName("java.lang.reflect.InvocationTargetException");
                        Class.forName("java.lang.InterruptedException");
                        Class.forName("java.util.zip.Deflater");
                        Class.forName("java.lang.ClassFormatError");
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace(System.err);
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    InitiateInstThread e = this;
                    synchronized (e) {
                        try {
                            this.wait(1L);
                        }
                        catch (InterruptedException e2) {
                            // empty catch block
                        }
                    }
                    Classes.enableClassLoadHook();
                    boolean instrSpawnedThreads = this.cmd.getInstrSpawnedThreads();
                    if (this.targetAppRunning || ProfilerInterface.hasAnyCoreClassNames(this.cmd.getRootClassNames()) || instrSpawnedThreads || instrType == 4 || instrType == 5) {
                        ProfilerInterface.getLoadedClasses();
                        boolean loadedRootClassesExist = false;
                        switch (instrType) {
                            case 2: 
                            case 3: {
                                loadedRootClassesExist = instrSpawnedThreads ? true : ProfilerInterface.checkForLoadedRootClasses();
                                break;
                            }
                            case 1: {
                                loadedRootClassesExist = ProfilerInterface.checkForLoadedRootClasses();
                                break;
                            }
                            case 4: 
                            case 5: {
                                loadedRootClassesExist = true;
                            }
                        }
                        if (loadedRootClassesExist) {
                            ProfilerInterface.sendRootClassLoadedCommand(false);
                            if (!ProfilerInterface.getAndInstrumentClasses(true)) {
                                ProfilerInterface.disableProfilerHooks();
                            }
                            rootClassLoaded = true;
                        }
                    }
                }
                initInstrumentationThread = null;
            }
            finally {
                serialClientOperationsLock.endTrans();
            }
            ThreadInfo.removeProfilerServerThread(this);
        }

        private static void computeRootWildcard() {
            ProfilerInterface.access$1002(new boolean[rootClassNames.length]);
            ProfilerInterface.access$1102(new boolean[rootClassNames.length]);
            for (int i = 0; i < rootClassNames.length; ++i) {
                int nameLen = rootClassNames[i].length();
                boolean bl = rootClassNameWildcard[i] = nameLen == 0 || rootClassNames[i].charAt(nameLen - 1) == '.';
                if (rootClassNameWildcard[i] || rootClassNames[i].charAt(nameLen - 1) != '*') continue;
                rootClassNames[i] = rootClassNames[i].substring(0, nameLen - 1);
                rootClassNameWildcard[i] = true;
                rootClassNamePackageWildcard[i] = true;
            }
        }
    }

    private static class HFIRIThread
    extends Thread {
        HFIRIThread() {
            ThreadInfo.addProfilerServerThread(this);
            this.setName("*** Profiler Agent Special Execution Thread 1");
            this.setDaemon(true);
        }

        public void run() {
            RootClassLoadedCommand cmd = new RootClassLoadedCommand(new String[]{"*FAKE_CLASS_1*", "*FAKE_CLASS_2*"}, new int[]{0, 0}, null, 2, new int[]{-1}, "");
            profilerServer.sendComplexCmdToClient(cmd);
            profilerServer;
            InstrumentMethodGroupResponse imgr = (InstrumentMethodGroupResponse)ProfilerServer.getLastResponse();
            ThreadInfo.removeProfilerServerThread(this);
        }
    }
}

