/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import com.sun.security.cert.PolicyNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class PolicyNodeImpl
implements PolicyNode {
    private static final String ANY_POLICY = "2.5.29.32.0";
    private PolicyNodeImpl mParent;
    private HashSet mChildren;
    private String mValidPolicy;
    private HashSet mQualifierSet;
    private boolean mCriticalityIndicator;
    private HashSet mExpectedPolicySet;
    private boolean mOriginalExpectedPolicySet;
    private int mDepth;
    private boolean isImmutable = false;

    PolicyNodeImpl(PolicyNodeImpl policyNodeImpl, String string, Set set, boolean bl, Set set2, boolean bl2) {
        this.mParent = policyNodeImpl;
        this.mChildren = new HashSet();
        this.mValidPolicy = string != null ? string : "";
        this.mQualifierSet = set != null ? new HashSet(set) : new HashSet();
        this.mCriticalityIndicator = bl;
        this.mExpectedPolicySet = set2 != null ? new HashSet(set2) : new HashSet();
        boolean bl3 = this.mOriginalExpectedPolicySet = !bl2;
        if (this.mParent != null) {
            this.mDepth = this.mParent.getDepth() + 1;
            this.mParent.addChild(this);
        } else {
            this.mDepth = 0;
        }
    }

    PolicyNodeImpl(PolicyNodeImpl policyNodeImpl, PolicyNodeImpl policyNodeImpl2) {
        this(policyNodeImpl, policyNodeImpl2.mValidPolicy, policyNodeImpl2.mQualifierSet, policyNodeImpl2.mCriticalityIndicator, policyNodeImpl2.mExpectedPolicySet, false);
    }

    public PolicyNode getParent() {
        return this.mParent;
    }

    public Iterator getChildren() {
        return Collections.unmodifiableSet(this.mChildren).iterator();
    }

    public int getDepth() {
        return this.mDepth;
    }

    public String getValidPolicy() {
        return this.mValidPolicy;
    }

    public Set getPolicyQualifiers() {
        return Collections.unmodifiableSet(this.mQualifierSet);
    }

    public Set getExpectedPolicies() {
        return Collections.unmodifiableSet(this.mExpectedPolicySet);
    }

    public boolean isCritical() {
        return this.mCriticalityIndicator;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.asString());
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            stringBuffer.append((PolicyNodeImpl)iterator.next());
        }
        return stringBuffer.toString();
    }

    boolean isImmutable() {
        return this.isImmutable;
    }

    void setImmutable() {
        if (this.isImmutable) {
            return;
        }
        Iterator iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)iterator.next();
            policyNodeImpl.setImmutable();
        }
        this.isImmutable = true;
    }

    private void addChild(PolicyNodeImpl policyNodeImpl) {
        if (this.isImmutable) {
            throw new IllegalStateException("PolicyNode is immutable");
        }
        this.mChildren.add(policyNodeImpl);
    }

    void addExpectedPolicy(String string) {
        if (this.isImmutable) {
            throw new IllegalStateException("PolicyNode is immutable");
        }
        if (this.mOriginalExpectedPolicySet) {
            this.mExpectedPolicySet.clear();
            this.mOriginalExpectedPolicySet = false;
        }
        this.mExpectedPolicySet.add(string);
    }

    void prune(int n) {
        if (this.isImmutable) {
            throw new IllegalStateException("PolicyNode is immutable");
        }
        if (this.mChildren.size() == 0) {
            return;
        }
        Iterator iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)iterator.next();
            policyNodeImpl.prune(n);
            if (policyNodeImpl.mChildren.size() != 0 || n <= this.mDepth + 1) continue;
            iterator.remove();
        }
    }

    void deleteChild(PolicyNode policyNode) {
        if (this.isImmutable) {
            throw new IllegalStateException("PolicyNode is immutable");
        }
        this.mChildren.remove(policyNode);
    }

    PolicyNodeImpl copyTree() {
        return this.copyTree(null);
    }

    private PolicyNodeImpl copyTree(PolicyNodeImpl policyNodeImpl) {
        PolicyNodeImpl policyNodeImpl2 = new PolicyNodeImpl(policyNodeImpl, this);
        Iterator iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            PolicyNodeImpl policyNodeImpl3 = (PolicyNodeImpl)iterator.next();
            policyNodeImpl3.copyTree(policyNodeImpl2);
        }
        return policyNodeImpl2;
    }

    Set getPolicyNodes(int n) {
        HashSet hashSet = new HashSet();
        this.getPolicyNodes(n, hashSet);
        return hashSet;
    }

    private void getPolicyNodes(int n, Set set) {
        if (this.mDepth == n) {
            set.add(this);
        } else {
            Iterator iterator = this.mChildren.iterator();
            while (iterator.hasNext()) {
                PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)iterator.next();
                policyNodeImpl.getPolicyNodes(n, set);
            }
        }
    }

    Set getPolicyNodesExpected(int n, String string, boolean bl) {
        if (string.equals(ANY_POLICY)) {
            return this.getPolicyNodes(n);
        }
        return this.getPolicyNodesExpectedHelper(n, string, bl);
    }

    private Set getPolicyNodesExpectedHelper(int n, String string, boolean bl) {
        HashSet<PolicyNodeImpl> hashSet = new HashSet<PolicyNodeImpl>();
        if (this.mDepth < n) {
            Iterator iterator = this.mChildren.iterator();
            while (iterator.hasNext()) {
                PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)iterator.next();
                hashSet.addAll(policyNodeImpl.getPolicyNodesExpectedHelper(n, string, bl));
            }
        } else if (bl) {
            if (this.mExpectedPolicySet.contains(ANY_POLICY)) {
                hashSet.add(this);
            }
        } else if (this.mExpectedPolicySet.contains(string)) {
            hashSet.add(this);
        }
        return hashSet;
    }

    Set getPolicyNodesValid(int n, String string) {
        HashSet<PolicyNodeImpl> hashSet = new HashSet<PolicyNodeImpl>();
        if (this.mDepth < n) {
            Iterator iterator = this.mChildren.iterator();
            while (iterator.hasNext()) {
                PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)iterator.next();
                hashSet.addAll(policyNodeImpl.getPolicyNodesValid(n, string));
            }
        } else if (this.mValidPolicy.equals(string)) {
            hashSet.add(this);
        }
        return hashSet;
    }

    private static String policyToString(String string) {
        if (string.equals(ANY_POLICY)) {
            return "anyPolicy";
        }
        return string;
    }

    String asString() {
        if (this.mParent == null) {
            return "anyPolicy  ROOT\n";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getDepth();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append(PolicyNodeImpl.policyToString(this.getValidPolicy()));
        stringBuffer.append("  CRIT: ");
        stringBuffer.append(this.isCritical());
        stringBuffer.append("  EP: ");
        Iterator iterator = this.getExpectedPolicies().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(PolicyNodeImpl.policyToString(string));
            stringBuffer.append(" ");
        }
        stringBuffer.append(" (");
        stringBuffer.append(this.getDepth());
        stringBuffer.append(")\n");
        return stringBuffer.toString();
    }
}

