/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import com.sun.security.cert.CRLSelector;
import com.sun.security.cert.CertSelector;
import com.sun.security.cert.CertStoreException;
import com.sun.security.cert.CertStoreParameters;
import com.sun.security.cert.CertStoreSpi;
import com.sun.security.cert.CollectionCertStoreParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;

public class CollectionCertStore
extends CertStoreSpi {
    private Collection coll;

    public CollectionCertStore(CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException {
        super(certStoreParameters);
        if (!(certStoreParameters instanceof CollectionCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("parameters must be CollectionCertStoreParameters");
        }
        this.coll = ((CollectionCertStoreParameters)certStoreParameters).getCollection();
    }

    public Collection engineGetCertificates(CertSelector certSelector) throws CertStoreException {
        if (this.coll == null) {
            throw new CertStoreException("Collection is null");
        }
        for (int i = 0; i < 10; ++i) {
            try {
                HashSet hashSet = new HashSet();
                Iterator iterator = this.coll.iterator();
                if (certSelector != null) {
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!(e instanceof Certificate) || !certSelector.match((Certificate)e)) continue;
                        hashSet.add(e);
                    }
                } else {
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!(e instanceof Certificate)) continue;
                        hashSet.add(e);
                    }
                }
                return hashSet;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
        }
        throw new ConcurrentModificationException("Too many ConcurrentModificationExceptions");
    }

    public Collection engineGetCRLs(CRLSelector cRLSelector) throws CertStoreException {
        if (this.coll == null) {
            throw new CertStoreException("Collection is null");
        }
        for (int i = 0; i < 10; ++i) {
            try {
                HashSet hashSet = new HashSet();
                Iterator iterator = this.coll.iterator();
                if (cRLSelector != null) {
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!(e instanceof CRL) || !cRLSelector.match((CRL)e)) continue;
                        hashSet.add(e);
                    }
                } else {
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!(e instanceof CRL)) continue;
                        hashSet.add(e);
                    }
                }
                return hashSet;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
        }
        throw new ConcurrentModificationException("Too many ConcurrentModificationExceptions");
    }
}

