<?xml version="1.0" encoding="windows-1252" ?>


<!--
Stylesheet which makes a best effort to transform a pre-10.1.3 jdeveloper 
extension manifest to a JDeveloper compatible JSR-198 manifest.

Prior to 10.1.3, you could have multiple extensions in a single manifest file.
This is no longer possible. Mostly, legacy extensions are "second class
citizens" as far as most of the extension manager features go. It's not possible
to turn them off, their dependencies may not be honoured, and some features
(notably resource lookups) may no longer work...

We more or less just try to add the addins, gallery, palette and help items for
the extensions.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  
  <xsl:template match="/">
    <!-- Get the name of the extension by getting the first non top level group -->
    <xsl:variable name="extname">
      <xsl:value-of select="//*[local-name()='group'][not(boolean(@toplevel))]/@name" />
    </xsl:variable>
    
    <!-- Generate an id by converting to lower case and replacing spaces with periods -->
    <xsl:variable name="extid">
      <xsl:value-of select="translate( $extname, ' ABCDEFGHIJKLMNOPQRSTUVWXYZ', '.abcdefghijklmnopqrstuvwxyz' )" />
    </xsl:variable>
    
    <extension xmlns="http://jcp.org/jsr/198/extension-manifest"
               id="{$extid}"
               esdk-version="1.0"
               version="1.0">
      <name>Test Extension: <xsl:value-of select="$extname" /></name>
      
      <!-- We have no way of knowing whether extensions are using features
           that are only in J2EE. Therefore, we must make all legacy extensions
           depend on J2EE. -->
      <dependencies>
        <import>oracle.j2ee</import>
      </dependencies>
      
      <hooks>
        <jdeveloper-hook xmlns="http://xmlns.oracle.com/jdeveloper/1013/extension">
        
          <!-- 
              addins are easy. We just coalesce all elements with addin as the
              local name into the addins jdeveloper hook.
          -->
          <addins>
            <xsl:for-each select="//*[local-name()='addin']">
              <addin><xsl:value-of select="." /></addin>
            </xsl:for-each>
          </addins>
          
          <!--
            Gallery items are also pretty similar in 10.1.3, we just have to 
            strip out any namespaces and copy each <gallery> element into an
            <item> element under the <gallery> jdeveloper hook.
          -->
          <gallery>
            <xsl:for-each select="//*[local-name()='gallery']">
              <item>
                <xsl:apply-templates select="*" mode="copy_sans_namespace" />
              </item>
            </xsl:for-each>
          </gallery>
     
          <!--
            Help items are mostly the same, except that helpURL is now
            localHelpURL. We also strip out namespaces here.
          -->
          <help>
            <xsl:for-each select="//*[local-name()='help']">
              <item>
                <xsl:apply-templates select="*[not(local-name()='helpURL')]" mode="copy_sans_namespace" />
                <xsl:for-each select="*[local-name()='helpURL']">
                  <localHelpURL><xsl:value-of select="." /></localHelpURL>
                </xsl:for-each>
              </item>
            </xsl:for-each>
          </help>
        </jdeveloper-hook>
      </hooks>
      
    </extension>
               
  </xsl:template>
  
  <!-- Similar to copy-of, except that it strips namespaces out. -->
  <xsl:template match="*" priority="-1" mode="copy_sans_namespace">
    <xsl:element name="{name()}">
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates mode="copy_sans_namespace"/>
    </xsl:element>
  </xsl:template>
  
  <xsl:template match="text()" mode="copy_sans_namespace">
    <xsl:value-of select="normalize-space(.)"/>
  </xsl:template>
  
</xsl:stylesheet>
