/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.esdk.migration;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ResourceBundle;
import javax.ide.net.URIFactory;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.BundleLoader;
import oracle.jdevimpl.esdk.migration.LegacyExtensionSource;

public final class MigrationController
implements Controller {
    public static final int CONVERT_JDEVEXT_ID = Ide.findOrCreateCmdID((String)"oracle.ideimpl.extension.ConvertToExtension");

    public boolean handleEvent(IdeAction action, Context context) {
        if (action.getCommandId() == CONVERT_JDEVEXT_ID) {
            this.convertLegacyManifest(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertLegacyManifest(Context c) {
        if (c.getSelection() != null && c.getSelection().length == 1 && c.getSelection()[0] instanceof Locatable) {
            URL url = ((Locatable)c.getSelection()[0]).getURL();
            URI uri = URIFactory.newURI((String)url.toString());
            LegacyExtensionSource les = new LegacyExtensionSource(uri);
            les.setManifestURI(uri);
            URL dest = URLFactory.newURL((URL)URLFileSystem.getParent((URL)url), (String)"extension.xml");
            if (URLFileSystem.exists((URL)dest)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)this.getBundle().getString("EXT_XML_EXISTS"), (String)this.getBundle().getString("EXT_XML_ERROR_TITLE"), null);
                return;
            }
            InputStream ins = null;
            try {
                IdeAction printAction;
                ins = les.getInputStream();
                URLFileSystem.copy((InputStream)ins, (URL)dest);
                Editor e = EditorUtil.openDefaultEditorInFrame((URL)dest);
                Integer prettyPrint = Ide.findCmdID((String)"PrettyPrintXMLCommand");
                if (prettyPrint != null && (printAction = IdeAction.find((int)prettyPrint)) != null) {
                    printAction.performAction(e.getContext());
                    e.getContext().getNode().save();
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)this.getBundle().getString("ERROR_CONVERTING"), (String)this.getBundle().getString("EXT_XML_ERROR_TITLE"), null);
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        }
    }

    private ResourceBundle getBundle() {
        return BundleLoader.getBundle((String)"oracle.jdevimpl.esdk.Resources");
    }
}

