/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.esdk.migration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import javax.ide.extension.spi.JARExtensionSource;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

class LegacyExtensionSource
extends JARExtensionSource {
    private String _manifestText = null;
    private static final String MANIFEST_ENTRY = "META-INF/jdev-ext.xml";
    private static final String ALT_MANIFEST_ENTRY = "meta-inf/jdev-ext.xml";
    private URI _manifestURI;

    public LegacyExtensionSource(URI uri) {
        super(uri);
    }

    public final URI getManifestURI() {
        if (this._manifestURI != null) {
            return this._manifestURI;
        }
        this._manifestURI = URIFactory.newJarURI((URI)this.getURI(), (String)MANIFEST_ENTRY);
        if (!VirtualFileSystem.getVirtualFileSystem().exists(this._manifestURI)) {
            this._manifestURI = URIFactory.newJarURI((URI)this.getURI(), (String)ALT_MANIFEST_ENTRY);
            if (!VirtualFileSystem.getVirtualFileSystem().exists(this._manifestURI)) {
                this._manifestURI = null;
            }
        }
        return this._manifestURI;
    }

    void setManifestURI(URI manifestURI) {
        this._manifestURI = manifestURI;
    }

    public InputStream getInputStream() throws IOException {
        if (this._manifestText == null) {
            this.transformLegacyManifest();
        }
        return new ByteArrayInputStream(this._manifestText.getBytes());
    }

    private void transformLegacyManifest() throws IOException {
        InputStream oldIn = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            StreamSource xslStream = new StreamSource(LegacyExtensionSource.class.getResource("manifest-1012-to-1013.xsl").toString());
            Transformer transformer = transformerFactory.newTransformer(xslStream);
            oldIn = VirtualFileSystem.getVirtualFileSystem().openInputStream(this.getManifestURI());
            StreamSource fromStream = new StreamSource(oldIn);
            StringWriter outWriter = new StringWriter();
            StreamResult toStream = new StreamResult(outWriter);
            transformer.transform(fromStream, toStream);
            outWriter.close();
            this._manifestText = outWriter.toString();
        }
        catch (TransformerConfigurationException tce) {
            tce.printStackTrace();
            throw new IOException("Transformer factory error");
        }
        catch (TransformerException te) {
            te.printStackTrace();
            throw new IOException("Transformer exception");
        }
    }
}

