/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.esdk;

import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.transform.TransformerFactory;
import oracle.ide.Ide;
import oracle.ide.cmd.OpenCommand;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdevimpl.esdk.Util;

final class UnzipRunnable
implements Runnable {
    private static final Logger LOG = Logger.getLogger(UnzipRunnable.class.getName());
    private static final String JSR198_NS = "http://jcp.org/jsr/198/extension-manifest";
    private static final String EXTENSION = "extension";
    private final URL _zipFile;
    private final URL _extractDir;
    private final DeterminateProgressMonitor _monitor;
    private static final double ZIP_PORTION = 1.0;
    private static final int YIELD_EVERY = 10;
    static final String EXTENSION_SDK_JWS = "extensionsdk.jws";
    private TransformerFactory _transformerFactory;

    UnzipRunnable(DeterminateProgressMonitor monitor, URL zipFile, URL dir) {
        this._monitor = monitor;
        this._zipFile = zipFile;
        this._extractDir = dir;
        this._transformerFactory = TransformerFactory.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._monitor.display();
            if (this.extractImpl()) {
                this.openWorkspace();
            }
        }
        catch (IOException ioe) {
            Util.error("errorinstall");
            ioe.printStackTrace();
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)re);
        }
        finally {
            this._monitor.finish();
        }
    }

    private boolean openWorkspace() throws IOException {
        final URL workspaceURL = URLFactory.newURL((URL)this._extractDir, (String)EXTENSION_SDK_JWS);
        if (!URLFileSystem.exists((URL)workspaceURL)) {
            throw new IOException("Extension SDK ZIP did not contain extensionsdk.jws");
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        OpenCommand cmd = new OpenCommand();
                        cmd.setContext(Ide.getMainWindow().getIdeMainWindowView().getContext());
                        cmd.openURL(workspaceURL);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._monitor.setProgress(100);
        Thread.yield();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean extractImpl() throws IOException {
        ZipFile zip = null;
        try {
            zip = new ZipFile(URLFileSystem.getPlatformPathName((URL)this._zipFile));
            String baseDir = URLFileSystem.getPlatformPathName((URL)this._extractDir);
            int i = 0;
            double progressStep = 1.0 * (1.0 / (double)zip.size()) * 100.0;
            double progress = 0.0;
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                if (++i % 10 == 0) {
                    Thread.yield();
                }
                ZipEntry entry = e.nextElement();
                if (this._monitor.isCanceled()) {
                    boolean bl = false;
                    return bl;
                }
                File outFile = new File(baseDir + File.separator + entry.getName());
                if (!outFile.exists()) {
                    if (entry.isDirectory()) {
                        if (!outFile.mkdirs()) {
                            throw new IOException("Failed to create directory " + outFile);
                        }
                    } else {
                        if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
                            throw new IOException("Failed to create directory " + outFile.getParentFile());
                        }
                        InputStream inStream = null;
                        try {
                            inStream = zip.getInputStream(entry);
                            URLFileSystem.copy((InputStream)inStream, (URL)URLFactory.newURL((String)outFile.getPath()));
                            LOG.fine("Extracted " + outFile);
                            inStream.close();
                        }
                        catch (IOException ioe) {
                            LOG.log(Level.SEVERE, "closing input stream from zip file", ioe);
                        }
                        finally {
                            if (inStream != null) {
                                inStream.close();
                            }
                        }
                    }
                }
                this._monitor.setProgress((int)(progress += progressStep));
            }
        }
        finally {
            if (zip != null) {
                zip.close();
            }
            this._monitor.setProgress(100);
        }
        return true;
    }
}

