/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.esdk;

import java.awt.Component;
import java.net.URL;
import javax.ide.extension.Extension;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.webupdate.PostStartupHook;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdevimpl.esdk.UnzipRunnable;
import oracle.jdevimpl.esdk.Util;

public final class ESDKInstaller
implements PostStartupHook {
    static final String EXTENSION_ID = "oracle.jdeveloper.esdk";
    private static final String SOURCE_ZIP = "esdksamples.zip";
    static final String EXTRACT_DIR = "extension-samples";

    public void install() {
        if (Util.ask("wanttoinstall", false)) {
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            URL systemDir = er.getSystemDirectory(EXTENSION_ID);
            URL sourceZip = URLFactory.newURL((URL)systemDir, (String)SOURCE_ZIP);
            if (!URLFileSystem.exists((URL)sourceZip)) {
                Util.error("missingsources");
            } else {
                this.installSources(sourceZip);
            }
        }
    }

    private void installSources(URL zipfile) {
        Extension thisExtension = ExtensionRegistry.getExtensionRegistry().findExtension(EXTENSION_ID);
        if (thisExtension == null) {
            throw new IllegalStateException("Unable to find extension with id oracle.jdeveloper.esdk");
        }
        String extractDir = "extension-samples-" + thisExtension.getVersion().toCanonicalString();
        URL extractURL = URLFactory.newDirURL((URL)URLFactory.newURL((String)Ide.getWorkDirectory()), (String)extractDir);
        if (this.verifyExtractDirectory(extractURL)) {
            DeterminateProgressMonitor dpm = new DeterminateProgressMonitor((Component)Ide.getMainWindow(), Util.getRes().getString("progresstitle"));
            dpm.setMaximum(100);
            dpm.getPanel().setMessage("Installing extension SDK samples");
            dpm.setCloseOnFinish(true);
            UnzipRunnable unzipper = new UnzipRunnable(dpm, zipfile, extractURL);
            Thread t = new Thread((Runnable)unzipper, "Extension SDK sample installer");
            t.start();
        }
    }

    private boolean verifyExtractDirectory(URL extractDir) {
        if (URLFileSystem.exists((URL)extractDir)) {
            if (Util.ask("overwritesource", true)) {
                if (!this.removeDirectory(extractDir)) {
                    Util.error("failedtoremove");
                    return false;
                }
            } else {
                return false;
            }
        }
        return URLFileSystem.mkdirs((URL)extractDir);
    }

    private boolean removeDirectory(URL url) {
        URL[] files = URLFileSystem.list((URL)url);
        for (int i = 0; i < files.length; ++i) {
            URL child = files[i];
            if (URLFileSystem.isDirectory((URL)child) && !this.removeDirectory(child)) {
                return false;
            }
            if (URLFileSystem.delete((URL)child)) continue;
            return false;
        }
        return true;
    }
}

