/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.esdk;

import java.awt.EventQueue;
import java.net.URL;
import java.util.Iterator;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionRegistry;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.OpenCommand;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.esdk.ESDKInstaller;
import oracle.jdevimpl.esdk.ESDKInstallerAddin;
import oracle.jdevimpl.extensiondt.cmd.Actions;

public final class ESDKController
implements Controller {
    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == ESDKInstallerAddin.CMDID_OPEN_SDK) {
            this.openSDK();
            return true;
        }
        if (cmdId == ESDKInstallerAddin.CMDID_DEPLOY_ALL) {
            this.deployAll();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        return false;
    }

    private void openSDK() {
        URL extractURL = this.getBaseDir();
        final URL workspaceFile = URLFactory.newURL((URL)extractURL, (String)"extensionsdk.jws");
        if (!URLFileSystem.exists((URL)workspaceFile)) {
            new ESDKInstaller().install();
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    OpenCommand cmd = new OpenCommand();
                    cmd.setContext(Ide.getMainWindow().getIdeMainWindowView().getContext());
                    cmd.openURL(workspaceFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private URL getBaseDir() {
        Extension thisExtension = ExtensionRegistry.getExtensionRegistry().findExtension("oracle.jdeveloper.esdk");
        if (thisExtension == null) {
            throw new IllegalStateException("Extension id not found: oracle.jdeveloper.esdk");
        }
        String extractDir = "extension-samples-" + thisExtension.getVersion().toCanonicalString();
        URL extractURL = URLFactory.newURL((URL)URLFactory.newURL((String)Ide.getWorkDirectory()), (String)extractDir);
        return extractURL;
    }

    private void deployAll() {
        IdeAction deployAction = IdeAction.find((int)Actions.DEPLOY_TO_TARGET_ID);
        if (deployAction == null) {
            return;
        }
        URL extractURL = this.getBaseDir();
        URL workspaceURL = URLFactory.newURL((URL)extractURL, (String)"extensionsdk.jws");
        Node workspaceNode = NodeFactory.find((URL)workspaceURL);
        if (workspaceNode != null && workspaceNode instanceof Workspace) {
            Workspace workspace = (Workspace)workspaceNode;
            Iterator i = workspace.getChildren();
            while (i.hasNext()) {
                Node child = (Node)i.next();
                if (!(child instanceof Project) || child.getShortLabel().contains("AllSamples")) continue;
                Context context = Context.newIdeContext();
                context.setWorkspace(workspace);
                context.setProject((Project)child);
                context.setSelection(new Element[]{child});
                try {
                    deployAction.performAction(context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

