<?xml version="1.0"?>

<!--  $Header: soatutor/integration/xpdl/xml/Tibco4Patch.xsl /st_pcbpel_11.1.1.4.0/1 2011/09/09 12:33:22 fevers Exp $ -->

<!-- 
 Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 

   NAME
     VisioMasterMap.xml - <one-line expansion of the name>

   DESCRIPTION
     <short description of component this file declares/defines>

   NOTES
     <other useful comments, qualifications, etc.>

   MODIFIED   (MM/DD/YY)
   fevers      03/23/11 - adding tutor xml-related files
   fevers      03/23/11 - Creation

-->
<!--
    
    Date        Who         Change
    =========   =========== ====================================================
    10-Jun-10   N.Kumar     created
    11-Jun-10   N.Kumar     comments included
	09-Dec-10	J. Lange	Modified xpdl2 schema reference for TIBCO v4 files.
    
  -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xpdl2="http://www.wfmc.org/2004/XPDL2.0alpha">
	<xsl:output method="xml" indent="yes"/>
	<!--
    When RelativeObjectCoordinates are used make sure the below mentioned rules are followed.
    1. Activities which are in lane are absolute
    2. Activities which are in subprocess are relative to subprocess
    3. Lanes are relative to pool
    4. Pools are absolute
    
    For Tibco
    1. Activities which are in lane are relative to lane - make them absolute
    2. Activities which are in subprocess are relative to subprocess - do nothing
    3. since pool contains no coordinates - create absolute pool coordinates
    4. since lane contains no coordinates - create relative lane coordinates
    5. since no transition contains connections info - let bpa redrawConnections
    6. since object pin of activities is middle, make it upper-left.
  -->
	<!-- Root template -->
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="xpdl2:Package/xpdl2:ExtendedAttributes">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xpdl2:ExtendedAttribute Name="isRelativeObjectCoordinates" Value="true"/>
			<xpdl2:ExtendedAttribute Name="redrawConnections" Value="true"/>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<!--Assuming all tibco models are of Horizontal Orientation-->
	<xsl:template match="xpdl2:Pool">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="Orientation"><xsl:text>HORIZONTAL</xsl:text></xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="//xpdl2:Pool/xpdl2:NodeGraphicsInfos/xpdl2:NodeGraphicsInfo">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<!--creating height attribute for pool. poolHeight = sum of all of it's child lane's height-->
			<xsl:attribute name="Height"><xsl:value-of select="sum(ancestor::xpdl2:Pool/xpdl2:Lanes/xpdl2:Lane/xpdl2:NodeGraphicsInfos/xpdl2:NodeGraphicsInfo/@Height)"/></xsl:attribute>
			<!--creating coordinates element for pool with x and y coordinates. x=0 and pooly = sum of all lanes (which precedes this pool) height-->
			<xsl:element name="Coordinates">
				<xsl:attribute name="XCoordinate"><xsl:text>0</xsl:text></xsl:attribute>
				<xsl:attribute name="YCoordinate"><xsl:call-template name="pooly"><xsl:with-param name="poolId" select="ancestor::xpdl2:Pool/@Id"/></xsl:call-template></xsl:attribute>
			</xsl:element>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="//xpdl2:Lane/xpdl2:NodeGraphicsInfos/xpdl2:NodeGraphicsInfo">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<!--set width and x of lane as 0 and let xpdl code deal with stretching of lane-->
			<xsl:attribute name="Width"><xsl:text>0</xsl:text></xsl:attribute>
			<xsl:element name="Coordinates">
				<xsl:attribute name="XCoordinate"><xsl:text>0</xsl:text></xsl:attribute>
				<xsl:attribute name="YCoordinate"><xsl:call-template name="laney"><xsl:with-param name="laneId" select="ancestor::xpdl2:Lane/@Id"/></xsl:call-template></xsl:attribute>
			</xsl:element>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<!--template which gets y coordinate of lane, when laneId is passed to it.-->
	<xsl:template name="laney">
		<xsl:param name="laneId"/>
		<xsl:variable name="currentLanePosition">
			<xsl:for-each select="//xpdl2:Lane[@Id = $laneId]/ancestor::xpdl2:Pool/xpdl2:Lanes/xpdl2:Lane">
				<xsl:if test="$laneId = ./@Id">
					<xsl:value-of select="position()"/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$currentLanePosition = 1">
				<xsl:text>0</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="sum(//xpdl2:Lane[@Id = $laneId]/ancestor::xpdl2:Pool/xpdl2:Lanes/xpdl2:Lane[@Id = $laneId]/preceding-sibling::xpdl2:Lane/xpdl2:NodeGraphicsInfos/xpdl2:NodeGraphicsInfo/@Height)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--template which gets y coordinate of pool, when poolId is passed to it.-->
	<xsl:template name="pooly">
		<xsl:param name="poolId"/>
		<xsl:variable name="currentPoolPosition">
			<xsl:for-each select="//xpdl2:Pool">
				<xsl:if test="$poolId = ./@Id">
					<xsl:value-of select="position()"/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$currentPoolPosition = 1">
				<xsl:text>0</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="sum(//xpdl2:Pool[@Id = $poolId]/preceding::xpdl2:Pool/xpdl2:Lanes/xpdl2:Lane/xpdl2:NodeGraphicsInfos/xpdl2:NodeGraphicsInfo/@Height)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--set objectpin to upper-left for the activities which are in subprocess-->
	<xsl:template match="xpdl2:ActivitySet/xpdl2:Activities/xpdl2:Activity/xpdl2:NodeGraphicsInfos/xpdl2:NodeGraphicsInfo/xpdl2:Coordinates">
		<xsl:copy>
			<xsl:copy-of select="@*[name() != 'XCoordinate' and name() != 'YCoordinate']"/>
			<xsl:attribute name="XCoordinate"><xsl:value-of select="@XCoordinate - (ancestor::xpdl2:NodeGraphicsInfo/@Width) div 2"/></xsl:attribute>
			<xsl:attribute name="YCoordinate"><xsl:value-of select="@YCoordinate - (ancestor::xpdl2:NodeGraphicsInfo/@Height) div 2"/></xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<!--make activity coordinates absolute and also set their object pin to upper-left-->
	<xsl:template match="xpdl2:WorkflowProcess/xpdl2:Activities/xpdl2:Activity/xpdl2:NodeGraphicsInfos/xpdl2:NodeGraphicsInfo/xpdl2:Coordinates">
		<xsl:copy>
			<xsl:copy-of select="@*[name() != 'YCoordinate' and name() != 'XCoordinate']"/>
			<xsl:variable name="laneId">
				<xsl:value-of select="ancestor::xpdl2:NodeGraphicsInfo/@LaneId"/>
			</xsl:variable>
			<xsl:attribute name="XCoordinate"><xsl:value-of select="@XCoordinate - (../@Width) div 2"/></xsl:attribute>
			<xsl:attribute name="YCoordinate"><xsl:variable name="poolY"><xsl:call-template name="pooly"><xsl:with-param name="poolId" select="//xpdl2:Lane[@Id = $laneId]/ancestor::xpdl2:Pool/@Id"/></xsl:call-template></xsl:variable><xsl:variable name="laneY"><xsl:call-template name="laney"><xsl:with-param name="laneId" select="$laneId"/></xsl:call-template></xsl:variable><xsl:value-of select="(@YCoordinate - (../@Height) div 2) + $poolY + $laneY"/></xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
