<?xml version="1.0" encoding="UTF-8"?>
<!--
		This transformation is applied to non-standard XPDL 2.1 documents in
		order to convert them into standard form as it is specified in XML
		schema for XPDL v2.1.
                
                Date        Who         Change
                =========   =========== ====================================================
                26-Apr-11   Jim Lange   Created.
                03-May-11   Jim Lange   Removed logic to set Page attribute (after changing
                                        XPDL java code).
                
	-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xpdl21="http://www.wfmc.org/2008/XPDL2.1" xmlns:xpdl="http://www.wfmc.org/2004/XPDL2.0alpha" xmlns:albpm="http://www.albpm.com/2007/albpm.XPDL2">
	<xsl:output method="xml" indent="yes"/>
	<!-- 
		General template - just copying everything as it is
	-->
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	<!--
		Adding element ExtendedAttribute name="isRelativeCoordinates" 
	-->
	<xsl:template match="xpdl21:Package/xpdl21:ExtendedAttributes">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xpdl21:ExtendedAttribute Name="isRelativeObjectCoordinates" Value="false"/>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="xpdl21:Package">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:if test="not(child::xpdl21:ExtendedAttributes)">
				<xpdl21:ExtendedAttributes>
					<xpdl21:ExtendedAttribute Name="isRelativeObjectCoordinates" Value="false"/>
				</xpdl21:ExtendedAttributes>
			</xsl:if>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
