<?xml version="1.0" encoding="UTF-8"?>
<!--
		This transformation is applied to non-standard XPDL 2.1 documents in
		order to convert them into standard form as it is specified in XML
		schema for XPDL v2.1.
                
                Date        Who         Change
                =========   =========== ====================================================
                18-Aug-09   Jim Lange   Add case to add <Event> section for ALBM link events.
                
                19-Aug-09   Jim Lange   Supress <Implementation> tag for ALBM link events.
                                        Reorganize into ALBPM and BizAgi sections (to make it 
                                        easier to split into separate files later).
                
                31-Dec-09   N.Kumar     Include Route element in Activity if TransitionRestrictions element found in Activity   
                                        and activity type is join, set its dimensions as 20x20
                
                06-Jan-10   N.Kumar     Make Lane Ids unique by adding XCoordinate to Lane Id
                
                07-Jan-10   N.Kumar     Set Connector element name with its referencing element name
                                        Set Default attribute of Transitions (include OTHERWISE condition element in Transition element)
                                        Remove invisible Activity elements
                                
                08-Jan-10   N.Kumar     Activitiy dimensions changed back to previous dimensions
                                         (Task,CollapsedBlockActivity-80x50, 
                                          events,Routes-50x50, expandedBlockActivity-0x0)
                
                04-Feb-10   N.Kumar     .Add Intermediate Error Events if model has attached Error Events.
                                        .Change(if only error Elements exists) 'Transition From attribute' to make flow start from error event 
                                          instead of errorEvent attached activity
                                        .Set default Ids('error'+TargetActivityName) to 'ErrorIntermediateEvents','Transition attribute From' 
                                          if errorEvents have no name specified in extensions
                
                05-Feb-10   N.Kumar     apply-templates element relocated in Activities template because java code is depending on order of execution
                
                10-Feb-10   N.Kumar     .Set Default attribute of Transitions only if other flows flowing from same source have CONDITIONAL albpmExtension
                                        .Remove extra transitions generated by attached intermediate events(Compensate, timer).
                
                15-Feb-10   N.Kumar     .change ActivitySetId by removing'_ActivitySet'.
                                        .Consider ProcessGroup as visible element if it has in or out flows from it.
                                        .Convert ProcessGroup to Intermediate Event.
                                        .Deal with Transition Name
                
                17-Feb-10   N.Kumar     Convert events which have attached          intermediate events to Tasks.
                10-Apr-12   J. Lange    Bug 13714476 - Fixed stripping of LaneId attribute
                                        from NodeGraphicsInfo.
-->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xpdl21="http://www.wfmc.org/2008/XPDL2.1"
                xmlns:xpdl="http://www.wfmc.org/2004/XPDL2.0alpha"
                xmlns:albpm="http://www.albpm.com/2007/albpm.XPDL2">
 <xsl:output method="xml" indent="yes"/>
 <!-- 
		Constants for recognized ToolIds
                TODO: Seems like these should be variables
	-->
    <xsl:param name="ALBPM_TOOL_ID" select="'ALBPM'"/>
 <!--xsl:param name="BIZAGI_TOOL_ID" select="'BizAgi_Process_Modeler'"/-->
 <!-- 
		General template - just copying everything as it is
	-->
    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
    
    
    <!-- variable to swap coordinates for a horizontal ALBPM work-flow process -->
    <xsl:variable name="SWAP_LAYOUT"
               select="//xpdl:WorkflowProcess[position() = 1]/xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:BooleanFeature[@name = 'horizontal']/@value"/>
 
 
    <!--
            Adding element ExtendedAttribute name="isRelativeObjectCoordinates"
            and 'redrawConnections' ExtendedAttribute
     -->
        <xsl:template match="xpdl:Package/xpdl:ExtendedAttributes">
            <xsl:copy>
                <xsl:copy-of select="@*"/>
                <xpdl:ExtendedAttribute Name="isRelativeObjectCoordinates" Value="false"/>
                <xpdl:ExtendedAttribute Name="redrawConnections" Value="true"/>
                <xsl:apply-templates/>                                
            </xsl:copy>
        </xsl:template>
        <xsl:template match="xpdl:Package">
            <xsl:copy>
                <xsl:copy-of select="@*"/>
                <xsl:if test="not(child::xpdl:ExtendedAttributes)">
                    <xpdl:ExtendedAttributes>
                        <xpdl:ExtendedAttribute Name="isRelativeObjectCoordinates" Value="false"/>
                        <xpdl:ExtendedAttribute Name="redrawConnections" Value="true"/>
                    </xpdl:ExtendedAttributes>
                </xsl:if>
                <xsl:apply-templates/>
            </xsl:copy>            
        </xsl:template>
 
 <!--
        setting orientation to Horizontal if swap_layout is true
 -->
    <xsl:template match="//xpdl:Pool">
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:if test="$SWAP_LAYOUT = 'true'">
                <xsl:attribute name="Orientation">
                    <xsl:text>HORIZONTAL</xsl:text>
                 </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>
    
    <!--Add Error Activity elements to Activities element when there is an Error element in the model-->
    <!--BPM doesn't create any Error Activity elements though there are attached Error elements in the model-->
    <!--check for exceptional transitions to determine if model has any Error elements-->
    <xsl:template match="xpdl:Activities">
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates/> <!-- TODO: seems like xpdl java execution is depending on order of execution and hence apply-templates is moved to here-->
            <xsl:for-each select="./../xpdl:Transitions/xpdl:Transition/xpdl:Condition[@Type = 'EXCEPTION']">
                <xsl:if test="./../@From != 'ProcessGroup'">
                    <xsl:element name="Activity">
                        <xsl:attribute name="Name"> 
                            <xsl:value-of select="./../albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name = 'userName']/@value"/> 
                        </xsl:attribute>
                        <xsl:attribute name="Id"> 
                            <xsl:choose>
                                <xsl:when test="./../albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='userName']/@value != ''">
                                    <xsl:value-of select="./../albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='userName']/@value"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="concat('error' , ./../@From)"/> 
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:attribute>
                        <xsl:element name="Event">
                            <xsl:element name="IntermediateEvent">
                                <xsl:attribute name="Trigger"> <xsl:text>Error</xsl:text> </xsl:attribute>
                                <xsl:attribute name="Target"> <xsl:value-of select="./../@From"/> </xsl:attribute>
                                <xsl:attribute name="IsAttached"> <xsl:text>true</xsl:text> </xsl:attribute>
                            </xsl:element>
                        </xsl:element>
                        <xsl:element name="NodeGraphicsInfos">
                            <xsl:element name="NodeGraphicsInfo">
                                <xsl:attribute name="IsVisible"> <xsl:text>true</xsl:text> </xsl:attribute>
                                <xsl:attribute name="Height"> <xsl:text>50</xsl:text> </xsl:attribute>
                                <xsl:attribute name="Width"> <xsl:text>50</xsl:text> </xsl:attribute>
                                <xsl:element name="Coordinates">
                                    <xsl:choose>
                                        <xsl:when test="$SWAP_LAYOUT = 'true'">
                                            <xsl:attribute name="XCoordinate"> 
                                                <xsl:value-of select="./../xpdl:ConnectorGraphicsInfos/xpdl:ConnectorGraphicsInfo/xpdl:Coordinates[1]/@YCoordinate + 30"/> 
                                            </xsl:attribute>
                                            <xsl:attribute name="YCoordinate"> 
                                                <xsl:value-of select="./../xpdl:ConnectorGraphicsInfos/xpdl:ConnectorGraphicsInfo/xpdl:Coordinates[1]/@XCoordinate + 20"/> 
                                            </xsl:attribute>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:attribute name="XCoordinate"> 
                                                <xsl:value-of select="./../xpdl:ConnectorGraphicsInfos/xpdl:ConnectorGraphicsInfo/xpdl:Coordinates[1]/@XCoordinate + 30"/> 
                                            </xsl:attribute>
                                            <xsl:attribute name="YCoordinate"> 
                                                <xsl:value-of select="./../xpdl:ConnectorGraphicsInfos/xpdl:ConnectorGraphicsInfo/xpdl:Coordinates[1]/@YCoordinate + 20"/> 
                                            </xsl:attribute>
                                        </xsl:otherwise>
                                    </xsl:choose>                                
                                </xsl:element>
                            </xsl:element>
                        </xsl:element>
                    </xsl:element>
                </xsl:if>
            </xsl:for-each>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match = "xpdl:ActivitySet">
        <xsl:copy>
            <xsl:copy-of select="@*[name() != 'Id']"/>
            <xsl:attribute name="Id">
                <xsl:value-of select="substring-before(@Id,'_ActivitySet')"/>
            </xsl:attribute>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="//xpdl:Activity">
    
        <!--Removing ProcessException Activity-->
        <!--xsl:variable name="isProcessException">
            <xsl:choose>
                <xsl:when test="xpdl:Extensions/albpm:ALBPMExtensions/albpm:Localization/albpm:LocalizationLabels/albpm:LocalizedLabel[@ label='Process Exceptions']">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>false</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable-->
        
        <xsl:variable name="activityId" >
            <xsl:value-of select="@Id"/>
        </xsl:variable>
        <!--Removing invisible Activities-->
        <xsl:variable name="isVisible">
            <xsl:choose>
                <!--if ProcessGroup has any flows to and from it, then consider ProcessGroup as visible Event.-->
                <xsl:when test="@Id = 'ProcessGroup' and ./../../xpdl:Transitions/xpdl:Transition[@From = 'ProcessGroup']">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="xpdl:NodeGraphicsInfos/xpdl:NodeGraphicsInfo/@IsVisible = 'true'">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>false</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:if test="$isVisible = 'true'">
            <xsl:copy>
                <xsl:copy-of select="@*[name() != 'Name']"/>
                <!-- copy albpm label to name attribute -->
                <xsl:attribute name="Name">
                     <xsl:variable name="albpmLabel">
                        <xsl:value-of select="./xpdl:Extensions/albpm:ALBPMExtensions/albpm:Localization/albpm:LocalizationLabels/albpm:LocalizedLabel[position() = 1]/@label"/>
                    </xsl:variable>
                    <xsl:choose>                        
                        <!--this condition will get executed when activity is Connector-->
                        <xsl:when test = "starts-with(@Id, 'C:')">
                            <xsl:value-of select = "child::xpdl:Implementation/xpdl:Reference/@ActivityId"/>
                        </xsl:when>
                        <!--if not connector, copy name from albpmLabel-->
                        <xsl:when test="$albpmLabel and $albpmLabel != ''">
                            <xsl:value-of select = "$albpmLabel"/>
                        </xsl:when>                        
                        <!--if name not found in albpm extensions then copy it's own name value-->
                        <xsl:otherwise>
                            <xsl:value-of select="@Name"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
                
                <!--adding Loop Element if activity contains enableLoop extension set to true-->
                <xsl:if test="xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:BooleanFeature[@name='enableLoop']/@value='true'">
                    <xsl:if test="not(child::xpdl:Loop)">
                        <xpdl:Loop LoopType="Standard"/>
                    </xsl:if>
                </xsl:if>
                
                <!--add missing child elements, remove if wrong elements found-->
                <xsl:choose>
                    
                    <!--convert ProcessGroup element as Error intermediate event element-->
                    <xsl:when test="@Id = 'ProcessGroup' and ./../../xpdl:Transitions/xpdl:Transition[@From = 'ProcessGroup']">
                        <xpdl:Event>
                            <xpdl:IntermediateEvent Trigger="Error"/>
                        </xpdl:Event>
                        <xsl:apply-templates select="node()[local-name() != 'Implementation']"/>
                    </xsl:when>
                    
                    <!--convert events which have attached intermediate events to Task elements.-->
                    <xsl:when test="./xpdl:Event and //xpdl:Activity/xpdl:Event/xpdl:IntermediateEvent[@Target = $activityId]">
                        <xsl:choose>
                            <xsl:when test="./xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature/@name = 'type'
                                            and ./xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature/@value = 'PROCESS_NOTIFICATION'">
                                <xpdl:Implementation>
                                    <xpdl:Task>
                                        <xpdl:TaskSend/>
                                    </xpdl:Task>
                                </xpdl:Implementation>
                            </xsl:when>
                            <xsl:when test="./xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature/@name = 'type'
                                            and ./xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature/@value = 'NOTIFICATION_WAIT'">
                                <xpdl:Implementation>
                                    <xpdl:Task>
                                        <xpdl:TaskReceive/>
                                    </xpdl:Task>
                                </xpdl:Implementation>
                            </xsl:when>
                            <xsl:otherwise>
                                <xpdl:Implementation>
                                    <xpdl:No/>
                                </xpdl:Implementation>
                            </xsl:otherwise>
                        </xsl:choose>
                        <xsl:apply-templates select="node()[local-name() != 'Event']"/>
                    </xsl:when>
                    
                    <xsl:when test="./xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature/@name = 'type' 
                                          and ./xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature/@value = 'CONNECTOR'">
                        <xpdl:Event>
                            <xpdl:IntermediateEvent Trigger="Link"/>
                        </xpdl:Event>
                        <!-- exclude <implementation> tag -->
                        <xsl:apply-templates select="node()[local-name() != 'Implementation']"/>
                    </xsl:when>
                    
                    <!--setting start and end events of Activityset as events and removing Route tag from these Activities -->
                    <xsl:when test="ancestor::xpdl:ActivitySet and @Id = concat(substring-before(ancestor::xpdl:ActivitySet/@Id,'_ActivitySet'),'$Begin') and child::xpdl:Route">
                        <xpdl:Event>
                            <xpdl:StartEvent/>
                        </xpdl:Event>
                        <xsl:apply-templates select="node()[local-name()!='Route']"/>
                    </xsl:when>
                    
                    <xsl:when test="ancestor::xpdl:ActivitySet and @Id=concat(substring-before(ancestor::xpdl:ActivitySet/@Id,'_ActivitySet'),'$End') and child::xpdl:Route">
                        <xpdl:Event>
                            <xpdl:EndEvent/>
                        </xpdl:Event>
                        <xsl:apply-templates select="node()[local-name()!='Route']"/>
                    </xsl:when>
                    
                    <!--adding TaskUser element if activity is DecisionActivity-->
                    <xsl:when test="child::xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name = 'type']/@value='DECISION'">
                        <xsl:choose>                            
                            <xsl:when test="child::xpdl:Implementation">
                                <xsl:choose>
                                    <xsl:when test="child::xpdl:Implemenation/xpdl:Task">
                                        <xsl:if test="not(child::xpdl:Implementation/xpdl:Task/xpdl:TaskUser)">
                                            <xpdl:TaskUser/>
                                        </xsl:if>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xpdl:Task>
                                            <xpdl:TaskUser/>
                                        </xpdl:Task>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:otherwise>
                                <xpdl:Implementation>
                                    <xpdl:Task>
                                        <xpdl:TaskUser/>
                                    </xpdl:Task>
                                </xpdl:Implementation>
                            </xsl:otherwise>
                        </xsl:choose>
                        <xsl:apply-templates/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates/>
                    </xsl:otherwise>
                </xsl:choose>
                
                 <!--setting joins of split, or split, multiple gateways as gateways so that these are read as gateways by bpa-->
                <!--xsl:variable name="isJoinType">
                    <xsl:choose>
                        <xsl:when test="xpdl:TransitionRestrictions/xpdl:TransitionRestriction/xpdl:Join[@Type='COMPLEX' or @Type='OR' or @Type='AND']">
                            <xsl:text>true</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text>false</xsl:text>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable-->
                <!--xsl:if test="$isJoinType='true'"-->
                <xsl:if test="child::xpdl:TransitionRestrictions and 
                              child::xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name = 'type']/@value = 'JOIN'">
                    <xsl:element name="xpdl:Route">
                        <xsl:attribute name="GatewayType">
                            <xsl:value-of select="xpdl:TransitionRestrictions/xpdl:TransitionRestriction/xpdl:Join/@Type"/>
                        </xsl:attribute>
                        <xsl:attribute name="MarkerVisible">
                            <xsl:text>true</xsl:text>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>
            </xsl:copy>
        </xsl:if>
    </xsl:template>
 
 
 <xsl:template match="xpdl:Activity/xpdl:Implementation">
  <xsl:copy>
   <xsl:copy-of select="@*"/>
   <!--Setting color of Automatic,ProcessCreation,Grab,Global Automatic elements.(adding TaskService element to Implementation element)
                            and adding TaskUser element for GlobalInteractivie elements.                          
    -->
   <xsl:choose>
    <xsl:when test="not(child::xpdl:Task) and 
                                (ancestor::xpdl:Activity/xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='type']/@value='AUTOMATIC'
                                or ancestor::xpdl:Activity/xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='type']/@value='GRAB'
                                or ancestor::xpdl:Activity/xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='type']/@value='GLOBAL_AUTOMATIC'
                            )">
     <xpdl:Task>
      <xpdl:TaskService/>
     </xpdl:Task>
    </xsl:when>
    <xsl:when test="not(child::xpdl:Task) and ancestor::xpdl:Activity/xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='type']/@value='GLOBAL'">
     <xpdl:Task>
      <xpdl:TaskUser/>
     </xpdl:Task>
    </xsl:when>
   </xsl:choose>
   <xsl:apply-templates/>
  </xsl:copy>
 </xsl:template>
 
 <!--adding TaskService element to automatic tasks without disturbing existing task element and
            adding TaskUser element to GlobalInteractive elements
  -->
 <xsl:template match="xpdl:Activity/xpdl:Implementation/xpdl:Task">
  <xsl:copy>
   <xsl:copy-of select="@*"/>
   <xsl:choose>
    <xsl:when test="(ancestor::xpdl:Activity/xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='type']/@value='AUTOMATIC'
                        or ancestor::xpdl:Activity/xpdl:Extensions/albpm:ALBPMExtesnions/albpm:FeatureSet/albpm:StringFeature[@name='type']/@value='GRAB' 
                        or ancestor::xpdl:Activity/xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='type']/@value='GLOBAL_AUTOMATIC') and not(child::xpdl:TaskService)">
     <xpdl:TaskService/>
    </xsl:when>
    <xsl:when test="not(child::xpdl:TaskUser) and ancestor::xpdl:Activity/xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='type']/@value='GLOBAL'">
     <xpdl:TaskUser/>
    </xsl:when>
   </xsl:choose>
   <xsl:apply-templates/>
  </xsl:copy>
 </xsl:template>
 
 <!--adding view attribute on BlockActivity element-->
 <xsl:template match="xpdl:Activity/xpdl:BlockActivity">
  <xsl:copy>
   <xsl:copy-of select="@*[name() != 'ActivitySetId']"/>
   <xsl:attribute name="ActivitySetId">
    <xsl:value-of select="substring-before(@ActivitySetId,'_ActivitySet')"/>
   </xsl:attribute>
   <xsl:choose>
    <xsl:when test="ancestor::xpdl:Activity/xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:BooleanFeature[@ name='collapsed']/@value='true'">
     <xsl:attribute name="View">
      <xsl:text>COLLAPSED</xsl:text>
     </xsl:attribute>
    </xsl:when>
    <!--xsl:when test="ancestor::xpdl:Activity/xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:BooleanFeature[@ name='collapsed']/@value!='true'">
     <xsl:attribute name="View">
      <xsl:text>EXPANDED</xsl:text>
     </xsl:attribute>
    </xsl:when-->
    <xsl:otherwise>
        <xsl:attribute name="View">
	  <xsl:text>EXPANDED</xsl:text>
	</xsl:attribute>	
    </xsl:otherwise>
   </xsl:choose>
   <xsl:apply-templates/>
  </xsl:copy>
 </xsl:template>
 
 
 <xsl:template match="//xpdl:Transition">
  
  <!--removing extra transition generated by bpm when due transition event attached to a task-->
  <xsl:variable name="isExtraTransition">
   <xsl:choose>
    <xsl:when test="child::albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='albpmType']/@value='DUE'
                 or child::albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='albpmType']/@value='COMPENSATE' 
                 or child::albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='albpmType']/@value='MESSAGE_BASED'">
     <xsl:text>true</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>false</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  
  <xsl:if test="$isExtraTransition='false'">
   <!-- Copy ALBPM UserName attribute to XPDL Name attribute-->
   <xsl:copy>
    <xsl:copy-of select="@*[name() != 'Id' and name() != 'From' and name() != 'Name']"/>
    <xsl:attribute name="Id">
        <xsl:choose>
            <xsl:when test="./albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='albpmType']/@value != 'UNCONDITIONAL'">
                <xsl:value-of select="concat(@Id, ./albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='albpmType']/@value)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select = "@Id"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:attribute>
    
    <xsl:variable name="albpmLabel">
    <xsl:value-of select="./xpdl:Extensions/albpm:ALBPMExtensions/albpm:Localization/albpm:LocalizationLabels/albpm:LocalizedLabel[position() = 1]/@label"/>
   </xsl:variable>
   <xsl:variable name="to">
    <xsl:value-of select="@To"/>
   </xsl:variable>
   <xsl:attribute name="Name">
        <xsl:choose>
            <!--xsl:when test="ends-with(./@From , '_transition_event_compensation')">
                <xsl:variable name="from">
                    <xsl:value-of select="@From"/>
                </xsl:variable>
                <xsl:if test="//xpdl:Transitions/xpdl:Transition[@From = substring-before($from,'_transition_event_compensation') and @To = $to and albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name = 'albpmType' and @value = 'COMPENSATE']]
                /albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name = 'userName']/@value">
                    <xsl:value-of select="//xpdl:Transitions/xpdl:Transition[@From = substring-before($from,'_transition_event_compensation') and @To = $to and albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name = 'albpmType' and @value = 'COMPENSATE']]
                /albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name = 'userName']/@value"/>
                </xsl:if>
            </xsl:when>
            <xsl:when test="ends-with(./@From , '_transition_event_due_timer')">
                <xsl:variable name="from">
                    <xsl:value-of select="@From"/>
                </xsl:variable>
                <xsl:if test="//xpdl:Transitions/xpdl:Transition[@From = substring-before($from,'_transition_event_due_timer') and @To = $to and albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name = 'albpmType' and @value = 'DUE']]
                /albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name = 'userName']/@value">
                    <xsl:value-of select="//xpdl:Transitions/xpdl:Transition[@From = substring-before($from,'_transition_event_due_timer') and @To = $to and albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name = 'albpmType' and @value = 'DUE']]
                /albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name = 'userName']/@value"/>
                </xsl:if>
            </xsl:when-->
            <xsl:when test="$albpmLabel and $albpmLabel != ''"> 
                <xsl:value-of select="$albpmLabel"/>
            </xsl:when>
            <xsl:when test="./albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='userName']/@value != ''">
                <xsl:value-of select="./albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='userName']/@value"/>
            </xsl:when>
            <xsl:when test="$albpmLabel = ''">
                <xsl:value-of select="$albpmLabel"/>
            </xsl:when>
        </xsl:choose>
        <xsl:value-of select="./xpdl:Extensions/albpm:ALBPMExtensions/albpm:Localization/albpm:LocalizationLabels/albpm:LocalizedLabel[position() = 1]/@label"/>
   </xsl:attribute>
   
    <xsl:attribute name="From">
        <!--if transition is of EXCEPTION type then change from attribute to errorEvent name -->
        <xsl:choose>
            <xsl:when test="child::xpdl:Condition[@Type = 'EXCEPTION']">
                <!--if name of errorEvent is not found in albpmExtensions then set default name as a combination of strings 'error' and From activity name-->
                <xsl:choose>
                    <xsl:when test="@From = 'ProcessGroup'">
                        <xsl:value-of select="@From"/>
                    </xsl:when>
                    <xsl:when test="./albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='userName']/@value != ''">
                        <xsl:value-of select="./albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='userName']/@value"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="concat('error' , @From)"/> 
                    </xsl:otherwise>
                </xsl:choose>                
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="@From"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:attribute>
    

    <!--include default attribute type 'OTHERWISE' if atleast one condition flow is emerging out from same source
        in other words include <xpdl:Condition type='OTHERWISE'/> element if atleast one condition type flow is passing out from same source 
        logic: check if transition is of unconditional type, if yes, check if any other flow is passing out from same source, if yes,
        check if that flow is of CONDITION type, if yes, include  <xpdl:Condition type='OTHERWISE'/> element.
    -->
    <xsl:if test = "child::albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='albpmType']/@value='UNCONDITIONAL'">
        <xsl:variable name = "currentSource">
            <xsl:value-of select = "@From"/>
        </xsl:variable>
        <xsl:variable name="hasSiblingConditionFlow">
            <xsl:if test="ancestor::xpdl:Transitions/xpdl:Transition[@From = $currentSource]/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='albpmType']/@value='CONDITIONAL'">
                <xsl:text>true</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:if test="$hasSiblingConditionFlow = 'true'">
            <xpdl:Condition Type = "OTHERWISE"/>
        </xsl:if>
    </xsl:if>
    <!--if transition is of EXCEPTION type then remove Condition element-->
    <xsl:choose>
        <xsl:when test="child::xpdl:Condition[@Type = 'EXCEPTION']">
            <xsl:apply-templates select="node()[local-name() != 'Condition']"/>
        </xsl:when>
        <xsl:otherwise>
            <xsl:apply-templates/>
        </xsl:otherwise>
    </xsl:choose>
    
   </xsl:copy>
  </xsl:if>
 </xsl:template>
 <!--	Ignore all elements defined in albpm namespace (ALBPM) 
            TODO: This leaves behind the contents of the <albpm:Component> element
        -->
 <!-- TODO: Causes problems       
	<xsl:template match="//albpm:*">
		<xsl:apply-templates select="node()" />
	</xsl:template>
-->
 
 <!--making lane ids unique by adding x-coordinate to lane id-->
 <xsl:template match = "xpdl:Lane">
    <xsl:copy>
        <xsl:copy-of select="@*[name() != 'Id']"/>
        <xsl:attribute name="Id">
            <xsl:value-of select="concat(@Id, child::xpdl:NodeGraphicsInfos/xpdl:NodeGraphicsInfo/xpdl:Coordinates/@XCoordinate)"/>
        </xsl:attribute>
        <xsl:apply-templates/>
    </xsl:copy>
 </xsl:template>
 
 <!--swaping coordinates of Lanes if orientation is horizontal-->
 <xsl:template match="xpdl:Lane/xpdl:NodeGraphicsInfos/xpdl:NodeGraphicsInfo/xpdl:Coordinates">
  <xsl:copy>
   <xsl:choose>
    <xsl:when test="$SWAP_LAYOUT = 'true'">
     <xsl:attribute name="XCoordinate">
      <xsl:value-of select="@YCoordinate"/>
     </xsl:attribute>
     <xsl:attribute name="YCoordinate">
      <xsl:value-of select="@XCoordinate"/>
     </xsl:attribute>
    </xsl:when>
    <xsl:otherwise>
     <xsl:copy-of select="@*"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:copy>
 </xsl:template>
 
 
 <!--
		Ignore Coordinates elements of connectors (ALBPM)
-->
 <xsl:template match="xpdl:ConnectorGraphicsInfo">
  <xsl:if test="not(@ToolId = '$ALBPM_TOOL_ID')">
   <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
   </xsl:copy>
  </xsl:if>
 </xsl:template>
 
 
 <!-- Copy AlBPM label attribute to Name attribute (NOT WORKING) -->
 <xsl:template match="xpdl:WorkflowProcess|xpdl:Transition">
  <xsl:copy>
   <xsl:copy-of select="@*[name() != 'XCoordinate' and name() != 'YCoordinate']"/>
   <xsl:variable name="albpmLabel">
    <xsl:value-of select="./xpdl:Extensions/albpm:ALBPMExtensions/albpm:Localization/albpm:LocalizationLabels/albpm:LocalizedLabel[position() = 1]/@label"/>
   </xsl:variable>
   <xsl:attribute name="Name">
      <xsl:choose>                        
        <xsl:when test="$albpmLabel and $albpmLabel != ''">
            <xsl:value-of select = "$albpmLabel"/>
        </xsl:when>                        
        <!--if name not found in albpm extensions then copy it's own name value-->
        <xsl:otherwise>
            <xsl:value-of select="@Name"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
   <xsl:apply-templates select="node()"/>
  </xsl:copy>
 </xsl:template>
 
 
 <!--
	Fixes NodeGraphicsInfo elements, mainly Width and Height 
        setting width of Lanes to same value so that all lanes will have same width if orientation is horizontal
        and setting height of Lanes to same value so that all lanes will have same height if orientation is vertical        
        Here maximum Y coordinate value of all activities is found out  and then this value is set to all lanes, depending on orientation.
-->
 <xsl:template match="xpdl:Lanes/xpdl:Lane/xpdl:NodeGraphicsInfos/xpdl:NodeGraphicsInfo">
  <!-- TODO: remove maxY content as lane height or width is set to 0  -->
  <xsl:variable name="maxY">
   <!--xsl:for-each select="//xpdl:Activity[xpdl:Extensions/albpm:ALBPMExtensions/albpm:Localization/albpm:LocalizationLabels/albpm:LocalizedLabel[@ label!='Process Exceptions']]/xpdl:NodeGraphicsInfos/xpdl:NodeGraphicsInfo/xpdl:Coordinates/@YCoordinate"-->
   <xsl:for-each select = "//xpdl:Activity/xpdl:NodeGraphicsInfos/xpdl:NodeGraphicsInfo[@IsVisible != 'false']/xpdl:Coordinates/@YCoordinate">
    <xsl:sort data-type="number" order="descending"/>
    <xsl:if test="position()=1">
     <xsl:value-of select="."/>
    </xsl:if>
   </xsl:for-each>
  </xsl:variable>
  <xsl:copy>
   <xsl:copy-of select="@*[name() != 'Height' and name() != 'Width' and name() != 'ExpandedHeight' and name() != 'ExpandedWidth']"/>
   <xsl:choose>
    <xsl:when test="$SWAP_LAYOUT = 'true'">
     <xsl:attribute name="Height">
      <xsl:value-of select="@Width"/>
     </xsl:attribute>
     <xsl:attribute name="Width">
      <!--xsl:value-of select="number($maxY)+number(100)"/-->
      <xsl:text> 0 </xsl:text>
     </xsl:attribute>
    </xsl:when>
    <xsl:otherwise>
     <xsl:attribute name="Height">
      <!--xsl:value-of select="number($maxY)+number(100)"/-->
      <xsl:text> 0 </xsl:text>
     </xsl:attribute>
     <xsl:attribute name="Width">
      <xsl:value-of select="@Width"/>
     </xsl:attribute>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:apply-templates/>
  </xsl:copy>
 </xsl:template>
 
 
 <!--setting 80x50 width,height to task and 30x30 to events, routes, and 50x50 to other activities-->
 <xsl:template match="xpdl:Activity/xpdl:NodeGraphicsInfos/xpdl:NodeGraphicsInfo">
  <xsl:param name="activityType">
  <xsl:variable name="activityId">
    <xsl:value-of select="ancestor::xpdl:Activity/@Id"/>
  </xsl:variable>
   <xsl:choose>
   <!--If events with attached intermediate events found then consider them as tasks-->
    <xsl:when test="ancestor::xpdl:Activity/xpdl:Implementation or 
                    ancestor::xpdl:Activity/xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name = 'type']/@value = 'DECISION' or
                    (ancestor::xpdl:Activity/xpdl:Event and //xpdl:Activity/xpdl:Event/xpdl:IntermediateEvent[@Target = $activityId])">
     <xsl:text>Task</xsl:text>
    </xsl:when>
    <xsl:when test="ancestor::xpdl:Activity/xpdl:Event">
     <xsl:text>Event</xsl:text>
    </xsl:when>
    <xsl:when test="ancestor::xpdl:Activity/xpdl:Route or (ancestor::xpdl:Activity/xpdl:TransitionRestrictions and 
                      ancestor::xpdl:Activity/xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name = 'type']/@value = 'JOIN')">
     <xsl:text>Route</xsl:text>
    </xsl:when>
    <xsl:when test="ancestor::xpdl:Activity/xpdl:BlockActivity">
        <xsl:choose>
            <xsl:when test="ancestor::xpdl:Activity/xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:BooleanFeature[@ name='collapsed']/@value!='true'">
                <xsl:text>ExpandedBlockActivity</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>CollapsedBlockActivity</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:when>
   </xsl:choose>
  </xsl:param>
<!--xsl:param name="activityWidth"-->
<!--xsl:param name="activityHeight"-->
  <xsl:copy>
   <xsl:copy-of select="@*[name() != 'Height' and name() != 'Width']"/>
   <xsl:attribute name="Height">  
    <xsl:variable name="value">
     <xsl:choose>

      <xsl:when test="$SWAP_LAYOUT = 'true'">
       <xsl:value-of select="@Width"/>
      </xsl:when>
      <xsl:when test="@Height">
       <xsl:value-of select="@Height"/>
      </xsl:when>
     </xsl:choose>
    </xsl:variable>    
    <xsl:choose>

    <!--copying raw xpdl width or height value if exists-->
     <xsl:when test="number($value)">
      <xsl:value-of select="$value"/>
     </xsl:when>
     
     <!--setting 40mm height to Task-->
     <xsl:when test="$activityType='Task' or $activityType='CollapsedBlockActivity'">
      <xsl:text>50</xsl:text><!--50-->           
     </xsl:when>

     <!--setting 20mm height to Event,Route-->
     <xsl:when test="$activityType='Event' or $activityType='Route'">
      <xsl:text>50</xsl:text><!--30-->
     </xsl:when>
     
     <!--setting 0 height to BlockActivity, Process in java again to set appropriate width-->
     <xsl:when test="$activityType='ExpandedBlockActivity'">
        <xsl:text>0</xsl:text>
     </xsl:when>
     
     <xsl:otherwise>
      <xsl:text>0</xsl:text>
     </xsl:otherwise>
    </xsl:choose>

   </xsl:attribute>
   <xsl:attribute name="Width">
      <xsl:variable name="value">
     <xsl:choose>
      <!-- TODO: May not apply to ALBPM -->
      <!--xsl:when test="@Expanded='true' and @ExpandedWidth">
							<xsl:value-of select="@ExpandedWidth"/>
						</xsl:when-->
      <xsl:when test="$SWAP_LAYOUT = 'true'">
       <xsl:value-of select="@Height"/>
      </xsl:when>
      <xsl:when test="@Width">
       <xsl:value-of select="@Width"/>
      </xsl:when>
     </xsl:choose>
    </xsl:variable>
    
    <xsl:choose>
    
     <xsl:when test="number($value)">
      <xsl:value-of select="$value"/>
     </xsl:when>
    
     <xsl:when test="$activityType='Task' or $activityType='CollapsedBlockActivity'">
      <xsl:text>80</xsl:text><!--40-->
     </xsl:when>
    
     <xsl:when test="$activityType='Event' or $activityType='Route'">
      <xsl:text>50</xsl:text><!--50-->
     </xsl:when>

    <xsl:when test="$activityType='ExpandedBlockActivity'">
     <xsl:text>0</xsl:text>
    </xsl:when>
    
     <xsl:otherwise>
      <xsl:text>0</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:attribute>

   <!--passing activityType parameter to coordinates template to move activities towards top left by half of their width,height-->
   <xsl:apply-templates>
    <xsl:with-param name="activityType" select="$activityType"/>
    <!--xsl:with-param name="activityWidth" select="$activityWidth"/>
    <xsl:with-param name="activityHeight" select="$activityHeight"/-->
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>
  <!--
		.Swap X-Y coordinates if process's orientation is horizontal (ALBPM)
                .placing timer,compensation Activities on Task elements
                .moving activities towards top-left by half of their width, height
                TODO:pass activityWidth,activityHeight from xpdl:Activity/xpdl:NodeGraphicsInfos/xpdl:NodeGraphicsInfo template
-->
 <xsl:template match="xpdl:Activity/xpdl:NodeGraphicsInfos/xpdl:NodeGraphicsInfo/xpdl:Coordinates">
  <xsl:param name="activityType"/>
  <!--xsl:param name="activityWidth"/>
  <xsl:param name="activityHeight"/-->
  <xsl:variable name="activityWidth">
   <xsl:choose>
    
    <xsl:when test="ancestor::xpdl:NodeGraphicsInfo/@Width">
     <xsl:value-of select="ancestor::xpdl:NodeGraphicsInfo/@Width"/>
    </xsl:when>
    
    <xsl:when test="$activityType='Task' or $activityType='CollapsedBlockActivity'">
     <xsl:text>80</xsl:text><!--80-->
    </xsl:when>
    
    <xsl:when test="$activityType='Event' or $activityType='Route'">
     <xsl:text>50</xsl:text><!--30-->
    </xsl:when>
    
    <xsl:when test="$activityType='ExpandedBlockActivity'">
        <xsl:text>0</xsl:text>
    </xsl:when>
    
    <xsl:otherwise><xsl:text>0</xsl:text></xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  
  <xsl:variable name="activityHeight">
   <xsl:choose>
   
    <xsl:when test="ancestor::xpdl:NodeGraphicsInfo/@Width">
     <xsl:value-of select="ancestor::xpdl:NodeGraphicsInfo/@Width"/>
    </xsl:when>
   
    <xsl:when test="$activityType='Event' or $activityType='Route'">
     <xsl:text>50</xsl:text><!--30-->
    </xsl:when>
   
    <xsl:when test="$activityType='Task' or $activityType='CollapsedBlockActivity'">
     <xsl:text>50</xsl:text><!--50-->
    </xsl:when>
   
    <xsl:when test="$activityType='ExpandedBlockActivity'">
        <xsl:text>0</xsl:text>
    </xsl:when>
   
    <xsl:otherwise><xsl:text>0</xsl:text></xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  
  <!--moving activities half of width, half of height towards top left corner-->
  <xsl:copy>
   <xsl:choose>
    <xsl:when test="$SWAP_LAYOUT = 'true'">
     <xsl:choose>
     
      <!--placing Timer Event on Activity if exists-->
      <xsl:when test="ancestor::xpdl:Activity/xpdl:Event/xpdl:IntermediateEvent[@Trigger='Timer']/@Target">
       <xsl:attribute name="XCoordinate">
        <xsl:value-of select="number(@YCoordinate)+80"/>
       </xsl:attribute>
       <xsl:attribute name="YCoordinate">
        <xsl:value-of select="number(@XCoordinate)+30 "/>
       </xsl:attribute>
      </xsl:when>
      
      <!--placing Compensation Event on Activity if exists-->
      <xsl:when test="ancestor::xpdl:Activity/xpdl:Event/xpdl:IntermediateEvent[@Trigger='Compensation']/@Target">
       <xsl:attribute name="XCoordinate">
        <xsl:value-of select="number(@YCoordinate)+40"/>
       </xsl:attribute>
       <xsl:attribute name="YCoordinate">
        <xsl:value-of select="number(@XCoordinate)+30 "/>
       </xsl:attribute>
      </xsl:when>
      
      <!--if activity is not timer or compensation then moving activity towards top left by half of their width, height-->
      <xsl:otherwise>
       <xsl:attribute name="XCoordinate">
        <xsl:value-of select="number(@YCoordinate) -($activityWidth div 2) "/>
       </xsl:attribute>
       <xsl:attribute name="YCoordinate">
        <xsl:value-of select="number(@XCoordinate) - ($activityHeight div 2) "/>
       </xsl:attribute>
       <!--xsl:attribute name="XCoordinate">
        <xsl:value-of select="number(@YCoordinate)"/>
       </xsl:attribute>
       <xsl:attribute name="YCoordinate">
        <xsl:value-of select="number(@XCoordinate)"/>
       </xsl:attribute-->
      </xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    
    <xsl:otherwise>
     <xsl:choose>
     
      <!--placing Timer Event on Activity if exists-->
      <xsl:when test="ancestor::xpdl:Activity/xpdl:Event/xpdl:IntermediateEvent[@Trigger='Timer']/@Target">
       <xsl:attribute name="XCoordinate">
        <xsl:value-of select="number(@XCoordinate)+30"/>
       </xsl:attribute>
       <xsl:attribute name="YCoordinate">
        <xsl:value-of select="number(@YCoordinate)+80 "/>
       </xsl:attribute>
      </xsl:when>
      
      <!--placing compensation Event to Activity if exists-->
      <xsl:when test="ancestor::xpdl:Activity/xpdl:Event/xpdl:IntermediateEvent[@Trigger='Compensation']/@Target">
       <xsl:attribute name="XCoordinate">
        <xsl:value-of select="number(@XCoordinate)+40"/>
       </xsl:attribute>
       <xsl:attribute name="YCoordinate">
        <xsl:value-of select="number(@YCoordinate)+30 "/>
       </xsl:attribute>
      </xsl:when>
      
      <!--if activity is not timer or compensation then moving activity towards top left by half of their width, height-->
      <xsl:otherwise>
       <xsl:attribute name="XCoordinate">
        <xsl:value-of select="number(@XCoordinate) - ($activityWidth div 2) "/>
       </xsl:attribute>
       <xsl:attribute name="YCoordinate">
        <xsl:value-of select="number(@YCoordinate) - ($activityHeight div 2) "/>
       </xsl:attribute>
       <!--xsl:attribute name="XCoordinate">
        <xsl:value-of select="number(@XCoordinate)"/>
       </xsl:attribute>
       <xsl:attribute name="YCoordinate">
        <xsl:value-of select="number(@YCoordinate)"/>
       </xsl:attribute--> 
      </xsl:otherwise>
     </xsl:choose>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:copy>
 </xsl:template>

 
</xsl:stylesheet>