<?xml version="1.0" encoding="windows-1252"?>
	<!--
		This transformation is applied to non-standard XPDL 2.1 documents in
		order to convert them into standard form as it is specified in XML
		schema for XPDL v2.1.
                
                Date        Who         Change
                =========   =========== ====================================================
                18-Aug-09   Jim Lange   Add case to add <Event> section for ALBM link events.
                19-Aug-09   Jim Lange   Supress <Implementation> tag for ALBM link events.
                                        Reorganize into ALBPM and BizAgi sections (to make it 
                                        easier to split into separate files later).
                
	-->
<!--if default namespace is there in raw xpdl then include
    xmlns:xpdl21="http://www.wfmc.org/2008/XPDL2.1" namespace in xsl:stylesheet element
    and refere elements which are under default namespace with xpdl21 namespace.
-->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"        
        xmlns:igxpdl="http://www.igrafx.com/2008/igrafx-xpdl2"
        xmlns:xpdl21="http://www.wfmc.org/2008/XPDL2.1">
       
	<xsl:output method="xml" indent="yes" />
	<!-- 
		General template - just copying everything as it is
	-->
	<xsl:template match="@*|node()">
		<xsl:copy>                    
                    <xsl:apply-templates select="@*[name()!='BorderColor' and name()!='FillColor']|node()" />
		</xsl:copy>
	</xsl:template>

        <!--xsl:template match="/*">
            <xsl:copy-->
                <!-- xsi,xsd namespace addition to document element using xsl 2.0-->
                <!--xsl:namespace name="xsi">
                    <xsl:value-of select="document('')/xsl:stylesheet/namespace::*[name()='xsi']"/>                
                </xsl:namespace>
                <xsl:namespace name="xsd">
                    <xsl:value-of select="document('')/xsl:stylesheet/namespace::*[name()='xsd']"/>
                </xsl:namespace-->
                <!--xsl:copy-of select="document('')/xsl:stylesheet/namespace::*[name()='xsi']"/>
                <xsl:copy-of select="document('')/xsl:stylesheet/namespace::*[name()='xsd']"/>
                <xsl:copy-of select="@*"/>
                <xsl:apply-templates select="@*|node()"/>
            </xsl:copy>
        </xsl:template-->


<!-- =========================================
     Coral Corporation rules
     =========================================
-->
        <xsl:template match="//xpdl21:Package">
            <xsl:copy>
                <xsl:copy-of select="@*"/>
                <xsl:if test="child::igxpdl:Pages">
                    <xsl:element name="Pages">
                        <xsl:for-each select="//igxpdl:Pages/igxpdl:Page">
                            <xsl:element name="Page">
                                <xsl:attribute name="Id">
                                    <xsl:value-of select="./@ID"/>
                                </xsl:attribute>
                                <xsl:attribute name="Name">
                                    <xsl:value-of select="./@Name"/>
                                </xsl:attribute>
                            </xsl:element>
                        </xsl:for-each>
                    </xsl:element>
                </xsl:if>
                <xsl:apply-templates/>
            </xsl:copy>
        </xsl:template>
<!-- ==============================================
     TIBCO Rules
     ==============================================
-->
        <!--xsl:template match="//xpdl2:NodeGraphicsInfo">
            <xsl:copy>
                <xsl:copy-of select="@*"/>
                <xsl:attribute name="rule">
                    <xsl:text>TIBCO Rules</xsl:text>
                </xsl:attribute>
                <xsl:apply-templates/>
            </xsl:copy>
        </xsl:template-->
        


<!-- ================================================
     ALBPM rules
     ================================================
-->     

	<!-- variable to swap coordinates for a horizontal ALBPM work-flow process -->
	<!--xsl:variable name="SWAP_LAYOUT"
		select="//xpdl:WorkflowProcess[position() = 1]/xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:BooleanFeature[@name = 'horizontal']/@value" />

        <xsl:template match="//xpdl:Pool">
                <xsl:copy>
                        <xsl:copy-of select="@*" />
                        <xsl:if test="$SWAP_LAYOUT = 'true'">
                            <xsl:attribute name="Orientation">
                                <xsl:text>HORIZONTAL</xsl:text>
                            </xsl:attribute>
                        </xsl:if>
                         <xsl:apply-templates />
                </xsl:copy>
        </xsl:template>
        
	<xsl:template match="//xpdl:Activity">
		<xsl:copy>
			<xsl:copy-of select="@*" /-->
                        <!-- copy albpm label to name attribute >
                        <xsl:attribute name = "Name">
                            <xsl:value-of select = "./xpdl:Extensions/albpm:ALBPMExtensions/albpm:Localization/albpm:LocalizationLabels/albpm:LocalizedLabel[@language='en']/@label" /> 
                        </xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="./xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature/@name = 'type' 
                                          and ./xpdl:Extensions/albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature/@value = 'CONNECTOR'">
                                    <xpdl:Event>
                                        <xpdl:IntermediateEvent Trigger="Link" />
                                    </xpdl:Event-->
                                <!-- exclude <implementation> tag -->                        
                                <!--xsl:apply-templates select="node()[local-name() != 'Implementation']" />
                            </xsl:when>     
                            <xsl:otherwise>
        			<xsl:apply-templates />
                            </xsl:otherwise>
                        </xsl:choose>
		</xsl:copy>
	</xsl:template-->

        <!-- Copy ALBPM UserName attribute to XPDL Name attribute
        >
	<xsl:template match="//xpdl:Transition">
		<xsl:copy>
			<xsl:copy-of select="@*" />
                        <xsl:attribute name = "Name">
                            <xsl:value-of select = "./albpm:ALBPMExtensions/albpm:FeatureSet/albpm:StringFeature[@name='userName']/@value" /> 
                        </xsl:attribute>
                        <xsl:apply-templates />
		</xsl:copy>
	</xsl:template-->

	<!--	Ignore all elements defined in albpm namespace (ALBPM) 
            TODO: This leaves behind the contents of the <albpm:Component> element
        -->
<!-- TODO: Causes problems       
	<xsl:template match="//albpm:*">
		<xsl:apply-templates select="node()" />
	</xsl:template>
-->
	<!--
		Swap X-Y coordinates if process's orientation is horizontal (ALBPM)
	-->
	<!--xsl:template match="xpdl:Coordinates">
		<xsl:copy>
			<xsl:choose>
				<xsl:when test="$SWAP_LAYOUT = 'true'">
					<xsl:attribute name="XCoordinate">
                                            <xsl:value-of select="@YCoordinate" />
                                        </xsl:attribute>
					<xsl:attribute name="YCoordinate">
                                            <xsl:value-of select="@XCoordinate" />
                                        </xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="@*" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:copy>
	</xsl:template-->

	<!--
		Ignore Coordinates elements of connectors (ALBPM)
	-->
	<!--xsl:template match="xpdl:ConnectorGraphicsInfo">
		<xsl:if test="not(@ToolId = '$ALBPM_TOOL_ID')">
			<xsl:copy>
				<xsl:apply-templates select="@*|node()" />
			</xsl:copy>
		</xsl:if>
	</xsl:template-->

        <!-- Copy AlBPM label attribute to Name attribute (NOT WORKING) -->
	<!--xsl:template
		match="xpdl:WorkflowProcess|xpdl:Activity|xpdl:Transition">
		<xsl:copy>
			<xsl:copy-of select="@*[name() != 'XCoordinate' and name() != 'YCoordinate']" />
			<xsl:variable name="albpmLabel">
				<xsl:value-of
					select="./xpdl:Extensions/albpm:ALBPMExtensions/albpm:Localization/albpm:LocalizationLabels/albpm:LocalizedLabel[position() = 1]/@label" />
			</xsl:variable>
			<xsl:attribute name="Name">
					<xsl:choose>
						<xsl:when test="$albpmLabel">
							<xsl:value-of select="$albpmLabel" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="@Name" />
						</xsl:otherwise>
					</xsl:choose>
                        </xsl:attribute>
			<xsl:apply-templates select="node()" />
		</xsl:copy>
	</xsl:template-->

	<!--
		Fixes NodeGraphicsInfo elements, mainly Width and Height
	-->
	<!--xsl:template match="xpdl:NodeGraphicsInfo">
		<xsl:copy>
			<xsl:copy-of
				select="@*[name() != 'Height' and name() != 'Width' and name() != 'ExpandedHeight' and name() != 'ExpandedWidth']" />
                        <xsl:attribute name="rule">
                            <xsl:text>In ALBPM rules</xsl:text>
                        </xsl:attribute>
			<xsl:attribute name="Height">
				<xsl:variable name="value">
					<xsl:choose-->
                                                <!-- TODO: May not apply to ALBPM -->
						<!--xsl:when test="@Expanded = 'true' and @ExpandedHeight">
							<xsl:value-of select="@ExpandedHeight" />
						</xsl:when>
						<xsl:when test="$SWAP_LAYOUT = 'true'">
							<xsl:value-of select="@Width" />
						</xsl:when>
						<xsl:when test="@Height">
							<xsl:value-of select="@Height" />
						</xsl:when>
					</xsl:choose>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="number($value) and number($value)!=''">
						<xsl:value-of select="$value" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>100.0</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:attribute name="Width">
				<xsl:variable name="value">
					<xsl:choose-->
                                                <!-- TODO: May not apply to ALBPM -->
						<!--xsl:when test="@Expanded='true' and @ExpandedWidth">
							<xsl:value-of select="@ExpandedWidth" />
						</xsl:when>
						<xsl:when test="$SWAP_LAYOUT = 'true'">
							<xsl:value-of select="@Height" />
						</xsl:when>
						<xsl:when test="@Width">
							<xsl:value-of select="@Width" />
						</xsl:when>
					</xsl:choose>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="number($value) and number($value)!=''">
						<xsl:value-of select="$value" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>100.0</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:apply-templates />
		</xsl:copy>
	</xsl:template-->

<!-- ================================================
     BizAgi rules
     ================================================
-->     

	<!--	Fixes IsForCompensation. Standard approach is to have it as
		'IsForCompensation' attribute (Bizagi)
	-->
	<!--xsl:template match="//xpdl21:Activity">
		<xsl:copy>
			<xsl:copy-of select="@*" />
			<xsl:if	test="not(@IsForCompensation) and (./xpdl21:IsForCompensationSpecified)">
				<xsl:attribute name="IsForCompensation">
					<xsl:value-of select="./xpdl21:IsForCompensationSpecified" />
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates
				select="@*|node()[local-name() != 'IsForCompensationSpecified']" />
		</xsl:copy>
	</xsl:template-->
      

	<!--
		Fixes expanded state of subprocess by setting standard View attribute
		(Bizagi)
	-->
    
	<!--xsl:template match="xpdl21:BlockActivity">
		<xsl:copy>
			<xsl:copy-of select="@*" />
			<xsl:if test="not(@View)">
				<xsl:choose>
					<xsl:when
						test="../xpdl21:NodeGraphicsInfos/xpdl21:NodeGraphicsInfo/@Expanded = 'true'">
						<xsl:attribute name="View">EXPANDED</xsl:attribute>
					</xsl:when>
					<xsl:when
						test="../xpdl21:NodeGraphicsInfos/xpdl21:NodeGraphicsInfo/@Expanded = 'false'">
						<xsl:attribute name="View">COLLAPSED</xsl:attribute>
					</xsl:when>
				</xsl:choose>
			</xsl:if>
			<xsl:apply-templates />
		</xsl:copy>
	</xsl:template-->
    
	<!--
		Fixes NodeGraphicsInfo elements, mainly Width and Height
	-->

	<!--xsl:template match="xpdl21:NodeGraphicsInfo">
		<xsl:copy>
			<xsl:copy-of
				select="@*[name() != 'Height' and name() != 'Width' and name() != 'ExpandedHeight' and name() != 'ExpandedWidth']" />
                        <xsl:attribute name="rule">
                            <xsl:text>In BizAgi Rules</xsl:text>
                        </xsl:attribute>
			<xsl:attribute name="Height">
                                <xsl:choose>
                                        <xsl:when test="@Expanded = 'true' and @ExpandedHeight">
                                                <xsl:value-of select="@ExpandedHeight" />
                                        </xsl:when>
                                        <xsl:when test="@Height">
                                                <xsl:value-of select="@Height" />
                                        </xsl:when>
                                </xsl:choose>
			</xsl:attribute>
			<xsl:attribute name="Width">
                                <xsl:choose>
                                        <xsl:when test="@Expanded='true' and @ExpandedWidth">
                                                <xsl:value-of select="@ExpandedWidth" />
                                        </xsl:when>
                                        <xsl:when test="@Width">
                                                <xsl:value-of select="@Width" />
                                        </xsl:when>
                                </xsl:choose>
			</xsl:attribute>
			<xsl:apply-templates />
		</xsl:copy>
	</xsl:template-->

	<!--
		Makes lane's relative coordinates absolute (Bizagi) 
	-->

	<!--xsl:template match="xpdl21:Lane/xpdl21:NodeGraphicsInfos/xpdl21:NodeGraphicsInfo/xpdl21:Coordinates">
		<xsl:copy>
			<xsl:copy-of select="@*[name() != 'XCoordinate' and name() != 'YCoordinate']"/>
			
			<xsl:attribute name="XCoordinate">
                            <xsl:value-of 
                            select="@XCoordinate+ancestor::xpdl21:Pool/xpdl21:NodeGraphicsInfos/xpdl21:NodeGraphicsInfo/xpdl21:Coordinates/@XCoordinate"/>
                        </xsl:attribute>
			<xsl:attribute name="YCoordinate">
                            <xsl:value-of 
                            select="@YCoordinate+ancestor::xpdl21:Pool/xpdl21:NodeGraphicsInfos/xpdl21:NodeGraphicsInfo/xpdl21:Coordinates/@YCoordinate"/>
                        </xsl:attribute>
		</xsl:copy>
	</xsl:template-->
        <!-- previous code
        <xsl:template
		match="xpdl21:Lane/xpdl21:NodeGraphicsInfos/xpdl21:NodeGraphicsInfo[@ToolId='$BIZAGI_TOOL_ID']/xpdl21:Coordinates">
		<xsl:copy>
			<xsl:copy-of
				select="@*[name() != 'XCoordinate' and name() != 'YCoordinate']" />
			<xsl:attribute name="XCoordinate">
				<xsl:value-of
				select="./@XCoordinate + ../../../../../xpdl21:NodeGraphicsInfos/xpdl21:NodeGraphicsInfo[@ToolId='$BIZAGI_TOOL_ID']/xpdl21:Coordinates/@XCoordinate" />
			</xsl:attribute>
			<xsl:attribute name="YCoordinate">
				<xsl:value-of
				select="./@YCoordinate + ../../../../../xpdl21:NodeGraphicsInfos/xpdl21:NodeGraphicsInfo[@ToolId='$BIZAGI_TOOL_ID']/xpdl21:Coordinates/@YCoordinate" />
			</xsl:attribute>
		</xsl:copy>
	</xsl:template>
        -->


</xsl:stylesheet>
