<?xml version="1.0" encoding="UTF-8"?>
<!--
		This transformation is applied to non-standard XPDL 2.1 documents in
		order to convert them into standard form as it is specified in XML
		schema for XPDL v2.1.
                
                Date        Who         Change
                =========   =========== ====================================================
                18-Aug-09   Jim Lange   Add case to add <Event> section for ALBM link events.
                19-Aug-09   Jim Lange   Supress <Implementation> tag for ALBM link events.
                                        Reorganize into ALBPM and BizAgi sections (to make it 
                                        easier to split into separate files later).
                
	-->
<xsl:stylesheet version="1.0" 
                                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                                xmlns:xpdl21="http://www.wfmc.org/2008/XPDL2.1" 
                                xmlns:xpdl="http://www.wfmc.org/2004/XPDL2.0alpha" 
                                xmlns:albpm="http://www.albpm.com/2007/albpm.XPDL2">
	<xsl:output method="xml" indent="yes"/>
	<!-- 
		Constants for recognized ToolIds
                TODO: Seems like these should be variables
	-->
	<!--xsl:param name="ALBPM_TOOL_ID" select="'ALBPM'"/>
	<xsl:param name="BIZAGI_TOOL_ID" select="'BizAgi_Process_Modeler'"/-->
	<!-- 
		General template - just copying everything as it is
	-->
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="//xpdl21:Activity">
		<xsl:copy>
			<xsl:copy-of select="@*" />
			<xsl:if	test="not(@IsForCompensation) and (./xpdl21:IsForCompensationSpecified)">
				<xsl:attribute name="IsForCompensation">
					<xsl:value-of select="./xpdl21:IsForCompensationSpecified" />
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates
				select="@*|node()[local-name() != 'IsForCompensationSpecified']" />
		</xsl:copy>
	</xsl:template>
        
        <!--
            Adding element ExtendedAttribute name="isRelativeCoordinates" 
        -->
        <xsl:template match="xpdl21:Package/xpdl21:ExtendedAttributes">
            <xsl:copy>
                <xsl:copy-of select="@*"/>
                <!--xsl:attribute name="Naveen"><xsl:text>Kumar</xsl:text></xsl:attribute-->
                <xpdl21:ExtendedAttribute Name="isRelativeObjectCoordinates" Value="true"/>
                <xsl:apply-templates/>                                
            </xsl:copy>
        </xsl:template>
        <xsl:template match="xpdl21:Package">
            <xsl:copy>
                <xsl:copy-of select="@*"/>
                <xsl:if test="not(child::xpdl21:ExtendedAttributes)">
                    <xpdl21:ExtendedAttributes>
                        <xpdl21:ExtendedAttribute Name="isRelativeObjectCoordinates" Value="true"/>
                    </xpdl21:ExtendedAttributes>
                </xsl:if>
                <xsl:apply-templates/>
            </xsl:copy>            
        </xsl:template>
	
        <!--adding view attribute on Subflow element-->
        <xsl:template match="xpdl21:SubFlow">
            <xsl:copy>
                <xsl:copy-of select="@*"/>
                <xsl:attribute name="View">
                    <xsl:choose>
                        <xsl:when test="ancestor::xpdl21:Activity/xpdl21:NodeGraphicsInfos/xpdl21:NodeGraphicsInfo/@Expanded='false'">
                            <xsl:text>COLLAPSED</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text>EXPANDED</xsl:text>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
            </xsl:copy>
        </xsl:template>
        
        <!--
		Fixes expanded state of subprocess by setting standard View attribute
		(Bizagi)
	-->
	
	<xsl:template match="xpdl21:BlockActivity">
		<xsl:copy>
			<xsl:copy-of select="@*" />
			<xsl:if test="not(@View)">
				<xsl:choose>
					<xsl:when
						test="../xpdl21:NodeGraphicsInfos/xpdl21:NodeGraphicsInfo/@Expanded = 'true'">
						<xsl:attribute name="View">EXPANDED</xsl:attribute>
					</xsl:when>
					<xsl:when
						test="../xpdl21:NodeGraphicsInfos/xpdl21:NodeGraphicsInfo/@Expanded = 'false'">
						<xsl:attribute name="View">COLLAPSED</xsl:attribute>
					</xsl:when>
				</xsl:choose>
			</xsl:if>
			<xsl:apply-templates />
		</xsl:copy>
	</xsl:template>
	<!--
		Fixes NodeGraphicsInfo elements, mainly Width and Height
	-->
	
	<xsl:template match="xpdl21:NodeGraphicsInfo">
		<xsl:copy>
			<xsl:copy-of
				select="@*[name() != 'Height' and name() != 'Width' and name() != 'ExpandedHeight' and name() != 'ExpandedWidth']" />
			<xsl:attribute name="Height">
                                <xsl:choose>
                                        <xsl:when test="@Expanded = 'true' and @ExpandedHeight">
                                                <xsl:value-of select="@ExpandedHeight" />
                                        </xsl:when>
                                        <xsl:when test="@Height">
                                                <xsl:value-of select="@Height" />
                                        </xsl:when>
                                </xsl:choose>
			</xsl:attribute>
			<xsl:attribute name="Width">
                                <xsl:choose>
                                        <xsl:when test="@Expanded='true' and @ExpandedWidth">
                                                <xsl:value-of select="@ExpandedWidth" />
                                        </xsl:when>
                                        <xsl:when test="@Width">
                                                <xsl:value-of select="@Width" />
                                        </xsl:when>
                                </xsl:choose>
			</xsl:attribute>
			<xsl:apply-templates />
		</xsl:copy>
	</xsl:template>
	<!--
		Makes lane's relative coordinates absolute (Bizagi) 
	-->
	
	<!--xsl:template match="xpdl21:Lane/xpdl21:NodeGraphicsInfos/xpdl21:NodeGraphicsInfo/xpdl21:Coordinates">
		<xsl:copy>
			<xsl:copy-of select="@*[name() != 'XCoordinate' and name() != 'YCoordinate']"/>
			
			<xsl:attribute name="XCoordinate">
                            <xsl:value-of 
                            select="@XCoordinate+ancestor::xpdl21:Pool/xpdl21:NodeGraphicsInfos/xpdl21:NodeGraphicsInfo/xpdl21:Coordinates/@XCoordinate"/>
                        </xsl:attribute>
			<xsl:attribute name="YCoordinate">
                            <xsl:value-of 
                            select="@YCoordinate+ancestor::xpdl21:Pool/xpdl21:NodeGraphicsInfos/xpdl21:NodeGraphicsInfo/xpdl21:Coordinates/@YCoordinate"/>
                        </xsl:attribute>
		</xsl:copy>
	</xsl:template-->
	<!-- previous code
        <xsl:template
		match="xpdl21:Lane/xpdl21:NodeGraphicsInfos/xpdl21:NodeGraphicsInfo[@ToolId='$BIZAGI_TOOL_ID']/xpdl21:Coordinates">
		<xsl:copy>
			<xsl:copy-of
				select="@*[name() != 'XCoordinate' and name() != 'YCoordinate']" />
			<xsl:attribute name="XCoordinate">
				<xsl:value-of
				select="./@XCoordinate + ../../../../../xpdl21:NodeGraphicsInfos/xpdl21:NodeGraphicsInfo[@ToolId='$BIZAGI_TOOL_ID']/xpdl21:Coordinates/@XCoordinate" />
			</xsl:attribute>
			<xsl:attribute name="YCoordinate">
				<xsl:value-of
				select="./@YCoordinate + ../../../../../xpdl21:NodeGraphicsInfos/xpdl21:NodeGraphicsInfo[@ToolId='$BIZAGI_TOOL_ID']/xpdl21:Coordinates/@YCoordinate" />
			</xsl:attribute>
		</xsl:copy>
	</xsl:template>
       -->
</xsl:stylesheet>
