<?xml version='1.0' ?>
<!--
    $Id: xdoc2html.xsl 98760 2009-06-01 21:02:56Z diegor $
-->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lxslt="http://xml.apache.org/xslt"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    xmlns:date="http://exslt.org/dates-and-times"
    xmlns:resources="xalan://oracle.bpm.designer.reports.XSLHelper"
    extension-element-prefixes="redirect date resources">

    <xsl:output method="html" indent="yes"/>
    <xsl:param name="version"/>
    <xsl:param name="buildNumber"/>
    <xsl:param name="resources-dir"/>
    <xsl:param name="resources-path"/>
    <xsl:param name="stylesheet">reports.css</xsl:param>

    <!-- ======================================================================================================== -->
    <!-- MAIN TEMPLATES - REPORTS AND NESTED FILE                                                                 -->
    <!-- ======================================================================================================== -->

    <xsl:template match="/report">
	<xsl:comment><xsl:value-of select="resources:get('MAIN_TITLE')"/></xsl:comment>
	<xsl:comment>
            <xsl:value-of select="resources:get('GENERATED_BY_FUEGO')"/>&#160; <xsl:value-of select="$version"/>&#160; (<xsl:value-of select="$buildNumber"/>)&#160; <xsl:value-of select="resources:get('ON')"/>&#160; <xsl:value-of select="date:date-time()"/>
        </xsl:comment>
	<xsl:comment><xsl:value-of select="resources:get('REPORT_OPTIONS')"/>&#160;<xsl:value-of select="@options"/></xsl:comment>
        <xsl:comment>xsl:template match="report"</xsl:comment>

	<HTML>
	    <HEAD>
		<TITLE>
		    <xsl:value-of select="/report/@title"/>
		</TITLE>
		<LINK TITLE="Style" HREF="{$resources-dir}/{$stylesheet}" TYPE="text/css" REL="stylesheet"/>

	    </HEAD>
	    <BODY>

                <table cellpadding="0" cellspacing="0" border="0" width="100%" background="{$resources-dir}/header.png">
			<tr>
			     <td>
				<img src="{$resources-dir}/studio-logo.png" width="224" height="45" vspace="2"/>
			     </td>
			     <td width="100%" class="header">
				<xsl:value-of select="/report/@title"/>
			     </td>
			     <td valign="top">
				<img src="{$resources-dir}/fuego-logo.png" width="76" height="16" hspace="4" vspace="6" align="right"/>
			     </td>
			</tr>
                </table>

		<center>
		    <xsl:apply-templates/>
		</center>

	    </BODY>
	</HTML>
    </xsl:template>

    <xsl:template name="generate-file">
	<xsl:comment><xsl:value-of select="resources:get('REPORT_HEADER_COMMENT')"/></xsl:comment>
	<xsl:comment>
            <xsl:value-of select="resources:get('GENERATED_BY_FUEGO')"/>&#160;<xsl:value-of select="$version"/>&#160;(<xsl:value-of select="$buildNumber"/>)&#160; <xsl:value-of select="resources:get('ON')"/>&#160; <xsl:value-of select="date:date-time()"/>
        </xsl:comment>
        <xsl:comment>xsl:template name="generate-file"</xsl:comment>

	<HTML>
	    <HEAD>
		<TITLE>
		    <xsl:value-of select="/report/@title"/>
		</TITLE>
                <LINK TITLE="Style" HREF="{$stylesheet}" TYPE="text/css" REL="stylesheet"/>
	    </HEAD>
	    <BODY>
                <table cellpadding="0" cellspacing="0" border="0" width="100%" background="header.png">
			<tr>
			     <td>
				<img src="studio-logo.png" width="224" height="45" vspace="2"/>
			     </td>
			     <td width="100%" class="header">
				<xsl:value-of select="/report/@title"/>
			     </td>
			     <td valign="top">
				<img src="fuego-logo.png" width="76" height="16" hspace="4" vspace="6" align="right"/>
			     </td>
			</tr>
                </table>

		<center>
		    <xsl:apply-templates select="."/>
		</center>
	    </BODY>
	</HTML>
    </xsl:template>

    <!-- ======================================================================================================== -->
    <!-- PROJECT TEMPLATES                                                                                        -->
    <!-- ======================================================================================================== -->

    <!-- Top Level component -->
    <xsl:template match="report/project">
        
        <xsl:comment>xsl:template match="report/project"</xsl:comment>
	<br/>
	<TABLE width="85%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
	    <TR>
		<TD colspan="2">
		     <div class="tabletitle">
			<img src="{$resources-dir}/process_group.gif" width="16" height="16" hspace="2" vspace="2" align="absmiddle"/>
			<xsl:value-of select="resources:get('PROCESSES')"/>
		     </div>
		</TD>
	    </TR>
	    <TR CLASS="tabletitle2">
		<TD CLASS="tabletitle2">&#160;<B><xsl:value-of select="resources:get('NAME')"/></B></TD>
		<TD CLASS="tabletitle2">&#160;<B><xsl:value-of select="resources:get('VARIATION')"/></B></TD>
	    </TR>
	    <xsl:for-each select="node">
		<xsl:call-template name="node">
		    <xsl:with-param name="parent-dir"></xsl:with-param>
		</xsl:call-template>
	    </xsl:for-each>
	</TABLE>
	<BR/>
    <xsl:if test="component/components/component">
        <TABLE width="85%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
            <TR>
            <TD colspan="2">
                 <div class="tabletitle">
                <img src="{$resources-dir}/component_group.gif" width="16" height="16" hspace="2" vspace="2" align="absmiddle"/>
                <xsl:value-of select="resources:get('COMPONENTS')"/>
                 </div>
            </TD>
            </TR>
            <TR CLASS="tabletitle2">
            <TD CLASS="tabletitle2">&#160;<B><xsl:value-of select="resources:get('NAME')"/></B></TD>
            <TD CLASS="tabletitle2">&#160;<B><xsl:value-of select="resources:get('TYPE')"/></B></TD>
            </TR>
            <!-- we skip the root node -->
            <xsl:for-each select="component/components/component">
            <TR CLASS="tablecell">
                <TD>&#160;
                      <img src="{$resources-dir}/component.gif" width="12" height="11" hspace="4"/>&#160;
                  <a href="{$resources-dir}/COMP-{@displayName}.html"><xsl:value-of select="@displayName"/></a>
                </TD>
                <TD>&#160;<xsl:value-of select="@type"/></TD>
            </TR>
            <redirect:write file="{$resources-path}/COMP-{@displayName}.html">
                <xsl:call-template name="generate-file"/>
            </redirect:write>
            </xsl:for-each>
        </TABLE>
    </xsl:if>
	<BR/>
    <xsl:if test="business-parameters">
        <xsl:call-template name="dataObjects">
            <xsl:with-param name="dataObject-list" select="business-parameters"/>
            <xsl:with-param name="VARIABLE_NAME" select="resources:get('BUSINESS_PARAMETER')"/>
            <xsl:with-param name="VARIABLES_NAME" select="resources:get('BUSINESS_PARAMETERS')"/>
            <xsl:with-param name="type" select="'parameter'"/>
        </xsl:call-template>
    </xsl:if>
    <xsl:if test="business-dataObjects">
        <xsl:call-template name="dataObjects">
            <xsl:with-param name="dataObject-list" select="business-dataObjects"/>
            <xsl:with-param name="VARIABLE_NAME" select="resources:get('BUSINESS_VARIABLE')"/>
            <xsl:with-param name="VARIABLES_NAME" select="resources:get('BUSINESS_VARIABLES')"/>
            <xsl:with-param name="type" select="'business'"/>
        </xsl:call-template>
    </xsl:if>
    <xsl:if test="external-dataObjects">
        <xsl:call-template name="dataObjects">
            <xsl:with-param name="dataObject-list" select="external-dataObjects"/>
            <xsl:with-param name="VARIABLE_NAME" select="resources:get('EXTERNAL_VARIABLE')"/>
            <xsl:with-param name="VARIABLES_NAME" select="resources:get('EXTERNAL_VARIABLES')"/>
            <xsl:with-param name="type" select="'external'"/>
        </xsl:call-template>
    </xsl:if>

    <xsl:if test="business-parameters">
        <xsl:call-template name="dataObjects-full">
            <xsl:with-param name="dataObject-list" select="business-parameters"/>
            <xsl:with-param name="VARIABLE_NAME" select="resources:get('BUSINESS_PARAMETER')"/>
            <xsl:with-param name="type" select="'parameter'"/>

        </xsl:call-template>
    </xsl:if>
    <xsl:if test="business-dataObjects">
        <xsl:call-template name="dataObjects-full">
            <xsl:with-param name="dataObject-list" select="business-dataObjects"/>
            <xsl:with-param name="VARIABLE_NAME" select="resources:get('BUSINESS_VARIABLE')"/>
            <xsl:with-param name="type" select="'business'"/>
        </xsl:call-template>
    </xsl:if>
    <xsl:if test="external-dataObjects">
        <xsl:call-template name="dataObjects-full">
            <xsl:with-param name="dataObject-list" select="external-dataObjects"/>
            <xsl:with-param name="VARIABLE_NAME" select="resources:get('EXTERNAL_VARIABLE')"/>
            <xsl:with-param name="type" select="'external'"/>
        </xsl:call-template>
    </xsl:if>

    </xsl:template>
    <xsl:template name="dataObjects">
        <xsl:param name="dataObject-list"/>
        <xsl:param name="VARIABLES_NAME"/>
        <xsl:param name="VARIABLE_NAME"/>
        <xsl:param name="VARIABLES_IMAGE" select="'variable_group.gif'"/>
        <xsl:param name="VARIABLE_IMAGE" select="'dataObject.gif'"/>
        <xsl:param name="type"/>
        <xsl:if test="$dataObject-list/dataObject" >
            <TABLE width="85%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
                <TR>
                <TD colspan="3">
                     <div class="tabletitle">
                    <img src="{$resources-dir}/{$VARIABLES_IMAGE}" width="16" height="16" hspace="2" vspace="2" align="absmiddle"/>
                    <xsl:value-of select="$VARIABLES_NAME"/>
                     </div>
                </TD>
                </TR>
                <TR CLASS="tabletitle2">
                <TD CLASS="tabletitle2">&#160;<B><xsl:value-of select="$VARIABLE_NAME"/></B></TD>
                <xsl:if test="$type != 'parameter'">
                    <TD CLASS="tabletitle2">&#160;<B><xsl:value-of select="resources:get('NAME')"/></B></TD>
                </xsl:if>
                <TD CLASS="tabletitle2">&#160;<B><xsl:value-of select="resources:get('TYPE')"/></B></TD>
                </TR>
                <xsl:for-each select="$dataObject-list/dataObject">
                <TR CLASS="tablecell">
                    <TD>&#160;<img src="{$resources-dir}/{$VARIABLE_IMAGE}" width="13" height="13"/>&#160;
                        <A HREF="#{$type}-{@id}"> <xsl:value-of select="@id"/>
                        </A>
                        </TD>
                    <xsl:if test="$type != 'parameter'">
                        <TD>&#160;<xsl:value-of select="@name"/></TD>
                    </xsl:if>
                    <TD>&#160;
                    <xsl:if test="@type-link">
                        <A HREF="{$resources-path}/COMP-{@type-link}.html"><xsl:value-of select="@type-link"/></A>
                    </xsl:if>
                    <xsl:if test="@type">
                        <xsl:value-of select="@type"/>
                    </xsl:if>
                    </TD>
                </TR>
                </xsl:for-each>
            </TABLE>
            <BR/>
        </xsl:if>
    </xsl:template>

    <xsl:template name="dataObjects-full">
        <xsl:param name="dataObject-list"/>
        <xsl:param name="VARIABLE_NAME"/>
        <xsl:param name="type"/>
	    <BR/>
	    <HR/>
	    <BR/>
	    <xsl:for-each select="$dataObject-list/dataObject">
		<A NAME="{$type}-{@id}"/>
		<TABLE width="80%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
		    <TR>
			<TD CLASS="tabletitle" WIDTH="25%"><IMG SRC="{$resources-dir}/select.gif"/><B><xsl:value-of select="$VARIABLE_NAME"/>:</B></TD>
			<TD CLASS="tabletitle" WIDTH="75%"><B><xsl:value-of select="@id"/></B></TD>
		    </TR>
		    <TR class="tablecell">
			<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('TYPE')"/>:</TD>
			<TD COLSPAN="2">
                <xsl:if test="@type-link">
                    <A HREF="{$resources-path}/COMP-{@type-link}.html"><xsl:value-of select="@type-link"/></A>
                </xsl:if>
                <xsl:if test="@type">
                    <xsl:value-of select="@type"/>
                </xsl:if>
                &#160;</TD>
		    </TR>
            <xsl:if test="@business-dataObject-type">
                <TR class="tablecell">
                <TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('VARIABLE_TYPE')"/>:</TD>
                <TD COLSPAN="2"><xsl:value-of select="@business-dataObject-type"/>&#160;</TD>
                </TR>
            </xsl:if>

            <xsl:if test="@parameter-default-value">
                <TR class="tablecell">
                <TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('DEFAULT_VALUE')"/>:</TD>
                <TD COLSPAN="2"><xsl:value-of select="@parameter-default-value"/>&#160;</TD>
                </TR>
            </xsl:if>
		</TABLE>
        <BR/>
        <xsl:if test="value">
            <TABLE width="70%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
                <TR>
                <TD colspan="3">
                     <div class="tabletitle">
                        <xsl:value-of select="resources:get('VALUES')"/>
                     </div>
                </TD>
                </TR>
                <TR CLASS="tabletitle2">
                    <TD CLASS="tabletitle2"><xsl:value-of select="resources:get('OU')"/>&#160;</TD>
                    <TD CLASS="tabletitle2"><xsl:value-of select="resources:get('VALUE')"/>&#160;</TD>
                </TR>
                <xsl:for-each select="value">
                    <TR class="tablecell">
                        <TD><xsl:value-of select="@ou"/>&#160;</TD>
                        <TD><xsl:value-of select="@value"/>&#160;</TD>
                    </TR>
                </xsl:for-each>
            </TABLE>
            <BR/>
        </xsl:if>
        <xsl:if test="business-dataObject-range">
            <TABLE width="70%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
                <TR>
                <TD colspan="2">
                     <div class="tabletitle">
                        <xsl:value-of select="resources:get('RANGES')"/>
                     </div>
                </TD>
                </TR>
                <TR CLASS="tabletitle2">
                    <TD><b><xsl:value-of select="resources:get('NAME')"/>&#160;</b></TD>
                    <TD><b><xsl:value-of select="resources:get('START')"/>&#160;</b></TD>
                    <TD><b><xsl:value-of select="resources:get('FINISH')"/>&#160;</b></TD>
                </TR>
                <xsl:for-each select="business-dataObject-range">
                    <TR class="tablecell">
                    <TD><xsl:value-of select="@business-dataObject-range-name"/>&#160;</TD>
                    <TD><xsl:value-of select="@business-dataObject-range-start"/>&#160;</TD>
                    <TD><xsl:value-of select="@business-dataObject-range-finish"/>&#160;</TD>
                    </TR>
                </xsl:for-each>
            </TABLE>
            <BR/>
        </xsl:if>
	    </xsl:for-each>
    </xsl:template >


    <!-- ======================================================================================================== -->
    <!-- PROCESSES TEMPLATES                                                                                      -->
    <!-- ======================================================================================================== -->

    <!-- Top Level component -->
    <xsl:template match="report/process|report/screenflow|report/procedure|report/bpel">
	<xsl:call-template name="process">
	    <xsl:with-param name="base-dir" select="$resources-dir"/>
	</xsl:call-template>
    </xsl:template>

    <!-- Nested component -->
    <xsl:template match="node/process|node/screenflow|node/procedure|node/bpel">
	<xsl:call-template name="process">
	    <xsl:with-param name="base-dir">.</xsl:with-param>
	</xsl:call-template>
    </xsl:template>

    <xsl:template name="process-index">
	<xsl:call-template name="process"/>

<!--	<TABLE WIDTH="90%" BORDER="0" CELLSPACING="1" CELLPADDING="1">-->
<!--	    <TR><TD>-->
<!--		<BR/><FONT FACE="Verdana, Arial, Helvetica, sans-serif" SIZE="3" COLOR="#595986"><B>Contents</B></FONT>-->
<!--	    </TD></TR>-->
<!--	    <TR><TD>-->
<!--		<xsl:call-template name="process-info-index"/>-->
<!--		<xsl:apply-templates select="roles" mode="toc"/>-->
<!--		<xsl:apply-templates select="activities" mode="toc"/>-->
<!--		<xsl:apply-templates select="exceptions" mode="toc"/>-->
<!--		<xsl:apply-templates select="dataObjects" mode="toc"/>-->
<!--		<BR/>-->
<!--	    </TD></TR>-->
<!--	</TABLE>-->

    </xsl:template>

    <xsl:template name="node">
	<xsl:param name="parent-dir"/>
	<xsl:for-each select="process|procedure|screenflow|bpel">
	    <TR CLASS="tablecell">
		<TD>&#160;
		     <img src="{$resources-dir}/process.gif" width="12" height="11" hspace="4"/>&#160;
		     <A HREF="{$resources-dir}/{@id}.html"><xsl:value-of select="$parent-dir"/><xsl:value-of select="@displayName"/></A>
		</TD>
		<TD>&#160;<xsl:value-of select="@variation"/></TD>
	    </TR>
	    <redirect:write file="{$resources-path}/{@id}.html">
		<xsl:call-template name="generate-file"/>
	    </redirect:write>
	</xsl:for-each>
	<xsl:for-each select="node">
	    <xsl:call-template name="node">
		<xsl:with-param name="parent-dir"><xsl:value-of select="$parent-dir"/><xsl:value-of select="@name"/>/</xsl:with-param>
	    </xsl:call-template>
	</xsl:for-each>
    </xsl:template>

    <xsl:template name="process">
	<xsl:param name="base-dir"/>
	<!-- the process map -->
        <SCRIPT LANGUAGE="JavaScript"><xsl:text>
                    function MM_preloadImages() { //v3.0
                    var d=document; if(d.images){ if(!d.MM_p) d.MM_p=new Array();
                    var i,j=d.MM_p.length,a=MM_preloadImages.arguments; for(i=0; i&lt;a.length; i++)
                    if (a[i].indexOf("#")!=0){ d.MM_p[j]=new Image; d.MM_p[j++].src=a[i];}}
                    }

                    function MM_swapImgRestore() { //v3.0
                    var i,x,a=document.MM_sr; for(i=0;a&amp;&amp;i&lt;a.length&amp;&amp;(x=a[i])&amp;&amp;x.oSrc;i++) x.src=x.oSrc;
                    }

                    function MM_findObj(n, d) { //v3.0
                    var p,i,x;  if(!d) d=document; if((p=n.indexOf("?"))&gt;0&amp;&amp;parent.frames.length) {
                    d=parent.frames[n.substring(p+1)].document; n=n.substring(0,p);}
                    if(!(x=d[n])&amp;&amp;d.all) x=d.all[n]; for (i=0;!x&amp;&amp;i&lt;d.forms.length;i++) x=d.forms[i][n];
                    for(i=0;!x&amp;&amp;d.layers&amp;&amp;i&lt;d.layers.length;i++) x=MM_findObj(n,d.layers[i].document); return x;
                    }

                    function MM_swapImage() { //v3.0
                    var i,j=0,x,a=MM_swapImage.arguments; document.MM_sr=new Array; for(i=0;i&lt;(a.length-2);i+=3)
                    if ((x=MM_findObj(a[i]))!=null){document.MM_sr[j++]=x; if(!x.oSrc) x.oSrc=x.src; x.src=a[i+2];}
                    }
                </xsl:text></SCRIPT>

	<MAP NAME="ProcessImageMap">
	    <xsl:for-each select="map/area">
		<xsl:if test="@referencedActivity">
		    <AREA SHAPE="rect" COORDS="{@coords}" HREF="#activity-{@referencedActivity}" ALT="{@referencedActivity}"/>
		</xsl:if>
		<xsl:if test="@referencedRole">
		    <AREA SHAPE="rect" COORDS="{@coords}" HREF="#role-{@referencedRole}" ALT="{@referencedRole}"/>
		</xsl:if>
	    </xsl:for-each>
	</MAP>

	<p class="txttitle"><xsl:value-of select="@displayName"/></p>
	<img src="${gif5x5}" width="1" height="5"/>
	<br/>
	<A NAME="process-image"><!-- --></A>
	<BR/>
	<TABLE CELLPADDING="1" CELLSPACING="0" BORDER="1"><TR><TD>
	<IMG SRC="{$base-dir}/{@id}.png" USEMAP="#ProcessImageMap" ALT="Process {@name} image"/>
	</TD></TR></TABLE>
	<BR/>
	<BR/>
	<A NAME="process-info"><!-- --></A>
	<BR/>

        <xsl:apply-templates select="roles" mode="toc">
            <xsl:with-param name="base-dir" select="$base-dir"/>
        </xsl:apply-templates>

        <xsl:apply-templates select="activities" mode="toc">
                        <xsl:with-param name="base-dir" select="$base-dir"/>
        </xsl:apply-templates>

        <xsl:apply-templates select="exceptions" mode="toc">
                        <xsl:with-param name="base-dir" select="$base-dir"/>
        </xsl:apply-templates>

        <xsl:apply-templates select="dataObjects" mode="toc">
                        <xsl:with-param name="base-dir" select="$base-dir"/>
        </xsl:apply-templates>

        <xsl:apply-templates select="methods" mode="toc">
                        <xsl:with-param name="base-dir" select="$base-dir"/>
        </xsl:apply-templates>

        <BR/>
	<TABLE width="90%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
	    <TR>
		<TD CLASS="tabletitle" WIDTH="15%"><B><xsl:value-of select="resources:get('PROCESS')"/>:</B></TD>
		<TD CLASS="tabletitle" WIDTH="80%"><B><xsl:value-of select="@name"/></B></TD>
		<TD CLASS="tabletitle" ALIGN="right"><IMG SRC="{$base-dir}/top.gif"/><A  CLASS="tabletitle" HREF="#process-info-index"><xsl:value-of select="resources:get('INDEX')"/></A></TD>
	    </TR>
	    <TR class="tablecell">
		<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('AUTHOR')"/>:</TD>
		<TD COLSPAN="2"><xsl:value-of select="@author"/>&#160;</TD>
	    </TR>
	    <TR class="tablecell">
		<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('DESCRIPTION')"/>:</TD>
		<TD COLSPAN="2"><xsl:value-of select="@description"/>&#160;</TD>
	    </TR>
	    <TR class="tablecell">
		<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('CREATION_DATE')"/>:</TD>
		<TD COLSPAN="2"><xsl:value-of select="@creationDate"/>&#160;</TD>
	    </TR>
	    <TR class="tablecell">
		<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('VARIATION')"/>:</TD>
		<TD COLSPAN="2"><xsl:value-of select="@variation"/>&#160;</TD>
	    </TR>
	    <TR class="tablecell">
		<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('GENERATE_EVENTS')"/>:</TD>
		<TD COLSPAN="2"><xsl:value-of select="@generateEvents"/>&#160;</TD>
	    </TR>
	</TABLE>
	<xsl:apply-templates select="documentation" mode="internal">
	    <xsl:with-param name="base-dir" select="$base-dir"/>
	</xsl:apply-templates>
	<xsl:apply-templates select="useCaseDoc" mode="internal">
	    <xsl:with-param name="base-dir" select="$base-dir"/>
	</xsl:apply-templates>
	<xsl:apply-templates select="roles" mode="internal">
	    <xsl:with-param name="base-dir" select="$base-dir"/>
	</xsl:apply-templates>
	<xsl:apply-templates select="activities" mode="internal">
	    <xsl:with-param name="base-dir" select="$base-dir"/>
	</xsl:apply-templates>
	<xsl:apply-templates select="exceptions" mode="internal">
	    <xsl:with-param name="base-dir" select="$base-dir"/>
	</xsl:apply-templates>
	<xsl:apply-templates select="methods" mode="internal">
	    <xsl:with-param name="base-dir" select="$base-dir"/>
	</xsl:apply-templates>
	<xsl:apply-templates select="dataObjects" mode="internal">
	    <xsl:with-param name="base-dir" select="$base-dir"/>
	</xsl:apply-templates>
    </xsl:template>

    <xsl:template match="roles" mode="internal">
	<xsl:param name="base-dir"/>
	    <BR/>
	    <HR/>
	    <BR/>
	    <xsl:for-each select="role">
		<A NAME="role-{@name}"/>
		<TABLE WIDTH="90%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
		    <TR>
			<TD CLASS="tabletitle" WIDTH="15%"><IMG SRC="{$base-dir}/select.gif"/><B><xsl:value-of select="resources:get('ROLE')"/>:</B></TD>
			<TD CLASS="tabletitle" WIDTH="80%"><B><xsl:value-of select="@name"/></B></TD>
			<TD CLASS="tabletitle" ALIGN="right"><IMG SRC="{$base-dir}/top.gif"/><A  CLASS="tabletitle" HREF="#roles-index"><xsl:value-of select="resources:get('INDEX')"/></A></TD>
		    </TR>
		    <TR class="tablecell">
			<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('DESCRIPTION')"/>:</TD>
			<TD COLSPAN="2"><xsl:value-of select="@description"/>&#160;</TD>
		    </TR>
		    <xsl:if test="@parametricValue">
			<TR class="tablecell">
			    <TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('PARAMETRIC_VALUE')"/>:</TD>
			    <TD COLSPAN="2"><xsl:value-of select="@parametricValue"/>
			    </TD>
			</TR>
		    </xsl:if>
		    <xsl:if test="activities">
			<TR class="tablecell">
			    <TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('ACTIVITIES')"/>:</TD>
			    <TD COLSPAN="2"><xsl:value-of select="@description"/>
			    <ul>
				<xsl:for-each select="activities/activity">
					<li><A HREF="#activity-{@name}"><xsl:value-of select="@name"/></A></li>
				</xsl:for-each>
			    </ul>
			    </TD>
			</TR>
		    </xsl:if>
		</TABLE>
		<BR/>
	    </xsl:for-each>
    </xsl:template>


    <xsl:template match="activities" mode="internal">
	<xsl:param name="base-dir"/>
	    <BR/>
	    <HR/>
	    <BR/>
	    <xsl:for-each select="activity">
		<A NAME="activity-{@name}"/>
		<TABLE width="90%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
		    <TR>
			<TD CLASS="tabletitle" WIDTH="15%"><IMG SRC="{$base-dir}/select.gif"/><B><xsl:value-of select="resources:get('ACTIVITY')"/>:</B></TD>
			<TD CLASS="tabletitle" WIDTH="80%"><B><xsl:value-of select="@name"/></B></TD>
			<TD CLASS="tabletitle" ALIGN="right"><IMG SRC="{$base-dir}/top.gif"/><A  CLASS="tabletitle" HREF="#activities-index"><xsl:value-of select="resources:get('INDEX')"/></A></TD>
		    </TR>
		    <TR class="tablecell">
			<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('DESCRIPTION')"/>:</TD>
			<TD COLSPAN="2"><xsl:value-of select="@description"/>&#160;</TD>
		    </TR>
		    <xsl:if test="@role">
			<TR class="tablecell">
			    <TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('ROLE')"/>:</TD>
			    <TD COLSPAN="2"><A HREF="#role-{@role}"><xsl:value-of select="@role"/></A>&#160;</TD>
			</TR>
		    </xsl:if>
		    <xsl:if test="@automaticrole">
			<TR class="tablecell">
			    <TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('ROLE')"/>:</TD>
			    <TD COLSPAN="2"> <xsl:value-of select="@automaticrole"/>&#160;</TD>
			</TR>
		    </xsl:if>
		    <TR class="tablecell">
			<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('TYPE')"/>:</TD>
			<TD COLSPAN="2"><xsl:value-of select="@type"/>&#160;</TD>
		    </TR>
		    <xsl:if test="properties">
			<TR>
			    <TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('PROPERTIES')"/>:</TD>
			    <TD COLSPAN="2">
				<TABLE CELLSPACING="1" CELLPADDING="1" border="0" width="100%">
				    <xsl:for-each select="properties/property">
                                        <TR class="tablecell">
                                            <TD width="50%">
                                                <b>
                                                    <xsl:value-of select="resources:getActivityProperty(@key)"/>&#160;
                                                </b>
                                            </TD>
                                            <TD>
                                                <xsl:choose>
                                                    <xsl:when test="@target-link">
                                                        <A HREF="{$base-dir}/{@target-link}.html">
                                                            <xsl:value-of select="@target-description"/>
                                                        </A>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <xsl:value-of select="resources:getPropertyDisplayValue(@key,@value)"/>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                                &#160;
                                            </TD>
                                        </TR>
				    </xsl:for-each>
				</TABLE>
			    </TD>
			</TR>
		    </xsl:if>
		</TABLE>
		<xsl:apply-templates select="documentation" mode="internal">
		    <xsl:with-param name="base-dir" select="$base-dir"/>
		</xsl:apply-templates>
		<xsl:apply-templates select="useCaseDoc" mode="internal">
		    <xsl:with-param name="base-dir" select="$base-dir"/>
		</xsl:apply-templates>

		<xsl:apply-templates select="transitions"/>
		<xsl:apply-templates select="mappings">
		    <xsl:with-param name="base-dir" select="$base-dir"/>
		</xsl:apply-templates>
		<xsl:apply-templates select="tasks">
		    <xsl:with-param name="base-dir" select="$base-dir"/>
		</xsl:apply-templates>

		<BR/>
	    </xsl:for-each>
    </xsl:template>

    <xsl:template match="transitions">
	<xsl:param name="base-dir"/>
	<TABLE width="90%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
	    <TR>
		<TD CLASS="tabletitle" colspan="5"><B><xsl:value-of select="resources:get('TRANSITIONS')"/></B></TD>
	    </TR>
	    <TR CLASS="tabletitle2">
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('NAME')"/></B></TD>
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('TO_ACTIVITY')"/></B></TD>
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('TYPE')"/></B></TD>
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('PROPERTIES')"/></B></TD>
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('DESCRIPTION')"/></B></TD>
	    </TR>
	    <xsl:for-each select="transition">
		<TR CLASS="tablecell">
                    <TD><xsl:value-of select="@name"/>&#160;</TD>
		    <TD><A HREF="#activity-{@toActivity}"><xsl:value-of select="@toActivity"/></A></TD>
		    <TD><xsl:value-of select="@type"/>&#160;</TD>
		    <TD><xsl:value-of select="@value"/>&#160;</TD>
		    <TD><xsl:value-of select="@description"/>&#160;</TD>
		</TR>
	    </xsl:for-each>
	</TABLE>
    </xsl:template>

    <xsl:template match="mappings">
	<xsl:param name="base-dir"/>
	<TABLE width="90%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
	    <TR>
		<TD CLASS="tabletitle" colspan="4"><B><xsl:value-of select="resources:get('ARGUMENT_MAPPINGS')"/></B></TD>
	    </TR>
	    <TR CLASS="tabletitle2">
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('NAME')"/></B></TD>
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('MAPPING')"/></B></TD>
	    </TR>
	    <xsl:for-each select="mapping">
		<TR CLASS="tablecell">
		    <TD><xsl:value-of select="@name"/>&#160;</TD>
		    <TD>
			<ul>
			<xsl:for-each select="mappingItem">
			    <li><xsl:value-of select="@name"/>&#160;=&#160;<xsl:value-of select="@mapFrom"/></li>
			</xsl:for-each>
			</ul>
		    </TD>
		</TR>
	    </xsl:for-each>
	</TABLE>
    </xsl:template>

    <xsl:template match="activity/tasks">
	<xsl:param name="base-dir"/>
	<TABLE width="90%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
	    <TR>
		<TD CLASS="tabletitle" colspan="4"><B><xsl:value-of select="resources:get('TASKS')"/></B></TD>
	    </TR>
	    <TR CLASS="tabletitle2">
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('NAME')"/></B></TD>
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('TYPE')"/></B></TD>
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('TARGET')"/></B></TD>
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('ARGUMENT_MAPPINGS')"/></B></TD>
	    </TR>
	    <xsl:for-each select="task">
		<TR CLASS="tablecell">
		    <TD><xsl:value-of select="@name"/>&#160;</TD>
		    <TD><xsl:value-of select="@type"/>&#160; </TD>
		    <TD>
			<xsl:if test="@target-link">
			    <A HREF="{$base-dir}/{@target-link}.html"><xsl:value-of select="@target-link"/></A>&#160;
			</xsl:if>
			<xsl:if test="@type-link">
			    <A HREF="{$base-dir}/COMP-{@type-link}.html"><xsl:value-of select="@type-link"/></A>&#160;
			</xsl:if>
			<xsl:if test="@target">
			    <xsl:value-of select="@target"/>&#160;
			</xsl:if>
		    </TD>
		    <TD>&#160;
			<xsl:apply-templates select="mappings">
			    <xsl:with-param name="base-dir" select="$base-dir"/>
			</xsl:apply-templates>
		    </TD>
		</TR>
	    </xsl:for-each>
	</TABLE>
    </xsl:template>

    <xsl:template match="exceptions">
	<xsl:param name="base-dir"/>
	    <BR/>
	    <HR/>
	    <BR/>
	    <xsl:for-each select="exception">
		<A NAME="exception-{@name}"><!-- --></A>
		<TABLE WIDTH="90%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
		    <TR>
			<TD CLASS="tabletitle" WIDTH="15%"><IMG SRC="{$base-dir}/select.gif"/><B><xsl:value-of select="resources:get('EXCEPTION')"/>:</B></TD>
			<TD CLASS="tabletitle" WIDTH="80%"><B><xsl:value-of select="@name"/></B></TD>
			<TD CLASS="tabletitle" ALIGN="right"><IMG SRC="{$base-dir}/top.gif"/><A  CLASS="tabletitle" HREF="#exceptions-index"><xsl:value-of select="resources:get('INDEX')"/></A></TD>
		    </TR>
		    <TR class="tablecell">
			<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('TARGET')"/>:</TD>
			<TD COLSPAN="2"><A HREF="#activity-{@target}"><xsl:value-of select="@target"/></A>&#160;</TD>
		    </TR>
		</TABLE>
		<BR/>
	    </xsl:for-each>
    </xsl:template>


    <xsl:template match="dataObjects" mode="internal">
	<xsl:param name="base-dir"/>
	    <BR/>
	    <HR/>
	    <BR/>
	    <xsl:for-each select="dataObject">
		<A NAME="dataObject-{@name}"><!-- --></A>
		<TABLE WIDTH="90%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
		    <TR>
			<TD CLASS="tabletitle" WIDTH="15%"><IMG SRC="{$base-dir}/select.gif"/><B><xsl:value-of select="resources:get('VARIABLE')"/>:</B></TD>
			<TD CLASS="tabletitle" WIDTH="80%"><B><xsl:value-of select="@name"/></B></TD>
			<TD CLASS="tabletitle" ALIGN="right"><IMG SRC="{$base-dir}/top.gif"/><A  CLASS="tabletitle" HREF="#dataObjects-index"><xsl:value-of select="resources:get('INDEX')"/></A></TD>
		    </TR>
		    <TR class="tablecell">
			<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('TYPE')"/>:</TD>
			<TD COLSPAN="2">
			    <xsl:if test="@type-link">
				<A HREF="{$base-dir}/COMP-{@type-link}.html"><xsl:value-of select="@type-link"/></A>&#160;
			    </xsl:if>
			    <xsl:if test="@type">
				<xsl:value-of select="@type"/>&#160;
			    </xsl:if>
			</TD>
		    </TR>
		    <TR class="tablecell">
			<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('DESCRIPTION')"/>:</TD>
			<TD COLSPAN="2"><xsl:value-of select="@description"/>&#160;</TD>
		    </TR>
		    <TR class="tablecell">
			<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('CATEGORY')"/>:</TD>
			<TD COLSPAN="2"><xsl:value-of select="@category"/>&#160;</TD>
		    </TR>
		</TABLE>
		<BR/>
	    </xsl:for-each>
    </xsl:template>


    <xsl:template match="process/methods|procedure/methods|screenflow/methods|bpel/methods" mode="internal">
	<xsl:param name="base-dir"/>
	<xsl:for-each select="method">
        <A NAME="method-{@name}"><!-- --></A>
	    <xsl:call-template name="method">
		<xsl:with-param name="base-dir" select="$base-dir"/>
	    </xsl:call-template>
	</xsl:for-each>
    </xsl:template>


    <xsl:template name="process-info-index">
	<xsl:param name="base-dir"/>
	<BR/>
	<A NAME="process-info-index"></A><IMG SRC="{$base-dir}/isito.gif" WIDTH="22" HEIGHT="20"/>
	<FONT FACE="Verdana, Arial, Helvetica, sans-serif" SIZE="3"><B><xsl:value-of select="resources:get('PROCESS')"/></B></FONT>
	<BR/>
	&#160;&#160;&#160;&#160;<FONT CLASS="TableRow"><A HREF="#process-image" onMouseOut="MM_swapImgRestore()" onMouseOver="MM_swapImage('Image1','','{$base-dir}/bullet1.gif',1)">
	    <IMG SRC="{$base-dir}bullet2.gif" WIDTH="13" HEIGHT="13" BORDER="0" NAME="Image1"/>
	    Image</A></FONT><BR/>
	&#160;&#160;&#160;&#160;<FONT CLASS="TableRow"><A HREF="#process-info" onMouseOut="MM_swapImgRestore()" onMouseOver="MM_swapImage('Image2','','{$base-dir}/bullet1.gif',1)">
	    <IMG SRC="{$base-dir}bullet2.gif" WIDTH="13" HEIGHT="13" BORDER="0" NAME="Image2"/>
	    Information</A></FONT><BR/>

    </xsl:template>

    <xsl:template match="roles" mode="toc">
	<xsl:param name="base-dir"/>
	<BR/>
	<A NAME="roles-index"></A><IMG SRC="{$base-dir}/isito.gif" WIDTH="22" HEIGHT="20"/>
	<FONT FACE="Verdana, Arial, Helvetica, sans-serif" SIZE="3"><B><xsl:value-of select="resources:get('ROLES')"/></B></FONT>
	<BR/>
	<xsl:for-each select="role">
	    &#160;&#160;&#160;&#160;<FONT CLASS="TableRow"><A HREF="#role-{@name}" onMouseOut="MM_swapImgRestore()" onMouseOver="MM_swapImage('Image{100000 + position()}','','{$base-dir}/bullet1.gif',1)">
		<IMG SRC="{$base-dir}/bullet2.gif" WIDTH="13" HEIGHT="13" BORDER="0" NAME="Image{100000 + position()}"/>
		<xsl:value-of select="@name"/></A></FONT><BR/>
	</xsl:for-each>

    </xsl:template>

    <xsl:template match="activities" mode="toc">
	<xsl:param name="base-dir"/>
	<BR/>
	<A NAME="activities-index"></A><IMG SRC="{$base-dir}/isito.gif" WIDTH="22" HEIGHT="20"/>
	<FONT FACE="Verdana, Arial, Helvetica, sans-serif" SIZE="3"><B><xsl:value-of select="resources:get('ACTIVITIES')"/></B></FONT>
	<BR/>
	<xsl:for-each select="activity">
	    &#160;&#160;&#160;&#160;<FONT CLASS="TableRow"><A HREF="#activity-{@name}" onMouseOut="MM_swapImgRestore()" onMouseOver="MM_swapImage('Image{200000 + position()}','','{$base-dir}/bullet1.gif',1)">
		<IMG SRC="{$base-dir}/bullet2.gif" WIDTH="13" HEIGHT="13" BORDER="0" NAME="Image{200000 + position()}"/>
		<xsl:value-of select="@name"/></A></FONT><BR/>
	</xsl:for-each>
    </xsl:template>

    <xsl:template match="exceptions" mode="toc">
	<xsl:param name="base-dir"/>
	<BR/>
	<A NAME="exceptions-index"></A><IMG SRC="{$base-dir}/isito.gif" WIDTH="22" HEIGHT="20"/>
	<FONT FACE="Verdana, Arial, Helvetica, sans-serif" SIZE="3"><B><xsl:value-of select="resources:get('EXCEPTIONS')"/></B></FONT>
	<BR/>
	<xsl:for-each select="exception">
	    &#160;&#160;&#160;&#160;<FONT CLASS="TableRow"><A HREF="#exception-{@name}" onMouseOut="MM_swapImgRestore()" onMouseOver="MM_swapImage('Image{300000 + position()}','','{$base-dir}/bullet1.gif',1)">
		<IMG SRC="{$base-dir}/bullet2.gif" WIDTH="13" HEIGHT="13" BORDER="0" NAME="Image{300000 + position()}"/>
		<xsl:value-of select="@name"/></A></FONT><BR/>
	</xsl:for-each>
    </xsl:template>

    <xsl:template match="dataObjects" mode="toc">
	<xsl:param name="base-dir"/>
	<BR/>
	<A NAME="dataObjects-index"></A><IMG SRC="{$base-dir}/isito.gif" WIDTH="22" HEIGHT="20"/>
	<FONT FACE="Verdana, Arial, Helvetica, sans-serif" SIZE="3"><B><xsl:value-of select="resources:get('VARIABLES')"/></B></FONT>
	<BR/>
	<xsl:for-each select="dataObject">
	    &#160;&#160;&#160;&#160;<FONT CLASS="TableRow"><A HREF="#dataObject-{@name}" onMouseOut="MM_swapImgRestore()" onMouseOver="MM_swapImage('Image{400000 + position()}','','{$base-dir}/bullet1.gif',1)">
		<IMG SRC="{$base-dir}/bullet2.gif" WIDTH="13" HEIGHT="13" BORDER="0" NAME="Image{400000 + position()}"/>
		<xsl:value-of select="@name"/></A></FONT><BR/>
	</xsl:for-each>
    </xsl:template>

    <xsl:template match="methods" mode="toc">
	<xsl:param name="base-dir"/>
	<BR/>
	<A NAME="methods-index"></A><IMG SRC="{$base-dir}/isito.gif" WIDTH="22" HEIGHT="20"/>
	<FONT FACE="Verdana, Arial, Helvetica, sans-serif" SIZE="3"><B><xsl:value-of select="resources:get('METHODS')"/></B></FONT>
	<BR/>
	<xsl:for-each select="method">
	    &#160;&#160;&#160;&#160;<FONT CLASS="TableRow"><A HREF="#method-{@name}" onMouseOut="MM_swapImgRestore()" onMouseOver="MM_swapImage('Image{500000 + position()}','','{$base-dir}/bullet1.gif',1)">
		<IMG SRC="{$base-dir}/bullet2.gif" WIDTH="13" HEIGHT="13" BORDER="0" NAME="Image{500000 + position()}"/>
		<xsl:value-of select="@name"/></A></FONT><BR/>
	</xsl:for-each>
    </xsl:template>

    <!-- ======================================================================================================== -->
    <!-- COMPONENT CATALOG TEMPLATES                                                                              -->
    <!-- ======================================================================================================== -->

    <!-- Top Level component -->
    <xsl:template match="report/component">
	<xsl:call-template name="component">
	    <xsl:with-param name="base-dir" select="$resources-dir"/>
	</xsl:call-template>
    </xsl:template>

    <!-- Nested component -->
    <xsl:template match="components/component">
	<xsl:call-template name="component">
	    <xsl:with-param name="base-dir">.</xsl:with-param>
	</xsl:call-template>
    </xsl:template>

    <!-- Write a component description    -->
    <xsl:template name="component">
	<xsl:param name="base-dir"/>
	<p class="txttitle"><xsl:value-of select="@displayName"/></p>
	<img src="{$base-dir}/5x5.gif" width="1" height="5"/><br/>

	<A NAME="component-info"><!-- --></A>
	<xsl:if test="@name">
	    <BR/>
	    <TABLE width="90%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
		<TR>
		    <TD CLASS="tabletitle" WIDTH="15%"><B><xsl:value-of select="resources:get('COMPONENT')"/>:</B></TD>
		    <TD CLASS="tabletitle" WIDTH="80%"><B><xsl:value-of select="@name"/></B></TD>
		    <TD CLASS="tabletitle" ALIGN="right"><IMG SRC="{$base-dir}/top.gif"/><A  CLASS="tabletitle" HREF="#process-info-index"><xsl:value-of select="resources:get('INDEX')"/></A></TD>
		</TR>
		<TR class="tablecell">
		    <TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('DESCRIPTION')"/>:</TD>
		    <TD COLSPAN="2"><xsl:value-of select="@description"/>&#160;</TD>
		</TR>
		<TR class="tablecell">
		    <TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('TYPE')"/>:</TD>
		    <TD COLSPAN="2"><xsl:value-of select="@type"/>&#160;</TD>
		</TR>
		<xsl:if test="delegate">
		    <TR class="tablecell">
			<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('DELEGATE')"/>:</TD>
			<TD COLSPAN="2">
			    <xsl:if test="delegate/@type-link">
				<A HREF="{$base-dir}/COMP-{delegate/@type-link}.html"><xsl:value-of select="delegate/@type-link"/></A>&#160;
			    </xsl:if>
			    <xsl:if test="@type">
				<xsl:value-of select="delegate/@type"/>&#160;
			    </xsl:if>
			</TD>
		    </TR>
		</xsl:if>
		<xsl:if test="superType">
		    <TR class="tablecell">
			<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('SUPER_TYPES')"/>:</TD>
			<TD COLSPAN="2">
			    <ul> <xsl:for-each select="superType">
				<li>
				    <xsl:if test="@type-link">
					<A HREF="{$base-dir}/COMP-{@type-link}.html"><xsl:value-of select="@type-link"/></A>&#160;
				    </xsl:if>
				    <xsl:if test="@type">
					<xsl:value-of select="@type"/>&#160;
				    </xsl:if>
				</li>
			    </xsl:for-each> </ul>
			</TD>
		    </TR>
		</xsl:if>
	    </TABLE>
	    <xsl:apply-templates select="documentation" mode="internal">
		<xsl:with-param name="base-dir" select="$base-dir"/>
	    </xsl:apply-templates>

	    <xsl:apply-templates select="useCaseDoc" mode="internal">
		<xsl:with-param name="base-dir" select="$base-dir"/>
	    </xsl:apply-templates>

	    <xsl:apply-templates select="attributes" mode="internal">
		<xsl:with-param name="base-dir" select="$base-dir"/>
	    </xsl:apply-templates>
	    <xsl:for-each select="methods/method">
		<xsl:call-template name="method">
		    <xsl:with-param name="base-dir" select="$base-dir"/>
		</xsl:call-template>
	    </xsl:for-each>
	</xsl:if>

	<xsl:apply-templates select="components" mode="internal-component">
	    <xsl:with-param name="base-dir" select="$base-dir"/>
	</xsl:apply-templates>
    </xsl:template>

    <xsl:template name="method">
	<xsl:param name="base-dir"/>
	<TABLE width="90%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
	    <TR>
		<TD CLASS="tabletitle" WIDTH="15%"><IMG SRC="{$base-dir}/select.gif"/><B><xsl:value-of select="resources:get('METHOD')"/>:</B></TD>
		<TD CLASS="tabletitle" WIDTH="80%"><B><xsl:value-of select="@name"/></B></TD>
		<TD CLASS="tabletitle" ALIGN="right"><IMG SRC="{$base-dir}/top.gif"/><A  CLASS="tabletitle" HREF="#methods-index"><xsl:value-of select="resources:get('INDEX')"/></A></TD>
	    </TR>
	    <TR class="tablecell">
		<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('RETURN_TYPE')"/>:</TD>
		<TD COLSPAN="2"><xsl:value-of select="@returnType"/>&#160;</TD>
	    </TR>
	    <TR class="tablecell">
		<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('STATIC')"/>:</TD>
		<TD COLSPAN="2"><xsl:value-of select="@static"/>&#160;</TD>
	    </TR>
	    <xsl:if test="@serverSide">
		<TR class="tablecell">
		    <TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('SERVER_SIDE')"/>:</TD>
		    <TD COLSPAN="2"><xsl:value-of select="@serverSide"/>&#160;</TD>
		</TR>
	    </xsl:if>
	    <xsl:if test="@style">
		<TR class="tablecell">
		    <TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('LANGUAGE_STYLE')"/>:</TD>
		    <TD COLSPAN="2"><xsl:value-of select="@style"/>&#160;</TD>
		</TR>
	    </xsl:if>
	    <xsl:if test="arguments">
		<TR>
		    <TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('ARGUMENTS')"/>:</TD>
		    <TD COLSPAN="2">
			<TABLE CELLSPACING="1" CELLPADDING="1" border="0" width="100%">
			    <xsl:for-each select="arguments/argument">
				<TR class="tablecell">
				    <TD width="50%"><b><xsl:value-of select="@name"/>&#160;</b></TD>
				    <TD><xsl:value-of select="@type"/>&#160;</TD>
				    <TD><xsl:value-of select="@modifiers"/>&#160;</TD>
				</TR>
			    </xsl:for-each>
			</TABLE>
		    </TD>
		</TR>
	    </xsl:if>
	    <xsl:if test="source">
		<TR class="tablecell">
		    <TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('SOURCE')"/>:</TD>
		    <TD COLSPAN="2"><pre><xsl:value-of select="source"/></pre>&#160;</TD>
		</TR>
	    </xsl:if>
	</TABLE>
	<xsl:apply-templates select="documentation" mode="internal">
	    <xsl:with-param name="base-dir" select="$base-dir"/>
	</xsl:apply-templates>

	<xsl:apply-templates select="useCaseDoc" mode="internal">
	    <xsl:with-param name="base-dir" select="$base-dir"/>
	</xsl:apply-templates>
	<BR/>

    </xsl:template>
    <xsl:template match="attributes" mode="internal">
	<xsl:param name="base-dir"/>
	<TABLE width="90%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
	    <TR>
		<TD CLASS="tabletitle" colspan="5"><B><xsl:value-of select="resources:get('ATTRIBUTES')"/></B></TD>
	    </TR>
	    <TR CLASS="tabletitle2">
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('NAME')"/></B></TD>
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('TYPE')"/></B></TD>
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('VIRTUAL')"/></B></TD>
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('DEFAULT_VALUE')"/></B></TD>
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('DESCRIPTION')"/></B></TD>
	    </TR>
	    <xsl:for-each select="attribute">
		<TR CLASS="tablecell">
		    <TD><xsl:value-of select="@name"/></TD>
		    <TD>
			<xsl:if test="@type-link">
			    <A HREF="{$base-dir}/COMP-{@type-link}.html"><xsl:value-of select="@type-link"/></A>&#160;
			</xsl:if>
			<xsl:if test="@type">
			    <xsl:value-of select="@type"/>&#160;
			</xsl:if>
		    </TD>
		    <TD><xsl:value-of select="@virtual"/>&#160;</TD>
		    <TD><xsl:value-of select="@defaultValue"/>&#160;</TD>
		    <TD><xsl:value-of select="@description"/>&#160;</TD>
		</TR>
		<tr><td colspan="5">
		    <table>
			<xsl:for-each select="validation">
			    <TR class="tablecell">
				<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('NAME')"/>:</TD>
				<TD COLSPAN="2"><pre><xsl:value-of select="@name"/></pre>&#160;</TD>
			    </TR>
			    <xsl:if test="expression">
				<TR class="tablecell">
				    <TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('EXPRESSION')"/>:</TD>
				    <TD COLSPAN="2"><pre><xsl:value-of select="expression"/></pre>&#160;</TD>
				</TR>
			    </xsl:if>

			</xsl:for-each>
			<xsl:for-each select="access">
			    <TR class="tablecell">
				<TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('NAME')"/>:</TD>
				<TD COLSPAN="2"><pre><xsl:value-of select="@name"/></pre>&#160;</TD>
			    </TR>
			    <xsl:if test="source">
				<TR class="tablecell">
				    <TD class="tabletitle2" WIDTH="15%"><xsl:value-of select="resources:get('SOURCE')"/>:</TD>
				    <TD COLSPAN="2"><pre><xsl:value-of select="source"/></pre>&#160;</TD>
				</TR>
			    </xsl:if>

			</xsl:for-each>
		    </table>
		</td></tr>
	    </xsl:for-each>
	</TABLE>
	<BR/>
    </xsl:template>
    <xsl:template match="components" mode="internal-component">
	<xsl:param name="base-dir"/>
	<TABLE width="90%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
	    <TR>
		<TD CLASS="tabletitle" colspan="2"><B><xsl:value-of select="resources:get('COMPONENTS')"/></B></TD>
	    </TR>
	    <TR CLASS="tabletitle2">
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('NAME')"/></B></TD>
		<TD CLASS="tabletitle2"><B><xsl:value-of select="resources:get('TYPE')"/></B></TD>
	    </TR>
	    <xsl:for-each select="component">
		<TR CLASS="tablecell">
		    <TD><A HREF="{$base-dir}/COMP-{@displayName}.html"><xsl:value-of select="@name"/></A></TD>
		    <TD><xsl:value-of select="@type"/>&#160;</TD>
		</TR>
		<redirect:write file="{$resources-path}/COMP-{@displayName}.html">
		    <xsl:call-template name="generate-file"/>
		</redirect:write>
	    </xsl:for-each>
	</TABLE>
    </xsl:template>

    <!-- ======================================================================================================== -->
    <!-- BASE UTILS TEMPLATES                                                                                     -->
    <!-- ======================================================================================================== -->
    <xsl:template match="useCaseDoc" mode="internal">
	<xsl:param name="base-dir"/>
	<TABLE width="90%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
	    <TR>
		<TD CLASS="tabletitle"><B><xsl:value-of select="resources:get('USE_CASES')"/></B></TD>
	    </TR>
	    <TR CLASS="tablecell">
		<TD>
		    <xsl:apply-templates mode="copy"><xsl:with-param name="base-dir" select="$base-dir"/></xsl:apply-templates>
		</TD>
	    </TR>
	</TABLE>
    </xsl:template>

    <xsl:template match="documentation" mode="internal">
	<xsl:param name="base-dir"/>
	<TABLE width="90%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
	    <TR>
		<TD CLASS="tabletitle"><B><xsl:value-of select="resources:get('DOCUMENTATION')"/></B></TD>
	    </TR>
	    <TR CLASS="tablecell">
		<TD>
		    <xsl:apply-templates mode="copy"><xsl:with-param name="base-dir" select="$base-dir"/></xsl:apply-templates>
		</TD>
	    </TR>
	</TABLE>
    </xsl:template>

    <xsl:template match="source" mode="internal">
	<xsl:param name="base-dir"/>
	<TABLE width="90%" BORDER="0" CELLSPACING="1" CELLPADDING="1">
	    <TR>
		<TD CLASS="tabletitle"><B><xsl:value-of select="resources:get('SOURCE')"/></B></TD>
	    </TR>
	    <TR CLASS="tablecell">
		<TD>
		    <xsl:value-of select="."/>
		</TD>
	    </TR>
	</TABLE>
    </xsl:template>

    <xsl:template name="header-footer">
<!--
    <TABLE>
	<TR>
	    <TD>
	    </TD>
	</TR>
    </TABLE>
    <BR/>
    <HR/>
-->
    </xsl:template>

    <xsl:template match="*" mode="copy">
	<xsl:param name="base-dir"/>
	<xsl:copy>
	    <xsl:copy-of select="@*"/>
	    <xsl:apply-templates mode="copy">
		<xsl:with-param name="base-dir" select="$base-dir"/>
	    </xsl:apply-templates>
	</xsl:copy>
    </xsl:template>

    <xsl:template match="img" mode="copy">
	<xsl:param name="base-dir"/>
	<img height="{@height}" width="{@width}" src="{$base-dir}/{@src}"/>
	<xsl:apply-templates mode="copy"/>
    </xsl:template>
</xsl:stylesheet>
