// ...........................................................................................................
//
// Copyright (c) 1993, 2011, Oracle and/or its affiliates. 
// All rights reserved. 
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Oracle Corp.
// The copyright notice above does not evidence any actual or intended
// publication of such source code.
//
// ...........................................................................................................
/* $Header: bpm/main/modules/tutor.reporter/src/oracle/bpm/tutor/reporter/resources/js/ReportScripts.js */
/* Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. */
/*

   MODIFIED    (MM/DD/YY)
    tkauth      08/28/11 - Change directory structure of resources
    tkauth      03/09/11 - Created

*/

var imgDir;

function Init() {
  DisplayIntroDetails(null);
  CheckExpandCollapse();
  SetContentHeight();
  var cw = document.getElementById('contentWrap');
  cw.scrollTop = 0;
}

function SetBottomSpace(divID) {
  var cw = document.getElementById('contentWrap');
  var div;
  if (div = document.getElementById(divID))
    div.style.paddingBottom = (cw.clientHeight - 50) + 'px';
}

function setImgDir(dir) {
  imgDir = dir;
}

function SetContentHeight() {
  //this will keep the length of the vertical scrollbar intact no matter
  //what the size of the user's screen
  var av = document.getElementById('alwaysVisible');
  var cw = document.getElementById('contentWrap');

  cw.style.top = av.offsetHeight + 'px';

  if (navigator.appName == "Netscape")
    cw.style.height = (window.innerHeight - cw.offsetTop) + 'px';
  if (navigator.appName.indexOf("Microsoft") != -1) {
    if (getIEVersion() > 6)
      cw.style.height = (document.documentElement.clientHeight - cw.offsetTop);
    else
      cw.style.height = (document.body.clientHeight - cw.offsetTop);
  }
  //add in buffer space at end of intro tab and task seg tab.
  SetBottomSpace('introSpace');
}

function getIEVersion() {
  var ret = -1;
  var agnt = navigator.userAgent;
  var re = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
  if (re.exec(agnt) != null)
    ret = parseFloat(RegExp.$1);
  return ret;
}

function ShowHideToggle(strContentID, strBtnID, clsName) {
  var elem = document.getElementById(strContentID);
  if (getDisplay(elem) == 'block') {
    //the following scrolling is only necessary to work around a bug in
    //FF, but it does no harm in IE.
    var cw = document.getElementById('contentWrap');
    var scrll = cw.scrollTop;
    elem.style.display = 'none';    //FF scrolls contentWrap to the top here.
    cw.scrollTop = scrll;
    document.getElementById(strBtnID).style.backgroundImage = 'url(' + imgDir + 'btnPlus.png)';
  }
  else {
    elem.style.display = 'block';
    document.getElementById(strBtnID).style.backgroundImage = 'url(' + imgDir + 'btnMinus.png)';
  }
  CheckExpandCollapse();
}

function CheckExpandCollapse() {
  var spanColl = document.getElementsByTagName("span");
  var img;
  var minus = false;
  var plus = false;
  var topLevelMinus = false;
  var topLevelPlus = false;
  for (var i = 0; i < spanColl.length; i++) {
    if (spanColl[i].className == 'expdCollpsCont') {
      //checking state of pluses and minuses among spans to determine
      //if content is totally collapsed, totally expanded, or partially expanded
      img = getBackgroundImageURL(spanColl[i]);
      if (!minus && img.indexOf('btnMinus.png') >= 0)
        minus = true;
      else if (!plus && img.indexOf('btnPlus.png') >= 0)
        plus = true; 
    }
    else if (spanColl[i].className == 'expdCollpsCont processBtn') {
      //checking the top level +/-. If these are all pluses yet there are
      //some minuses at lower levels, this should be the equivalent of all
      //content collapsed. So this needs to override any minuses found at 
      //lower levels above.
      img = getBackgroundImageURL(spanColl[i]);
      if (!topLevelMinus && img.indexOf('btnMinus.png') >= 0)
        topLevelMinus = true;
      else if (!topLevelPlus && img.indexOf('btnPlus.png') >= 0)
        topLevelPlus = true;
    }
  }
 
  var hideLink = 'introHideLink';
  var showLink = 'introShowLink';

  var elem;
  if (topLevelMinus) {
    if (elem = document.getElementById(hideLink))
      elem.style.display = 'block';
  }
  else {
    if (elem = document.getElementById(hideLink))
      elem.style.display = 'none';
  }

  if (plus || topLevelPlus) {
    if (elem = document.getElementById(showLink))
      elem.style.display = 'block';
  }
  else {
    if (elem = document.getElementById(showLink))
      elem.style.display = 'none';
  }
}

function getBackgroundImageURL(obj) {
  if (obj.currentStyle)   //IE and Opera
    return obj.currentStyle.backgroundImage;
  else    //FF
    return getComputedStyle(obj,'').getPropertyValue('background-image');
}

function getDisplay(obj) {
  if (obj.currentStyle)   //IE and Opera
    return obj.currentStyle.display;
  else    //FF
    return getComputedStyle(obj,'').getPropertyValue('display');
}

function DisplayIntroDetails(bool) {
  var cw = document.getElementById('contentWrap');
  var tp = cw.scrollTop;
  var spc = (cw.scrollHeight - cw.clientHeight) + 0.01;
  var ratio = tp/spc;

  var elem;
  if (bool) {
    if (elem = document.getElementById('introHideLink'))
      elem.style.display = 'block';
    if (elem = document.getElementById('introShowLink'))
      elem.style.display = 'none';
  }
  else {
    if (elem = document.getElementById('introHideLink'))
      elem.style.display = 'none';
    if (elem = document.getElementById('introShowLink'))
      elem.style.display = 'block';
  }

  var myID;
  var a;
  for (var i = 0; (a = document.getElementsByTagName('div')[i]); i++) {
    if (a.className == 'introContent' || a.className == 'processContent' || a.className == 'introContent processImageContent') {
      myID = a.id;
      if (myID.substring(myID.length - 7, myID.length) == 'Content') {
        CallSetBtnImg(myID, myID.substring(0, myID.length - 7) + 'Btn', bool);
      }
    }
  }

  /* cw.scrollHeight will increase or decrease depending on whether the user
     is hiding or displaying details. */
  spc = cw.scrollHeight - cw.clientHeight;
  cw.scrollTop = (ratio * spc);
}

function ExpandContent(id) {
  var elemParNode = document.getElementById(id + 'Content').parentNode;
  if (elemParNode.style.display != 'block') {
    var elemParNodeId = elemParNode.id;
    if (elemParNodeId.substring(elemParNodeId.length - 7, elemParNodeId.length) == 'Content') {
      CallSetBtnImg(elemParNodeId, elemParNodeId.substring(0, elemParNodeId.length - 7) + 'Btn', true);
    }
  }
  CallSetBtnImg(id + 'Content', id + 'Btn', true);
}

function CallSetBtnImg(elemName1, elemName2, bool) {
  var elem1, elem2;
  elem1 = document.getElementById(elemName1);
  elem2 = document.getElementById(elemName2);

  if (elem1 && elem2) SetBtnImg(elem1, elem2, bool); 
}

function SetBtnImg(id, btnId, bool) {
  //if there is no detail, no plus/minus button
  if (TrimWhitespace(id.innerHTML) == '') {
    id.style.display = 'block';
    btnId.style.backgroundImage = 'none';
    btnId.style.cursor = 'default';
  }
  else if (bool) {
    id.style.display = 'block';
    btnId.style.backgroundImage = 'url(' + imgDir + 'btnMinus.png)';
  } //sometimes bool == null
  else if (bool == false) {
    id.style.display = 'none';
    btnId.style.backgroundImage = 'url(' + imgDir + 'btnPlus.png)';
  }
  else if (bool == null) {
    //this occurs at initial page load
    if (getBackgroundImageURL(btnId).indexOf('btnPlus.png') >= 0)
      btnId.style.backgroundImage = 'url(' + imgDir + 'btnPlus.png)';
    else if (getBackgroundImageURL(btnId).indexOf('btnMinus.png') >= 0)
      btnId.style.backgroundImage = 'url(' + imgDir + 'btnMinus.png)';
  }
}

function TrimWhitespace(str) {
  return str.replace(/^\s*|\s*$/g, "");
}

function SwitchText(str1, str2, innHTML, id) {
  var obj = document.getElementById(id);
  if (innHTML == str1) 
    obj.innerHTML = str2;
  else if (innHTML == str2)
    obj.innerHTML = str1;
  //IE6 doesn't redraw the vert scrollbar correctly, so reset content height
  if (navigator.appName.indexOf("Microsoft") != -1)
    SetContentHeight();
}

