<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
 ...........................................................................................................
//
// Copyright (c) 1993, 2011, Oracle and/or its affiliates. 
// All rights reserved. 
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Oracle Corp.
// The copyright notice above does not evidence any actual or intended
// publication of such source code.
//
// ...........................................................................................................

/* $Header: bpm/main/modules/tutor.reporter/src/oracle/bpm/tutor/reporter/resources/BPMxml2fo.xsl /st_pcbpel_11.1.1.4.0/2 2011/04/18 10:12:16 fevers Exp $ */
/* Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. */
/*
   DESCRIPTION
    <short description of component this file declares/defines>

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    fevers      04/14/11 - update for ps5. This is the most recent xsl for FOP 1.0
    			PDF functionality was removed for 11.1.1.6, but this file
			works to generate a pdf.
    fevers      04/06/11 - Adding source files for tutor.reporter
    fevers      04/06/11 - Creation
 */
/**
 *  @version $Header: HTMLPublisher.java 06-apr-2011.13:29:47 fevers   Exp $
 *  @author  fevers
 *  @since   release specific (what release of product did this appear in)
 */

    Date        Who         Change
    =========   =========== ====================================================
    22-Feb-11   F. Evers    created
    
  -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:rpt="http://www.oracle.com/oracle/bpm/tutor/reporter">
 <xsl:output method="xml" omit-xml-declaration="yes" indent="yes"/>
 <xsl:template match="/">
  <fo:root>
   <fo:layout-master-set>
    <!-- h, w. margins, header and footer use A4 page size with 1" right/left maring, 1/2" top/bottom margins  -->
    <fo:simple-page-master master-name="master0" margin-left="72.0pt"
                           margin-right="72.0pt" page-height="841.0pt"
                           page-width="595.0pt" margin-top="36.0pt"
                           margin-bottom="36.0pt">
     <!--<fo:region-before region-name="region-header" extent="36.0pt"/>-->
     <fo:region-body region-name="region-body" margin-top="36.0pt"
                     margin-bottom="36.0pt"/>
     <fo:region-after region-name="region-footer" extent="36.0pt"
                      display-align="after"/>
    </fo:simple-page-master>
   </fo:layout-master-set>
   <!-- bookmark section -->
   <fo:bookmark-tree>
    <xsl:for-each select="//rpt:bpmObject[@rpt:objectType='PROCESS']">
     <!-- loop thru all processes in the project or just one
       process if this is a single process report  -->
     <fo:bookmark internal-destination="{@rpt:id}ProcessBtn">
      <!-- bkmk for the process title -->
      <fo:bookmark-title>
       <!-- the name of the process -->
       <xsl:value-of select="@rpt:name"/>
      </fo:bookmark-title>
      <fo:bookmark internal-destination="{@rpt:id}processDataBtn">
       <!-- bkmk to display the process metadata table -->
       <fo:bookmark-title>Process Properties</fo:bookmark-title>
      </fo:bookmark>
      <fo:bookmark internal-destination="{@rpt:id}processImageBtn">
       <!-- bkmk to display the cropped process image(s) -->
       <fo:bookmark-title>Process Image</fo:bookmark-title>
      </fo:bookmark>
      <fo:bookmark internal-destination="{@rpt:id}lanesHeadBtn">
       <!-- bkmk to display the Lanes heading -->
       <fo:bookmark-title>Lanes</fo:bookmark-title>
       <!-- loop for the list of lanes -->
       <xsl:for-each select="./rpt:bpmObjects/rpt:bpmObject[@rpt:objectType='Lane']">
        <fo:bookmark internal-destination="{@rpt:id}">
         <fo:bookmark-title>
          <!-- the name of the lane -->
          <xsl:value-of select="@rpt:name"/>
         </fo:bookmark-title>
        </fo:bookmark>
       </xsl:for-each>
      </fo:bookmark>
      <fo:bookmark internal-destination="{@rpt:id}processStepsBtn">
       <!-- bkmk to display the Process Steps heading -->
       <fo:bookmark-title>Process Steps</fo:bookmark-title>
       <!-- loop for the list of process steps -->
       <xsl:for-each select="./rpt:bpmObjects/rpt:bpmObject[@rpt:objectType='Lane']/rpt:bpmObjects/rpt:bpmObject">
        <!-- SORT objects by alpha -->
        <xsl:sort select="./@rpt:name" order="ascending" data-type="text"/>
        <fo:bookmark internal-destination="{@rpt:id}">
         <fo:bookmark-title>
          <!-- the name of the process step -->
          <xsl:value-of select="@rpt:name"/>
         </fo:bookmark-title>
        </fo:bookmark>
       </xsl:for-each>
      </fo:bookmark>
     </fo:bookmark>
    </xsl:for-each>
   </fo:bookmark-tree>
   <fo:page-sequence master-reference="master0">
    <fo:title>Attribute Report</fo:title>
    <fo:static-content flow-name="region-footer">
     <fo:block text-align="end" font-size="10pt" font-family="serif"
               line-height="14pt">
      Process Report p.
      <fo:page-number/>
     </fo:block>
    </fo:static-content>
    <!--	body   -->
    <fo:flow flow-name="region-body">
     <fo:block id="alwaysVisible" padding-bottom="0.25pt" padding-top="0.25pt">
      <fo:table start-indent="0.0pt" table-layout="fixed" width="100%"
                border-collapse="separate">
       <fo:marker marker-class-name="test"/>
       <fo:table-column column-width="20%"/>
       <fo:table-column column-width="60%"/>
       <fo:table-column column-width="20%"/>
       <fo:table-body>
        <fo:table-row keep-with-next="always">
         <fo:table-cell>
          <fo:marker marker-class-name="test"/>
          <fo:block/>
         </fo:table-cell>
         <fo:table-cell number-columns-spanned="1">
          <fo:block padding-bottom="0.10pt" padding-top="0.25pt"
                    font-size="13pt" font-weight="bold" font-family="sans-serif"
                    line-height="15pt" space-after.optimum="15pt"
                    background-color="#FFFFFF" color="#336699"
                    text-align="center">
           <xsl:choose>
            <xsl:when test="//rpt:bpmObject[@rpt:objectType='PROJECT']/@rpt:name">
             <xsl:value-of select="//rpt:bpmObject[@rpt:objectType='PROJECT']/@rpt:name"/>
            </xsl:when>
            <xsl:otherwise>
             <xsl:value-of select="//rpt:bpmObject[@rpt:objectType='PROCESS']/@rpt:name"/>
            </xsl:otherwise>
           </xsl:choose>
          </fo:block>
          <fo:block padding-bottom="0.25pt" padding-top="0.10pt"
                    font-size="13pt" font-weight="bold" font-family="sans-serif"
                    line-height="15pt" space-after.optimum="15pt"
                    background-color="#FFFFFF" color="#336699"
                    text-align="center">Attribute Report</fo:block>
         </fo:table-cell>
         <fo:table-cell>
          <fo:marker marker-class-name="test"/>
          <fo:block font-size=".9em">
           <xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='reportDate']"/>
          </fo:block>
         </fo:table-cell>
        </fo:table-row>
       </fo:table-body>
      </fo:table>
     </fo:block>
     <!--<div id="contentWrap">-->
     <xsl:for-each select="//rpt:bpmObject[@rpt:objectType='PROCESS']">
      <!--BEGIN PROCESS PROPERTIES -->
      <!--<p class="HEADING1">
        <span id="{@rpt:id}processDataBtn" class="expdCollpsCont"
              onClick="ShowHideToggle('{@rpt:id}processDataContent', this.id, this.className);"></span>
         Process Properties
       </p>-->
       <fo:block id="{@rpt:id}ProcessBtn" />
      <fo:block id="{@rpt:id}processDataBtn" padding-bottom="0.25pt"
                padding-top="0.25pt" font-size="12pt" font-weight="bold"
                font-family="sans-serif" line-height="14pt"
                space-after.optimum="15pt" background-color="#FFFFFF"
                color="#4f81bd" text-align="left" border-bottom-style="solid"
                border-bottom-width="0.05em" border-bottom-color="#d6d6d6">Process
                                                                           Properties</fo:block>
      <!--   <div id="{@rpt:id}ProcessContent" class="processContent"> -->
      <!--<div id="{@rpt:id}processDataContent" class="introContent">-->
      <fo:block>
       <!--<table class="TABLE" summary="">-->
       <fo:table start-indent="0.0pt" table-layout="fixed" width="100%"
                 border-collapse="collapse" border-width="0.05em"
                 border-style="solid" border-color="#d6d6d6">
        <fo:table-body>
         <!--<tr>-->
         <fo:table-row>
          <!--<th class="FIRST_COL">Name</th>-->
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6" number-columns-spanned="2">
             <fo:marker marker-class-name="test"/>
             <fo:block font-weight="bold" text-align="left" font-size="9pt"
                       font-family="sans-serif">Name</fo:block>
            </fo:table-cell>
          <!--<td class="TABL_span" colspan="2">-->
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           number-columns-spanned="5">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">
              <xsl:value-of select="@rpt:name"/>
             </fo:block>
             <!--</td>-->
            </fo:table-cell>
          <!--</tr>-->
         </fo:table-row>
         <!--<tr>-->
         <fo:table-row>
          <!--<th class="FIRST_COL">Author</th>-->
          <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6" number-columns-spanned="2">
             <fo:marker marker-class-name="test"/>
             <fo:block font-weight="bold" text-align="left" font-size="9pt"
                       font-family="sans-serif">Author</fo:block>
            </fo:table-cell>
          <!--<td class="TABL_SPAN" colspan="2">-->
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           number-columns-spanned="5">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">
              <xsl:value-of select="./rpt:property[@rpt:name='author']"/>
             </fo:block>
             <!--</td>-->
            </fo:table-cell>
          <!--</tr>-->
         </fo:table-row>
         <!--<tr>-->
         <fo:table-row>
          <!--<th class="FIRST_COL">Description</th>-->
          <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6" number-columns-spanned="2">
             <fo:marker marker-class-name="test"/>
             <fo:block font-weight="bold" text-align="left" font-size="9pt"
                       font-family="sans-serif">Description</fo:block>
            </fo:table-cell>
          <!--<td class="TABL_span" colspan="2">-->
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           number-columns-spanned="5">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">
              <xsl:value-of select="./rpt:property[@rpt:name='description']"/>
             </fo:block>
             <!--</td>-->
            </fo:table-cell>
          <!--</tr>-->
         </fo:table-row>
         <!--<tr>-->
         <fo:table-row>
          <!--<th class="FIRST_COL">Project</th>-->
          <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6" number-columns-spanned="2">
             <fo:marker marker-class-name="test"/>
             <fo:block font-weight="bold" text-align="left" font-size="9pt"
                       font-family="sans-serif">Project</fo:block>
            </fo:table-cell>
         <!--<td class="TABL_span" colspan="2">-->
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           number-columns-spanned="5">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">
              <xsl:value-of select="./rpt:property[@rpt:name='project']"/>
             </fo:block>
             <!--</td>-->
            </fo:table-cell>
          <!--</tr>-->
         </fo:table-row>
         <!--<tr>-->
         <fo:table-row>
          <!--<th class="FIRST_COL">Use Case Documentation</th>-->
          <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6" number-columns-spanned="2">
             <fo:marker marker-class-name="test"/>
             <fo:block font-weight="bold" text-align="left" font-size="9pt"
                       font-family="sans-serif">Use Case Documentation</fo:block>
            </fo:table-cell>
          <!--<td class="TABL_span" colspan="2">-->
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           number-columns-spanned="5">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">
              <xsl:value-of select="./rpt:property[@rpt:name='useCaseDocumentation']"/>
             </fo:block>
             <!--</td>-->
            </fo:table-cell>
          <!--</tr>-->
         </fo:table-row>
         <xsl:choose>
          <xsl:when test="./rpt:propertyGroup[@name='Declarations']">
           <fo:table-row>
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6" number-columns-spanned="2">
             <fo:marker marker-class-name="test"/>
             <fo:block font-weight="bold" text-align="left" font-size="9pt"
                       font-family="sans-serif">Global Variables</fo:block>
            </fo:table-cell>
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           number-columns-spanned="5">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif"/>
            </fo:table-cell>
           </fo:table-row>
           <xsl:for-each select="./rpt:propertyGroup[@name='Declarations']">
            <fo:table-row>
             <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6">
             <fo:marker marker-class-name="test"/>
             <fo:block font-weight="bold" text-align="left" font-size="9pt"
                       font-family="sans-serif"/>
            </fo:table-cell>
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt"
                          number-columns-spanned="3">
            <fo:marker marker-class-name="test"/>
            <fo:block font-weight="bold" text-align="center" font-size="9pt"
                      font-family="sans-serif"><xsl:value-of select="@name_heading"/></fo:block>
           </fo:table-cell>
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt"
                          number-columns-spanned="3">
            <fo:marker marker-class-name="test"/>
            <fo:block font-weight="bold" text-align="center" font-size="9pt"
                      font-family="sans-serif"><xsl:value-of select="@value_heading"/></fo:block>
           </fo:table-cell>
            </fo:table-row>
            <xsl:for-each select="./rpt:propertyGroup">
             <fo:table-row>
             <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6">
             <fo:marker marker-class-name="test"/>
             <fo:block font-weight="bold" text-align="left" font-size="9pt"
                       font-family="sans-serif"/>
            </fo:table-cell>
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt" number-columns-spanned="3">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif"><xsl:value-of select="./rpt:property[@rpt:name='Name']"/></fo:block>
            </fo:table-cell>
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt" number-columns-spanned="3">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif"><xsl:value-of select="./rpt:property[@rpt:name='DeclarationType']"/></fo:block>
            </fo:table-cell>
             </fo:table-row>
            </xsl:for-each>
           </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
           <fo:table-row>
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6" number-columns-spanned="2">
             <fo:marker marker-class-name="test"/>
             <fo:block font-weight="bold" text-align="left" font-size="9pt"
                       font-family="sans-serif">Global Variables</fo:block>
            </fo:table-cell>
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6" number-columns-spanned="5">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">NONE</fo:block>
            </fo:table-cell>
           </fo:table-row>
          </xsl:otherwise>
         </xsl:choose>
         <xsl:choose>
          <xsl:when test="./rpt:propertyGroup[@name='Local Declarations']">
           <fo:table-row>
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6" number-columns-spanned="2">
             <fo:marker marker-class-name="test"/>
             <fo:block font-weight="bold" text-align="left" font-size="9pt"
                       font-family="sans-serif">Local Variables</fo:block>
            </fo:table-cell>
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6" number-columns-spanned="5">
             <fo:marker marker-class-name="test"/>
             <fo:block />
            </fo:table-cell>
           </fo:table-row>
           <xsl:for-each select="./rpt:propertyGroup[@name='Local Declarations']">
            <fo:table-row>
             <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6">
             <fo:marker marker-class-name="test"/>
             <fo:block />
            </fo:table-cell>
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt"
                          number-columns-spanned="3">
            <fo:marker marker-class-name="test"/>
            <fo:block font-weight="bold" text-align="center" font-size="9pt"
                      font-family="sans-serif"><xsl:value-of select="@name_heading"/></fo:block>
           </fo:table-cell>
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt"
                          number-columns-spanned="3">
            <fo:marker marker-class-name="test"/>
            <fo:block font-weight="bold" text-align="center" font-size="9pt"
                      font-family="sans-serif"><xsl:value-of select="@value_heading"/></fo:block>
           </fo:table-cell>
            </fo:table-row>
            <xsl:for-each select="./rpt:propertyGroup">
             <fo:table-row>
              <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6">
             <fo:marker marker-class-name="test"/>
             <fo:block />
            </fo:table-cell>
               <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt" number-columns-spanned="3">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif"><xsl:value-of select="./rpt:property[@rpt:name='Name']"/></fo:block>
            </fo:table-cell>
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt" number-columns-spanned="3">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif"><xsl:value-of select="./rpt:property[@rpt:name='DeclarationType']"/></fo:block>
            </fo:table-cell>
             </fo:table-row>
            </xsl:for-each>
           </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
           <fo:table-row>
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6" number-columns-spanned="2">
             <fo:marker marker-class-name="test"/>
             <fo:block font-weight="bold" text-align="left" font-size="9pt"
                       font-family="sans-serif">Local Variables</fo:block>
            </fo:table-cell> 
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           number-columns-spanned="5">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">
              NONE
             </fo:block>
             </fo:table-cell>
           </fo:table-row>
          </xsl:otherwise>
         </xsl:choose>
        </fo:table-body>
       </fo:table>
      </fo:block>
      <!-- END PROCESS PROPERTIES -->
      <fo:block-container width="600px" id="{@rpt:id}processImageBtn"
                          break-before="page" break-after="page">
       <xsl:for-each select="//rpt:propertyGroup[@name='CroppedImages']/rpt:property[@rpt:name='ImageName']">
        <fo:block>
         <fo:external-graphic src="{text()}" width="80%" height="540px"
                              content-width="scale-to-fit"
                              content-height="scale-to-fit"/>
        </fo:block>
       </xsl:for-each>
      </fo:block-container>
      <!-- <img src="{./rpt:property[@rpt:name='imgName']}"/> IMAGE GOES HERE -->
      <fo:block padding-bottom="0.25pt" padding-top="0.25pt" font-size="11pt"
                font-weight="bold" font-family="sans-serif" line-height="14pt"
                space-after.optimum="15pt" background-color="#FFFFFF"
                color="#4f81bd" text-align="left" border-bottom-style="solid"
                border-bottom-width="0.05em" border-bottom-color="#d6d6d6">
       <!--<fo:inline id="{@rpt:id}ProcessBtn" class="expdCollpsCont">-->
       <xsl:value-of select="@rpt:name"/>
       <!--</fo:inline>-->
      </fo:block>
      <!--<div id="{@rpt:id}ProcessContent" class="introContent">-->
      <fo:block id="{@rpt:id}ProcessContent" padding-bottom="0.25pt"
                padding-top="0.25pt" padding-left="20pt">
       <!--<p class="HEADING1">-->
       <fo:block id="{@rpt:id}lanesHeadBtn" padding-bottom="0.25pt"
                 padding-top="0.25pt" font-size="12pt" font-weight="bold"
                 font-family="sans-serif" line-height="14pt"
                 space-after.optimum="15pt" background-color="#FFFFFF"
                 color="#4f81bd" text-align="left" border-bottom-style="solid"
                 border-bottom-width="0.05em" border-bottom-color="#d6d6d6">Lanes</fo:block>
       <!--<div id="{@rpt:id}lanesHeadContent" class="introContent"> 'IntroContent' has no actial style props-->
       <!--<fo:block id="{@rpt:id}lanesHeadContent" class="introContent" padding-bottom="0pt" padding-top="0.25pt">-->
       <xsl:for-each select="./rpt:bpmObjects/rpt:bpmObject[@rpt:objectType='Lane']">
        <!-- <a name="{@rpt:id}"/>  -->
        <fo:block line-height="0pt" space-after="0pt" font-size="0pt"
                  id="{@rpt:id}"/>
        <!--<p class="HEADING2">-->
        <fo:block padding-bottom="0.25pt" padding-top="0.25pt" font-size="11pt"
                  font-weight="bold" font-family="sans-serif" line-height="14pt"
                  space-after.optimum="15pt" space-before.optimum="20pt"
                  background-color="#FFFFFF" color="#4f81bd" text-align="left"
                  border-bottom-style="solid" border-bottom-width="0.05em"
                  border-bottom-color="#d6d6d6" keep-with-next="always">
         <fo:inline id="{@rpt:id}LaneBtn"/>
         <xsl:value-of select="@rpt:name"/>
         <!--</p>-->
        </fo:block>
        <!--<div id="{@rpt:id}LaneContent" class="introContent">-->
        <fo:block id="{@rpt:id}lanesHeadContent" padding-bottom="0.25pt"
                  padding-top="0.25pt">
         <!--<table class="TABLE" summary="">-->
         <fo:table start-indent="0.0pt" table-layout="fixed" width="100%"
                   border-collapse="collapse" border-width="0.05em"
                   border-style="solid" border-color="#d6d6d6">
          <!-- <tr> -->
          <fo:table-body>
           <fo:table-row>
            <!--<th class="FIRST_COL">Name</th>-->
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6">
             <fo:marker marker-class-name="test"/>
             <fo:block font-weight="bold" text-align="left" font-size="9pt"
                       font-family="sans-serif">Name</fo:block>
            </fo:table-cell>
            <!--<td class="TABL_span" colspan="2">-->
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           number-columns-spanned="2">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">
              <xsl:value-of select="@rpt:name"/>
             </fo:block>
             <!--</td>-->
            </fo:table-cell>
            <!--</tr>-->
           </fo:table-row>
           <!-- <tr> -->
           <fo:table-row>
            <!--<th class="FIRST_COL">Type</th>-->
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6">
             <fo:marker marker-class-name="test"/>
             <fo:block font-weight="bold" text-align="left" font-size="9pt"
                       font-family="sans-serif">Type</fo:block>
            </fo:table-cell>
            <!--<td class="TABL_span" colspan="2">-->
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           number-columns-spanned="2">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">
              <xsl:value-of select="@rpt:objectType"/>
             </fo:block>
             <!--</td>-->
            </fo:table-cell>
            <!--</tr>-->
           </fo:table-row>
           <!--</fo:table-header>-->
           <!-- <tr> -->
           <fo:table-row>
            <!--<th class="FIRST_COL">Description</th>-->
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6">
             <fo:marker marker-class-name="test"/>
             <fo:block font-weight="bold" text-align="left" font-size="9pt"
                       font-family="sans-serif">Description</fo:block>
            </fo:table-cell>
            <!--<td class="TABL_span" colspan="2">-->
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           number-columns-spanned="2">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">
              <xsl:value-of select="./rpt:property[@rpt:name='description']"/>
             </fo:block>
             <!--</td>-->
            </fo:table-cell>
            <!--</tr>-->
           </fo:table-row>
           <!-- <tr> -->
           <fo:table-row>
            <!--<th class="FIRST_COL">Process Steps</th>-->
            <fo:table-cell padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6">
             <fo:marker marker-class-name="test"/>
             <fo:block font-weight="bold" text-align="left" font-size="9pt"
                       font-family="sans-serif">Process Steps</fo:block>
            </fo:table-cell>
            <!--<td class="TABL_span" colspan="2">-->
            <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           number-columns-spanned="2">
             <fo:marker marker-class-name="test"/>
            </fo:table-cell>
            <!--</tr>-->
           </fo:table-row>
           <!-- <tr> -->
           <fo:table-row keep-with-next="always">
            <!--<th class="FIRST_COL"/>-->
            <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt">
             <fo:marker marker-class-name="test"/>
             <fo:block/>
            </fo:table-cell>
            <!--<th class="FIRST_COL">Name</th>-->
            <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt">
             <fo:marker marker-class-name="test"/>
             <fo:block font-weight="bold" text-align="center">Name</fo:block>
            </fo:table-cell>
            <!--<th class="TABL_3COL TABL_CENTER">Type</th>-->
            <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt">
             <fo:marker marker-class-name="test"/>
             <fo:block font-weight="bold" text-align="center">Type</fo:block>
            </fo:table-cell>
            <!--</tr>-->
           </fo:table-row>
           <xsl:for-each select="./rpt:bpmObjects/rpt:bpmObject">
            <!-- <tr> -->
            <fo:table-row keep-with-next="always">
             <!--<th class="FIRST_COL"/>-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt">
              <fo:marker marker-class-name="test"/>
              <fo:block/>
             </fo:table-cell>
             <!--<td class="TABL_3COL">-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt">
              <fo:block text-align="left" font-size="9pt"
                        font-family="sans-serif">
               <fo:basic-link color="blue" internal-destination="{@rpt:id}">
                <xsl:value-of select="@rpt:name"/>
               </fo:basic-link>
              </fo:block>
              <!--</td>-->
             </fo:table-cell>
             <!--<td class="TABL_3COL">-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt">
              <fo:marker marker-class-name="test"/>
              <fo:block text-align="left" font-size="9pt"
                        font-family="sans-serif">
               <xsl:value-of select="@rpt:objectType"/>
              </fo:block>
              <!--</td>-->
             </fo:table-cell>
             <!--</tr>-->
            </fo:table-row>
           </xsl:for-each>
           <!--</table>-->
          </fo:table-body>
         </fo:table>
         <fo:block/>
         <fo:block/>
         <!--</div>-->
        </fo:block>
        <!--end LaneContent-->
       </xsl:for-each>
       <!--</div>-->
      </fo:block>
      <!--end lanesHeadContent-->
      <!--<p class="HEADING1">-->
      <fo:block id="{@rpt:id}processStepsBtn" padding-bottom="0.25pt"
                padding-top="0.25pt" font-size="12pt" font-weight="bold"
                font-family="sans-serif" line-height="14pt"
                space-after.optimum="15pt" background-color="#FFFFFF"
                color="#4f81bd" text-align="left" border-bottom-style="solid"
                border-bottom-width="0.05em" border-bottom-color="#d6d6d6"
                keep-with-next="always">
       <!--<fo:inline id="{@rpt:id}processStepsBtn"/> no need for button-->
       Process Steps
       <!--</p>-->
      </fo:block>
      <!--<div id="{@rpt:id}processStepsContent" class="introContent">-->
      <!--<fo:block id="{@rpt:id}processStepsContent" padding-bottom="0.25pt" padding-top="0.25pt">-->
      <xsl:for-each select="./rpt:bpmObjects/rpt:bpmObject[@rpt:objectType='Lane']/rpt:bpmObjects/rpt:bpmObject">
       <!-- SORT objects by alpha -->
       <xsl:sort select="./@rpt:name" order="ascending" data-type="text"/>
       <!--<fo:block line-height="0pt" space-after="0pt" font-size="0pt" id="{@rpt:id}"  keep-with-next="always"/>-->
       <!--<p class="HEADING1">-->
       <fo:block id="{@rpt:id}" padding-bottom="0.25pt" padding-top="0.25pt"
                 font-size="11pt" font-weight="bold" font-family="sans-serif"
                 line-height="14pt" space-after.optimum="10pt"
                 space-before.optimum="15pt" background-color="#FFFFFF"
                 color="#4f81bd" text-align="left" border-bottom-style="solid"
                 border-bottom-width="0.05em" border-bottom-color="#d6d6d6"
                 keep-with-next="always">
        <!--<fo:inline id="{@rpt:id}Btn"/> I don't need no stinkin button! -->
        <xsl:value-of select="@rpt:name"/>
        <!--</p>-->
       </fo:block>
       <!--<div id="{@rpt:id}Content" class="introContent">-->
       <fo:block id="{@rpt:id}Content">
        <!--<table class="TABLE" summary=""> THIS IS THE STEPS PROPERTIES TABLE-->
        <fo:table start-indent="0.0pt" table-layout="fixed" width="100%"
                  border-collapse="separate">
         <fo:table-body>
          <!-- <tr> -->
          <fo:table-row>
           <!--<th class="FIRST_COL">Name</th>-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt">
            <fo:marker marker-class-name="test"/>
            <fo:block font-weight="bold" text-align="center" font-size="9pt"
                      font-family="sans-serif">Name</fo:block>
           </fo:table-cell>
           <!--<td class="TABL_span" colspan="4">-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt"
                          number-columns-spanned="4">
            <fo:marker marker-class-name="test"/>
            <fo:block text-align="left" font-size="9pt"
                      font-family="sans-serif">
             <xsl:value-of select="@rpt:name"/>
            </fo:block>
            <!--</td>-->
           </fo:table-cell>
           <!--</tr>-->
          </fo:table-row>
          <!-- <tr> -->
          <fo:table-row>
           <!--<th class="FIRST_COL">Type</th>-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt">
            <fo:marker marker-class-name="test"/>
            <fo:block font-weight="bold" text-align="center" font-size="9pt"
                      font-family="sans-serif">Type</fo:block>
           </fo:table-cell>
           <!--<td class="TABL_span" colspan="4">-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt"
                          number-columns-spanned="4">
            <fo:marker marker-class-name="test"/>
            <fo:block text-align="left" font-size="9pt"
                      font-family="sans-serif">
             <xsl:value-of select="@rpt:objectType"/>
            </fo:block>
            <!--</td>-->
           </fo:table-cell>
           <!--</tr>-->
          </fo:table-row>
          <!-- <tr> -->
          <fo:table-row>
           <!--<th class="FIRST_COL">Description</th>-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt">
            <fo:marker marker-class-name="test"/>
            <fo:block font-weight="bold" text-align="center" font-size="9pt"
                      font-family="sans-serif">Description</fo:block>
           </fo:table-cell>
           <!--<td class="TABL_span" colspan="4">-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt"
                          number-columns-spanned="4">
            <fo:marker marker-class-name="test"/>
            <fo:block text-align="left" font-size="9pt"
                      font-family="sans-serif">
             <xsl:value-of select="./rpt:property[@rpt:name='description']"/>
            </fo:block>
            <!--</td>-->
           </fo:table-cell>
           <!--</tr>-->
          </fo:table-row>
          <!-- <tr> -->
          <fo:table-row keep-with-next="always">
           <!--<th class="FIRST_COL">Out Flows</th>-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt">
            <fo:marker marker-class-name="test"/>
            <fo:block font-weight="bold" text-align="center" font-size="9pt"
                      font-family="sans-serif">OutFlows</fo:block>
           </fo:table-cell>
           <!--<td class="TABL_span" colspan="4"/>-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt"
                          number-columns-spanned="4">
            <fo:marker marker-class-name="test"/>
            <fo:block/>
           </fo:table-cell>
           <!--</tr>-->
          </fo:table-row>
          <!-- <tr> -->
          <fo:table-row keep-with-next="always">
           <!--<th class="FIRST_COL"/>-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt">
            <fo:marker marker-class-name="test"/>
            <fo:block/>
           </fo:table-cell>
           <!--<th class="TABL_span TABL_CENTER" colspan="3">Sequence Flows</th>-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt"
                          number-columns-spanned="3">
            <fo:marker marker-class-name="test"/>
            <fo:block font-weight="bold" text-align="center" font-size="9pt"
                      font-family="sans-serif">Sequence Flows</fo:block>
           </fo:table-cell>
           <!--<th class="TABL_3COL TABL_CENTER">Target Objects</th>-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt">
            <fo:marker marker-class-name="test"/>
            <fo:block font-weight="bold" text-align="center" font-size="9pt"
                      font-family="sans-serif">Target Objects</fo:block>
           </fo:table-cell>
           <!--</tr>-->
          </fo:table-row>
          <!-- <tr> -->
          <fo:table-row keep-with-next="always">
           <!--<th class="FIRST_COL"/>-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt">
            <fo:marker marker-class-name="test"/>
            <fo:block/>
           </fo:table-cell>
           <!--<th class="TABL_5COL TABL_CENTER">Name</th>-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt">
            <fo:marker marker-class-name="test"/>
            <fo:block font-weight="bold" text-align="center" font-size="9pt"
                      font-family="sans-serif">Name</fo:block>
           </fo:table-cell>
           <!--<th class="TABL_5COL TABL_CENTER">Description</th>-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt">
            <fo:marker marker-class-name="test"/>
            <fo:block font-weight="bold" text-align="center" font-size="9pt"
                      font-family="sans-serif">Description</fo:block>
           </fo:table-cell>
           <!--<th class="TABL_5COL TABL_CENTER">Condition</th>-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt">
            <fo:marker marker-class-name="test"/>
            <fo:block font-weight="bold" text-align="center" font-size="9pt"
                      font-family="sans-serif">Condition</fo:block>
           </fo:table-cell>
           <!--<th class="SHADED"/>-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt">
            <fo:marker marker-class-name="test"/>
            <fo:block/>
           </fo:table-cell>
           <!--</tr>-->
          </fo:table-row>
          <xsl:choose>
           <xsl:when test="./rpt:outgoing">
            <xsl:for-each select="./rpt:outgoing">
             <xsl:variable name="seqFlowID" select="@rpt:id"/>
             <xsl:variable name="flowNodeID"
                           select="//rpt:relationship[@rpt:id=$seqFlowID]/@rpt:targetObject"/>
             <!-- <tr> -->
             <fo:table-row keep-with-next="always">
              <!--<th class="FIRST_COL"/>-->
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                             border-style="solid" border-color="#d6d6d6"
                             padding-start="3pt" padding-end="3pt"
                             padding-before="3pt" padding-after="3pt">
               <fo:marker marker-class-name="test"/>
               <fo:block/>
              </fo:table-cell>
              <!--<td class="TABL_5COL">-->
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                             border-style="solid" border-color="#d6d6d6"
                             padding-start="3pt" padding-end="3pt"
                             padding-before="3pt" padding-after="3pt">
               <fo:marker marker-class-name="test"/>
               <fo:block text-align="left" font-size="9pt"
                         font-family="sans-serif">
                <xsl:value-of select="//rpt:relationship[@rpt:id=$seqFlowID]/@rpt:name"/>
               </fo:block>
               <!--</td>-->
              </fo:table-cell>
              <!--<td class="TABL_5COL">-->
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                             border-style="solid" border-color="#d6d6d6"
                             padding-start="3pt" padding-end="3pt"
                             padding-before="3pt" padding-after="3pt">
               <fo:marker marker-class-name="test"/>
               <fo:block text-align="left" font-size="9pt"
                         font-family="sans-serif" wrap-option="wrap">
                <xsl:value-of select="//rpt:relationship[@rpt:id=$seqFlowID]/rpt:property[@rpt:name='description']"/>
               </fo:block>
               <!--</td>-->
              </fo:table-cell>
              <!--<td class="TABL_5COL">-->
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                             border-style="solid" border-color="#d6d6d6"
                             padding-start="3pt" padding-end="3pt"
                             padding-before="3pt" padding-after="3pt">
               <fo:marker marker-class-name="test"/>
               <fo:block text-align="left" font-size="9pt"
                         font-family="sans-serif" wrap-option="wrap">
                <xsl:value-of select="//rpt:relationship[@rpt:id=$seqFlowID]/rpt:property[@rpt:name='condition']"/>
               </fo:block>
               <!--</td>-->
              </fo:table-cell>
              <!--<td class="TABL_5COL">-->
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                             border-style="solid" border-color="#d6d6d6"
                             padding-start="3pt" padding-end="3pt"
                             padding-before="3pt" padding-after="3pt">
               <fo:marker marker-class-name="test"/>
               <fo:block text-align="left" font-size="9pt"
                         font-family="sans-serif" wrap-option="wrap">
                <fo:basic-link color="blue"
                               internal-destination="{//rpt:bpmObject[@rpt:id=$flowNodeID]/@rpt:id}">
                 <xsl:value-of select="//rpt:bpmObject[@rpt:id=$flowNodeID]/@rpt:name"/>
                </fo:basic-link>
               </fo:block>
               <!--</td>-->
              </fo:table-cell>
              <!--</tr>-->
             </fo:table-row>
            </xsl:for-each>
           </xsl:when>
           <xsl:otherwise>
            <!-- <tr> -->
            <fo:table-row keep-with-next="always">
             <!--<th class="FIRST_COL">&#160;</th>-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt">
              <fo:marker marker-class-name="test"/>
              <fo:block/>
             </fo:table-cell>
             <!--<td class="TABL_5COL"/>-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt">
              <fo:marker marker-class-name="test"/>
              <fo:block/>
             </fo:table-cell>
             <!--<td class="TABL_5COL"/>-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt">
              <fo:marker marker-class-name="test"/>
              <fo:block/>
             </fo:table-cell>
             <!--<td class="TABL_5COL"/>-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt">
              <fo:marker marker-class-name="test"/>
              <fo:block/>
             </fo:table-cell>
             <!--<td class="TABL_5COL"/>-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt">
              <fo:marker marker-class-name="test"/>
              <fo:block/>
             </fo:table-cell>
             <!--</tr>-->
            </fo:table-row>
           </xsl:otherwise>
          </xsl:choose>
          <!-- <tr> -->
          <fo:table-row keep-with-next="always">
           <!--<th class="FIRST_COL">Inflows</th>-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt">
            <fo:marker marker-class-name="test"/>
            <fo:block font-weight="bold" text-align="center" font-size="9pt"
                      font-family="sans-serif">Inflows</fo:block>
           </fo:table-cell>
           <!--<td class="TABL_span" colspan="4">-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt"
                          number-columns-spanned="4">
            <fo:marker marker-class-name="test"/>
            <xsl:for-each select="./rpt:incoming">
             <xsl:variable name="seqFlowID" select="@rpt:id"/>
             <xsl:variable name="flowNodeID"
                           select="//rpt:relationship[@rpt:id=$seqFlowID]/@rpt:sourceObject"/>
             <!--<p class="TABLEPAR">-->
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">
              <fo:basic-link color="blue"
                             internal-destination="{//rpt:bpmObject[@rpt:id=$flowNodeID]/@rpt:id}">
               <xsl:value-of select="//rpt:bpmObject[@rpt:id=$flowNodeID]/@rpt:name"/>
              </fo:basic-link>
              <!--</p>-->
             </fo:block>
            </xsl:for-each>
            <!--</td>-->
           </fo:table-cell>
           <!--</tr>-->
          </fo:table-row>
          <!-- <tr> -->
          <fo:table-row keep-with-next="always">
           <!--<th class="FIRST_COL">Lane</th>-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt">
            <fo:marker marker-class-name="test"/>
            <fo:block font-weight="bold" text-align="center" font-size="9pt"
                      font-family="sans-serif">Lane</fo:block>
           </fo:table-cell>
           <!--<td class="TABL_span" colspan="4">-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt"
                          number-columns-spanned="4">
            <fo:marker marker-class-name="test"/>
            <fo:block text-align="left" font-size="9pt"
                      font-family="sans-serif">
             <fo:basic-link color="blue" internal-destination="{../../@rpt:id}">
              <xsl:value-of select="../../@rpt:name"/>
             </fo:basic-link>
            </fo:block>
            <!--</td>-->
           </fo:table-cell>
           <!--</tr>-->
          </fo:table-row>
          <!-- <tr> -->
          <fo:table-row keep-with-next="always">
           <!--<th class="FIRST_COL">Parent Subprocess</th>-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt">
            <fo:marker marker-class-name="test"/>
            <fo:block font-weight="bold" text-align="center" font-size="9pt"
                      font-family="sans-serif">Parent Subprocess</fo:block>
           </fo:table-cell>
           <xsl:variable name="subProcID"
                         select="./rpt:property[@rpt:name='parentSubprocess']"/>
           <!--<td class="TABL_span" colspan="4">-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt"
                          number-columns-spanned="4">
            <fo:marker marker-class-name="test"/>
            <xsl:choose>
             <xsl:when test="not(//rpt:bpmObject[@rpt:id=$subProcID]/@rpt:id) = ''">
              <fo:block text-align="left" font-size="9pt"
                        font-family="sans-serif">
               <!-- THIS LINK IS CAUSING PROBS WHEN I REMOVE THE '#' -->
               <fo:basic-link color="blue"
                              internal-destination="{//rpt:bpmObject[@rpt:id=$subProcID]/@rpt:id}">
                <xsl:value-of select="//rpt:bpmObject[@rpt:id=$subProcID]/@rpt:name"/>
               </fo:basic-link>
              </fo:block>
             </xsl:when>
             <xsl:otherwise>
              <fo:block/>
             </xsl:otherwise>
            </xsl:choose>
            <!--</td>-->
           </fo:table-cell>
           <!--</tr>-->
          </fo:table-row>
          <!-- <tr> -->
          <fo:table-row keep-with-next="always">
           <!--<th class="FIRST_COL">Use Case Documentation</th>-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt">
            <fo:marker marker-class-name="test"/>
            <fo:block wrap-option="wrap" font-weight="bold" text-align="center"
                      font-size="9pt" font-family="sans-serif">Use Case
                                                               Documentation</fo:block>
           </fo:table-cell>
           <!--<td class="TABL_span" colspan="4">-->
           <fo:table-cell border-collapse="collapse" border-width="0.05em"
                          border-style="solid" border-color="#d6d6d6"
                          padding-start="3pt" padding-end="3pt"
                          padding-before="3pt" padding-after="3pt"
                          number-columns-spanned="4">
            <fo:marker marker-class-name="test"/>
            <fo:block text-align="left" font-size="9pt"
                      font-family="sans-serif">
             <xsl:value-of select="./rpt:property[@rpt:name='useCaseDocumentation']"/>
            </fo:block>
            <!--</td>-->
           </fo:table-cell>
           <!--</tr>-->
          </fo:table-row>
          <xsl:choose>
           <xsl:when test="./rpt:propertyGroup[@name='Annotations']">
            <!-- <tr> -->
            <fo:table-row keep-with-next="always">
             <!--<th class="FIRST_COL">Annotations</th>-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt">
              <fo:marker marker-class-name="test"/>
              <fo:block font-weight="bold" text-align="center" font-size="9pt"
                        font-family="sans-serif">Annotations</fo:block>
             </fo:table-cell>
             <!--<td class="TABL_span" colspan="4"/>-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt"
                            number-columns-spanned="4">
              <fo:marker marker-class-name="test"/>
              <fo:block/>
             </fo:table-cell>
             <!--</tr>-->
            </fo:table-row>
            <xsl:for-each select="./rpt:propertyGroup[@name='Annotations']">
             <!-- <tr> -->
             <fo:table-row keep-with-next="always">
              <!--<th class="FIRST_COL"/>-->
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                             border-style="solid" border-color="#d6d6d6"
                             padding-start="3pt" padding-end="3pt"
                             padding-before="3pt" padding-after="3pt">
               <fo:marker marker-class-name="test"/>
               <fo:block/>
              </fo:table-cell>
              <!--<th class="TABL_span TABL_CENTER" colspan="2">
																	<xsl:value-of select="@rpt:name_heading"/>
																</th>-->
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                             border-style="solid" border-color="#d6d6d6"
                             padding-start="3pt" padding-end="3pt"
                             padding-before="3pt" padding-after="3pt"
                             number-columns-spanned="2">
               <fo:marker marker-class-name="test"/>
               <fo:block font-weight="bold" text-align="center" font-size="9pt"
                         font-family="sans-serif">
                <xsl:value-of select="@name_heading"/>
               </fo:block>
              </fo:table-cell>
              <!--<th class="TABL_span TABL_CENTER" colspan="2">
																	<xsl:value-of select="@rpt:value_heading"/>
																</th>-->
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                             border-style="solid" border-color="#d6d6d6"
                             padding-start="3pt" padding-end="3pt"
                             padding-before="3pt" padding-after="3pt"
                             number-columns-spanned="2">
               <fo:marker marker-class-name="test"/>
               <fo:block font-weight="bold" text-align="center" font-size="9pt"
                         font-family="sans-serif">
                <xsl:value-of select="@value_heading"/>
               </fo:block>
              </fo:table-cell>
              <!--</tr>-->
             </fo:table-row>
             <xsl:for-each select="./rpt:propertyGroup">
              <!-- <tr> -->
              <fo:table-row>
               <!--<th class="FIRST_COL"/>-->
               <fo:table-cell border-collapse="collapse" border-width="0.05em"
                              border-style="solid" border-color="#d6d6d6"
                              padding-start="3pt" padding-end="3pt"
                              padding-before="3pt" padding-after="3pt">
                <fo:marker marker-class-name="test"/>
                <fo:block/>
               </fo:table-cell>
               <!--<td class="TABL_span" colspan="2">-->
               <fo:table-cell border-collapse="collapse" border-width="0.05em"
                              border-style="solid" border-color="#d6d6d6"
                              padding-start="3pt" padding-end="3pt"
                              padding-before="3pt" padding-after="3pt"
                              number-columns-spanned="2">
                <fo:marker marker-class-name="test"/>
                <fo:block text-align="left" font-size="9pt"
                          font-family="sans-serif">
                 <xsl:value-of select="./rpt:property[@rpt:name='Key']"/>
                </fo:block>
                <!--</td>-->
               </fo:table-cell>
               <!--<td class="TABL_span" colspan="2">-->
               <fo:table-cell border-collapse="collapse" border-width="0.05em"
                              border-style="solid" border-color="#d6d6d6"
                              padding-start="3pt" padding-end="3pt"
                              padding-before="3pt" padding-after="3pt"
                              number-columns-spanned="2">
                <fo:marker marker-class-name="test"/>
                <fo:block text-align="left" font-size="9pt"
                          font-family="sans-serif">
                 <xsl:value-of select="./rpt:property[@rpt:name='Value']"/>
                </fo:block>
                <!--</td>-->
               </fo:table-cell>
               <!--</tr>-->
              </fo:table-row>
             </xsl:for-each>
            </xsl:for-each>
           </xsl:when>
           <xsl:otherwise>
            <!-- <tr> -->
            <fo:table-row>
             <!--<th class="FIRST_COL">Annotations</th>-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt">
              <fo:marker marker-class-name="test"/>
              <fo:block font-weight="bold" text-align="center" font-size="9pt"
                        font-family="sans-serif">Annotations</fo:block>
             </fo:table-cell>
             <!--<td class="TABL_span" colspan="4">-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt"
                            number-columns-spanned="4">
              <fo:marker marker-class-name="test"/>
              <fo:block text-align="left" font-size="9pt"
                        font-family="sans-serif">NONE</fo:block>
              <!--</td>-->
             </fo:table-cell>
             <!--</tr>-->
            </fo:table-row>
           </xsl:otherwise>
          </xsl:choose>
          <!-- 
          <xsl:choose>
           <xsl:when test="./rpt:propertyGroup[@name='Declarations']">
            <fo:table-row keep-with-next="always">
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt">
              <fo:marker marker-class-name="test"/>
              <fo:block font-weight="bold" text-align="center" font-size="9pt"
                        font-family="sans-serif">Declarations</fo:block>
             </fo:table-cell>
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt"
                            number-columns-spanned="4">
              <fo:marker marker-class-name="test"/>
              <fo:block/>
             </fo:table-cell>
            </fo:table-row>
            <xsl:for-each select="./rpt:propertyGroup[@name='Declarations']">
             <fo:table-row keep-with-next="always">
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                             border-style="solid" border-color="#d6d6d6"
                             padding-start="3pt" padding-end="3pt"
                             padding-before="3pt" padding-after="3pt">
               <fo:marker marker-class-name="test"/>
               <fo:block/>
              </fo:table-cell>
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                             border-style="solid" border-color="#d6d6d6"
                             padding-start="3pt" padding-end="3pt"
                             padding-before="3pt" padding-after="3pt"
                             number-columns-spanned="2">
               <fo:marker marker-class-name="test"/>
               <fo:block font-weight="bold" text-align="center" font-size="9pt"
                         font-family="sans-serif">
                <xsl:value-of select="@name_heading"/>
               </fo:block>
              </fo:table-cell>
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                             border-style="solid" border-color="#d6d6d6"
                             padding-start="3pt" padding-end="3pt"
                             padding-before="3pt" padding-after="3pt"
                             number-columns-spanned="2">
               <fo:marker marker-class-name="test"/>
               <fo:block font-weight="bold" text-align="center" font-size="9pt"
                         font-family="sans-serif">
                <xsl:value-of select="@value_heading"/>
               </fo:block>
              </fo:table-cell>
             </fo:table-row>
             <xsl:for-each select="./rpt:propertyGroup">
              <fo:table-row keep-with-next="always">
               <fo:table-cell border-collapse="collapse" border-width="0.05em"
                              border-style="solid" border-color="#d6d6d6"
                              padding-start="3pt" padding-end="3pt"
                              padding-before="3pt" padding-after="3pt">
                <fo:marker marker-class-name="test"/>
                <fo:block/>
               </fo:table-cell>
               <fo:table-cell border-collapse="collapse" border-width="0.05em"
                              border-style="solid" border-color="#d6d6d6"
                              padding-start="3pt" padding-end="3pt"
                              padding-before="3pt" padding-after="3pt"
                              number-columns-spanned="2">
                <fo:marker marker-class-name="test"/>
                <fo:block text-align="left" font-size="9pt"
                          font-family="sans-serif">
                 <xsl:value-of select="./rpt:property[@rpt:name='Name']"/>
                </fo:block>
               </fo:table-cell>
               <fo:table-cell border-collapse="collapse" border-width="0.05em"
                              border-style="solid" border-color="#d6d6d6"
                              padding-start="3pt" padding-end="3pt"
                              padding-before="3pt" padding-after="3pt"
                              number-columns-spanned="2">
                <fo:marker marker-class-name="test"/>
                <fo:block text-align="left" font-size="9pt"
                          font-family="sans-serif">
                 <xsl:value-of select="./rpt:property[@rpt:name='DeclarationType']"/>
                </fo:block>
               </fo:table-cell>
              </fo:table-row>
             </xsl:for-each>
            </xsl:for-each>
           </xsl:when>
           <xsl:otherwise>
            <fo:table-row keep-with-next="always">
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt">
              <fo:marker marker-class-name="test"/>
              <fo:block text-align="center" font-size="9pt"
                        font-family="sans-serif">Declarations</fo:block>
             </fo:table-cell>
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt"
                            number-columns-spanned="4">
              <fo:marker marker-class-name="test"/>
              <fo:block text-align="left" font-size="9pt"
                        font-family="sans-serif">NONE</fo:block>
             </fo:table-cell>
            </fo:table-row>
           </xsl:otherwise>
          </xsl:choose>
          <xsl:choose>
           <xsl:when test="./rpt:propertyGroup[@name='Local Declarations']">
            <fo:table-row keep-with-next="always">
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt">
              <fo:marker marker-class-name="test"/>
              <fo:block text-align="center" font-size="9pt"
                        font-family="sans-serif">Local Declarations</fo:block>
             </fo:table-cell>
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt"
                            number-columns-spanned="4">
              <fo:marker marker-class-name="test"/>
              <fo:block/>
             </fo:table-cell>
            </fo:table-row>
            <xsl:for-each select="./rpt:propertyGroup[@name='Local Declarations']">
             <fo:table-row keep-with-next="always">
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                             border-style="solid" border-color="#d6d6d6"
                             padding-start="3pt" padding-end="3pt"
                             padding-before="3pt" padding-after="3pt">
               <fo:marker marker-class-name="test"/>
               <fo:block/>
              </fo:table-cell>
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                             border-style="solid" border-color="#d6d6d6"
                             padding-start="3pt" padding-end="3pt"
                             padding-before="3pt" padding-after="3pt"
                             number-columns-spanned="2">
               <fo:marker marker-class-name="test"/>
               <fo:block text-align="left" font-size="9pt"
                         font-family="sans-serif">
                <xsl:value-of select="@name_heading"/>
               </fo:block>
              </fo:table-cell>
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                             border-style="solid" border-color="#d6d6d6"
                             padding-start="3pt" padding-end="3pt"
                             padding-before="3pt" padding-after="3pt"
                             number-columns-spanned="4">
               <fo:marker marker-class-name="test"/>
               <fo:block text-align="left" font-size="9pt"
                         font-family="sans-serif">
                <xsl:value-of select="@value_heading"/>
               </fo:block>
              </fo:table-cell>
             </fo:table-row>
             <xsl:for-each select="./rpt:propertyGroup">
              <fo:table-row keep-with-next="always">
               <fo:table-cell border-collapse="collapse" border-width="0.05em"
                              border-style="solid" border-color="#d6d6d6"
                              padding-start="3pt" padding-end="3pt"
                              padding-before="3pt" padding-after="3pt">
                <fo:marker marker-class-name="test"/>
                <fo:block/>
               </fo:table-cell>
               <fo:table-cell border-collapse="collapse" border-width="0.05em"
                              border-style="solid" border-color="#d6d6d6"
                              padding-start="3pt" padding-end="3pt"
                              padding-before="3pt" padding-after="3pt"
                              number-columns-spanned="2">
                <fo:marker marker-class-name="test"/>
                <fo:block text-align="left" font-size="9pt"
                          font-family="sans-serif">
                 <xsl:value-of select="./rpt:property[@rpt:name='Name']"/>
                </fo:block>
               </fo:table-cell>
               <fo:table-cell border-collapse="collapse" border-width="0.05em"
                              border-style="solid" border-color="#d6d6d6"
                              padding-start="3pt" padding-end="3pt"
                              padding-before="3pt" padding-after="3pt"
                              number-columns-spanned="2">
                <fo:marker marker-class-name="test"/>
                <fo:block text-align="left" font-size="9pt"
                          font-family="sans-serif">
                 <xsl:value-of select="./rpt:property[@rpt:name='DeclarationType']"/>
                </fo:block>
               </fo:table-cell>
              </fo:table-row>
             </xsl:for-each>
            </xsl:for-each>
           </xsl:when>
           <xsl:otherwise>
            <fo:table-row keep-with-next="always">
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt">
              <fo:marker marker-class-name="test"/>
              <fo:block text-align="center" font-size="9pt"
                        font-family="sans-serif">Local Declarations</fo:block>
             </fo:table-cell>
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt"
                            number-columns-spanned="4">
              <fo:block text-align="left" font-size="9pt"
                        font-family="sans-serif">NONE</fo:block>
             </fo:table-cell>
            </fo:table-row>
           </xsl:otherwise>
          </xsl:choose>-->
          <xsl:if test="./rpt:property[@rpt:name='trigger']">
           <fo:table-row keep-with-next="always">
            <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="center" font-size="9pt"
                       font-family="sans-serif">Event Trigger</fo:block>
            </fo:table-cell>
            <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           number-columns-spanned="4">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">
              <xsl:value-of select="./rpt:property[@rpt:name='trigger']"/>
             </fo:block>
            </fo:table-cell>
           </fo:table-row>
          </xsl:if>
          <xsl:if test="./rpt:property[@rpt:name='eventDefinition']">
           <!-- <tr> -->
           <fo:table-row>
            <!--<th class="FIRST_COL">Event Definition</th>-->
            <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="center" font-size="9pt"
                       font-family="sans-serif">Event Definition</fo:block>
            </fo:table-cell>
            <!--<td class="TABL_span" colspan="4">-->
            <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           number-columns-spanned="4">
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">
              <xsl:value-of select="./rpt:property[@rpt:name='eventDefinition']"/>
             </fo:block>
             <!--</td>-->
            </fo:table-cell>
            <!--</tr>-->
           </fo:table-row>
          </xsl:if>
          <xsl:if test="./rpt:property[@rpt:name='gatewayDirection']">
           <!-- <tr> -->
           <fo:table-row>
            <!--<th class="FIRST_COL">Gateway Direction</th>-->
            <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="center" font-size="9pt"
                       font-family="sans-serif">Gateway Direction</fo:block>
            </fo:table-cell>
            <!--<td class="TABL_span" colspan="4">-->
            <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           number-columns-spanned="4">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">
              <xsl:value-of select="./rpt:property[@rpt:name='gatewayDirection']"/>
             </fo:block>
             <!--</td>-->
            </fo:table-cell>
            <!--</tr>-->
           </fo:table-row>
          </xsl:if>
          <xsl:if test="./rpt:property[@rpt:name='LoopCharacteristicsType']">
           <!-- <tr> -->
           <fo:table-row keep-with-next="always">
            <!--<th class="FIRST_COL">Loop Type</th>-->
            <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="center" font-size="9pt"
                       font-family="sans-serif">Loop Type</fo:block>
            </fo:table-cell>
            <!--<td class="TABL_span" colspan="4">-->
            <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           number-columns-spanned="4">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">
              <xsl:value-of select="./rpt:property[@rpt:name='LoopCharacteristicsType']"/>
             </fo:block>
             <!--</td>-->
            </fo:table-cell>
            <!--</tr>-->
           </fo:table-row>
          </xsl:if>
          <xsl:choose>
           <xsl:when test="./rpt:propertyGroup[@name='Features']">
            <!-- <tr> -->
            <fo:table-row keep-with-next="always">
             <!--<th class="FIRST_COL">Features</th>-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt">
              <fo:marker marker-class-name="test"/>
              <fo:block text-align="center" font-size="9pt"
                        font-family="sans-serif">Features</fo:block>
             </fo:table-cell>
             <!--<td class="TABL_span" colspan="4"/>-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt"
                            number-columns-spanned="4">
              <fo:marker marker-class-name="test"/>
              <fo:block/>
             </fo:table-cell>
             <!--</tr>-->
            </fo:table-row>
            <xsl:for-each select="./rpt:propertyGroup[@name='Features']">
             <!-- <tr> -->
             <fo:table-row>
              <!--<th class="FIRST_COL"/>-->
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                             border-style="solid" border-color="#d6d6d6"
                             padding-start="3pt" padding-end="3pt"
                             padding-before="3pt" padding-after="3pt">
               <fo:marker marker-class-name="test"/>
               <fo:block/>
              </fo:table-cell>
              <!--<th class="TABL_span TABL_CENTER" colspan="2">-->
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                             border-style="solid" border-color="#d6d6d6"
                             padding-start="3pt" padding-end="3pt"
                             padding-before="3pt" padding-after="3pt"
                             number-columns-spanned="2">
               <fo:marker marker-class-name="test"/>
               <fo:block text-align="left" font-size="9pt"
                         font-family="sans-serif">
                <xsl:value-of select="@name_heading"/>
               </fo:block>
              </fo:table-cell>
              <!--</th>-->
              <!--<th class="TABL_span TABL_CENTER" colspan="2">-->
              <fo:table-cell border-collapse="collapse" border-width="0.05em"
                             border-style="solid" border-color="#d6d6d6"
                             padding-start="3pt" padding-end="3pt"
                             padding-before="3pt" padding-after="3pt"
                             number-columns-spanned="2">
               <fo:marker marker-class-name="test"/>
               <fo:block text-align="left" font-size="9pt"
                         font-family="sans-serif">
                <xsl:value-of select="@value_heading"/>
               </fo:block>
              </fo:table-cell>
              <!--</th>-->
              <!--</tr>-->
             </fo:table-row>
             <xsl:for-each select="./rpt:propertyGroup">
              <!-- <tr> -->
              <fo:table-row keep-with-next="always">
               <!--<th class="FIRST_COL"/>-->
               <fo:table-cell border-collapse="collapse" border-width="0.05em"
                              border-style="solid" border-color="#d6d6d6"
                              padding-start="3pt" padding-end="3pt"
                              padding-before="3pt" padding-after="3pt">
                <fo:marker marker-class-name="test"/>
                <fo:block/>
               </fo:table-cell>
               <!--<td class="TABL_span" colspan="2">-->
               <fo:table-cell border-collapse="collapse" border-width="0.05em"
                              border-style="solid" border-color="#d6d6d6"
                              padding-start="3pt" padding-end="3pt"
                              padding-before="3pt" padding-after="3pt"
                              number-columns-spanned="2">
                <fo:marker marker-class-name="test"/>
                <fo:block text-align="left" font-size="9pt"
                          font-family="sans-serif">
                 <xsl:value-of select="./rpt:property[@rpt:name='Name']"/>
                </fo:block>
                <!--</td>-->
               </fo:table-cell>
               <!--<td class="TABL_span" colspan="2">-->
               <fo:table-cell border-collapse="collapse" border-width="0.05em"
                              border-style="solid" border-color="#d6d6d6"
                              padding-start="3pt" padding-end="3pt"
                              padding-before="3pt" padding-after="3pt"
                              number-columns-spanned="2">
                <fo:marker marker-class-name="test"/>
                <fo:block text-align="left" font-size="9pt"
                          font-family="sans-serif">
                 <xsl:value-of select="./rpt:property[@rpt:name='Value']"/>
                </fo:block>
                <!--</td>-->
               </fo:table-cell>
               <!--</tr>-->
              </fo:table-row>
             </xsl:for-each>
            </xsl:for-each>
           </xsl:when>
           <xsl:otherwise>
            <!-- <tr> -->
            <fo:table-row keep-with-next="always">
             <!--<th class="FIRST_COL">Features</th>-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt">
              <fo:marker marker-class-name="test"/>
              <fo:block text-align="center" font-size="9pt"
                        font-family="sans-serif">Features</fo:block>
             </fo:table-cell>
             <!--<td class="TABL_span" colspan="4">-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt"
                            number-columns-spanned="4">
              <fo:marker marker-class-name="test"/>
              <fo:block text-align="left" font-size="9pt"
                        font-family="sans-serif">NONE</fo:block>
              <!--</td>-->
             </fo:table-cell>
             <!--</tr>-->
            </fo:table-row>
           </xsl:otherwise>
          </xsl:choose>
          <xsl:for-each select="./rpt:propertyGroup[@name='Boundary Events']">
           <!-- <tr> -->
           <fo:table-row keep-with-next="always">
            <!--<th class="FIRST_COL">Boundary Events</th>-->
            <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">Boundry Events</fo:block>
            </fo:table-cell>
            <!--<td class="TABL_span" colspan="4"/>-->
            <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           number-columns-spanned="4">
             <fo:marker marker-class-name="test"/>
             <fo:block/>
             <!--</td>-->
            </fo:table-cell>
            <!--</tr>-->
           </fo:table-row>
           <!-- <tr> -->
           <fo:table-row keep-with-next="always">
            <!--<th class="FIRST_COL"/>-->
            <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt">
             <fo:marker marker-class-name="test"/>
             <fo:block/>
            </fo:table-cell>
            <!--<th class="TABL_span TABL_CENTER" colspan="2">-->
            <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           number-columns-spanned="2">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">
              <xsl:value-of select="@name_heading"/>
             </fo:block>
            </fo:table-cell>
            <!--</th>-->
            <!--<th class="TABL_span TABL_CENTER" colspan="2">-->
            <fo:table-cell border-collapse="collapse" border-width="0.05em"
                           border-style="solid" border-color="#d6d6d6"
                           padding-start="3pt" padding-end="3pt"
                           padding-before="3pt" padding-after="3pt"
                           number-columns-spanned="2">
             <fo:marker marker-class-name="test"/>
             <fo:block text-align="left" font-size="9pt"
                       font-family="sans-serif">
              <xsl:value-of select="@value_heading"/>
             </fo:block>
             <!--</th>-->
            </fo:table-cell>
            <!--</tr>-->
           </fo:table-row>
           <xsl:for-each select="./rpt:propertyGroup">
            <!-- <tr> -->
            <fo:table-row keep-with-next="always">
             <!--<th class="FIRST_COL"/>-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt">
              <fo:marker marker-class-name="test"/>
              <fo:block/>
             </fo:table-cell>
             <!--<td class="TABL_span" colspan="2">-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt"
                            number-columns-spanned="2">
              <fo:basic-link color="blue"
                             internal-destination="{./rpt:property[@rpt:name='EventID']}">
               <xsl:value-of select="./rpt:property[@rpt:name='EventName']"/>
              </fo:basic-link>
              <!--</td>-->
             </fo:table-cell>
             <!--<td class="TABL_span" colspan="2">-->
             <fo:table-cell border-collapse="collapse" border-width="0.05em"
                            border-style="solid" border-color="#d6d6d6"
                            padding-start="3pt" padding-end="3pt"
                            padding-before="3pt" padding-after="3pt"
                            number-columns-spanned="2">
              <fo:basic-link color="blue"
                             internal-destination="{./rpt:property[@rpt:name='LeadsToID']}">
               <xsl:value-of select="./rpt:property[@rpt:name='LeadsToName']"/>
              </fo:basic-link>
              <!--</td>-->
             </fo:table-cell>
             <!--</tr>-->
            </fo:table-row>
           </xsl:for-each>
          </xsl:for-each>
          <!--</table>-->
         </fo:table-body>
        </fo:table>
        <!-- block to replace /br -->
        <fo:block/>
        <fo:block/>
        <fo:block/>
        <fo:block/>
        <!--</div>-->
       </fo:block>
      </xsl:for-each>
      <!--</div>-->
      <!--</fo:block> block surrounding proc steps-->
      <!--end processStepsContent-->
      <!--</div>-->
      <!--</fo:block>
							end ProcessContent-->
      <!--</div>-->
      <!-- THIS DIV WRAPS THE WHOLE PROCESS -->
     </xsl:for-each>
     <fo:block id="introSpace"/>
     <!--</fo:block>
					 end contentWrap-->
     <!--</div>-->
     <!--end contentWrap-->
     <!--				
			</body>
		</html>
-->
    </fo:flow>
    <!-- end flow "region-body"-->
   </fo:page-sequence>
  </fo:root>
 </xsl:template>
</xsl:stylesheet>
