<?xml version="1.0" encoding="UTF-8"?>
<!--
 ...........................................................................................................
//
// Copyright (c) 1993, 2012, Oracle and/or its affiliates. 
// All rights reserved. 
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Oracle Corp.
// The copyright notice above does not evidence any actual or intended
// publication of such source code.
//
// ...........................................................................................................
-->
<!--

    MODIFIED    (MM/DD/YY)
    tkauth      08/27/11 - Created

  -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:rpt="http://www.oracle.com/oracle/bpm/tutor/reporter">

<xsl:output
	method="html"
	omit-xml-declaration="yes"
	doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
	doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    encoding="UTF-8"
	indent="yes"/>

<xsl:template match="/">

<html>
<head>
  <link rel="stylesheet" type="text/css" href="resources/css/BPMReport.css" media="screen"></link>
  <link rel="stylesheet" type="text/css" href="resources/css/BPMReportPrint.css" media="print"></link>
  <script type="text/javascript" src="resources/js/ReportScripts.js"></script>
  <title><xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='processReportDisplay']/@rpt:display_name"/></title>
</head>
<body onresize="SetContentHeight();" onload="setImgDir('resources/img/');Init();">

<div id="alwaysVisible">
  <table width="100%">
    <tr>
      <td class="RPT_META"></td>
      <td class="DOCTITLE">
        <xsl:choose>
          <xsl:when test="//rpt:bpmObject[@rpt:objectType='PROJECT']/@rpt:name">
            <xsl:value-of select="//rpt:bpmObject[@rpt:objectType='PROJECT']/@rpt:name"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="//rpt:bpmObject[@rpt:objectType='PROCESS']/rpt:property[@rpt:name='project']"/> : <xsl:value-of select="//rpt:bpmObject[@rpt:objectType='PROCESS']/@rpt:name"/>
          </xsl:otherwise>
        </xsl:choose>
        <br/><xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='processReportDisplay']/@rpt:display_name"/>
      </td>
      <td class="RPT_META"><xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='reportDate']/@rpt:display_name"/>&#160;<xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='reportDate']"/>
      </td>
    </tr>
  </table>
  <div id="introHideShow" class="hideShowLink">
      <a href="#" id="introHideLink" onClick="DisplayIntroDetails(false); return false;"><xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='hideDetailsDisplay']/@rpt:display_name"/></a>
      <a href="#" id="introShowLink" onClick="DisplayIntroDetails(true); return false;"><xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='showDetailsDisplay']/@rpt:display_name"/></a>
  </div>
</div>

<div id="contentWrap">


<xsl:for-each select="//rpt:bpmObject[@rpt:objectType='PROCESS']">
<p class="HEADING1">
  <span id="{@rpt:id}ProcessBtn"
        class="expdCollpsCont processBtn"
        onClick="ShowHideToggle('{@rpt:id}ProcessContent', this.id, this.className);">&#160;</span>&#160;
  <xsl:value-of select="@rpt:name"/>
</p>

<div id="{@rpt:id}ProcessContent" class="processContent">


<p class="HEADING1">
  <span id="{@rpt:id}processDataBtn"
        class="expdCollpsCont"
        onClick="ShowHideToggle('{@rpt:id}processDataContent', this.id, this.className);">&#160;</span>&#160;
  <xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='processPropsDisplay']/@rpt:display_name"/>
</p>

<div id="{@rpt:id}processDataContent" class="introContent">


  <table class="TABLE" summary="">
    <tr>
      <th class="FIRST_COL"><xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='procNameDisplay']/@rpt:display_name"/></th>
      <td class="TABL_SPAN" colspan="2"><xsl:value-of select="@rpt:name"/></td>
    </tr>
    <tr>
      <th class="FIRST_COL"><xsl:value-of select="./rpt:property[@rpt:name='author']/@rpt:display_name"/></th>
      <td class="TABL_SPAN" colspan="2"><xsl:value-of select="./rpt:property[@rpt:name='author']"/></td>
    </tr>
    <tr>
      <th class="FIRST_COL"><xsl:value-of select="./rpt:property[@rpt:name='description']/@rpt:display_name"/></th>
      <td class="TABL_SPAN" colspan="2"><xsl:value-of select="./rpt:property[@rpt:name='description']"/></td>
    </tr>
    <tr>
      <th class="FIRST_COL"><xsl:value-of select="./rpt:property[@rpt:name='project']/@rpt:display_name"/></th>
      <td class="TABL_SPAN" colspan="2"><xsl:value-of select="./rpt:property[@rpt:name='project']"/></td>
    </tr>
    <tr>
      <th class="FIRST_COL"><xsl:value-of select="./rpt:property[@rpt:name='useCaseDocumentation']/@rpt:display_name"/></th>
      <td class="TABL_SPAN" colspan="2"><xsl:value-of select="./rpt:property[@rpt:name='useCaseDocumentation']" disable-output-escaping="yes" /></td>
    </tr>


      <xsl:choose>
      <xsl:when test="./rpt:propertyGroup[@name='Declarations']/rpt:propertyGroup">
        <tr>
          <th class="FIRST_COL"><xsl:value-of select="./rpt:propertyGroup[@name='Declarations']/@rpt:display_name"/></th>
          <td class="TABL_SPAN" colspan="2"></td>
        </tr>
        <xsl:for-each select="./rpt:propertyGroup[@name='Declarations']">
          <tr>
            <th class="FIRST_COL"></th>
            <th class="TABL_SPAN TABL_CENTER"><xsl:value-of select="@name_heading"/></th>
            <th class="TABL_SPAN TABL_CENTER"><xsl:value-of select="@value_heading"/></th>
          </tr>
          <xsl:for-each select="./rpt:propertyGroup">
            <tr>
              <th class="FIRST_COL"></th>
              <td class="TABL_3COL"><xsl:value-of select="./rpt:property[@rpt:name='Name']"/></td>
            <td class="TABL_3COL"><xsl:value-of select="./rpt:property[@rpt:name='DeclarationType']"/></td>
            </tr>
          </xsl:for-each>
          </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <tr>
          <th class="FIRST_COL"><xsl:value-of select="./rpt:propertyGroup[@name='Declarations']/@rpt:display_name"/></th>
          <td class="TABL_SPAN" colspan="2"><xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='noneDisplay']/@rpt:display_name"/></td>
        </tr>
      </xsl:otherwise>
      </xsl:choose>

      <xsl:choose>
      <xsl:when test="./rpt:propertyGroup[@name='Local Declarations']/rpt:propertyGroup">
        <tr>
          <th class="FIRST_COL"><xsl:value-of select="./rpt:propertyGroup[@name='Local Declarations']/@rpt:display_name"/></th>
          <td class="TABL_SPAN" colspan="2"></td>
        </tr>
        <xsl:for-each select="./rpt:propertyGroup[@name='Local Declarations']">
          <tr>
            <th class="FIRST_COL"></th>
            <th class="TABL_SPAN TABL_CENTER"><xsl:value-of select="@name_heading"/></th>
            <th class="TABL_SPAN TABL_CENTER"><xsl:value-of select="@value_heading"/></th>
          </tr>
          <xsl:for-each select="./rpt:propertyGroup">
            <tr>
              <th class="FIRST_COL"></th>
              <td class="TABL_3COL"><xsl:value-of select="./rpt:property[@rpt:name='Name']"/></td>
            <td class="TABL_3COL"><xsl:value-of select="./rpt:property[@rpt:name='DeclarationType']"/></td>
            </tr>
          </xsl:for-each>
          </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <tr>
          <th class="FIRST_COL"><xsl:value-of select="./rpt:propertyGroup[@name='Local Declarations']/@rpt:display_name"/></th>
          <td class="TABL_SPAN" colspan="2"><xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='noneDisplay']/@rpt:display_name"/></td>
        </tr>
      </xsl:otherwise>
      </xsl:choose>
  </table>
</div>


<p class="HEADING1">
  <span id="{@rpt:id}processImageBtn"
        class="expdCollpsCont"
        onClick="ShowHideToggle('{@rpt:id}processImageContent', this.id, this.className);">&#160;</span>&#160;
  <xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='processImgDisplay']/@rpt:display_name"/>
</p>
<div id="{@rpt:id}processImageContent" class="introContent processImageContent">

<!--<xsl:variable name="imageName" select="./rpt:property[@rpt:name='imgName']"/>-->
  <img>
    <!--<xsl:attribute name="src"><xsl:value-of select="$imageName"/>-->
    <xsl:attribute name="src"><xsl:value-of select="escape-html-uri(./rpt:property[@rpt:name='imgName'])"/>
    </xsl:attribute>
  </img>
</div><!--end processImageContent-->

<p class="HEADING1">
  <span id="{@rpt:id}lanesHeadBtn"
        class="expdCollpsCont"
        onClick="ShowHideToggle('{@rpt:id}lanesHeadContent', this.id, this.className);">&#160;</span>&#160;
  <xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='lanesDisplay']/@rpt:display_name"/>
</p>

<div id="{@rpt:id}lanesHeadContent" class="introContent">

<xsl:for-each select="./rpt:bpmObjects/rpt:bpmObject[@rpt:objectType='Lane']">
<a name="{@rpt:id}"/>
<p class="HEADING2">
  <span id="{@rpt:id}Btn"
        class="expdCollpsCont"
        onClick="ShowHideToggle('{@rpt:id}Content', this.id, this.className);">&#160;&#160;</span>
  <xsl:value-of select="@rpt:name"/>
</p>
<div id="{@rpt:id}Content" class="introContent">
  <table class="TABLE" summary="">
    <tr>
      <th class="FIRST_COL"><xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='objNameDisplay']/@rpt:display_name"/></th>
      <td class="TABL_SPAN" colspan="2"><xsl:value-of select="@rpt:name"/></td>
    </tr>
    <tr>
      <th class="FIRST_COL"><xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='objTypeDisplay']/@rpt:display_name"/></th>
      <td class="TABL_SPAN" colspan="2"><xsl:value-of select="@rpt:objectType"/></td>
    </tr>
<!--    Lane Description temporarily commented out until users can add description to Lane in UI
    <tr>
      <th class="FIRST_COL"><xsl:value-of select="./rpt:property[@rpt:name='description']/@rpt:display_name"/></th>
      <td class="TABL_SPAN" colspan="2"><xsl:value-of select="./rpt:property[@rpt:name='description']"/></td>
    </tr>
-->
    <tr>
      <th class="FIRST_COL"><xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='processStepsDisplay']/@rpt:display_name"/></th>
      <td class="TABL_SPAN" colspan="2"></td>
    </tr>
    <tr>
      <th class="FIRST_COL"></th>
      <th class="TABL_3COL TABL_CENTER"><xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='objNameDisplay']/@rpt:display_name"/></th>
      <th class="TABL_3COL TABL_CENTER"><xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='objTypeDisplay']/@rpt:display_name"/></th>
    </tr>
    <xsl:for-each select="./rpt:bpmObjects/rpt:bpmObject">
      <tr>
        <th class="FIRST_COL"></th>
        <td class="TABL_3COL"><a href='#{escape-html-uri(@rpt:id)}' onclick="ExpandContent('{@rpt:id}')"><xsl:value-of select="@rpt:name"/></a></td>
        <td class="TABL_3COL"><xsl:value-of select="@rpt:objectType"/></td>
      </tr>
    </xsl:for-each>
  </table>
  <br/>
  <br/>
</div> <!--end LaneContent-->
</xsl:for-each>

</div> <!--end lanesHeadContent-->

<p class="HEADING1">
  <span id="{@rpt:id}processStepsBtn"
        class="expdCollpsCont"
        onClick="ShowHideToggle('{@rpt:id}processStepsContent', this.id, this.className);">&#160;</span>&#160;
  <xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='processStepsDisplay']/@rpt:display_name"/>
</p>
<div id="{@rpt:id}processStepsContent" class="introContent">

  <xsl:for-each select="./rpt:bpmObjects/rpt:bpmObject[@rpt:objectType='Lane']/rpt:bpmObjects/rpt:bpmObject">
    <!-- SORT objects by alpha -->
    <xsl:sort select="./@rpt:name" order="ascending" data-type="text"/>

    <a name="{@rpt:id}"/>
    <p class="HEADING1">
      <span id="{@rpt:id}Btn"
            class="expdCollpsCont"
            onClick="ShowHideToggle('{@rpt:id}Content', this.id, this.className);">&#160;</span>&#160;
      <xsl:value-of select="@rpt:name"/>
    </p>
    <div id="{@rpt:id}Content" class="introContent">

      <table class="TABLE" summary="">
      <tr>
        <th class="FIRST_COL"><xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='objNameDisplay']/@rpt:display_name"/></th>
        <td class="TABL_SPAN" colspan="4"><xsl:value-of select="@rpt:name"/></td>
      </tr>

      <tr>
        <th class="FIRST_COL"><xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='objTypeDisplay']/@rpt:display_name"/></th>
          <td class="TABL_SPAN" colspan="4"><xsl:value-of select="@rpt:objectType"/></td>
      </tr>

      <tr>
        <th class="FIRST_COL"><xsl:value-of select="./rpt:property[@rpt:name='description']/@rpt:display_name"/></th>
          <td class="TABL_SPAN" colspan="4"><xsl:value-of select="./rpt:property[@rpt:name='description']"/></td>
      </tr>

        <tr>
          <th class="FIRST_COL"><xsl:value-of select="//rpt:relationships/rpt:property[@rpt:name='outflowsDisplay']/@rpt:display_name"/></th>
          <td class="TABL_SPAN" colspan="4"></td>
        </tr>
        <tr>
          <th class="FIRST_COL"></th>
          <th class="TABL_SPAN TABL_CENTER" colspan="3"><xsl:value-of select="//rpt:relationships/rpt:property[@rpt:name='seqFlowsDisplay']/@rpt:display_name"/></th>
          <th class="TABL_3COL TABL_CENTER"><xsl:value-of select="//rpt:relationships/rpt:property[@rpt:name='targetObjsDisplay']/@rpt:display_name"/></th>
        </tr>
        <tr>
          <th class="FIRST_COL"></th>
          <th class="TABL_5COL TABL_CENTER"><xsl:value-of select="//rpt:relationships/rpt:property[@rpt:name='seqFlowNameDisplay']/@rpt:display_name"/></th>
          <th class="TABL_5COL TABL_CENTER"><xsl:value-of select="//rpt:relationships/rpt:property[@rpt:name='seqFlowDescDisplay']/@rpt:display_name"/></th>
          <th class="TABL_5COL TABL_CENTER"><xsl:value-of select="//rpt:relationships/rpt:property[@rpt:name='seqFlowCondDisplay']/@rpt:display_name"/></th>
          <th class="SHADED"></th>
        </tr>

      <xsl:choose>
      <xsl:when test="./rpt:outgoing">
        <xsl:for-each select="./rpt:outgoing">
          <xsl:variable name="seqFlowID" select="@rpt:id"/>
          <xsl:variable name="flowNodeID" select="//rpt:relationship[@rpt:id=$seqFlowID]/@rpt:targetObject"/>
          <tr>
            <th class="FIRST_COL"></th>
            <td class="TABL_5COL">
              <xsl:value-of select="//rpt:relationship[@rpt:id=$seqFlowID]/@rpt:name"/>
            </td>
            <td class="TABL_5COL">
              <xsl:value-of select="//rpt:relationship[@rpt:id=$seqFlowID]/rpt:property[@rpt:name='description']"/>
            </td>
            <td class="TABL_5COL">
              <xsl:value-of select="//rpt:relationship[@rpt:id=$seqFlowID]/rpt:property[@rpt:name='condition']"/>
            </td>
            <td class="TABL_5COL"><a href="#{escape-html-uri(//rpt:bpmObject[@rpt:id=$flowNodeID]/@rpt:id)}" onclick="ExpandContent('{//rpt:bpmObject[@rpt:id=$flowNodeID]/@rpt:id}')">
              <xsl:value-of select="//rpt:bpmObject[@rpt:id=$flowNodeID]/@rpt:name"/></a>
            </td>
          </tr>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
          <tr>
            <th class="FIRST_COL">&#160;</th>
            <td class="TABL_5COL"></td>
            <td class="TABL_5COL"></td>
            <td class="TABL_5COL"></td>
            <td class="TABL_5COL"></td>
          </tr>
      </xsl:otherwise>
      </xsl:choose>

      <tr>
        <th class="FIRST_COL"><xsl:value-of select="//rpt:relationships/rpt:property[@rpt:name='inflowsDisplay']/@rpt:display_name"/></th>
        <td class="TABL_SPAN" colspan="4">
          <xsl:for-each select="./rpt:incoming">
          <xsl:variable name="seqFlowID" select="@rpt:id"/>
                <xsl:variable name="flowNodeID" select="//rpt:relationship[@rpt:id=$seqFlowID]/@rpt:sourceObject"/>
                <p class="TABLEPAR"><a href="#{escape-html-uri(//rpt:bpmObject[@rpt:id=$flowNodeID]/@rpt:id)}" onclick="ExpandContent('{//rpt:bpmObject[@rpt:id=$flowNodeID]/@rpt:id}')">
            <xsl:value-of select="//rpt:bpmObject[@rpt:id=$flowNodeID]/@rpt:name"/></a></p>
          </xsl:for-each>
        </td>
      </tr>

      <tr>
        <th class="FIRST_COL"><xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='laneDisplay']/@rpt:display_name"/></th>
          <td class="TABL_SPAN" colspan="4"><a href="#{escape-html-uri(../../@rpt:id)}" onclick="ExpandContent('{../../@rpt:id}')">
          <xsl:value-of select="../../@rpt:name"/></a></td>
      </tr>

      <tr>
        <th class="FIRST_COL"><xsl:value-of select="./rpt:property[@rpt:name='parentSubprocess']/@rpt:display_name"/></th>
        <xsl:variable name="subProcID" select="./rpt:property[@rpt:name='parentSubprocess']"/>
          <td class="TABL_SPAN" colspan="4"><a href="#{escape-html-uri(//rpt:bpmObject[@rpt:id=$subProcID]/@rpt:id)}" onclick="ExpandContent('{//rpt:bpmObject[@rpt:id=$subProcID]/@rpt:id}')">
          <xsl:value-of select="//rpt:bpmObject[@rpt:id=$subProcID]/@rpt:name"/></a></td>
      </tr>

      <tr>
        <th class="FIRST_COL"><xsl:value-of select="./rpt:property[@rpt:name='useCaseDocumentation']/@rpt:display_name"/></th>
          <td class="TABL_SPAN" colspan="4"><xsl:value-of select="./rpt:property[@rpt:name='useCaseDocumentation']" disable-output-escaping="yes" /></td>
      </tr>



      <xsl:choose>
      <xsl:when test="./rpt:propertyGroup[@name='Annotations']/rpt:propertyGroup">
        <tr>
          <th class="FIRST_COL"><xsl:value-of select="./rpt:propertyGroup[@name='Annotations']/@rpt:display_name"/></th>
          <td class="TABL_SPAN" colspan="4"></td>
        </tr>
        <xsl:for-each select="./rpt:propertyGroup[@name='Annotations']">
          <tr>
            <th class="FIRST_COL"></th>
            <th class="TABL_SPAN TABL_CENTER" colspan="2"><xsl:value-of select="@name_heading"/></th>
            <th class="TABL_SPAN TABL_CENTER" colspan="2"><xsl:value-of select="@value_heading"/></th>
          </tr>
          <xsl:for-each select="./rpt:propertyGroup">
            <tr>
              <th class="FIRST_COL"></th>
              <td class="TABL_SPAN" colspan="2"><xsl:value-of select="./rpt:property[@rpt:name='Key']"/></td>
            <td class="TABL_SPAN" colspan="2"><xsl:value-of select="./rpt:property[@rpt:name='Value']"/></td>
            </tr>
          </xsl:for-each>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <tr>
          <th class="FIRST_COL"><xsl:value-of select="./rpt:propertyGroup[@name='Annotations']/@rpt:display_name"/></th>
          <td class="TABL_SPAN" colspan="4"><xsl:value-of select="//rpt:definitions/rpt:property[@rpt:name='noneDisplay']/@rpt:display_name"/></td>
        </tr>
      </xsl:otherwise>
      </xsl:choose>


      <xsl:if test="./rpt:property[@rpt:name='trigger']">
        <tr>
          <th class="FIRST_COL"><xsl:value-of select="./rpt:property[@rpt:name='trigger']/@rpt:display_name"/></th>
        <td class="TABL_SPAN" colspan="4"><xsl:value-of select="./rpt:property[@rpt:name='trigger']"/></td>
        </tr>
      </xsl:if>
      <xsl:if test="./rpt:property[@rpt:name='eventDefinition']">
        <tr>
          <th class="FIRST_COL"><xsl:value-of select="./rpt:property[@rpt:name='eventDefinition']/@rpt:display_name"/></th>
          <td class="TABL_SPAN" colspan="4"><xsl:value-of select="./rpt:property[@rpt:name='eventDefinition']"/></td>
        </tr>
      </xsl:if>
      <xsl:if test="./rpt:property[@rpt:name='gatewayDirection']">
        <tr>
          <th class="FIRST_COL"><xsl:value-of select="./rpt:property[@rpt:name='gatewayDirection']/@rpt:display_name"/></th>
          <td class="TABL_SPAN" colspan="4"><xsl:value-of select="./rpt:property[@rpt:name='gatewayDirection']"/></td>
        </tr>
      </xsl:if>
      <xsl:if test="./rpt:property[@rpt:name='LoopCharacteristicsType']">
        <tr>
          <th class="FIRST_COL"><xsl:value-of select="./rpt:property[@rpt:name='LoopCharacteristicsType']/@rpt:display_name"/></th>
          <td class="TABL_SPAN" colspan="4"><xsl:value-of select="./rpt:property[@rpt:name='LoopCharacteristicsType']"/></td>
        </tr>
      </xsl:if>

      <xsl:for-each select="./rpt:propertyGroup[@name='Boundary Events']">
        <tr>
          <th class="FIRST_COL"><xsl:value-of select="./rpt:propertyGroup[@name='Boundary Events']/@rpt:display_name"/></th>
          <td class="TABL_SPAN" colspan="4"></td>
        </tr>
        <tr>
          <th class="FIRST_COL"></th>
          <th class="TABL_SPAN TABL_CENTER" colspan="2"><xsl:value-of select="@name_heading"/></th>
        <th class="TABL_SPAN TABL_CENTER" colspan="2"><xsl:value-of select="@value_heading"/></th>
        </tr>
        <xsl:for-each select="./rpt:propertyGroup">
          <tr>
            <th class="FIRST_COL"></th>
                <td class="TABL_SPAN" colspan="2"><a href="#{escape-html-uri(./rpt:property[@rpt:name='EventID'])}" onclick="ExpandContent('{./rpt:property[@rpt:name='EventID']}')">
            <xsl:value-of select="./rpt:property[@rpt:name='EventName']"/></a></td>
            <td class="TABL_SPAN" colspan="2"><a href="#{escape-html-uri(./rpt:property[@rpt:name='LeadsToID'])}" onclick="ExpandContent('{./rpt:property[@rpt:name='LeadsToID']}')">
              <xsl:value-of select="./rpt:property[@rpt:name='LeadsToName']"/></a></td>
          </tr>
          </xsl:for-each>
      </xsl:for-each>


      </table>
      <br/>
      <br/>
    </div>
  </xsl:for-each>

</div> <!--end processStepsContent-->

</div> <!--end ProcessContent-->
</xsl:for-each>


<div id="introSpace"/>

</div><!--end contentWrap-->
</body>

</html>
</xsl:template>
</xsl:stylesheet>