/******************************************************************************
 Fuego JS: Timer

 Author: Nicolas Damonte
 Build:  1.00
******************************************************************************/
var isFObjectTimerAlive = false;
var isFObjectTimerPaused = false;
var actionsToPerformDefaultValues 	= new Array();
var actionsToPerformTimerValues 	= new Array();
var actionsReadyToPerform = "";
var secondsOfTimer = -1;
var readyFunctionName = "defaultReadyActionImplementation";

function stopTimer()
{
	isFObjectTimerAlive = false;
}

function resumeTimer()
{
	isFObjectTimerPaused = false;
}

function pauseTimer()
{
	isFObjectTimerPaused = true;
}

function startTimer()
{
	isFObjectTimerAlive = true;
	isFObjectTimerPaused = false;
	updateTimer();
}

function resetTimer()
{
	isFObjectTimerAlive = false;
	isFObjectTimerPaused = false;
	actionsToPerformDefaultValues 	= new Array();
	actionsToPerformTimerValues 	= new Array();
	actionsReadyToPerform = "";
	secondsOfTimer = -1;
}

function updateTimer()
{
	if(isFObjectTimerAlive)
	{
		if(!isFObjectTimerPaused){
            secondsOfTimer = secondsOfTimer + 1;

            checkActionsToPerform();

            if(areActionsToPerform()){
                performReadyActions();
            }
        }

        //Calling every one second
        setTimeout("updateTimer();", 1000);
	}


}

function getTimerValues()
{
    var timerValuesStr = "";
    for (actionId in actionsToPerformTimerValues) {
        if(timerValuesStr != ""){
            timerValuesStr = timerValuesStr + ", ";
        }
		timerValuesStr = timerValuesStr + actionsToPerformTimerValues[actionId];
	}

	return timerValuesStr;
}

function restoreTimerValues(timerValues)
{
    pauseTimer();

    var values = eval("[" + timerValues + "]");
    i = 0;

    for (actionId in actionsToPerformTimerValues) {
        if(values.length > i){
            actionsToPerformTimerValues[actionId] = values[i];
            i = i + 1;
        }
	}

	resumeTimer();
}

function checkActionsToPerform()
{
	for (actionId in actionsToPerformTimerValues) {
		var timeToPerform = actionsToPerformTimerValues[actionId];
		if(timeToPerform != null)
		{
			timeToPerform = timeToPerform - 1;
			if(timeToPerform == 0){
				actionsToPerformTimerValues[actionId] = actionsToPerformDefaultValues[actionId];
				if(actionsReadyToPerform.length > 0){
				    actionsReadyToPerform = actionsReadyToPerform + ",";
				}
				actionsReadyToPerform = actionsReadyToPerform + "'" + actionId + "'";

			}else{
				actionsToPerformTimerValues[actionId] = timeToPerform;
			}
		}
	}
}

function areActionsToPerform(){
    if(actionsReadyToPerform != "")
    {
        return true;
    }else{
        return false;
    }
}

function registerActionToPerform(actionId, timeToPerform)
{
	//Register default value
	actionsToPerformDefaultValues[actionId] = timeToPerform;

	//Is it in progress?
	if(actionsToPerformTimerValues[actionId] == null){
		actionsToPerformTimerValues[actionId] = timeToPerform;
	}
}

function performReadyActions()
{
	pauseTimer();
	var actionsReadyToPerformArray = eval("[" + actionsReadyToPerform + "]");
	eval(readyFunctionName + "(actionsReadyToPerformArray);");
	actionsReadyToPerform = "";
	resumeTimer();
}

function setReadyActionImplementation(functionName){
    readyFunctionName = functionName;
}

function defaultReadyActionImplementation(actionsToPerform)
{
    doXoGraphicAction(23, actionsToPerform, null);
}