<%--
	Copyright (c) 2000 eTopware Inc.  All Rights Reserved
	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF eTopware Inc.
	The copyright notice above does not evidence any actual or intended
	publication of such source code.

	$Id: webXObjectHtml.jsp 98811 2009-06-03 21:59:47Z diegor $
--%>
<%@ page
        session="true"
        import="oracle.bpm.xobject.runtime.*,
           oracle.bpm.xobjectbject.runtime.html.*,
                oracle.bpm.web.execution.impl.WebUtils,
                oracle.bpm.web.execution.*"
        language="java" 
        contentType="text/html;charset=UTF-8"
        %>
<%@ page import="oracle.bpm.web.execution.servlet.ServletExternalContext" %>
<%
    final ExternalContext externalContext = WebUtils.createExternalContext(request, response);
    final ComponentContext invocation = WebUtils.findComponentContext(externalContext);

    final String docKey = (String) invocation.getAttribute(XOConstants.XCONTROLLER_ID_PARAM_NAME);
    final String screenKey = (String) invocation.getAttribute(XOConstants.XSCREEN_ID_PARAM_NAME);
    final String webRootRelativeDir = (String) invocation.getAttribute(XOConstants.ATT_WEBROOT_PATH);

    //Getting controller
    XOExecutionController controller = (XOExecutionController) invocation.getAttribute(docKey);
    //Getting screen
    XScreenHTMLImpl doc = (XScreenHTMLImpl) controller.getCurrentManager().getXScreen();

    //Setting form action URL
    doc.getPage().getForm().setAction(WebUtils.urlForAction("XObject", "controller", externalContext));

    final ExternalContextProperties contextProperties = externalContext.getProperties();
    boolean showHeader = contextProperties.isHeaderVisible();
    boolean showFooter = contextProperties.isFooterVisible();
    boolean showMenu = true; //Backward compatibility
    boolean showMsgInBottom = contextProperties.isMessageAtBottom();
    boolean useRemoteScripting = contextProperties.isAjaxSupported();
    boolean partialRendering = externalContext instanceof ServletExternalContext;  //applicationEnvironment.useFObjectPartialRendering();
    final String portletId = invocation.getPortletId();
%>
<html>
<head>
    <title><%=WebUtils.getTitle(externalContext)%></title>
    <link rel="stylesheet" type="text/css" href="<%=WebUtils.getStyleSheet(externalContext)%>">
<%
    if(doc.isCssEnabled())
    {
        final String cssFilename = doc.getPage().getCssFilename();
        if(cssFilename != null)
        {
            final String cssFile;
            //Extracting the css folder from webRoot/webResources/customDir/myStyle.css => customDir/myStyle.css
            int webRootIndex = cssFilename.indexOf('/');
            webRootIndex = webRootIndex != -1 ? cssFilename.indexOf('/', webRootIndex + 1) : webRootIndex;
            if(webRootIndex != -1){
                cssFile = ".." + webRootRelativeDir + cssFilename.substring(webRootIndex);
            } else {
                //Backward compatibility
                cssFile = "../css/" + cssFilename;
            }
%>
            <link rel="stylesheet" type="text/css" href="<%=cssFile%>">
<%
        }
    }
%>
    <link rel="shortcut icon" type="image/x-icon" href="<%=WebUtils.urlForStaticImage("Application", "LOGO_ICO",externalContext)%>">
    <link rel="icon" type="image/x-icon" href="<%=WebUtils.urlForStaticImage("Application", "LOGO_ICO",externalContext)%>">
</head>
<script type="text/javascript">

    if(window.opener == null || window.name == "main"){
        window.name = "main";
    }else{
        window.name = "BPMObjectPresentation";
    }
            
    var remoteScripting = <%=useRemoteScripting%>;
    var partial = <%=partialRendering%>;
    var docKey = '<%=docKey%>';

    function broadcastViewChangeEvent(viewId){
        try{
            var parentWindow = window.parent;
            if(parentWindow == null){
                parentWindow = window.opener;
            }
            if (parentWindow != null) {
                parentWindow.broadcastViewChangeEvent<%=portletId%>(viewId);
            }
        }catch(e){
            //Not supported
            try{
                //For popups ...
                if(window.parent != null && window.opener != null){
                    window.opener.broadcastViewChangeEvent<%=portletId%>(viewId);
                }
            }catch(e){alert(e.message)}
        }
    }
</script>
<%
    doc.setStyleSheet(WebUtils.getStyleSheet(externalContext));
    String msgString = doc.getHTMLMsgs();

    //todo only for IExplorer!
    //Setting the path to copy and loads the bgImage
    if (doc.getPage().hasBgImg()) {
        doc.getPage().setBackgroundImageSrcPath(config.getServletContext().getRealPath("/fobjImages"));
    }
%>
<body onLoad="<%=doc.getOnLoadBodyScript()%>">
<% if (showHeader) { %>
<jsp:include page='<%=WebUtils.getHeaderPage()%>'/>
<% } %>

<table border="0" width="100%" cellpadding="0" cellspacing="0">
    <tr>
        <td width="100%" align="left" valign="top">
            <%
                //MSG In TOP
                if (!showMsgInBottom) {
            %>
            <DIV id="fo.msgContainer">
                <BR/>
                <SPAN id="fo.clientError"><%=doc.getPage().getHTMLErrorContainer()%></SPAN>
                <SPAN id="fobjecMsgDiv"><%=msgString%></SPAN>
                <BR/>
            </DIV> fobjecMsgDiv
            <%
                }
            %>

            <!-- Starting Detail -->
            <br>
            <br>
            <center>
                <DIV id="fobjectbodydiv">
                    <%=doc.getDocumentHtmlText()%>
                </DIV>
                <% if (doc.isDisplay()) { %>
                <table width="100%" align="center">
                    <tr>
                        <td align="center" valign="middle">
                            <input type="button" value="OK"
                                   onClick="javascript:doXoAction(<%=XOConstants.ACTION_SUBMIT%>, 'display');">
                        </td>
                    </tr>
                </table>
                <% } %>

            </center>
        </td>
    </tr>
</table>

<%
    //MSG In BOTTOM
    if (showMsgInBottom) {
%>
<DIV id="fo.msgContainer">
    <BR/>
    <SPAN id="fo.clientError"><%=doc.getPage().getHTMLErrorContainer()%></SPAN>
    <SPAN id="fobjecMsgDiv"><%=msgString%></SPAN>
    <BR/>
</DIV>
<%
    }

    if (showFooter) { %>
<jsp:include page='<%=WebUtils.getFooterPage()%>'/>
<% } %>
</body>
</html>
