// - Copyright Notice
// -----------------------------------------------------------------------
// (C) Copyright 1998 Fuego Inc.  All Rights Reserved
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Fuego Inc.
// The copyright notice above does not evidence any actual or intended
// publication of such source code.
//
// $Id: VisualBasicCILBaseParser.g 98820 2009-06-04 14:06:28Z diegor $
// -----------------------------------------------------------------------

header {
    package oracle.bpm.compiler.langs.visualbasic;
}

options {
    mangleLiteralPrefix="";
    upperCaseMangledLiterals=true;
}


// Import the necessary classes
{
    import oracle.bpm.type.Argument;
    import oracle.bpm.compiler.*;
}

class VisualBasicCILBaseParser
    extends FuegoBaseParser;

options {
    importVocab=VisualBasic;
}

tokens {

    COMPLETION<AST=Completion>;
    FUNCTION<AST=Method>;
    SUB<AST=Method>;
    
    // unsupported constructions
    WITH<AST=Unsupported>;
    SYNCLOCK<AST=Unsupported>;
    RAISEEVENT<AST=Unsupported>;
    ADDHANDLER<AST=Unsupported>;
    REMOVEHANDLER<AST=Unsupported>;
    ON<AST=Unsupported>;
    RESUME<AST=Unsupported>;
    GOTO<AST=Unsupported>;
    END<AST=Unsupported>;
    STOP<AST=Unsupported>;
    REDIM<AST=Unsupported>;
    ERROR<AST=Unsupported>;
    ERASE<AST=Unsupported>;
    GETTYPE<AST=Unsupported>;
    INTEGER_DIV<AST=Unsupported>;
    
    // literal values
    LITERAL_STRING<AST=StringConst>;
    LITERAL_REGEXP<AST=RegExpConst>;
    LITERAL_DECIMAL<AST=DecimalConst>;
    LITERAL_REAL<AST=RealConst>;
    LITERAL_INTEGER<AST=IntConst>;
    LITERAL_TIME<AST=TimeConst>;
    LITERAL_INTERVAL<AST=IntervalConst>;
    TRUE<AST=BoolConst.True>;
    FALSE<AST=BoolConst>;
    ID<AST=Identifier>;
 
    // built-in types
    BOOLEAN<AST=TypeSpec.Bool>;
    DATE<AST=TypeSpec.Time>;
    BYTE<AST=TypeSpec.Int8>;
    SHORT<AST=TypeSpec.Int16>;
    INTEGER<AST=TypeSpec.Int32>;
    LONG<AST=TypeSpec.Int64>;
    CHAR<AST=TypeSpec.Char>;
    SINGLE<AST=TypeSpec.Real32>;
    DOUBLE<AST=TypeSpec.Real64>;
    DECIMAL<AST=TypeSpec.Decimal>;
    STRING<AST=TypeSpec.Str>;
    OBJECT<AST=TypeSpec.Any>;
 
    // cast targets
    CTYPE<AST=Cast>;
    
    CBOOL<AST=TypeSpec.Bool>;
    CCHAR<AST=TypeSpec.Char>;
    CDATE<AST=TypeSpec.Time>;
    CDEC<AST=TypeSpec.Decimal>;
    CSNG<AST=TypeSpec.Real32>;
    CDBL<AST=TypeSpec.Real64>;
    CBYTE<AST=TypeSpec.Int8>;
    CSHORT<AST=TypeSpec.Int16>;
    CINT<AST=TypeSpec.Int32>;
    CLNG<AST=TypeSpec.Int64>;
    COBJ<AST=TypeSpec.Any>;
    CSTR<AST=TypeSpec.Str>;

    // Arithmetic 
    ADD<AST=Term.Add>;
    SUB<AST=Term.Sub>;
    MUL<AST=Arithmetic.Mul>;
    DIV<AST=Arithmetic.Div>;
    MOD<AST=Arithmetic.Rem>;
    
    INC<AST=IncDecOperator.PreInc>;
    DEC<AST=IncDecOperator.PreDec>;

    // Relational
    NE<AST=Equality.Ne>;
    GT<AST=Comp.Gt>;
    LT<AST=Comp.Lt>;
    GE<AST=Comp.Ge>;
    LE<AST=Comp.Le>;
    LIKE<AST=Comp.Like>;

    // Logic
    NOT<AST=Not>;
    AND<AST=Logic.And>;
    ANDALSO<AST=Logic.And>;
    OR<AST=Logic.Or>;
    ORELSE<AST=Logic.Or>;
    XOR<AST=Logic.Xor>;

    // Statements
    IF<AST=If>;
    WHILE<AST=While>;
    UNTIL<AST=While.Until>;
    FOR<AST=For>;
    EACH<AST=ForEach>;
    EXIT<AST=Exit>;
    RETURN<AST=Return>;
    THROW<AST=Throw>;
    CATCH<AST=On>;
    TRY<AST=DoBlock>;
    FINALLY<AST=OnExit>;
    DO<AST=Block>;
    DISPLAY<AST=Display>;
    LOGMESSAGE<AST=Log>;
    INPUT<AST=Input>;
    COLON<AST=LabeledStatement>;

    CONCAT<AST=StringCat>;
    NOTHING<AST=NullConst>;
    EQEQ<AST=Equality.Eq>;
    ID<AST=Identifier>;
    MYCLASS<AST=Identifier.This>;
    MYBASE<AST=Identifier.Super>;
    ME<AST=Identifier.This>;
    CASE<AST=Switch.Case>;
    IS<AST=Is>;
    IN<AST=In>;
    TO<AST=Range>;
    QUESTION<AST=ExprIf>;
    LPAREN<AST=Function>;
    LBRACK<AST=ArrayReference>;
    DOT<AST=MemberReference>;
    AS<AST=Declaration>;
    RELAY<AST=Args>;
    EQ<AST=Assignment>;
    ORDERED<AST=Identifier.Ordered>;
    ENUM<AST=TypeSpec.Enum>;

    // sql nodes
    SELECT<AST=Select>;
    EXISTS<AST=Exists>;
    ORDER<AST=OrderBy>;
    HAVING<AST=Having>;
    ASC<AST=OrderBy.Col>;
    DESC<AST=OrderBy.DescCol>;
    DISTINCT<AST=Identifier.Distinct>;
    FROM<AST=Tables>;
    GROUP<AST=GroupByColumns>;
    BETWEEN<AST=In>;
    COUNT<AST=Aggregate.Count>;
    AVG<AST=Aggregate.Avg>;
    MIN<AST=Aggregate.Min>;
    MAX<AST=Aggregate.Max>;
    SUM<AST=Aggregate.Sum>;
    LIKE<AST=Comp.Like>;
    CAT<AST=StringCat>;
    NULL<AST=NullConst>;
    THIS<AST=Identifier.This>;

    DEREF;
    METHOD;
    BLOCK;
    QUALIFIED;
    INSERT;
    DELETE;
    UPDATE;
    INVOKE;
    SET_MEMBER;
    SET_ELEMENT;
    TRANSFORM;
    OBJECT_INPUT;
    INSERTCOLUMNS;
    SETVALUES;
    FIELDS;
    FIELD;
    FORMAL_ARG;
    NULL_STATEMENT;
    CASES;
    COLUMNS;
    TABLES;
    ARRAY;
    MAP;
}

//===================== The grammar =================================

method          : procedure | function 
		;

function        : FUNCTION^ ID (formalArgs)? (resultType)? NL!
			statements
		  END! FUNCTION! (NL!)* EOF!
		;

procedure	: SUB^<AST=Method> ID (formalArgs)? NL!
			statements
		  END! SUB! (NL!)* EOF!
		;

formalArgs	: LPAREN! (formalArg (COMMA! formalArg)*)? RPAREN!
		;

formalArg       : argType ID AS^<AST=FormalArgument> typeSpec
		;

methodBody      : statements EOF!		
                ;

argType         : inMode
		| inoutMode
		| outMode
		;
		
inMode          : IN! 
		| // empty
		;

inoutMode       : IN! OUT!
		;

outMode         : OUT!
		;

resultType	: AS^<AST=FormalArgument> typeSpec
		;

statements	: emptyStatement
		| (statement)+
		;
  
emptyStatement  : // empty
		;
		
oneStatement	: statement
		;
		
arraySpec       : LPAREN^<AST=NList> indexSpec RPAREN! (LPAREN! indexSpec RPAREN!)*
                ;

typeName        : name 
		| builtInType
		;

typeParameters  : LT^<AST=NList> typeParametersList GT!
		| MUL^<AST=NList> LITERAL_INTEGER
		;

enumLabels  :   LPAREN^<AST=NList>  ID (COMMA! ID)* RPAREN!
		;

langStatement	:
		(reference EQ) => 
		   assignment
		|  (COMPLETION (EOF | NL)) => COMPLETION
		|  callStatement
		|  ifStatement
		|  selectStatement
		|  forStatement
		|  doLoopStatement
		|  whileStatement
		|  exitStatement
		|  returnStatement
		|  tryStatement
		|  throwStatement
		|  dimStatement
		|  redimStatement
		|  eraseStatement
		|  displayStatement
		|  inputStatement
		|  logStatement
		|  withStatement
		|  syncStatement
		|  raiseStatement
		|  handlerStatement
		|  errorStatement
		|  onErrorStatement
		|  gotoStatement
		|  resumeStatement
		|  stopStatement
		|  labeledStatement
		|  NL! // empty statement
		;
		exception catch [NoViableAltException e] {
		    reportError(e);
		    skipToNewLine();
		}
		catch [RecognitionException e] {
		    #langStatement = handleException(e, "statement");
		}

labeledStatement: ID COLON^ statement
		;

//assignment      : expression (PLUS_EQ^ | MINUS_EQ^ | MUL_EQ^ | DIV_EQ^ | CAT_EQ^ | EXP_EQ^) expression NL!
//		;
		
assignment	:  reference EQ^ expression NL!
		;

outArg		: argTarget (EQ! name)?
		;

argTarget	: reference;

callStatement   : (CALL!)? basicReference LPAREN^ (argList)? RPAREN! (NL! relay)? NL!
		;
		
argList		: arg (COMMA! (NL!)* arg)*
		;
arg		: argType namedExpression
		;

ifStatement	: IF^ expression THEN! ((NL) => NL! statements (elseif)? END! IF! NL!
				       | oneStatement 
				       ) 
		;

elseif		: ELSEIF^<AST=If> expression THEN! NL! statements (elseif)?
		| ELSE! NL! statements
		;

selectStatement : SELECT^<AST=Switch> (CASE!)? expression NL! 
                  (caseStatement)+ (caseElseStatement)? END! SELECT! NL!
		;

caseStatement   : CASE^ caseClauses NL! statements
		;

caseClauses     : caseClause (COMMA! caseClause)*
		;
		
caseClause      : (IS!)? ( EQ^ | NE^ | LT^ | GT^ | LE^ | GE^ ) expression 
                | expression (TO^<AST=Range> expression)?
		;

caseElseStatement : CASE! ELSE^<AST=Switch.Default> NL! statements
		;

forStatement    : FOR^ loopVariable EQ! setOrRange (STEP! expression!)? NL! statements NEXT! (ID!)? NL!
		| FOR! EACH^ loopVariable IN! (NL!)*
			( (ID) => { isSQLSelect() }?
		    		    { setInsideSQL(true); }
					fullQuery
		    		    { setInsideSQL(false); }
			| expression 
			)
		  NL! statements NEXT! (ID!)? NL!
		;

loopVariable    : ID (AS^ typeSpec)? 
		;

doLoopStatement : DO! (WHILE^ | UNTIL^) expression NL! statements LOOP! NL!
		| DO! NL! statements ( LOOP! ((WHILE^ | UNTIL^) expression)?  | END! DO^<AST=DoBlock>) NL!	
		;
		
whileStatement	: WHILE^ expression NL! statements END! WHILE! NL!
	        ;

exitStatement   : EXIT^ (DO! | FOR! | FUNCTION! | SELECT! | SUB! | TRY! |  WHILE! | ID | COMPLETION |) NL!
		;

returnStatement : RETURN^ expression NL!
		;

tryStatement    : TRY^ NL! statements catchStatements END! TRY! NL!
		;

catchStatements	: (catchStatement)* (finallyStatement)?
		;

catchStatement  : CATCH^ ID AS! typeSpec (WHEN! expression)? NL! statements
		;

finallyStatement: FINALLY^ NL! statements
		;
		
throwStatement	: THROW^ expression NL!
		;

dimStatement	: (DIM! | CONST!) varDeclaration NL! // constants are handled as local variables
		;

varDeclaration  : ID AS^ (NEW!)? typeSpec (EQ! expression)?
		| multiDeclaration
		;
		
multiDeclaration: ID (COMMA!) ID AS! typeSpec 
		;

redimStatement  : REDIM^ (PRESEVE!) redimClause (COMMA! redimClause)* NL!
		;

redimClause     : ID 
		;

eraseStatement  : ERASE^ expression (COMMA! expression)? NL!
		;

displayStatement: DISPLAY^ expression (COMMA! (NL!)* args)? NL! (relay)?
                ;

                // In and Out arguments in any order
args            : argList
		;

logStatement    : LOGMESSAGE^ expression (COMMA! (NL!)* args)? NL!
                ;

inputStatement	: (INPUT LITERAL_STRING) => INPUT^ fields (NL! relay)? NL!
		| (INPUT ID COLON) => INPUT^ fields (NL! relay)? NL!
		| INPUT^<AST=ObjectInput> basicReference (COMMA! args)? (NL! relay)?
		;
		
fields		: field (COMMA! (NL!)* field)*
		;

field		: (LITERAL_STRING) => LITERAL_STRING COLON! basicReference (fieldOptions)? (fieldArray)?
		       { #field = new InputField(#field); }
		| (ID COLON) => ID COLON! basicReference (fieldOptions)? (fieldArray)?
		       { #field = new InputField(#field); }
		| arg       
		;

fieldOptions	: LPAREN^ fieldOption (COMMA! fieldOption)* RPAREN!
		;

fieldOption 	: id (EQ^ constant)?
		;

fieldArray	: (IN^ expression)
		;

relay           :  RELAY! (TO!)? ID (COMMA! argList)?
                ;

//- Unsupported Statements

withStatement   : WITH^ expression NL! statements END! WITH! NL!
		;

syncStatement   : SYNCLOCK^ expression NL! statements END! SYNCLOCK! NL!
		;

raiseStatement  : RAISEEVENT^ ID! (LPAREN! (argList)? RPAREN!)? NL!
		;

handlerStatement: (ADDHANDLER^ | REMOVEHANDLER^) expression COMMA! expression NL!
		;

errorStatement  : ERROR^ expression NL!
		;

onErrorStatement: ON^ ERROR! errorClause NL!
		;

errorClause     : GOTO^ (MINUS! | PLUS!) LITERAL_INTEGER 	
		| gotoStatement
		| resumeStatement
		;

gotoStatement   : GOTO^ ID NL!
		;

resumeStatement : RESUME^ (NEXT! | ID) NL!
		;

stopStatement   : STOP^ NL!
		;

endStatement    : END^ NL!
		;


//- Expression Staff

singleType	: typeSpec EOF!
		;

expression      : logicExpr
		;

logicExpr       : orExpr  (QUESTION^ orExpr COLON! expression)?
	        ;
		
orExpr		: andExpr ((OR^ | ORELSE^ | XOR^) (NL!)* andExpr)*
		;

andExpr		: notExpr ((AND^ | ANDALSO^) (NL!)* notExpr)*
		;

notExpr		: NOT^ notExpr
		| e:equalityExpr 
		;

equalityExpr	: basicExpr ( ( NE^ 
			      | EQEQ^ 
			      | IS^ 
			      | LIKE^
			      | EQ^<AST=Equality.Eq>) (NL!)* basicExpr)*
		| getTypeExpr
		| typeOfExpr 
		;


typeOfExpr      : TYPEOF! basicExpr IS^<AST=Is> simpleType // typeSpec 
		;

simpleType      : typeName 
		;

typeSpec	: n:typeName (p:typeParameters)? (a:arraySpec)?
                    {
                        #typeSpec = TypeSpec.make(#n, #p, #a);
                    }
                ;
getTypeExpr     : GETTYPE^ LPAREN! typeSpec RPAREN!
		;

basicExpr	: relationalExpr
		;

relationalExpr	: concatExpr
		    ( (IN) => IN^ setOrRange
		    | (LT^ | GT^ | LE^ | GE^) concatExpr
		    |  // Empty
		    )
		;

setOrRange	: (addExpr TO) => addExpr TO^ addExpr
		| addExpr
   		;

concatExpr      : addExpr (CONCAT^ addExpr)*
		;

addExpr		: modExpr ((ADD^ | SUB^) modExpr)*
		;

modExpr         : intDivExpr (MOD^ intDivExpr)*
		;

intDivExpr      : multExpr (INTEGER_DIV^ multExpr)*
		;

multExpr	: unaryExpr ( (MUL^ | DIV^) unaryExpr)*
		;

unaryExpr
    	: INC^                                unaryExpr
		| DEC^                                unaryExpr
		| SUB^<AST=UnaryArithmetic.UMinus>    unaryExpr
		| ADD^<AST=UnaryArithmetic.UPlus>	  unaryExpr
		| EXP^                                unaryExpr
		| postFixExpr
		;

postFixExpr     : reference
                        ( (INC) => INC^<AST=IncDecOperator.PostInc>
                        | (DEC) => DEC^<AST=IncDecOperator.PostDec>
                        | // Empty
                        )
                ;

derefPrimary    : primary
		;

arrayElements	: arrayElement (COMMA! arrayElement)*
		;

arrayElement	: expression
		      ( ARG_EQ^<AST=Pair> expression
		      | // Empty
		      )
		;

reference       : primaryRef
                        ( options {
                                generateAmbigWarnings=false;
                            }
                        :
                            DOT^ idOrNumber
                        |   (LBRACK RBRACK DOT) => LBRACK^<AST=MappedArrayReference> RBRACK! DOT! ID
                        |   LBRACK^ (expression)? RBRACK!
                        |   LPAREN^<AST=Function.VisualBasic> (argList)? RPAREN!
                        )*
                ;


primaryRef      : p:primary
                | value
                | LBRACE^<AST=ArrayConst> (arrayElements)? RBRACE!
                | ID
		        | castExpr
                ;

value   : LPAREN! expression (COMMA! expression)* RPAREN!
        | DO! LPAREN! reference EQ^ expression RPAREN!

		;
		
primary		: MYCLASS
		| MYBASE
		| ME
		| COMPLETION
		| constant
		| b:builtInType { #primary = new Deref(#b); }
		;

id		: ID 
		| COMPLETION
                ;
		
idOrNumber      : ID 
		| LITERAL_INTEGER 
		| COMPLETION
                ; 

basicReference	: (primary | ID)
		  (	DOT^ idOrNumber
		  |	(LBRACK RBRACK) => LBRACK^ RBRACK!
		  |	LBRACK^ expression RBRACK!
		  )*
		;

namedExprList	:  namedExpression (COMMA! namedExpression)*
		;

namedExpression : ( ID | RETURN) ARG_EQ^<AST=NamedNode> expression
		| expression
		;

castExpr        : CTYPE^ LPAREN! expression COMMA! typeSpec (COMMA^<AST=TransformCall> typeSpec)? RPAREN!
		| primitiveCast
		;
		
primitiveCast   : castTarget LPAREN^<AST=Cast> expression RPAREN! 
		;

castTarget      : CBOOL 
		| CBYTE
		| CCHAR
		| CDATE
		| CDEC
		| CDBL
		| CINT
		| CLNG
		| COBJ
		| CSHORT
		| CSNG
		| CSTR
		;
		 
builtInType     : BOOLEAN
		| DATE
                | BYTE 
                | SHORT
		| INTEGER
		| LONG
		| CHAR
                | SINGLE 
		| DOUBLE
		| DECIMAL
		| STRING
		| OBJECT
		;

constant	: literalValue
		| TRUE
		| FALSE
		| NOTHING
		;
		
