// - Copyright Notice
// -----------------------------------------------------------------------
// (C) Copyright 1998 Fuego Inc.  All Rights Reserved
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Fuego Inc.
// The copyright notice above does not evidence any actual or intended
// publication of such source code.
//
// $Id: Fuego1CILBaseParser.g 98820 2009-06-04 14:06:28Z diegor $
// -----------------------------------------------------------------------

header {
    package oracle.bpm.compiler.langs.fuego;
}

options {
    mangleLiteralPrefix="";
    upperCaseMangledLiterals=true;
}


// Import the necessary classes
{
    import oracle.bpm.type.Argument;
    import oracle.bpm.compiler.*;
}

class Fuego1CILBaseParser
    extends FuegoBaseParser;

options {
    importVocab=Fuego1;
}

tokens {
    CAT<AST=StringCat>;
    ADD<AST=Term.Add>;
    SUB<AST=Term.Sub>;
    MUL<AST=Arithmetic.Mul>;
    DIV<AST=Arithmetic.Div>;
    REM<AST=Arithmetic.Rem>;
    NOT<AST=Not>;
    AND<AST=Logic.And>;
    OR <AST=Logic.Or>;
    XOR<AST=Logic.Xor>;
    NULL<AST=NullConst>;
    EQEQ<AST=Equality.Eq>;
    NE<AST=Equality.Ne>;
    GT<AST=Comp.Gt>;
    LT<AST=Comp.Lt>;
    GE<AST=Comp.Ge>;
    LE<AST=Comp.Le>;
    ID<AST=Identifier>;
    COMPLETION<AST=Completion>;
    THIS<AST=Identifier.This>;
    SUPER<AST=Identifier.Super>;
    PARAMETER<AST=Parameter>;

    LITERAL_STRING<AST=StringConst>;
    LITERAL_REGEXP<AST=RegExpConst>;
    LITERAL_DECIMAL<AST=DecimalConst>;
    LITERAL_REAL<AST=RealConst>;
    LITERAL_INTEGER<AST=IntConst>;
    LITERAL_TIME<AST=TimeConst>;
    LITERAL_INTERVAL<AST=IntervalConst>;
    TRUE<AST=BoolConst.True>;
    FALSE<AST=BoolConst>;

    UNARY_ADD;
    NEGATE;

    IS<AST=Is>;
    IN<AST=In>;
    RANGE<AST=Range>;
    QUESTION<AST=ExprIf>;
    LPAREN<AST=Function>;
    LBRACK<AST=ArrayReference>;
    DOT<AST=MemberReference>;
    IF<AST=If>;
    WHILE<AST=While>;
    FOR<AST=For>;
    EACH<AST=ForEach>;
    EXIT<AST=Exit>;
    RETURN<AST=Return>;
    THROW<AST=Throw>;
    DISPLAY<AST=Display>;
    LOGMESSAGE<AST=Log>;
    INPUT<AST=Input>;
    ON<AST=On>;
    RELAY<AST=Args>;
    USING<AST=Args>;
    RETURNING<AST=Args>;
    EQ<AST=Assignment>;
    SWITCH<AST=Switch>;
    CASE<AST=Case>;
    ORDERED<AST=Identifier.Ordered>;
    
    // sql nodes
    SELECT<AST=Select>;
    EXISTS<AST=Exists>;
    ORDER<AST=OrderBy>;
    HAVING<AST=Having>;
    ASC<AST=OrderBy.Col>;
    DESC<AST=OrderBy.DescCol>;
    DISTINCT<AST=Identifier.Distinct>;
    FROM<AST=Tables>;
    GROUP<AST=GroupByColumns>;
    AS<AST=Alias>;
    BETWEEN<AST=In>;
    COUNT<AST=Aggregate.Count>;
    AVG<AST=Aggregate.Avg>;
    MIN<AST=Aggregate.Min>;
    MAX<AST=Aggregate.Max>;
    SUM<AST=Aggregate.Sum>;
    LIKE<AST=Comp.Like>;
    
    DEREF;
    METHOD;
    BLOCK;
    QUALIFIED;
    INSERT;
    DELETE;
    UPDATE;
    INVOKE;
    SET_MEMBER;
    SET_ELEMENT;
    TRANSFORM;
    OBJECT_INPUT;
    INSERTCOLUMNS;
    SETVALUES;
    FIELDS;
    FIELD;
    FORMAL_ARG;
    NULL_STATEMENT;
    CASES;
    COLUMNS;
    TABLES;
    ARRAY;
    MAP;
}

//===================== The grammar =================================


method		:   ID (formalArgs)? (resultType)?
			declarations
		    DO^<AST=Method>
			statements
			exceptions
		    END! (id)? EOF!
		;

block		:   ID declarations
		    DO^<AST=DoBlock>
			statements
			exceptions
		    END! id
		| DO^<AST=DoBlock>
			statements
			exceptions
		  END!
		;

methodBody      : statements exceptions EOF!		
                ;

formalArgs	: LPAREN! (formalArg (COMMA! formalArg)*)? RPAREN!
		;

formalArg	: argType ID (COLON^<AST=FormalArgument> | AS^<AST=FormalArgument>) typeSpec
		;

argType!	:   ( IN OUT  { #argType = new Arg.Type(Argument.IN | Argument.OUT); } 
		    | IN      { #argType = new Arg.Type(Argument.IN); }
		    | OUT     { #argType = new Arg.Type(Argument.OUT); }
		    |         { #argType = new Arg.Type(Argument.IN); }
		    ) 
		;

resultType	: (COLON^<AST=FormalArgument> | AS^<AST=FormalArgument>) typeSpec
		;


declarations	: ((declaration | oldDeclaration) (SEMICOLON!)?)*
		    { #declarations = new Block(#declarations); }
		;

statements	: emptyStatement 
		| (statement (SEMICOLON!)? )+
		;

emptyStatement  : ;

exceptions	: (onStatement)*
		    { #exceptions = new Block(#exceptions); }
		;

oldDeclaration	: ID (COLON^<AST=Declaration>) typeSpec (EQ! expression)?
		;
		
declaration	: ID (AS^<AST=Declaration>) typeSpec (EQ! expression)?
		;

typeParameters  :   LPAREN^<AST=NList> typeParametersList RPAREN!
		;

enumLabels  :   LPAREN^<AST=NList>  ID (COMMA! ID)* RPAREN!
       		;



langStatement	: oldLangStatement
		| switchStatement
		;
		exception catch [NoViableAltException e] {
		    reportError(e);
		    skipToNewLine();
		}
		catch [RecognitionException e] {
		    #langStatement = handleException(e, "statement");
		}

oldLangStatement: (ID ID COLON) => block
		| (ID primary)=> methodInvocation
		| ((ID|reference) (EQ)) => assignment
		| ((ID|reference) LT) => transformation
		|  classicInvocation
		|  ifStatement
		|  forStatement
		|  oldSwitchStatement
		|  whileStatement
		|  exitStatement
		|  returnStatement
		|  throwStatement
		|  displayStatement
		|  logStatement
		|  inputStatement
		|  block
		|  declaration
		|  labeledStatement
		;


labeledStatement: ID COLON^<AST=LabeledStatement> statement
		;

transformation	:   (ID | reference)
		    LT^<AST=TransformCall> SUB!
		    ( (LPAREN) =>
			LPAREN!
			expression (COMMA! expression)*
			RPAREN!
		    | 	expression
		    )
		    ;

assignment	:  ID EQ^ expression
		|! r:reference EQ e:expression
		    {
			Node node;
			if (#r.getType() == DOT)
			    node = new SetMember();
			else
			    node = new SetElement();
			Node refArgs = (Node) #r.getFirstChild();
			#assignment = #(node, refArgs, #e);
		    }
		;

methodInvocation!:  m:ID (f: reference | o:primary) (in:inArgs)? (r:relay|out:outArgs)?
		    {	
		    	Invoke invoke = new Invoke();
			#methodInvocation = #(invoke, #m, #o, #f, #in, #r,#out);
		    }
		;

inArgs		: USING^ inArg (COMMA! inArg)*
		;

inArg		: (ID EQ) => ID EQ^<AST=NamedNode> expression
		| expression
		;

outArgs		: RETURNING^ outArg (COMMA! outArg)*
			{ ((Args)#outArgs).setArgType(Args.OUT); }
		;

outArg!		: node:argTarget
			(EQ name:argName
				{ #outArg = new NamedNode(#name, #node); }
			| // Empty
				{ #outArg = #node; }
			)
		;

argTarget	: ID | reference;

argName		: ID | RETURN;

relay           :  RELAY^ ({ isTo(LT(1)) }? ID! ID | ID)
		    (USING! inArg (COMMA! inArg)*)?
		    { ((Args)#relay).setArgType(Args.RELAY); }
	        ;

relayHeader      :  RELAY^ ({ isTo(LT(1)) }? ID! ID | ID)
		    { ((Args)#relayHeader).setArgType(Args.RELAY); }
		;

relayInput      :  RELAY^ ({ isTo(LT(1)) }? ID! ID | ID)
		    (USING! relayInputArg (COMMA! relayInputArg)*)?
		    { ((Args)#relayInput).setArgType(Args.RELAY); }
		;

//relayArg	: ID EQ^<AST=NamedNode> (ID | RETURN)
//		;

relayInputArg	: ID EQ^<AST=NamedNode> (basicReference | RETURN)
		;

classicInvocation: basicReference LPAREN^ (argList)? RPAREN!
		{ ((Function) (#classicInvocation)).setExpression(false); }
		;
		
argList		: arg (COMMA! arg)*
		;
arg		: argType namedExpression
		;


displayStatement: DISPLAY^ expression (inArgs)? (relay|outArgs)?
		;

logStatement	: LOGMESSAGE^ expression (inArgs)? (outArgs)?
		;

inputStatement	: (INPUT ID COLON) => INPUT^ fields (inArgs)? (relayInput|outArgs)?
		| (INPUT LITERAL_STRING) => INPUT^ fields (inArgs)? (relayInput|outArgs)?
		| INPUT^<AST=ObjectInput> basicReference (inArgs)? (relayHeader|outArgs)?
		;

fields		: field (COMMA! field)* 
			{ #fields = new InputFields(#fields); }
		;

field		: basicReference (COLON!)? basicReference (fieldOptions)? (fieldArray)?
		        { #field = new InputField(#field); }
		;

fieldOptions	: LPAREN^ fieldOption (COMMA! fieldOption)* RPAREN!
		;

fieldOption 	: id (EQ^ constant)?
		;

fieldArray	: (IN^ expression)
		;

ifStatement	: IF^ expression 
                  THEN! statements (elseif)? END!
		;

elseif		: ELSEIF^<AST=If> expression THEN! statements (elseif)?
		| ELSE! statements
		;

forStatement	: FOR^	     ID IN! setOrRange block
		| FOR! EACH^ ID IN!
			( (ID) => { isSQLSelect() }?
		    		    { setInsideSQL(true); }
					fullQuery
		    		    { setInsideSQL(false); }
		    	| expression (WHERE! expression)?
		    	)
		   block
		;

whileStatement	: WHILE^ expression block
	        ;

switchStatement : CASE^<AST=Switch> expression (switchCase)+ (switchDefault)? END!
		;

switchCase	: WHEN^<AST=Switch.Case> switchCases statements
		;

switchCases	: caseExpr (COMMA! caseExpr)* THEN^<AST=SwitchCases>
		;

switchDefault	: ELSE^<AST=Switch.Default> statements
		;

oldSwitchStatement : SWITCH^ expression IN! (switchBody)+  END!
		  ;

switchBody	: CASE^<AST=Switch.Case> cases oldStatements
		;

oldStatements	: (oldStatement (SEMICOLON!)? )*
		    { #oldStatements = new Block(#oldStatements); }
		;

cases		: caseExpr (COMMA! caseExpr)* COLON^<AST=SwitchCases>
		;

caseExpr	: expression
		;

exitStatement	: (EXIT COLON id WHEN)=> EXIT^ COLON! id WHEN! expression
		| (EXIT COLON id) => EXIT^ COLON! id
		| (EXIT WHEN) => EXIT^ WHEN! expression
		| EXIT^
		;

returnStatement : RETURN^ expression
		;

onStatement	: ON^<AST=OnExit> EXIT! statements
		|! ON (id:ID (AS! | COLON!))? e:exceptionType s:statements
			{ #onStatement = new On(#ON, #e, #id, #s); }
		;


throwStatement	: THROW^ expression
		;

throwArguments  : name (LPAREN^ (namedExprList)? RPAREN!)?
		;
		
singleType	: typeSpec EOF!
		;

//- Expression Staff


expression      :   orExpr 	(QUESTION^ orExpr COLON! expression)?
	        ;
		exception catch [RecognitionException e] {
		    #expression = handleException(e, "expression");
		}
		
orExpr		:   andExpr (OR^ andExpr)*
		;


andExpr		:   notExpr 	(AND^ notExpr)*
		;

notExpr		:   NOT^ notExpr
		|   e:equalityExpr (IS^ (NOT)?	(NULL|typeSpec))?
		;

equalityExpr	: e1:basicExpr
		    (( NE^ | EQEQ^) basicExpr
		    | EQ^<AST=Equality.Eq> basicExpr
		    )*
		;


basicExpr	: relationalExpr
		;

relationalExpr	: e:addExpr
		    ( (IN) => IN^ setOrRange
		    | (LT^ | GT^ | LE^ | GE^| LIKE^) addExpr
		    |!      (NOT LIKE)=> not:NOT l:LIKE e2: addExpr
		                                                    {
                                                        #relationalExpr = #(#not, #(l, e, e2));
                                                }
		    |  // Empty
		    )
		;


setOrRange	: (addExpr RANGE)=> addExpr RANGE^ addExpr
		|  addExpr
		;
	 	exception catch [RecognitionException e] {
		    #setOrRange = handleException(e, "Set or range");
		}


arrayExpr	:   LBRACK^<AST=ArrayConst> (arrayElements)? RBRACK!
		;

arrayElements	: arrayElement (COMMA! arrayElement)*
		;

arrayElement	:  expression
		      ( COLON^<AST=Pair> expression
		      | // Empty
		      )
		;

addExpr		:   multExpr ((ADD^ | SUB^) multExpr)*
		;

multExpr	:   castExpr ( (MUL^ | DIV^ | REM^ ) castExpr)*
		;

castExpr	: unaryExpr ( (TO typeSpec USING) => (TO^<AST=TransformCall> typeSpec USING! typeSpec)
                            | (TO^<AST=Cast> typeSpec) )?
		;


unaryExpr
	    :   SUB^<AST=UnaryArithmetic.UMinus>   unaryExpr
		|   ADD^<AST=UnaryArithmetic.UPlus>	   unaryExpr
		|   v:value
		|   (LBRACK) => arrayExpr
		|   r:reference
		|!   p:primary	    { #unaryExpr = new Deref(#p); }
		|   COMPLETION
		;
	 	exception catch [RecognitionException e] {
		    #unaryExpr = handleException(e, "expression");
		}


primary		: ID
		| THIS
		| SUPER
		| PARAMETER
		| constant
		;


reference	:   (primary | COMPLETION)
		    (	DOT^ idOrNumber
		    |	(LPAREN RPAREN) => LPAREN^ RPAREN!
		    |	(LBRACK RBRACK DOT) => LBRACK^<AST=MappedArrayReference> RBRACK! DOT! ID
		    |	(LBRACK RBRACK) => LBRACK^ RBRACK! 
		    |	LBRACK^ expression RBRACK!
		    |	LPAREN^ argList   RPAREN!
		    )+
		;

id              : ID 
		| COMPLETION
		| PARAMETER
		;
		
idOrNumber      : ID 
		| LITERAL_INTEGER 
		| COMPLETION
		| PARAMETER
		| keyword
                ; 
	 	exception catch [RecognitionException e] {
		    #idOrNumber = handleException(e, "id");
		}

// todo: autogenerate this rule
keyword         : TO^<AST=Identifier>
		| AS^<AST=Identifier>
		;
		
basicReference	: (primary | COMPLETION)
		    (	DOT^ idOrNumber
		    |	(LBRACK RBRACK) => LBRACK^ RBRACK!
		    |	LBRACK^ expression RBRACK!
		    )*
		;

value		: LPAREN! e:expression RPAREN!
		      { #e.setParenthesis(true); }
		;

namedExprList	: namedExpression (COMMA! namedExpression)*
		;

namedExpression : ( ID | RETURN) COLON^<AST=NamedNode> expression
		| expression
		;
