#!/bin/sh
#
# $Header: bpm/main/modules/bpm-services/interface/src/genWASEJBStubs.sh /st_pcbpel_11.1.1.4.0/1 2012/03/30 16:48:24 pnandy Exp $
#
# genWASEJBStubs.sh
#
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      genWASEJBStubs.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      This script re-generates the WAS EJB stub classes for BPM EJBs.
#      
#      Stub class files  are checked in under the various server ejb directories.
#      The classes are added to oracle.bpm.bpm-services.interface.jar as part of the build process.
#
#      For example:
#        oracle/bpm/services/authentication/ejb/_BPMUserAuthenticationServiceRemote_Stub.class
#        oracle/bpm/services/organization/ejb/_BPMOrganizationServiceRemote_Stub.class
#
#      This script will check out the appropriate files, and then regenerate the 
#      stubs. You should check in the class files after running the script. Note that
#      ade will give a warning if the stub file is unchanged (which will be the case if
#      there has been no change in the EJB Remote interface since stub was last generated).
#      It is safe to ignore these warnings. Usually, there is never a change for the 
#      *Remote_Stub.class stubs, so we expect to see warnings for these classes.
#
#      Note that in order to run this script, you must have a current WAS ND install in
#      your environment. The script will not run if you do not have a WAS ND install.
#
#      Note also, you should always run this script after making interface changes to one
#      of our service EJBs. This script is run manually - it does not execute as part of the
#      build process. 
#      
#
#    NOTES
#      Note that in order to run this script, you must have a current WAS ND install in
#      your environment. The script will not run if you do not have a WAS ND install.
#
#      To install WAS ND:
#        cd $PCHOME ; ant install-was-nd
#
#      Note also, you should always run this script after making interface changes to one
#      of our service EJBs. This script is run manually - it does not execute as part of the
#      build process. 
#

#Check out the stub classes
ade co $bpmhome/main/modules/bpm-services/interface/src/oracle/bpm/services/authentication/ejb/*_Stub.class -nc
ade co $bpmhome/main/modules/bpm-services/interface/src/oracle/bpm/services/instancequery/ejb/*_Stub.class -nc
ade co $bpmhome/main/modules/bpm-services/interface/src/oracle/bpm/services/bpmapp/ejb/*_Stub.class -nc
ade co $bpmhome/main/modules/bpm-services/interface/src/oracle/bpm/services/organization/ejb/*_Stub.class -nc
ade co $bpmhome/main/modules/bpm-services/interface/src/oracle/bpm/services/internal/processmodel/ejb/*_Stub.class -nc
ade co $bpmhome/main/modules/bpm-services/interface/src/oracle/bpm/services/processsimulation/ejb/*_Stub.class -nc
ade co $bpmhome/main/modules/bpm-services/interface/src/oracle/bpm/services/processmetadata/ejb/*_Stub.class -nc
ade co $bpmhome/main/modules/bpm-services/interface/src/oracle/bpm/services/activityguide/ejb/*_Stub.class -nc
ade co $bpmhome/main/modules/bpm-services/interface/src/oracle/bpm/services/instancemanagement/ejb/*_Stub.class -nc
ade co $bpmhome/main/modules/bpm-services/interface/src/oracle/bpm/services/processdashboard/ejb/*_Stub.class -nc
ade co $bpmhome/main/modules/bpm-services/interface/src/oracle/bpm/services/processmetadata/ejb/*_Stub.class -nc
ade co $bpmhome/main/modules/bpm-services/interface/src/oracle/bpm/services/pml/ejb/*_Stub.class -nc


#Generate the stubs - relies on a WASND install being present.
cd $bpmhome/main/modules/bpm-services/interface/src

$WASND_HOME/bin/createEJBStubs.sh oracle.bpm.services.authentication.ejb.BPMUserAuthenticationServiceRemote -cp $bpmhome/generated/lib/oracle.bpm.bpm-services.interface.jar:$pchome/generated/services/bpm-services.jar

 $WASND_HOME/bin/createEJBStubs.sh oracle.bpm.services.instancequery.ejb.IInstanceQueryServiceRemote -cp $bpmhome/generated/lib/oracle.bpm.bpm-services.interface.jar:$pchome/generated/services/bpm-services.jar

 $WASND_HOME/bin/createEJBStubs.sh oracle.bpm.services.bpmapp.ejb.IBpmAppServiceRemote -cp $bpmhome/generated/lib/oracle.bpm.bpm-services.interface.jar:$pchome/generated/services/bpm-services.jar

 $WASND_HOME/bin/createEJBStubs.sh oracle.bpm.services.organization.ejb.BPMOrganizationServiceRemote -cp $bpmhome/generated/lib/oracle.bpm.bpm-services.interface.jar:$pchome/generated/services/bpm-services.jar

 $WASND_HOME/bin/createEJBStubs.sh oracle.bpm.services.internal.processmodel.ejb.IProcessModelServiceRemote -cp $bpmhome/generated/lib/oracle.bpm.bpm-services.interface.jar:$pchome/generated/services/bpm-services.jar

 $WASND_HOME/bin/createEJBStubs.sh oracle.bpm.services.processsimulation.ejb.IProcessSimulationServiceRemote -cp $bpmhome/generated/lib/oracle.bpm.bpm-services.interface.jar:$pchome/generated/services/bpm-services.jar

 $WASND_HOME/bin/createEJBStubs.sh oracle.bpm.services.processmetadata.ejb.ProcessMetadataServiceRemote -cp $bpmhome/generated/lib/oracle.bpm.bpm-services.interface.jar:$pchome/generated/services/bpm-services.jar

 $WASND_HOME/bin/createEJBStubs.sh oracle.bpm.services.activityguide.ejb.BpmAGProcessBrokerServiceRemote -cp $bpmhome/generated/lib/oracle.bpm.bpm-services.interface.jar:$pchome/generated/services/bpm-services.jar

 $WASND_HOME/bin/createEJBStubs.sh oracle.bpm.services.instancemanagement.ejb.IInstanceManagementServiceRemote -cp $bpmhome/generated/lib/oracle.bpm.bpm-services.interface.jar:$pchome/generated/services/bpm-services.jar

 $WASND_HOME/bin/createEJBStubs.sh oracle.bpm.services.processdashboard.ejb.IProcessDashboardServiceRemote -cp $bpmhome/generated/lib/oracle.bpm.bpm-services.interface.jar:$pchome/generated/services/bpm-services.jar

 $WASND_HOME/bin/createEJBStubs.sh oracle.bpm.services.pml.ejb.ISecurityServiceRemote -cp $bpmhome/generated/lib/oracle.bpm.bpm-services.interface.jar:$pchome/generated/services/bpm-services.jar:$bpmhome/generated/lib/oracle.bpm.pml.security.jar:$bpmhome/generated/lib/oracle.bpm.metadata-interface.jar:$bpmhome/generated/lib/oracle.bpm.core.jar:$pchome/generated/jrf/jps-api.jar

$WASND_HOME/bin/createEJBStubs.sh oracle.bpm.services.pml.ejb.IHistoryServiceRemote -cp $bpmhome/generated/lib/oracle.bpm.bpm-services.interface.jar:$bpmhome/generated/lib/oracle.bpm.metadata-interface.jar:$bpmhome/generated/lib/oracle.bpm.core.jar


cd -
