/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import oracle.bpm.services.processdashboard.model.ComponentType;
import oracle.bpm.services.processdashboard.model.Dimensions;
import oracle.bpm.services.processdashboard.model.Measurement;
import oracle.bpm.services.processdashboard.model.Series;
import oracle.bpm.services.processdashboard.model.ValueType;
import oracle.bpm.services.processdashboard.model.Widget;
import org.jetbrains.annotations.NotNull;

public class ComponentChecker {
    public static boolean validateComponent(@NotNull Widget widget, @NotNull ComponentType component) {
        if (!widget.getData().hasSeries()) {
            return true;
        }
        for (Series series : widget.getData().getSeries()) {
            if (ComponentChecker.validateComponent(series, component)) continue;
            return false;
        }
        return true;
    }

    public static List<ValueType> getValueTypes(@NotNull ComponentType component) {
        ArrayList<ValueType> value = new ArrayList<ValueType>();
        value.add(ValueType.VALUE);
        ArrayList<ValueType> percentage = new ArrayList<ValueType>();
        percentage.add(ValueType.PERCENTAGE);
        switch (component) {
            case AREA_VERT_ABS: 
            case AREA_VERT_STACK: 
            case BAR_HORIZ_STACK: 
            case BAR_VERT_STACK: 
            case LINE_VERT_STACK: 
            case BAR_HORIZ_CLUST: 
            case BAR_VERT_CLUST: 
            case LINE_VERT_ABS: {
                return Arrays.asList(ValueType.values());
            }
            case AREA_VERT_PERCENT: 
            case BAR_HORIZ_PERCENT: 
            case BAR_VERT_PERCENT: 
            case LINE_VERT_PERCENT: 
            case PIE_MULTI: 
            case PIE: 
            case PIE_BAR: {
                return percentage;
            }
        }
        return value;
    }

    public static List<ValueType> getValueTypes(@NotNull ComponentType component, @NotNull Class javaClass) {
        ArrayList<ValueType> value = new ArrayList<ValueType>();
        value.add(ValueType.VALUE);
        ArrayList<ValueType> percentage = new ArrayList<ValueType>();
        percentage.add(ValueType.PERCENTAGE);
        switch (component) {
            case AREA_VERT_ABS: 
            case AREA_VERT_STACK: 
            case BAR_HORIZ_STACK: 
            case BAR_VERT_STACK: 
            case LINE_VERT_STACK: 
            case BAR_HORIZ_CLUST: 
            case BAR_VERT_CLUST: 
            case LINE_VERT_ABS: {
                if (javaClass.isInstance("") || javaClass.isInstance(Boolean.TRUE)) {
                    return value;
                }
                return Arrays.asList(ValueType.values());
            }
            case AREA_VERT_PERCENT: 
            case BAR_HORIZ_PERCENT: 
            case BAR_VERT_PERCENT: 
            case LINE_VERT_PERCENT: 
            case PIE_MULTI: 
            case PIE: 
            case PIE_BAR: {
                if (javaClass.isInstance("") || javaClass.isInstance(Boolean.TRUE) || javaClass.isInstance(new Date())) {
                    return new ArrayList<ValueType>();
                }
                return percentage;
            }
        }
        return value;
    }

    public static List<ValueType> getValueTypes(@NotNull ComponentType component, int kind) {
        ArrayList<ValueType> value = new ArrayList<ValueType>();
        value.add(ValueType.VALUE);
        ArrayList<ValueType> percentage = new ArrayList<ValueType>();
        percentage.add(ValueType.PERCENTAGE);
        ArrayList<ValueType> time = new ArrayList<ValueType>();
        time.add(ValueType.AUTOMATIC_HANDLE_DATE);
        time.add(ValueType.DAYS);
        time.add(ValueType.HOURS);
        time.add(ValueType.MINUTES);
        time.add(ValueType.SECONDS);
        switch (component) {
            case AREA_VERT_ABS: 
            case AREA_VERT_STACK: 
            case BAR_HORIZ_STACK: 
            case BAR_VERT_STACK: 
            case LINE_VERT_STACK: 
            case BAR_HORIZ_CLUST: 
            case BAR_VERT_CLUST: 
            case LINE_VERT_ABS: {
                switch (kind) {
                    case 6: 
                    case 7: {
                        return time;
                    }
                    case -1: 
                    case 1: 
                    case 5: {
                        return value;
                    }
                }
                return Arrays.asList(ValueType.values());
            }
            case AREA_VERT_PERCENT: 
            case BAR_HORIZ_PERCENT: 
            case BAR_VERT_PERCENT: 
            case LINE_VERT_PERCENT: 
            case PIE_MULTI: 
            case PIE: 
            case PIE_BAR: {
                return percentage;
            }
        }
        return value;
    }

    private static boolean validateComponent(@NotNull Series series, @NotNull ComponentType component) {
        if (!series.hasMeasurement() || !series.hasDimentions()) {
            return false;
        }
        Measurement measurement = series.getMeasurement();
        Dimensions dimensions = series.getDimensions();
        switch (component) {
            case AREA_VERT_ABS: 
            case AREA_VERT_STACK: 
            case BAR_HORIZ_STACK: 
            case BAR_VERT_STACK: 
            case LINE_VERT_STACK: {
                return measurement.getValueType() != ValueType.PERCENTAGE && dimensions.hasXSeries() && dimensions.hasXGroup();
            }
            case AREA_VERT_PERCENT: 
            case PIE_MULTI: {
                return measurement.getValueType() == ValueType.PERCENTAGE && dimensions.hasXSeries() && dimensions.hasXGroup();
            }
            case BAR_HORIZ_CLUST: 
            case BAR_VERT_CLUST: 
            case LINE_VERT_ABS: {
                return measurement.getValueType() != ValueType.PERCENTAGE && dimensions.hasXSeries();
            }
            case BAR_HORIZ_PERCENT: 
            case BAR_VERT_PERCENT: 
            case LINE_VERT_PERCENT: 
            case PIE: 
            case PIE_BAR: {
                return measurement.getValueType() == ValueType.PERCENTAGE && dimensions.hasXSeries();
            }
        }
        return false;
    }

    private class Kind {
        public static final int NONE = -1;
        public static final int VOID = 0;
        public static final int BOOL = 1;
        public static final int INT = 2;
        public static final int DECIMAL = 3;
        public static final int REAL = 4;
        public static final int STRING = 5;
        public static final int TIME = 6;
        public static final int INTERVAL = 7;

        private Kind() {
        }
    }
}

