/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.model.impl;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.services.processdashboard.model.ComponentGroup;
import oracle.bpm.services.processdashboard.model.RowData;
import oracle.bpm.services.processdashboard.model.TabularData;
import oracle.bpm.services.processdashboard.model.TabularMetadata;
import oracle.bpm.services.processdashboard.model.impl.ModelTypeFactory;
import oracle.bpm.services.processdashboard.model.impl.RowDataImpl;
import oracle.bpm.services.processdashboard.model.impl.TabularMetadataImpl;
import oracle.bpm.services.processdashboard.model.jaxb.RowDataType;
import oracle.bpm.services.processdashboard.model.jaxb.TabularDataType;
import org.jetbrains.annotations.NotNull;

public class TabularDataImpl
implements TabularData {
    TabularDataType tabularDataType = ModelTypeFactory.getWidgetTypeFactory().createTabularDataType();

    private TabularDataImpl() {
    }

    public static TabularDataImpl create() {
        return new TabularDataImpl();
    }

    public static TabularDataImpl create(@NotNull TabularDataType tabularDataType) {
        TabularDataImpl tabularData = new TabularDataImpl();
        tabularData.tabularDataType = tabularDataType;
        return tabularData;
    }

    @Override
    public TabularMetadata getMetadata() {
        return this.tabularDataType.isSetMetadata() ? TabularMetadataImpl.create(this.tabularDataType.getMetadata()) : TabularMetadataImpl.create();
    }

    @Override
    public List<RowData> getRows() {
        ArrayList<RowData> rows = new ArrayList<RowData>();
        if (this.tabularDataType.isSetRows()) {
            for (RowDataType rowDataType : this.tabularDataType.getRows()) {
                rows.add(RowDataImpl.create(rowDataType));
            }
        }
        return rows;
    }

    @Override
    public List<Object[]> asArray() {
        List<RowData> rows = this.getRows();
        ComponentGroup componentGroup = null;
        if (this.tabularDataType.isSetType()) {
            try {
                componentGroup = ComponentGroup.valueOf(this.tabularDataType.getType());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (componentGroup == null) {
            RowData rowData;
            componentGroup = ComponentGroup.GRAPH;
            if (rows.size() == 1 && (rowData = rows.get(0)).getGroup() == null && rowData.getSeries() == null) {
                componentGroup = ComponentGroup.GAUGE;
            }
        }
        ArrayList<Object[]> array = new ArrayList<Object[]>();
        for (RowData rowData : rows) {
            switch (componentGroup) {
                case GRAPH: {
                    Object[] data = new Object[]{rowData.getGroup() == null ? "" : rowData.getGroup().getValue(), rowData.getSeries() == null ? "" : rowData.getSeries().getValue(), rowData.getMeasure() == null ? Integer.valueOf(0) : rowData.getMeasure().getValue()};
                    array.add(data);
                    break;
                }
                case GAUGE: {
                    Object[] data = new Object[]{rowData.getSeries() == null ? "" : rowData.getSeries().getValue(), rowData.getMeasure() == null ? Integer.valueOf(0) : rowData.getMeasure().getValue()};
                    array.add(data);
                }
            }
        }
        return array;
    }
}

