/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import oracle.bpm.project.model.processes.BpmnType;

public abstract class IDashboardConstants {
    public static final String DIMENSION_PROJECT = "project";
    public static final String DIMENSION_PROJECT_REVISION = "revision";
    public static final String DIMENSION_PROCESS = "process";
    public static final String DIMENSION_ROLE = "role";
    public static final String DIMENSION_ACTIVITY = "activity";
    public static final String DIMENSION_ACTIVITY_TYPE = "activityType";
    public static final String DIMENSION_PARTICIPANT = "participant";
    public static final String DIMENSION_COMPLETION_DATE = "completionDate";
    public static final String DIMENSION_COMPLETION_DATETIME = "completionDateTime";
    public static final String DIMENSION_CREATION_DATE = "creationDate";
    public static final String DIMENSION_CREATION_DATETIME = "creationDateTime";
    public static final String DIMENSION_MEASUREMENT = "measurement";
    public static final String MEASUREMENT_TASK_TIME = "taskTime";
    public static final String MEASUREMENT_QUANTITY = "quantityOfInstances";
    public static final String MEASUREMENT_AVG_TIME_TASK = "avgTimeTask";
    public static final String MEASUREMENT_AVG_TIME_PROCESS = "avgTimeProcess";
    public static final String MEASUREMENT_MEDIAN_TIME_TASK = "medianTimeTask";
    public static final String MEASUREMENT_MEDIAN_TIME_PROCESS = "medianTimeProcess";
    public static final String BACKWARD_COMPATIBILITY_MEASUREMENT_QUANTITY = "quantity";
    public static final String DASHBOARD_VIEWER = "BPMDashboardViewer";
    public static final Collection<String> standardDimensions;
    public static final Collection<String> workloadStandardDimensions;
    public static final Collection<String> processPerformanceStandardDimensions;
    public static final Collection<String> taskPerformanceStandardDimensions;
    public static final Collection<String> standardMeasurements;
    public static final Collection<String> workloadStandardMeasurements;
    public static final Collection<String> processPerformanceStandardMeasurements;
    public static final Collection<String> taskPerformanceStandardMeasurements;
    public static final List<BpmnType> STANDARD_WIDGET_ACTIVITY_TYPES;
    public static final List<String> STANDARD_WIDGET_ACTIVITY_TYPES_STR;

    static {
        TreeSet<String> _standardDimensions = new TreeSet<String>();
        _standardDimensions.add(DIMENSION_PROJECT);
        _standardDimensions.add(DIMENSION_PROCESS);
        _standardDimensions.add(DIMENSION_PROJECT_REVISION);
        _standardDimensions.add(DIMENSION_ACTIVITY);
        _standardDimensions.add(DIMENSION_MEASUREMENT);
        _standardDimensions.add(DIMENSION_ROLE);
        _standardDimensions.add(DIMENSION_COMPLETION_DATE);
        _standardDimensions.add(DIMENSION_CREATION_DATE);
        _standardDimensions.add(DIMENSION_PARTICIPANT);
        standardDimensions = Collections.unmodifiableCollection(_standardDimensions);
        TreeSet<String> _workloadStandardDimensions = new TreeSet<String>();
        _workloadStandardDimensions.add(DIMENSION_PROJECT);
        _workloadStandardDimensions.add(DIMENSION_PROCESS);
        _workloadStandardDimensions.add(DIMENSION_PROJECT_REVISION);
        _workloadStandardDimensions.add(DIMENSION_ACTIVITY);
        _workloadStandardDimensions.add(DIMENSION_ROLE);
        _workloadStandardDimensions.add(DIMENSION_PARTICIPANT);
        workloadStandardDimensions = Collections.unmodifiableCollection(_workloadStandardDimensions);
        TreeSet<String> _processPerformanceStandardDimensions = new TreeSet<String>();
        _processPerformanceStandardDimensions.add(DIMENSION_PROJECT);
        _processPerformanceStandardDimensions.add(DIMENSION_PROCESS);
        _processPerformanceStandardDimensions.add(DIMENSION_PROJECT_REVISION);
        _processPerformanceStandardDimensions.add(DIMENSION_COMPLETION_DATE);
        _processPerformanceStandardDimensions.add(DIMENSION_CREATION_DATE);
        processPerformanceStandardDimensions = Collections.unmodifiableCollection(_processPerformanceStandardDimensions);
        TreeSet<String> _taskPerformanceStandardDimensions = new TreeSet<String>();
        _taskPerformanceStandardDimensions.add(DIMENSION_PROJECT);
        _taskPerformanceStandardDimensions.add(DIMENSION_PROCESS);
        _taskPerformanceStandardDimensions.add(DIMENSION_PROJECT_REVISION);
        _taskPerformanceStandardDimensions.add(DIMENSION_ACTIVITY);
        _taskPerformanceStandardDimensions.add(DIMENSION_MEASUREMENT);
        _taskPerformanceStandardDimensions.add(DIMENSION_ROLE);
        _taskPerformanceStandardDimensions.add(DIMENSION_COMPLETION_DATE);
        _taskPerformanceStandardDimensions.add(DIMENSION_CREATION_DATE);
        _taskPerformanceStandardDimensions.add(DIMENSION_PARTICIPANT);
        taskPerformanceStandardDimensions = Collections.unmodifiableCollection(_taskPerformanceStandardDimensions);
        TreeSet<String> _standardMeasurements = new TreeSet<String>();
        _standardMeasurements.add(MEASUREMENT_QUANTITY);
        _standardMeasurements.add(MEASUREMENT_AVG_TIME_TASK);
        _standardMeasurements.add(MEASUREMENT_AVG_TIME_PROCESS);
        _standardMeasurements.add(MEASUREMENT_MEDIAN_TIME_TASK);
        _standardMeasurements.add(MEASUREMENT_MEDIAN_TIME_PROCESS);
        _standardMeasurements.add(MEASUREMENT_TASK_TIME);
        standardMeasurements = Collections.unmodifiableCollection(_standardMeasurements);
        TreeSet<String> _workloadStandardMeasurements = new TreeSet<String>();
        _workloadStandardMeasurements.add(MEASUREMENT_QUANTITY);
        _workloadStandardMeasurements.add(MEASUREMENT_AVG_TIME_TASK);
        _workloadStandardMeasurements.add(MEASUREMENT_AVG_TIME_PROCESS);
        _workloadStandardMeasurements.add(MEASUREMENT_MEDIAN_TIME_TASK);
        _workloadStandardMeasurements.add(MEASUREMENT_MEDIAN_TIME_PROCESS);
        workloadStandardMeasurements = Collections.unmodifiableCollection(_workloadStandardMeasurements);
        TreeSet<String> _processPerformanceStandardMeasurements = new TreeSet<String>();
        _processPerformanceStandardMeasurements.add(MEASUREMENT_TASK_TIME);
        processPerformanceStandardMeasurements = Collections.unmodifiableCollection(_processPerformanceStandardMeasurements);
        TreeSet<String> _taskPerformanceStandardMeasurements = new TreeSet<String>();
        _taskPerformanceStandardMeasurements.add(MEASUREMENT_TASK_TIME);
        taskPerformanceStandardMeasurements = Collections.unmodifiableCollection(_taskPerformanceStandardMeasurements);
        STANDARD_WIDGET_ACTIVITY_TYPES = new ArrayList<BpmnType>();
        STANDARD_WIDGET_ACTIVITY_TYPES.add(BpmnType.CALL_ACTIVITY);
        STANDARD_WIDGET_ACTIVITY_TYPES.add(BpmnType.BUSINESS_RULE_TASK);
        STANDARD_WIDGET_ACTIVITY_TYPES.add(BpmnType.MANUAL_TASK);
        STANDARD_WIDGET_ACTIVITY_TYPES.add(BpmnType.RECEIVE_TASK);
        STANDARD_WIDGET_ACTIVITY_TYPES.add(BpmnType.SCRIPT_TASK);
        STANDARD_WIDGET_ACTIVITY_TYPES.add(BpmnType.SERVICE_TASK);
        STANDARD_WIDGET_ACTIVITY_TYPES.add(BpmnType.USER_TASK);
        STANDARD_WIDGET_ACTIVITY_TYPES_STR = new ArrayList<String>();
        for (BpmnType bpmnType : STANDARD_WIDGET_ACTIVITY_TYPES) {
            STANDARD_WIDGET_ACTIVITY_TYPES_STR.add(bpmnType.name());
        }
    }
}

