/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.internal.processmodel.model.impl;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.services.internal.processmodel.model.IProcessModelPackage;
import oracle.bpm.services.internal.processmodel.model.impl.ProcessMarshallingException;
import oracle.bpm.services.internal.processmodel.model.impl.ProcessModelPackageImpl;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProcessModelSerializer {
    private ProcessModelSerializer() {
    }

    public static ProcessModelSerializer create() {
        return new ProcessModelSerializer();
    }

    public String marshall(@Nullable IProcessModelPackage modelPackage) throws ProcessMarshallingException {
        try {
            if (modelPackage != null) {
                return this.toXml(modelPackage);
            }
            return "";
        }
        catch (ParserConfigurationException e) {
            throw new ProcessMarshallingException(e);
        }
        catch (TransformerException e) {
            throw new ProcessMarshallingException(e);
        }
        catch (ProjectException e) {
            throw new ProcessMarshallingException(e);
        }
    }

    private String toXml(IProcessModelPackage modelPackage) throws ParserConfigurationException, TransformerException, ProjectException {
        DocumentBuilderFactory factory = XMLUtil.getDocumentBuilderFactory();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element packageRoot = doc.createElementNS("http://xmlns.oracle.com/bpm/ProcessModelPackage", ProcessModelPackageImpl.QNAME_MODELPACKAGE.getLocalPart());
        Process projectModel = modelPackage.getProjectModel();
        Element projectModelElem = doc.createElementNS("http://xmlns.oracle.com/bpm/ProcessModelPackage", ProcessModelPackageImpl.QNAME_PROJECTMODEL.getLocalPart());
        projectModelElem.setAttributeNS(ProcessModelPackageImpl.ATTR_QNAME_PROJECTMODEL_NAME.getNamespaceURI(), ProcessModelPackageImpl.ATTR_QNAME_PROJECTMODEL_NAME.getLocalPart(), modelPackage.getProjectName());
        projectModelElem.setAttributeNS(ProcessModelPackageImpl.ATTR_QNAME_PROJECTMODEL_DEFAULTLOCALE.getNamespaceURI(), ProcessModelPackageImpl.ATTR_QNAME_PROJECTMODEL_DEFAULTLOCALE.getLocalPart(), modelPackage.getDefaultLanguage().toString());
        CDATASection projectCDATA = doc.createCDATASection(projectModel.asXml());
        projectModelElem.appendChild(projectCDATA);
        packageRoot.appendChild(projectModelElem);
        Process process = modelPackage.getProcessModel();
        this.addProcessElement(doc, packageRoot, process);
        Sequence<Process> callees = ModelUtils.getCalledProcesses(process);
        Element calleesElem = doc.createElementNS("http://xmlns.oracle.com/bpm/ProcessModelPackage", ProcessModelPackageImpl.QNAME_CALLEES.getLocalPart());
        for (Process targetProcess : callees) {
            this.addProcessElement(doc, calleesElem, targetProcess);
        }
        packageRoot.appendChild(calleesElem);
        doc.appendChild(packageRoot);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        return writer.toString();
    }

    private Element addProcessElement(Document doc, Element parent, Process targetProcess) throws ProjectException {
        Element processElem = doc.createElementNS("http://xmlns.oracle.com/bpm/ProcessModelPackage", ProcessModelPackageImpl.QNAME_PROCESSMODEL.getLocalPart());
        processElem.setAttributeNS("", ProcessModelPackageImpl.ATTR_QNAME_PROCESSMODEL_NAME.getLocalPart(), targetProcess.getName());
        CDATASection cdata = doc.createCDATASection(targetProcess.asXml());
        processElem.appendChild(cdata);
        parent.appendChild(processElem);
        return processElem;
    }
}

