/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancequery.impl;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.common.model.CompositeDNModel;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IAuditVariable;
import oracle.bpm.services.instancequery.IAuditVariableMetadata;
import oracle.bpm.services.instancequery.impl.AuditVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AuditInstance
implements IAuditInstance {
    private transient CompositeDNModel compositeDNModel;
    private String mActivityId;
    private String mActivityName;
    private String mActivityType;
    private List<String> mAssociatedVariables;
    private String mAuditInstanceType;
    private Long mAuditLevel;
    private byte[] mAuditLog;
    private String mComment;
    private String mComponentInstanceId;
    private String mComponentName;
    private String mComponentType;
    private String mCompositeDn;
    private String mCompositeInstanceId;
    private String mCompositeName;
    private Calendar mCreateTime;
    private Calendar[] mDateValue;
    private Calendar mDueDate;
    private String mEcid;
    private boolean mFaultIsrecoverable;
    private String mFaultType;
    private String mFlowElementType;
    private String mInvokedComponentName;
    private String mLabel;
    private Long mLoopCount;
    private IAuditVariableMetadata mMetadata;
    private Long mMultiInstanceCount;
    private BigDecimal[] mNumberValue;
    private String mOperation;
    private Long mParentThreadId;
    private String mParticipant;
    private Calendar mPartitionDate;
    private transient Document mPayloadDoc;
    private transient Map<String, IAuditVariable> mPayloadElements;
    private Long mPriority;
    private Calendar mProcessDueDate;
    private String mProcessName;
    private Long mQueryId;
    private String mReferenceId;
    private String mRoleId;
    private String mScopeId;
    private String mSourceActivity;
    private Long mStep;
    private String[] mStringValue;
    private String mTargetActivity;
    private long mTenantId;
    private Long mThreadId;
    private String mTitle;
    private Long mUserTaskNumber;
    private transient Map<String, IAuditVariable> mVariables;
    private boolean mVariablesAvailable;
    private List<String> mVarNames;
    static final String logClassName = AuditInstance.class.getName();
    private static final String AUDIT_PAYLOAD_NS = "http://xmlns.oracle.com/bpmn/engine/audit";
    static final long serialVersionUID = -5301645008269986896L;

    public AuditInstance() {
    }

    private AuditInstance(IAuditVariableMetadata metadata) {
        this.init(metadata);
    }

    public static IAuditInstance newInstance(IAuditVariableMetadata metadata) {
        return new AuditInstance(metadata);
    }

    @Override
    public IAuditVariable getVariable(String name) {
        if (!this.isVariablesAvailable()) {
            return null;
        }
        if (this.mVariables == null) {
            this.mVariables = new HashMap<String, IAuditVariable>();
        }
        if (this.mVariables.containsKey(name)) {
            return this.mVariables.get(name);
        }
        int slot = 0;
        IAuditVariable v = null;
        slot = this.mMetadata.getSlot(name);
        if (slot > 0) {
            String dataType = this.mMetadata.getDataType(name);
            v = "STRING".equals(dataType) ? this.createVariable(name, this.mMetadata.getStringType(slot), dataType, this.mMetadata.getStringModelType(slot), slot, "AUDIT_QUERY", this.getStringValue(slot)) : ("NUMBER".equals(dataType) ? this.createVariable(name, this.mMetadata.getNumberType(slot), dataType, this.mMetadata.getNumberModelType(slot), slot, "AUDIT_QUERY", this.getNumberValue(slot)) : ("DATE".equals(dataType) ? this.createVariable(name, this.mMetadata.getDateType(slot), dataType, null, slot, "AUDIT_QUERY", this.getDateValue(slot)) : this.createVariable(name, this.mMetadata.getStringType(slot), dataType, this.mMetadata.getStringModelType(slot), slot, "AUDIT_QUERY", this.getStringValue(slot))));
        }
        if (v != null) {
            this.mVariables.put(v.getName(), v);
        }
        return v;
    }

    @Override
    public Map<String, IAuditVariable> getVariables() {
        if (!this.isVariablesAvailable()) {
            Map<String, IAuditVariable> vars = null;
            return vars;
        }
        return this.createFilteredVariableList(this.getVarNames(), this.mAssociatedVariables);
    }

    @Override
    public Map<String, IAuditVariable> getAllVariables() {
        if (!this.isVariablesAvailable()) {
            Map<String, IAuditVariable> vars = null;
            return vars;
        }
        return this.createVariableList(this.getVarNames());
    }

    @Override
    public String getDNApplicationName() {
        return this.getCompositeDNModel().getApplicationName();
    }

    @Override
    public String getDNCompositeName() {
        return this.getCompositeDNModel().getCompositeName();
    }

    @Override
    public String getDN() {
        return this.getCompositeDn();
    }

    @Override
    public String getDNLabel() {
        return this.getCompositeDNModel().getLabel();
    }

    @Override
    public String getDNRevision() {
        return this.getCompositeDNModel().getRevision();
    }

    @Override
    public void setCompositeInstanceId(String compositeInstanceId) {
        this.mCompositeInstanceId = compositeInstanceId;
    }

    @Override
    public String getCompositeInstanceId() {
        return this.mCompositeInstanceId;
    }

    @Override
    public void setPartitionDate(Calendar ciPartionDate) {
        this.mPartitionDate = ciPartionDate;
    }

    @Override
    public Calendar getPartitionDate() {
        return this.mPartitionDate;
    }

    @Override
    public void setParentThreadId(Long parentThreadId) {
        this.mParentThreadId = parentThreadId;
    }

    @Override
    public Long getParentThreadId() {
        return this.mParentThreadId;
    }

    @Override
    public void setPriority(Long priority) {
        this.mPriority = priority;
    }

    @Override
    public Long getPriority() {
        return this.mPriority;
    }

    @Override
    public void setQueryId(Long queryId) {
        this.mQueryId = queryId;
    }

    @Override
    public Long getQueryId() {
        return this.mQueryId;
    }

    @Override
    public void setStep(Long step) {
        this.mStep = step;
    }

    @Override
    public Long getStep() {
        return this.mStep;
    }

    @Override
    public void setLoopCount(Long value) {
        this.mLoopCount = value;
    }

    @Override
    public Long getLoopCount() {
        return this.mLoopCount;
    }

    @Override
    public void setThreadId(Long threadId) {
        this.mThreadId = threadId;
    }

    @Override
    public Long getThreadId() {
        return this.mThreadId;
    }

    @Override
    public void setActivityId(String activityId) {
        this.mActivityId = activityId;
    }

    @Override
    public String getActivityId() {
        return this.mActivityId;
    }

    @Override
    public void setActivityName(String activityName) {
        this.mActivityName = activityName;
    }

    @Override
    public String getActivityName() {
        return this.mActivityName;
    }

    @Override
    public void setActivityType(String mActivityType) {
        this.mActivityType = mActivityType;
    }

    @Override
    public String getActivityType() {
        return this.mActivityType;
    }

    @Override
    public void setAuditInstanceType(String auditInstanceType) {
        this.mAuditInstanceType = auditInstanceType;
    }

    @Override
    public String getAuditInstanceType() {
        return this.mAuditInstanceType;
    }

    @Override
    public void addAuditPayloadElement(IAuditVariable element) {
        if (this.mPayloadElements == null) {
            this.mPayloadElements = new HashMap<String, IAuditVariable>();
        }
        this.mPayloadElements.put(element.getName(), element);
    }

    @Override
    public Map<String, IAuditVariable> getPayloadElements() {
        return this.mPayloadElements;
    }

    @Override
    public void setAuditLevel(Long auditLevel) {
        this.mAuditLevel = auditLevel;
    }

    @Override
    public Long getAuditLevel() {
        return this.mAuditLevel;
    }

    @Override
    public void setAuditLog(byte[] auditLog) {
        this.mAuditLog = auditLog;
    }

    @Override
    public byte[] getAuditLog() {
        return this.mAuditLog;
    }

    @Override
    public void setComponentInstanceId(String componentInstanceId) {
        this.mComponentInstanceId = componentInstanceId;
    }

    @Override
    public String getComponentInstanceId() {
        return this.mComponentInstanceId;
    }

    @Override
    public void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    @Override
    public String getComponentName() {
        return this.mComponentName;
    }

    @Override
    public void setComponentType(String componentType) {
        this.mComponentType = componentType;
    }

    @Override
    public String getComponentType() {
        return this.mComponentType;
    }

    @Override
    public void setCompositeDn(String compositeDn) {
        this.compositeDNModel = CompositeDNModel.parseCompositeDN(compositeDn);
        this.mCompositeDn = this.compositeDNModel.getDNString();
    }

    @Override
    public String getCompositeDn() {
        return this.mCompositeDn;
    }

    @Override
    public void setCompositeName(String compositeName) {
        this.mCompositeName = compositeName;
    }

    @Override
    public String getCompositeName() {
        return this.mCompositeName;
    }

    @Override
    public void setProcessName(String processName) {
        this.mProcessName = processName;
    }

    @Override
    public String getProcessName() {
        return this.mProcessName;
    }

    @Override
    public void setFaultIsrecoverable(boolean faultIsrecoverable) {
        this.mFaultIsrecoverable = faultIsrecoverable;
    }

    @Override
    public boolean getFaultIsrecoverable() {
        return this.mFaultIsrecoverable;
    }

    @Override
    public void setFaultType(String faultType) {
        this.mFaultType = faultType;
    }

    @Override
    public String getFaultType() {
        return this.mFaultType;
    }

    @Override
    public void setFlowElementType(String flowElementType) {
        this.mFlowElementType = flowElementType;
    }

    @Override
    public String getFlowElementType() {
        return this.mFlowElementType;
    }

    @Override
    public void setInvokedComponentName(String invokedComponentName) {
        this.mInvokedComponentName = invokedComponentName;
    }

    @Override
    public String getInvokedComponentName() {
        return this.mInvokedComponentName;
    }

    @Override
    public void setLabel(String mLabel) {
        this.mLabel = mLabel;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public void setOperation(AuditInstanceOperation operation) {
        this.mOperation = operation != null ? operation.toString() : null;
    }

    @Override
    public AuditInstanceOperation getOperation() {
        if (this.mOperation != null) {
            return AuditInstanceOperation.valueOf(this.mOperation);
        }
        return null;
    }

    @Override
    public void setParticipant(String participant) {
        this.mParticipant = participant;
    }

    @Override
    public String getParticipant() {
        return this.mParticipant;
    }

    @Override
    public void setUserTaskNumber(Long userTaskNumber) {
        this.mUserTaskNumber = userTaskNumber;
    }

    @Override
    public Long getUserTaskNumber() {
        return this.mUserTaskNumber;
    }

    @Override
    public void setReferenceId(String referenceId) {
        this.mReferenceId = referenceId;
    }

    @Override
    public String getReferenceId() {
        return this.mReferenceId;
    }

    @Override
    public void setRoleId(String roleId) {
        this.mRoleId = roleId;
    }

    @Override
    public String getRoleId() {
        return this.mRoleId;
    }

    @Override
    public void setSourceActivity(String sourceActivity) {
        this.mSourceActivity = sourceActivity;
    }

    @Override
    public String getSourceActivity() {
        return this.mSourceActivity;
    }

    @Override
    public void setTargetActivity(String targetActivity) {
        this.mTargetActivity = targetActivity;
    }

    @Override
    public String getTargetActivity() {
        return this.mTargetActivity;
    }

    @Override
    public void setTitle(String title) {
        this.mTitle = title;
    }

    @Override
    public String getTitle() {
        return this.mTitle;
    }

    @Override
    public void setCreateTime(Calendar createTime) {
        this.mCreateTime = createTime;
    }

    @Override
    public Calendar getCreateTime() {
        return this.mCreateTime;
    }

    @Override
    public void setDueDate(Calendar dueDate) {
        this.mDueDate = dueDate;
    }

    @Override
    public Calendar getDueDate() {
        return this.mDueDate;
    }

    @Override
    public void setProcessDueDate(Calendar processDueDate) {
        this.mProcessDueDate = processDueDate;
    }

    @Override
    public Calendar getProcessDueDate() {
        return this.mProcessDueDate;
    }

    @Override
    public Calendar getDateValue(int slot) {
        return this.mDateValue[slot - 1];
    }

    @Override
    public void setDateValue(int slot, Calendar value) {
        this.mDateValue[slot - 1] = value;
    }

    @Override
    public BigDecimal getNumberValue(int slot) {
        return this.mNumberValue[slot - 1];
    }

    @Override
    public void setNumberValue(int slot, BigDecimal value) {
        this.mNumberValue[slot - 1] = value;
    }

    @Override
    public String getStringValue(int slot) {
        return this.mStringValue[slot - 1];
    }

    @Override
    public void setStringValue(int slot, String value) {
        this.mStringValue[slot - 1] = value;
    }

    @Override
    public void setDateValues(List<Calendar> values) {
        for (int i = 0; i < values.size(); ++i) {
            this.mDateValue[i] = values.get(i);
        }
    }

    @Override
    public void setNumberValues(List<BigDecimal> values) {
        for (int i = 0; i < values.size(); ++i) {
            this.mNumberValue[i] = values.get(i);
        }
    }

    @Override
    public void setStringValues(List<String> values) {
        for (int i = 0; i < values.size(); ++i) {
            this.mStringValue[i] = values.get(i);
        }
    }

    @Override
    public List<String> getStringValues() {
        return Arrays.asList(this.mStringValue);
    }

    @Override
    public List<BigDecimal> getNumberValues() {
        return Arrays.asList(this.mNumberValue);
    }

    @Override
    public List<Calendar> getDateValues() {
        return Arrays.asList(this.mDateValue);
    }

    @Override
    public boolean hasPayload() {
        return this.mAuditLog != null && this.mAuditLog.length > 0;
    }

    @Override
    public void addAssociatedVariable(String name) {
        if (this.mAssociatedVariables == null) {
            this.mAssociatedVariables = new ArrayList<String>();
        }
        if (!this.mAssociatedVariables.contains(name)) {
            this.mAssociatedVariables.add(name);
        }
    }

    @Override
    public void setAssociatedVariables(List<String> associatedVariables) {
        this.mAssociatedVariables = associatedVariables;
    }

    @Override
    public void setInstanceCount(Long multiInstanceCount) {
        this.mMultiInstanceCount = multiInstanceCount;
    }

    @Override
    public Long getInstanceCount() {
        return this.mMultiInstanceCount != null ? this.mMultiInstanceCount : 0L;
    }

    @Override
    public void setScopeId(String scopeId) {
        this.mScopeId = scopeId;
    }

    @Override
    public String getScopeId() {
        return this.mScopeId;
    }

    @Override
    public void setComment(String comment) {
        this.mComment = comment;
    }

    @Override
    public String getComment() {
        return this.mComment;
    }

    @Override
    public Document getPayloadDoc() {
        return this.mPayloadDoc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{ queryId=").append(String.valueOf(this.getQueryId())).append(", operation=").append(this.getOperation() == null ? "null" : this.getOperation()).append(", activityId=").append(this.getActivityId()).append(", scopeId=").append(this.getScopeId()).append(", activityName=").append(this.getActivityName()).append(", activityType=").append(this.getActivityType()).append(", sourceActivity=").append(this.getSourceActivity()).append(", targetActivity=").append(this.getTargetActivity()).append(", ECID=").append(this.getECID()).append(" }");
        return sb.toString();
    }

    @Override
    public boolean isMinimalInfoAvailable() {
        return this.mCompositeDn != null && this.mCompositeDn.length() > 0 && this.mActivityName != null && this.mActivityName.length() > 0 && this.mOperation != null && this.mAuditInstanceType != null && this.mAuditInstanceType.length() > 0 && this.mActivityId != null && this.mActivityId.length() > 0 && this.mComponentInstanceId != null && this.mComponentInstanceId.length() > 0 && this.mComponentName != null && this.mComponentName.length() > 0 && this.mThreadId != null && this.mThreadId > -1L && this.mScopeId != null && this.mScopeId.length() > 0;
    }

    public void setVariableValue(String name, Object value) throws BPMException {
        IAuditVariable var = this.getVariable(name);
        try {
            if (var != null) {
                String v = value instanceof Element ? ((Element)value).getTextContent() : String.valueOf(value);
                var.setValue(value);
                if ("STRING".equals(var.getDataType())) {
                    this.setStringValue(this.mMetadata.getSlot(name), String.valueOf(v));
                } else if ("DATE".equals(var.getDataType())) {
                    Calendar d = AuditInstance.getDate(v, "CCYY-MM-DDThh:mm:ss.sss");
                    this.setDateValue(this.mMetadata.getSlot(name), d);
                } else if ("NUMBER".equals(var.getDataType())) {
                    this.setNumberValue(this.mMetadata.getSlot(name), new BigDecimal(v));
                } else {
                    this.setStringValue(this.mMetadata.getSlot(name), v);
                }
            }
        }
        catch (Exception e) {
            BPMLogger.log(LoggerComponent.COMPONENT_AUDIT_CORE, Severity.ERRORS, e);
            Object[] objs = new Object[]{name, value};
            throw new BPMException(71301, objs, e);
        }
    }

    @Override
    public void recordDataChange(String name, Object oldValue, Object newValue) throws BPMException {
        String logMethodName = "recordDataChange";
        try {
            Element oldV;
            IAuditVariable var = this.getVariable(name);
            Element rootNode = null;
            if (this.mPayloadDoc == null) {
                this.mPayloadDoc = XMLUtil.createDocument();
                rootNode = this.mPayloadDoc.createElementNS(AUDIT_PAYLOAD_NS, "auditQueryPayload");
                this.mPayloadDoc.appendChild(rootNode);
            } else {
                rootNode = this.mPayloadDoc.getDocumentElement();
            }
            Element newV = null;
            if (oldValue instanceof Element) {
                oldV = (Element)oldValue;
            } else {
                oldV = this.mPayloadDoc.createElementNS(AUDIT_PAYLOAD_NS, name);
                oldV.setTextContent(String.valueOf(oldValue));
            }
            if (newValue instanceof Element) {
                newV = (Element)newValue;
            } else {
                newV = this.mPayloadDoc.createElementNS(AUDIT_PAYLOAD_NS, name);
                newV.setTextContent(String.valueOf(newValue));
            }
            Element newElement = this.mPayloadDoc.createElementNS(AUDIT_PAYLOAD_NS, "dataObject");
            newElement.setAttribute("name", name);
            if (var != null) {
                String variableType = "";
                if (var.getType() != null) {
                    variableType = "D".equals(var.getType()) ? "DIMENSION" : ("M".equals(var.getType()) ? "MEASURE" : ("C".equals(var.getType()) ? "COUNTER" : ""));
                }
                newElement.setAttribute("type", variableType);
                newElement.setAttribute("isBusinessIndicator", String.valueOf(var.isIndicator()));
            }
            Element oldValueElement = this.mPayloadDoc.createElementNS(AUDIT_PAYLOAD_NS, "oldValue");
            oldValueElement.appendChild(XMLUtil.cloneNode((Document)this.mPayloadDoc, (Node)oldV));
            Element newValueElement = this.mPayloadDoc.createElementNS(AUDIT_PAYLOAD_NS, "value");
            newValueElement.appendChild(XMLUtil.cloneNode((Document)this.mPayloadDoc, (Node)newV));
            newElement.appendChild(oldValueElement);
            newElement.appendChild(newValueElement);
            rootNode.appendChild(newElement);
            String xmlstr = XMLUtil.toString((Node)this.mPayloadDoc);
            BPMLogger.log(LoggerComponent.COMPONENT_AUDIT_CORE, Severity.DEBUG, logClassName, "recordDataChange", "PAYLOAD {" + xmlstr + "}");
            this.setVariableValue(name, newValue);
        }
        catch (Exception e) {
            BPMLogger.log(LoggerComponent.COMPONENT_AUDIT_CORE, Severity.ERRORS, e);
            Object[] objs = new Object[]{name, oldValue, newValue};
            throw new BPMException(71301, objs, e);
        }
    }

    @Override
    public String getECID() {
        return this.mEcid;
    }

    @Override
    public void setECID(String ecid) {
        this.mEcid = ecid;
    }

    @Override
    public long getTenantId() {
        return this.mTenantId;
    }

    @Override
    public void setTenantId(long tenantId) {
        this.mTenantId = tenantId;
    }

    private static Calendar getDate(String date, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Calendar calDate = Calendar.getInstance();
        if (date != null && !date.trim().equals("")) {
            calDate.setTime(sdf.parse(date));
        }
        return calDate;
    }

    private CompositeDNModel getCompositeDNModel() {
        if (this.compositeDNModel == null) {
            this.compositeDNModel = CompositeDNModel.parseCompositeDN(this.getCompositeDn());
        }
        return this.compositeDNModel;
    }

    private void init(IAuditVariableMetadata metadata) {
        this.mMetadata = metadata;
        this.mVariablesAvailable = metadata != null;
        this.mDateValue = new Calendar[10];
        this.mNumberValue = new BigDecimal[30];
        this.mStringValue = new String[20];
    }

    private IAuditVariable createVariable(String name, String type, String dataType, String modelType, int slot, String table, Object value) {
        IAuditVariable v = AuditVariable.newInstance();
        v.setAttribute(slot);
        v.setName(name);
        v.setTable(table);
        v.setDataType(dataType);
        v.setType(type);
        v.setModelDataType(modelType);
        v.setValue(value);
        v.setRanges(this.mMetadata.getRanges(name));
        return v;
    }

    private Map<String, IAuditVariable> createVariableList(List<String> names) {
        String logMethodName = "createVariableList";
        HashMap<String, IAuditVariable> variables = new HashMap<String, IAuditVariable>();
        for (String name : names) {
            if (name == null || name.length() <= 0) continue;
            IAuditVariable var = this.getVariable(name);
            variables.put(name, var);
        }
        BPMLogger.log(LoggerComponent.COMPONENT_AUDIT_CORE, Severity.DEBUG, logClassName, "createVariableList", "Variable list created " + ((Object)variables).toString());
        return variables;
    }

    private Map<String, IAuditVariable> createFilteredVariableList(List<String> allNames, List<String> associatedNames) {
        String logMethodName = "createFilteredVariableList";
        HashMap<String, IAuditVariable> variables = new HashMap<String, IAuditVariable>();
        for (String name : allNames) {
            if (name == null || name.length() <= 0) continue;
            IAuditVariable var = this.getVariable(name);
            if (this.isMeasurement() || this.isCounter()) {
                if (var.getType().equals("D") || var.getType().equals("A")) {
                    variables.put(name, var);
                    continue;
                }
                if (this.isMeasurement() && var.getType().equals("M") && associatedNames != null && associatedNames.contains(name)) {
                    variables.put(name, var);
                    continue;
                }
                if (!this.isCounter() || !var.getType().equals("C") || associatedNames == null || !associatedNames.contains(name)) continue;
                variables.put(name, var);
                continue;
            }
            if (!var.getType().equals("D") && !var.getType().equals("M") && !var.getType().equals("A")) continue;
            variables.put(name, var);
        }
        BPMLogger.log(LoggerComponent.COMPONENT_AUDIT_CORE, Severity.DEBUG, logClassName, "createFilteredVariableList", "Variable list created " + ((Object)variables).toString());
        return variables;
    }

    private boolean isMeasurement() {
        AuditInstanceOperation op = this.getOperation();
        return op == AuditInstanceOperation.MEASUREMENT_START || op == AuditInstanceOperation.MEASUREMENT_START_STOP || op == AuditInstanceOperation.MEASUREMENT_STOP;
    }

    private boolean isCounter() {
        AuditInstanceOperation op = this.getOperation();
        return op == AuditInstanceOperation.MEASUREMENT_COUNTER;
    }

    private boolean isVariablesAvailable() {
        return this.mVariablesAvailable;
    }

    private List<String> getVarNames() {
        if (this.mVarNames == null) {
            this.mVarNames = new ArrayList<String>();
            this.mVarNames.addAll(this.mMetadata.getNumberNames());
            this.mVarNames.addAll(this.mMetadata.getStringNames());
            this.mVarNames.addAll(this.mMetadata.getDateNames());
        }
        return this.mVarNames;
    }
}

