/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancemanagement.model.impl.alterflow;

import oracle.bpm.services.instancemanagement.model.IInstanceContextConfiguration;

public class InstanceContextConfiguration
implements IInstanceContextConfiguration {
    private Boolean includeActivityInstanceAttributes;
    private Boolean includeChildren;
    private Boolean includeCorrelationKeys;
    private Boolean includeLargeDocuments;
    private Boolean includeOpenActivities;
    private Boolean includeOpenActivityContainers;
    private Boolean includeProcessDataObjects;
    private Boolean includeProcessInstanceAttributes;
    private Boolean includeProjectDataObjects;
    private static final long serialVersionUID = 2692085976943948622L;

    private InstanceContextConfiguration(Builder builder) {
        this.includeProcessDataObjects = builder.includeProcessDataObjects;
        this.includeProjectDataObjects = builder.includeProjectDataObjects;
        this.includeCorrelationKeys = builder.includeCorrelationKeys;
        this.includeProcessInstanceAttributes = builder.includeProcessInstanceAttributes;
        this.includeActivityInstanceAttributes = builder.includeActivityInstanceAttributes;
        this.includeOpenActivities = builder.includeOpenActivities;
        this.includeOpenActivityContainers = builder.includeOpenActivityContainers;
        this.includeChildren = builder.includeChildren;
        this.includeLargeDocuments = builder.includeLargeDocuments;
    }

    public static IInstanceContextConfiguration createMinimalConfiguration() {
        Builder builder = new Builder();
        return builder.includeProjectDataObjects().includeProcessDataObjects().includeOpenActivities().build();
    }

    @Override
    public Boolean includeProcessDataObjects() {
        return this.includeProcessDataObjects;
    }

    @Override
    public Boolean includeProjectDataObjects() {
        return this.includeProjectDataObjects;
    }

    @Override
    public Boolean includeCorrelationKeys() {
        return this.includeCorrelationKeys;
    }

    @Override
    public Boolean includeProcessInstanceAttributes() {
        return this.includeProcessInstanceAttributes;
    }

    @Override
    public Boolean includeActivityInstanceAttributes() {
        return this.includeActivityInstanceAttributes;
    }

    @Override
    public Boolean includeOpenActivities() {
        return this.includeOpenActivities;
    }

    @Override
    public Boolean includeOpenActivityContainers() {
        return this.includeOpenActivityContainers;
    }

    @Override
    public Boolean includeChildren() {
        return this.includeChildren;
    }

    @Override
    public Boolean includeLargeDocuments() {
        return this.includeLargeDocuments;
    }

    public static class Builder {
        private Boolean includeActivityInstanceAttributes = false;
        private Boolean includeChildren = false;
        private Boolean includeCorrelationKeys = false;
        private Boolean includeLargeDocuments = false;
        private Boolean includeOpenActivities = false;
        private Boolean includeOpenActivityContainers = false;
        private Boolean includeProcessDataObjects = false;
        private Boolean includeProcessInstanceAttributes = false;
        private Boolean includeProjectDataObjects = false;

        public Builder includeProcessDataObjects() {
            this.includeProcessDataObjects = true;
            return this;
        }

        public Builder includeProjectDataObjects() {
            this.includeProjectDataObjects = true;
            return this;
        }

        public Builder includeCorrelationKeys() {
            this.includeCorrelationKeys = true;
            return this;
        }

        public Builder includeProcessInstanceAttributes() {
            this.includeProcessInstanceAttributes = true;
            return this;
        }

        public Builder includeActivityInstanceAttributes() {
            this.includeActivityInstanceAttributes = true;
            return this;
        }

        public Builder includeOpenActivities() {
            this.includeOpenActivities = true;
            return this;
        }

        public Builder includeOpenActivityContainers() {
            this.includeOpenActivityContainers = true;
            return this;
        }

        public Builder includeChildren() {
            this.includeChildren = true;
            return this;
        }

        public Builder includeLargeDocuments() {
            this.includeLargeDocuments = true;
            return this;
        }

        public IInstanceContextConfiguration build() {
            return new InstanceContextConfiguration(this);
        }
    }
}

