/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.instancemanagement.model.impl.alterflow;

import java.util.Collections;
import oracle.bpm.services.instancemanagement.model.IActivityInfo;
import oracle.bpm.services.instancemanagement.model.IActivityPathInfo;
import oracle.bpm.services.instancemanagement.model.IFlowChangeItem;
import oracle.bpm.services.instancemanagement.model.ILocationInfo;
import oracle.bpm.services.instancemanagement.model.IOpenActivityInfo;
import oracle.bpm.services.instancemanagement.model.IVariableItem;

public class FlowChangeItem
implements IFlowChangeItem {
    private IOpenActivityInfo sourceActivity;
    private IActivityInfo targetActivity;
    private Iterable<IActivityInfo> validGrabTargetActivities;
    private static final long serialVersionUID = -8974373393849177059L;

    private FlowChangeItem(IOpenActivityInfo sourceActivity, Iterable<IActivityInfo> validGrabTargetActivities) {
        this.sourceActivity = sourceActivity;
        this.validGrabTargetActivities = validGrabTargetActivities;
    }

    public static FlowChangeItem create(IOpenActivityInfo sourceActivity, Iterable<IActivityInfo> validGrabTargetActivities) {
        return new FlowChangeItem(sourceActivity, validGrabTargetActivities);
    }

    public static FlowChangeItem create(IActivityInfo sourceActivity, Iterable<IActivityInfo> validGrabTargetActivities) {
        OpenActivityAdapter adaptedOpenActivity = new OpenActivityAdapter(sourceActivity);
        return new FlowChangeItem(adaptedOpenActivity, validGrabTargetActivities);
    }

    public static FlowChangeItem create(IActivityInfo sourceActivity, IActivityInfo targetActivity) {
        OpenActivityAdapter adaptedOpenActivity = new OpenActivityAdapter(sourceActivity);
        FlowChangeItem flowChangeItem = new FlowChangeItem(adaptedOpenActivity, Collections.<IActivityInfo>emptySet());
        flowChangeItem.setTargetActivity(targetActivity);
        return flowChangeItem;
    }

    @Override
    public void setTargetActivity(IActivityInfo targetActivity) {
        this.targetActivity = targetActivity;
    }

    @Override
    public IOpenActivityInfo getSourceActivity() {
        return this.sourceActivity;
    }

    @Override
    public Iterable<IActivityInfo> getValidGrabTargetActivities() {
        return this.validGrabTargetActivities;
    }

    @Override
    public IActivityInfo getTargetActivity() {
        return this.targetActivity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowChangeItem that = (FlowChangeItem)o;
        return this.sourceActivity.equals(that.sourceActivity);
    }

    public int hashCode() {
        return this.sourceActivity.hashCode();
    }

    static class OpenActivityAdapter
    implements IOpenActivityInfo {
        private IActivityInfo delegated;
        private static final long serialVersionUID = 4534994775332843086L;

        OpenActivityAdapter(IActivityInfo activityInfo) {
            this.delegated = activityInfo;
        }

        @Override
        public IActivityPathInfo getPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ILocationInfo getLocation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean isContainerActivity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterable<IVariableItem> getAttributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStringPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStringPath(String pathSeparator, Boolean useThreadInstance) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            return this.delegated.getId();
        }

        @Override
        public String getDisplayName() {
            return this.delegated.getDisplayName();
        }

        @Override
        public String getProcessId() {
            return this.delegated.getProcessId();
        }
    }
}

