/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.common.exception;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.bpm.services.common.exception.BPMExceptionResourceBundles;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class BPMRuntimeException
extends RuntimeException
implements Serializable {
    protected int mErrorCode;
    Object[] mContextObjs;
    Object[] mErrorArgs;
    private LoggerComponent component = LoggerComponent.COMPONENT_COMMON;
    private String mContext = null;
    private String mDescription = null;
    private String mFix = null;
    private String mName = null;
    public static final long serialVersionUID = 3L;
    private static String gsListBundleName = null;
    private static ListResourceBundle gsPRB = null;

    public BPMRuntimeException(int errorCode) {
        this(errorCode, null, null);
    }

    public BPMRuntimeException(Severity severity, int errorCode, Object[] objs) {
        this.mErrorArgs = objs;
        this.mErrorCode = errorCode;
        this.component = LoggerComponent.getLogComponent(errorCode);
        this.init();
        this.log(severity == null ? Severity.ERRORS : severity);
    }

    public BPMRuntimeException(int errorCode, Object[] objs, Throwable t) {
        this(null, errorCode, objs, t);
    }

    public BPMRuntimeException(Severity severity, int errorCode, Object[] objs, Throwable t) {
        super(t);
        this.mErrorArgs = objs;
        this.mErrorCode = errorCode;
        this.component = LoggerComponent.getLogComponent(errorCode);
        this.init();
        this.log(severity == null ? Severity.ERRORS : severity);
    }

    public static void setPropertyBundleName(String name, Locale locale) throws Exception {
        gsPRB = (ListResourceBundle)ResourceBundle.getBundle(name, locale);
        gsListBundleName = name;
    }

    public static void setPropertyBundleName(String name) throws Exception {
        BPMRuntimeException.setPropertyBundleName(name, Locale.getDefault());
    }

    public static void setLocale(Locale l) throws Exception {
        if (gsListBundleName == null) {
            BPMExceptionResourceBundles.setLocale(l);
        } else {
            BPMRuntimeException.setPropertyBundleName(gsListBundleName, l);
        }
    }

    public LoggerComponent getComponent() {
        return this.component;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    public Object[] getErrorArgs() {
        return this.mErrorArgs;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public final String getName() {
        return this.mName;
    }

    public Throwable getRootCause() {
        Throwable tt;
        int i = 0;
        Throwable t = this.getCause();
        if (t == null) {
            return null;
        }
        while (i++ < 100 && (tt = t.getCause()) != null) {
            t = tt;
        }
        return t;
    }

    @Override
    public String getMessage() {
        StringBuffer buf = new StringBuffer();
        if (this.mName != null) {
            buf.append(this.mName);
            if (!this.mName.endsWith(".")) {
                buf.append('.');
            }
            buf.append('\n');
        }
        if (this.mDescription != null) {
            buf.append(this.mDescription);
            if (!this.mDescription.endsWith(".")) {
                buf.append('.');
            }
            buf.append('\n');
        }
        if (this.mFix != null) {
            buf.append(this.mFix);
            if (!this.mFix.endsWith(".")) {
                buf.append('.');
            }
            buf.append('\n');
        }
        if (this.mContext != null) {
            buf.append(this.mContext);
        }
        return buf.toString();
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        return buf.append("BPM-").append(this.mErrorCode).append("\n\n").append(this.getMessage()).toString();
    }

    protected String getResourceString(String key) throws MissingResourceException {
        if (gsListBundleName != null) {
            return gsPRB.getString(key);
        }
        return BPMExceptionResourceBundles.getResourceString(key);
    }

    private void log(Severity severity) {
        try {
            BPMLogger.log(this.component, severity, this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void init() {
        String mesg;
        String mPrefix = "exception." + this.mErrorCode;
        try {
            mesg = this.getResourceString(mPrefix + ".name");
            this.mName = MessageFormat.format(mesg, this.mErrorArgs);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            mesg = this.getResourceString(mPrefix + ".description");
            this.mDescription = MessageFormat.format(mesg, this.mErrorArgs);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            mesg = this.getResourceString(mPrefix + ".fix");
            this.mFix = MessageFormat.format(mesg, this.mErrorArgs);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (this.mContextObjs != null) {
            StringBuffer buf = new StringBuffer();
            Object value = null;
            int len = this.mContextObjs.length;
            for (int i = 0; i < len; i += 2) {
                Object key = this.mContextObjs[i];
                if (i + 1 < this.mContextObjs.length) {
                    value = this.mContextObjs[i + 1];
                }
                if (key == null || value == null) continue;
                buf.append(key).append(": ").append(value).append('\n');
            }
            this.mContext = buf.toString();
        }
    }
}

