/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.common.exception;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.bpm.services.common.exception.BPMExceptionContext;
import oracle.bpm.services.common.exception.BPMExceptionResourceBundles;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class BPMException
extends Exception
implements Serializable {
    private String mDescription = null;
    private BPMExceptionContext mExceptionCxt = sDefaultExceptionCtx;
    private String mFix = null;
    private String mName = null;
    private String mPrefix = null;
    private String mSeverity = null;
    private String mType = null;
    public static final long serialVersionUID = 3L;
    private static final BPMExceptionContext sDefaultExceptionCtx = new BPMExceptionContext();
    private static String gsListBundleName = null;
    private static ListResourceBundle gsPRB = null;

    public BPMException(int errorCode) {
        this(Severity.ERRORS, errorCode, null, null);
    }

    public BPMException(BPMExceptionContext exCtx) {
        super(exCtx != null ? exCtx.getThrowable() : null);
        this.init(exCtx);
        this.log();
    }

    public BPMException(Exception ex) {
        this(new BPMExceptionContext(Severity.ERRORS, ex));
    }

    public BPMException(int errorCode, Object[] objs, Throwable t) {
        this(null, errorCode, objs, t);
    }

    public BPMException(Severity severity, int errorCode, Object[] objs, Throwable t) {
        this(new BPMExceptionContext(severity, null, null, errorCode, objs, t));
    }

    public static void setPropertyBundleName(String name, Locale locale) throws Exception {
        gsPRB = (ListResourceBundle)ResourceBundle.getBundle(name, locale);
        gsListBundleName = name;
    }

    public static void setPropertyBundleName(String name) throws Exception {
        BPMException.setPropertyBundleName(name, Locale.getDefault());
    }

    public static void setLocale(Locale l) throws Exception {
        if (gsListBundleName == null) {
            BPMExceptionResourceBundles.setLocale(l);
        } else {
            BPMException.setPropertyBundleName(gsListBundleName, l);
        }
    }

    public BPMExceptionContext getExceptionContext() {
        return this.mExceptionCxt;
    }

    public LoggerComponent getComponent() {
        return this.mExceptionCxt.getComponent();
    }

    public int getErrorCode() {
        return this.mExceptionCxt.getErrorCode();
    }

    public Object[] getErrorArgs() {
        return this.mExceptionCxt.getMessageArguments();
    }

    public String getDescription() {
        return this.mDescription;
    }

    public final String getName() {
        return this.mName;
    }

    public Throwable getRootCause() {
        Throwable tt;
        int i = 0;
        Throwable t = this.getCause();
        if (t == null) {
            return null;
        }
        while (i++ < 100 && (tt = t.getCause()) != null) {
            t = tt;
        }
        return t;
    }

    @Override
    public String getMessage() {
        String causeMessage;
        Throwable thr;
        StringBuffer buf = new StringBuffer();
        buf.append("Exception\n");
        this.appendString(buf, "type", this.mType);
        this.appendString(buf, "severity", this.mSeverity);
        this.appendString(buf, "name", this.mName);
        this.appendString(buf, "description", this.mDescription);
        this.appendString(buf, "fix", this.mFix);
        if (buf.length() == 0 && (thr = this.getCause()) != null && (causeMessage = thr.getMessage()) != null) {
            buf.append(causeMessage);
        }
        return buf.toString();
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        return buf.append("BPM-").append(this.mExceptionCxt.getErrorCode()).append("\n\n").append(this.getMessage()).toString();
    }

    protected String getResourceString(String key) throws MissingResourceException {
        if (gsListBundleName != null) {
            return gsPRB.getString(key);
        }
        return BPMExceptionResourceBundles.getResourceString(key);
    }

    private void appendString(StringBuffer buf, String suffix, String str) {
        if (str != null) {
            buf.append(this.mPrefix);
            buf.append(".");
            buf.append(suffix);
            buf.append(": ");
            buf.append(str);
            buf.append('\n');
        }
    }

    private void log() {
        try {
            BPMLogger.log(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void init(BPMExceptionContext ctx) {
        String mesg;
        if (ctx != null) {
            this.mExceptionCxt = ctx;
        }
        Object[] errorArgs = this.mExceptionCxt.getMessageArguments();
        int errorCode = this.mExceptionCxt.getErrorCode();
        this.mPrefix = "exception." + errorCode;
        try {
            this.mSeverity = this.getResourceString(this.mPrefix + ".severity");
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            this.mType = this.getResourceString(this.mPrefix + ".type");
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            mesg = this.getResourceString(this.mPrefix + ".name");
            this.mName = MessageFormat.format(mesg, errorArgs);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            mesg = this.getResourceString(this.mPrefix + ".description");
            this.mDescription = MessageFormat.format(mesg, errorArgs);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            mesg = this.getResourceString(this.mPrefix + ".fix");
            this.mFix = MessageFormat.format(mesg, errorArgs);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
    }
}

