/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.common;

import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.common.AbstractWorkflowService;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.verification.ITaskActionPermission;
import oracle.bpm.services.activityguide.IBpmAGMetadataService;
import oracle.bpm.services.activityguide.IBpmAGProcessBrokerService;
import oracle.bpm.services.common.IBPMService;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.instancemanagement.IInstanceManagementService;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.services.permissions.IPermissionsService;
import org.jetbrains.annotations.NotNull;

public class AbstractBPMService
extends AbstractWorkflowService
implements IBPMService {
    private IBpmAGMetadataService iBpmAGMetadataService = null;
    private IBpmAGProcessBrokerService iBpmAGProcessBrokerService = null;
    private IInstanceManagementService iManagementService = null;
    private IPermissionsService iPermissionsService = null;
    private IInstanceQueryService iQueryService = null;
    private ITaskQueryService iTaskQueryService = null;

    @Override
    public IInstanceQueryService getInstanceQueryService() {
        return this.iQueryService;
    }

    @Override
    public void setInstanceQueryService(IInstanceQueryService newInstanceQueryService) {
        this.iQueryService = newInstanceQueryService;
    }

    @Override
    public IInstanceManagementService getInstanceManagementService() {
        return this.iManagementService;
    }

    @Override
    public void setInstanceManagementService(IInstanceManagementService newInstanceManagementService) {
        this.iManagementService = newInstanceManagementService;
    }

    @Override
    public IBpmAGMetadataService getBpmAGMetadataService() {
        return this.iBpmAGMetadataService;
    }

    @Override
    public void setBpmAGMetadataService(IBpmAGMetadataService newBpmAGMetadataService) {
        this.iBpmAGMetadataService = newBpmAGMetadataService;
    }

    public IPermissionsService getPermissionsService() {
        return this.iPermissionsService;
    }

    public void setPermissionsService(IPermissionsService newPermissionsService) {
        this.iPermissionsService = newPermissionsService;
    }

    @Override
    public IBpmAGProcessBrokerService getBpmAGProcessBrokerService() {
        return this.iBpmAGProcessBrokerService;
    }

    @Override
    public void setBpmAGProcessBrokerService(IBpmAGProcessBrokerService newBpmAGProcessBrokerService) {
        this.iBpmAGProcessBrokerService = newBpmAGProcessBrokerService;
    }

    public void performPermissionsCheck(@NotNull IBPMContext context, @NotNull IProcessInstance instance, @NotNull IPermissionsService.InstanceAction action) throws BPMException {
        ITaskActionPermission permission = this.iPermissionsService.canUserPerformProcessAction(context, instance, action.toString());
        if (!permission.getHasPermission()) {
            BPMException exception = new BPMException(70205, new Object[]{action, instance.getCubeInstanceId(), context.getUser()}, null);
            throw exception;
        }
    }
}

