/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemanagement.metadata.impl;

import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import oracle.bpm.casemanagement.metadata.model.CaseMetadata;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.CompositeModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CaseMetadataCache {
    private ConcurrentHashMap<String, CaseMetadata> caseMetadataCache = new ConcurrentHashMap();
    private static CaseMetadataCache cacheInstance = null;
    private static final String CASE_METADATA_ID_DELIMITER = "/";
    private static final String CASE_METADATA_XML_FILE = "CaseMetadata.xml";

    private CaseMetadataCache() {
    }

    public static synchronized CaseMetadataCache getInstance() {
        if (cacheInstance == null) {
            cacheInstance = new CaseMetadataCache();
        }
        return cacheInstance;
    }

    public CaseMetadata getCaseMetadata(String caseMetadataId) {
        if (caseMetadataId == null) {
            return null;
        }
        String compositeDN = this.getCompositeDN(caseMetadataId);
        CaseMetadata caseMetadata = null;
        if (compositeDN != null) {
            caseMetadata = this.caseMetadataCache.get(compositeDN);
            return caseMetadata;
        }
        return null;
    }

    public void addToCache(ComponentModel componentModel) {
        CompositeModel composite = componentModel.getComposite();
        String compositeDN = composite.getDN();
        System.out.println("addToCache:" + compositeDN);
        Document document = composite.getMetadataManager().getDocumentAsDOM(CASE_METADATA_XML_FILE);
        if (document != null) {
            System.out.println("document is not null");
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)"oracle.bpm.casemanagement.metadata.model");
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                CaseMetadata caseMetadata = (CaseMetadata)unmarshaller.unmarshal((Node)document.getDocumentElement());
                if (caseMetadata == null) {
                    System.out.println("case metadata is null");
                } else {
                    Marshaller marshaller = jaxbContext.createMarshaller();
                    marshaller.marshal((Object)caseMetadata, (OutputStream)System.out);
                }
                if (!this.caseMetadataCache.containsKey(compositeDN)) {
                    this.caseMetadataCache.put(compositeDN, caseMetadata);
                }
                System.out.println(this.caseMetadataCache.size());
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(ComponentModel componentModel) {
        CompositeModel composite = componentModel.getComposite();
        String compositeDN = composite.getDN();
        ConcurrentHashMap<String, CaseMetadata> concurrentHashMap = this.caseMetadataCache;
        synchronized (concurrentHashMap) {
            this.caseMetadataCache.remove(compositeDN);
        }
    }

    private String getCompositeDN(String caseMetadataId) {
        int delimiterPosition = caseMetadataId.lastIndexOf(CASE_METADATA_ID_DELIMITER);
        if (delimiterPosition == -1) {
            return null;
        }
        String compositeDN = caseMetadataId.substring(0, delimiterPosition);
        return compositeDN;
    }
}

